<?php
class CidadeController extends Controller {

    public function indexAction() {
        $this->redir(array("modulo" => "sc", "controller" => "cidade", "action" => "listar"));
    }


    public function adicionarAction() {
        $this->set("ufs",Db_TabelaAgrupada::findByField("idTabela",Db_TabelaAgrupada::TABLE_UF));
        $this->display("form");
    }

    public function editarAction() {
        $cidades = Db_Cidade::fetchAll();
        $this->set("cidades",$cidades);
        $this->set("ufs",Db_TabelaAgrupada::findByField("idTabela",Db_TabelaAgrupada::TABLE_UF));
        $this->set("cidade",Db_Cidade::find($_GET["id"]));
        $this->display("form");
    }

    public function pesquisarAction() {
        $count = Db_Cidade::fullSearch($_GET["termo"], true);

        /*Total de linhas*/
        $totalItems = $count[0]->count;

        /*Seta as opes do paginador*/
        $pager_options = array(
                'mode'       => 'Sliding',   // Sliding or Jumping mode. See below.
                'perPage'    => 10,   // Total rows to show per page
                'delta'      => 4,   // See below
                'totalItems' => $totalItems,
        );

        /*Instancia o paginador*/
        $pager = Pager::factory($pager_options);
        /* The following code will retreive the result using the pager options */

        /*Seta o offset para colocar na query*/
        list($from, $to) = $pager->getOffsetByPageId();

        /*Ajuste para MySQL que comea o offset com 0*/
        $from = $from - 1;

        /*A quanditade de linhas por query*/
        $perPage = $pager_options['perPage'];

        $cidades = Db_Cidade::fullSearch($_GET["termo"], false, $from, $perPage);

        $this->set("action",array("m"=>"lo","c" => "cidade", "a" => "pesquisar"));
        $this->set("subtitulo","Cidades");
        $this->set("cidades",$cidades);
        $this->set('paginacao',$pager->links);
        $this->set("botoes",array("voltar" => array("m"=>"rh","c" => "cidade", "a" => "listar")));
        $this->display();
    }

    public function saveAction() {

        if (Login::isLogado () && ACL::hasPermission(Login::getUsuario(),Db_Action::findByNome("adicionar", Db_Controller::findByName ( __CLASS__ ) ) )) {

            $c = new Db_Cidade();
            $c->setId($_POST["id"]);
            $c->setNome(ucfirst($_POST["nome"]));
            $c->setUf($_POST["uf"]);

            $this->set("cidade",$c);

            $id = $_POST["id"];

            if($this->validar()) {
                if(!$id) {//insero
                    $c->setLog(Login::getUsuario()->getLogin().' - '.date('d/m/Y').' - i');
                }else {//edio
                    $c->setLog(Login::getUsuario()->getLogin().' - '.date('d/m/Y').' - u');
                }
                $c->save();
                $this->redir(array("modulo" => "rh", "controller" => "cidade", "action" => "listar"),array("msg" => "OK"));
            }else {
                $this->adicionarAction();
            }
        }else {
            throw new Exception("O usurio no tem permisso de acessar essa action.");
        }
    }

    private function validar() {
        //validao vazio
        $campos = array ("nome", "uf");
        foreach ( $campos as $cp ) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "nome" :
                        $msg = "O campo nome deve ser preenchido.";
                        break;
                    case "uf" :
                        $msg = "O campo uf deve ser preenchido.";
                        break;
                }
                $this->_helper->addMensagem ( $cp, $msg );
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function listarAction() {
        $this->set("botoes",array("Adicionar" => array("m" => "rh" , "c" => "cidade", "a" => "adicionar")));

        if($_GET["msg"] == "OK") {
            $this->_helper->addMensagem("ok","Operao realizada com sucesso!");
        }elseif($_GET["msg"] == "FAIL") {
            $this->_helper->addMensagem("fail","Erro! No foi posssvel continuar a operao!");
        }

        $count = Db_Cidade::fetchAll(null,"uf, nome", true);

        /*Total de linhas*/
        $totalItems = $count[0]->count;

        /*Seta as opes do paginador*/
        $pager_options = array(
                'mode'       => 'Sliding',   // Sliding or Jumping mode. See below.
                'perPage'    => 10,   // Total rows to show per page
                'delta'      => 4,   // See below
                'totalItems' => $totalItems,
        );

        /*Instancia o paginador*/
        $pager = Pager::factory($pager_options);
        /* The following code will retreive the result using the pager options */

        /*Seta o offset para colocar na query*/
        list($from, $to) = $pager->getOffsetByPageId();

        /*Ajuste para MySQL que comea o offset com 0*/
        $from = $from - 1;

        /*A quanditade de linhas por query*/
        $perPage = $pager_options['perPage'];

        $this->set("action",array("m"=>"rh","c" => "cidade", "a" => "pesquisar"));
        $this->set("subtitulo","Cidades");
        $cidades = Db_Cidade::fetchAll(null,"uf, nome", false, $from, $perPage);
        $this->set("cidades",$cidades);
        $this->set('paginacao',$pager->links);
        $this->display();
    }

    public function deletarAction() {
        try {
            Db_Cidade::delete($_GET["id"]);
            $this->redir(array("modulo" => "rh", "controller" => "cidade", "action" => "listar"),array("msg" => "OK"));
        }catch (Exception $e) {
            $this->redir(array("modulo" => "rh", "controller" => "cidade", "action" => "listar"),array("msg" => "FAIL"));
        }

    }

}
