<?php
class calculoPriceController extends Controller
{
    /**
     * @throws Exception
     * Controller criado por Jonathan Luiz - Data29/02/2022
     *
     * Este controller  para concentrar clculos referentes a tabela Price no sistema de Emisso de Boletos
     *
     * O clculo da tabela PRICE  da seguinte maneira:
     *
     * Taxa Juros ao ms e dividir pelo nmero de dias do ms
     * ex: 0,9489 / 30 = 0,03163 (Juros ao dia -> O Sistema que calcula isso)
     *
     * Data da parcela que quer antecipar
     * -> Data do vencimento menos a data atual (Calcular o nmero de dias e multiplicar por juros ao dia)

     * vf = Valor Final da parcela ex: 309,91 (coluna vl_parcela da tabela PARCELA)
     * Tx = Taxa de juros ao dia (0,03163/100)
     * tempo = Nmero de dias entre a data atual e a data de vencimento
     * vf / (1+(Tx))^tempo

     * Obs: FOi usado a funo do PHP pow() pois o valor a ser exponenciado pode no ser inteiro.
     */
    public function descontoBoletoAction()
    {

        $dominio = parse_url($_SERVER['HTTP_REFERER'], PHP_URL_HOST);

        if(($_POST['data_vencimento'] == "") || ($_POST['data_vencimento'] == "undefined")){
            $data_Vencimento = date('d/m/Y');
        }else{
            $data_Vencimento = $_POST['data_vencimento'];
        }
        $parcelaId = $_POST['parcelaId'];
        $parcela = new Parcela();
        $parcela = $parcela::parcelaById($parcelaId);

        //busca o banco atravz do id do contrato.
        $contrato = new Contrato();
        $contrato = $contrato->getContrato($parcela['id_contrato']);

        //Inserido alterao de encoding para exibir os campos
        $parcela['log'] = utf8_encode($parcela['log']);
        $parcela['obs'] = utf8_encode($parcela['obs']);

        //Checa se o contrato possui enquadramento na tabela Price
        $checkPrice = ($contrato['vl_divida'] && $contrato['nr_meses_financiamento'] && $contrato['tx_juros'])?true:false;
        if($checkPrice){
            
            //Condio de amortizao para o cliente souzaincormporacoes.
            if ($dominio == "souzaincorporacoes.acadeone.com.br") {

                $jurosmes = $contrato['tx_juros'] / 100;

                //Calculando o nmero de dias e converte em meses entre a data de Vencimento da Parcela e a data de pagamento (hoje).
                $firstDate  = new DateTime(Helper::dataParaAmericano($data_Vencimento));
                $secondDate = new DateTime(Helper::dataParaAmericano($parcela['dt_parcela']));
                $intvl = $firstDate->diff($secondDate);
                $nrdias = $intvl->days/30;
                $nrMes = intval($nrdias);

                //Calculando o valor de desconto da Tabela PRICE com base na quantidade de meses.
                $vl_parcela = $parcela['vl_parcela'];
                $vlrfinal = $vl_parcela*(1/pow((1+$jurosmes),$nrMes));

            }else{
            //Calculando o valor de juros ao dia
                $jurosdia = $contrato['tx_juros'] / 30; //Mes de 30 dias

                //Calculando o nmero de dias entre a data de Vencimento da Parcela e a data de pagamento (hoje).
                $firstDate  = new DateTime(Helper::dataParaAmericano($data_Vencimento));
                $secondDate = new DateTime(Helper::dataParaAmericano($parcela['dt_parcela']));
                $intvl = $firstDate->diff($secondDate);
                $nrdias = $intvl->days;

                //Calculando o valor de desconto da Tabela PRICE
                $vl_parcela = $parcela['vl_parcela'];
                $vlrfinal = $vl_parcela/pow(1+($jurosdia/100),$nrdias);
            }

                //Envia os dados via JSON para a tela de Boleto 2Via
                $vl_desconto = $vl_parcela - $vlrfinal;
                $dados['data_vencimento'] = $data_Vencimento;
                $dados['vlrfinal'] = $vlrfinal;
                $dados['desconto'] = round($vl_desconto,2);
                $dados['mensagem'] = "Calculado o valor do desconto com sucesso!";
                echo json_encode($dados);
        }else{
            //Caso no se enquadre na tabela PRICE, retorna mensagem de erro.
            $dados['desconto'] = 0;
            $dados['mensagem'] = "Contrato nao se enquadra na tabela PRICE";
            echo json_encode($dados);
        }



    }

    public function getTabelaPriceAction(){

        if(($_POST['data_vencimento'] == "") || ($_POST['data_vencimento'] == "undefined")){
            $data_Vencimento = date('d/m/Y');
        }else{
        $data_Vencimento = $_POST['data_vencimento'];
        }

        //busca o banco atravz do id do contrato.
        $contrato = new Contrato();
        $contrato = $contrato->getContrato($_POST['id_contrato']);

        //Checa se o contrato possui enquadramento na tabela Price
        $checkPrice = ($contrato['vl_divida'] && $contrato['nr_meses_financiamento'] && $contrato['tx_juros'])?true:false;

        if($checkPrice){
            $dados['tx_juros'] = $contrato['tx_juros'];
            echo json_encode($dados);
        }
    }
}
