<?php
/**
 * Created by PhpStorm.
 * User: programacao1
 * Date: 13/06/19
 * Time: 16:03
 */

class AvisoController extends Controller
{
    public function indexAction() {
        $this->display('exibir');
    }

    public function exibeAvisoAction() {

        $id = $_GET['idAviso'];
        $dados = Aviso::exibeAviso($id);

        $this->set('dados', $dados);
        $this->display('exibir');
    }

    public function buscaAvisosAction() {

        $clienteAcade = $this->addUsuarioAcadeGeral();
        $avisos = Aviso::getTodosAvisos($clienteAcade['id_cliente'], $_POST['ultimoId'], 0);

        if($avisos) {
            foreach ($avisos as &$a) {
                $a['ds_titulo'] = utf8_encode($a['ds_titulo']);
                $a['ds_aviso'] = utf8_encode($a['ds_aviso']);
            }
        }

        echo json_encode($avisos);
    }

    public function listarAction() {
        if ($this->isAjax()) {

            $listaAviso = Aviso::findAviso($_POST);
            $totalAviso = Aviso::findAviso($_POST, true);

            $lista = array();
            foreach ($listaAviso as $aviso) {
                $status = '<span class="label label-success">Ativo</span>';
                $iconInativar = '<i id="icon_' . $aviso['id_aviso'] . '" class="fa fa-lock"></i>';
                $titleToggle = 'INATIVAR';

                $aviso['dt_aviso'] = str_replace('-', '/', $aviso['dt_aviso']);
                $aviso['dt_aviso'] = date("d/m/Y", strtotime($aviso['dt_aviso']));

                if ($aviso['fl_ativo'] == '0') {
                    $status = '<span class="label label-danger">Inativo</span>';
                    $iconInativar = '<i id="icon_' . $aviso['id_aviso'] . '" class="fa fa-unlock-alt"></i>';
                    $titleToggle = 'ATIVAR"';
                }

                if ($aviso['fl_atualizacao'] == '1') 
                {
                    $status = utf8_encode('<span class="label label-primary">Atualizao</span>');
                }

                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<span data-toggle="modal" data-target=".modalVisualizar"><button type="button" value="' . $aviso['id_aviso'] . '" data-toggle="tooltip" title="VISUALIZAR" class="btn btn-default btn-sm btn-visualizar" style="margin-right:5px"><i class="fa fa-eye"></i> </button></span>';
                $acoes .= '<a href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $aviso['id_aviso'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                
                if ($aviso['fl_atualizacao'] == '0') {
                    $acoes .= '<button data-toggle="tooltip" title="'.$titleToggle.'" type="button" value="' . $aviso['id_aviso'] . '" id="button_' . $aviso['id_aviso'] . '"  class="btn btn-default btn-sm btnInativar" style="margin-right:5px">' . $iconInativar . '</button>';
                }

                $title = "return confirm('Tem certeza que deseja excluir o aviso " . $aviso['id_aviso'] . "?')";
                $acoes .= '<a onclick="' . $title . '"  href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=deletar&id=' . $aviso['id_aviso'] . '" data-toggle="tooltip" title="DELETAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $acoes .= '</div>';

                //o mtodo utf8_encode()  utilizado para inserir campos que no sejam numricos.
                $lista[] = array(
                    'codigo' => '<div align="center">' . $aviso['id_aviso'] . '</div>',
                    'data' => '<div>' . utf8_encode($aviso['dt_aviso']) . '</div>',
                    'titulo' => '<div align="left">' . utf8_encode($aviso['ds_titulo']) . '</div>',
                    'status' => '<label id="status_' . $aviso['id_aviso'] . '">' . $status . '</label>',
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'draw' => $_POST['draw'],
                'recordsTotal' => count($totalAviso),
                'recordsFiltered' => count($totalAviso),
                'data' => $lista
            ));
        } else {
            $this->display('listar');
        }
    }

    public function inativarAction()
    {
        $aviso =  Controller::getAdapterAcadeGeral()->select()
            ->from(array('a' => TB_AVISO), '*')
            ->where('id_aviso = "'.$_POST['id_aviso'].'"')
            ->query()->fetch();
        try {
            //Inicia a transao com banco de dados
            $dbAcadeGeral = $this->getAdapterAcadeGeral();
            $dbAcadeGeral->beginTransaction();

            if ($aviso['fl_ativo'] == '1') {
                $aviso['fl_ativo'] = 0;
            } else {
                $aviso['fl_ativo'] = 1;
            }

            $flAtivo = array(
                'fl_ativo' => $aviso['fl_ativo']
            );

            $dbAcadeGeral->update(TB_AVISO, $flAtivo, 'id_aviso = '.$_POST['id_aviso']);
            $dbAcadeGeral->commit();
            echo json_encode($flAtivo);

        } catch (Exception $e) {
            $this->redir(array("modulo" => "sc", "controller" => "aviso", "action" => "listar"), array('msg' => 'fail', 'exception' => $e->getMessage()));
        }
    }

    public function visualizarAction()
    {
        $aviso = Controller::getAdapterAcadeGeral()->select()
            ->from(array('a' => TB_AVISO), '*')
            ->where('a.id_aviso = "'.$_POST['id'].'"')
            ->query()->fetch();

        $this->set('avisos', $aviso);
        $this->display();
    }

    public function adicionarAction()
    {
        if ($this->_isPost && $this->validar()) {
            try {
                //Inicia a transao com banco de dados
                $dbAcadeGeral = $this->getAdapterAcadeGeral();
                $dbAcadeGeral->beginTransaction();

                //Salvando os arquivos no banco acade_geral
                $camposTbAviso = array(
                    'ds_titulo' => $_POST['dsTitulo'],
                    'ds_aviso' => $_POST['dsAviso'],
                    'dt_aviso' => date('y-m-d'),
                    'hr_aviso' => date('H:i:s'),
                    'fl_ativo' => 1,
                    'fl_lotear' => ($_POST['flAcadeLotear'])?1:0,
                    'fl_ged' => ($_POST['flAcadeGed'])?1:0,
                    'fl_finan' => ($_POST['flAcadeFinan'])?1:0,
                    'fl_vendas' => ($_POST['flAcadeVendas'])?1:0,
                    'fl_permanente' => $_POST['flPermanente'],
                    'fl_atualizacao' => $_POST['flAvisoAtualizacao'],
                    'ds_log' => Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i'
                );

                $dbAcadeGeral->insert(TB_AVISO, $camposTbAviso);

                $dbAcadeGeral->commit();

                $this->atualizaSessao();

                $this->redir(array("modulo" => "", "controller" => "aviso", "action" => "listar"), array("msg" => "success"));
            } catch (Exception $e) {
                $this->redir(array("modulo" => "", "controller" => "aviso", "action" => "listar"), array('msg' => 'fail', 'exception' => $e->getMessage()));
            }
        }

        $this->display('form');
    }

    public function editarAction()
    {
        //Para exibir a informao do campo Descrio
        $aviso = Controller::getAdapterAcadeGeral()->select()
            ->from(array('a' => TB_AVISO), '*')
            ->where('id_aviso = "'.$_GET['id'].'"')
            ->query()->fetch();
        $this->set('aviso', $aviso);

        if ($this->_isPost && $this->validar()) {
            try {
                //Inicia a transao com banco de dados
                $dbAcadeGeral = $this->getAdapterAcadeGeral();
                $dbAcadeGeral->beginTransaction();

                //Salvando os arquivos no banco acade_geral
                $camposTbAviso = array(
                    'ds_titulo' => $_POST['dsTitulo'],
                    'ds_aviso' => $_POST['dsAviso'],
                    'fl_ativo' => 1,
                    'fl_lotear' => ($_POST['flAcadeLotear'])?1:0,
                    'fl_ged' => ($_POST['flAcadeGed'])?1:0,
                    'fl_finan' => ($_POST['flAcadeFinan'])?1:0,
                    'fl_vendas' => ($_POST['flAcadeVendas'])?1:0,
                    'fl_permanente' => $_POST['flPermanente'],
                    'ds_log' => Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - u'
                );

                $dbAcadeGeral->update(TB_AVISO, $camposTbAviso, 'id_aviso = ' . $_GET['id']);
                $dbAcadeGeral->commit();

                $this->atualizaSessao();

                $this->redir(array("modulo" => "", "controller" => "aviso", "action" => "listar"), array("msg" => "success"));

            } catch (Exception $e) {
                $this->redir(array("modulo" => "", "controller" => "aviso", "action" => "listar"), array('msg' => 'fail', 'exception' => $e->getMessage()));
            }
        }
        $this->display('form');
    }

    public function deletarAction()
    {
        try {
            $dbAcadeGeral = $this->getAdapterAcadeGeral();
            $dbAcadeGeral->beginTransaction();

            $dbAcadeGeral->delete(TB_AVISO_USUARIO, 'id_aviso = "'.$_GET['id'].'"');
            $dbAcadeGeral->delete(TB_AVISO, 'id_aviso = "'.$_GET['id'].'"');

            $dbAcadeGeral->commit();
            $this->redir(array("modulo" => "", "controller" => "aviso", "action" => "listar"), array("msg" => "success"));

            $this->atualizaSessao();

        } catch (Exception $e) {
            $dbAcadeGeral->rollBack();
            $this->redir(array("modulo" => "", "controller" => "aviso", "action" => "listar"), array('msg' => 'fail', 'exception' => $e->getMessage()));
        }
    }

    public function validar()
    {
        $campos = array("dsTitulo", "dsAviso");
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "dsTitulo" :
                        $msg = "O <b>Ttulo</b>  obrigatrio.";
                        break;
                    case "dsAviso" :
                        $msg = "O campo <b>Texto do Aviso</b>  obrigatrio.";
                        break;

                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }

        if ($_POST['flAcadeLotear'] == 0 && $_POST['flAcadeGed'] == 0 &&
            $_POST['flAcadeFinan'] == 0 && $_POST['flAcadeVendas'] == 0) {

            $this->_helper->addMensagem('danger', "Pelo menos um sistema deve ser selecionado.");
        }

        if (strlen($_POST['dsTitulo']) > 60) {
            $this->_helper->addMensagem('danger', "O campo <b>Ttulo</b> deve conter no mximo 60 caracteres");
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function  mensagemLidaAction() {

        Aviso::mensagemLida($_POST['idAviso']);

        $this->atualizaSessao();
    }

    public function atualizaSessao() {
        $clienteAcade = $this->addUsuarioAcadeGeral();
        $avisos = Aviso::getTodosAvisos($clienteAcade['id_cliente']);
        $_SESSION['avisos'] = $avisos;
    }

    //O SISTEMA DEVE EXIBIR NA TELA INICIAL SOMENTE A ULTIMA MENSAGEM DE ATUALIZAO CADASTRADA
    public function buscaAtualizacoesAction()
    {
        $atualizacao = Aviso::buscaAtualizacoes();
        
        echo json_encode([
            'conteudo' => $atualizacao['ds_aviso'],
            'idAviso' => $atualizacao['id_aviso'],
            'titulo' => utf8_encode($atualizacao['ds_titulo'])
        ]);
    }

    public function buscaTodosAvisosAtualizacoesAction()
    {
        $clienteAcade = $this->addUsuarioAcadeGeral();
        $avisos = Aviso::getTodosAvisos($clienteAcade['id_cliente'], $_POST['ultimoIdAtualizacao'], 1);

        if($avisos) {
            foreach ($avisos as &$a) {
                $a['ds_titulo'] = utf8_encode($a['ds_titulo']);
                $a['ds_aviso'] = utf8_encode($a['ds_aviso']);
            }
        }

        echo json_encode($avisos);
    }

    public function atualizaStatusMensagemAtualizacaoAction ()
    {
        $aviso = Aviso::atualizaStatusMensagemAtualizacao($_GET['mensagem']);

        echo json_encode($aviso);
    }

    public function buscaMensagemAtualizacaoAction()
    {
        $avisos = Controller::getAdapterAcadeGeral()->select()
            ->from(array('a' => TB_AVISO), ['id_aviso', 'ds_aviso', 'dt_aviso', 'ds_titulo'])
            ->where('id_aviso = "' . $_POST['idAviso'] .'"')
            ->where('fl_atualizacao = "1"')
            ->order('id_aviso DESC')
            ->query()->fetch();

        echo json_encode(['aviso' => $avisos['id_aviso']]);
    }
}

