<?php

class AjaxController extends Controller
{
    public function actionsAction()
    {
        //@todo checar permissao aqui
        if ($_GET["controller"]) {
            $actions = array();
            $controller = $_GET["controller"];
            FrontController::loadClass("Db_Action");
            $actions = Db_Action::fetchAll($controller);
            $this->set("actions", $actions);
        }
        $this->display();
    }

    /*
 * Busca e exibe em formato json os dados necessarios para o modal de informacoes de lotes
 */
    public function findPessoasByNomeAction()
    {
        $dados = array();

        //Buscando a lista de lotes para exibir na tela
        $lista = Pessoa::findPessoaByNome($_GET['term']);

        if ($lista) foreach ($lista as $pessoa) {

            if ((new Db_Usuario())->fetchRow('id = '.$pessoa['idPessoa'])) {
                continue;
            }

            $nrCpfCnpj = ($pessoa['nr_cnpj']) ? $pessoa['nr_cnpj'] : $pessoa['nr_cpf'];

            $dados[] = array(
                'text' => utf8_encode($pessoa['nm_pessoa']) . ' (' . $nrCpfCnpj . ')',
                'value' => $pessoa['idPessoa']);
        }

        echo json_encode($dados);
    }

    /*
* Busca e exibe em formato json os dados necessarios para o modal de informacoes de lotes
*/
    public function findEmpreendimentoByNomeAction()
    {
        $dados = array();

        //Buscando a lista de lotes para exibir na tela
        $lista = Empreendimento::findEmpreendimentosByNome(utf8_decode($_GET['term']));

        if ($lista) foreach ($lista as $empreendimento) {

            $dados[] = array('text' => utf8_encode($empreendimento['nm_empreendimento']), 'value' => $empreendimento['id']);
        }

        echo json_encode($dados);
    }
}