<?php
class AdminController extends Controller {

    protected $tb_cliente;
    private $tb_empreendimento;

    //Fun��o p�blica do construtor
    public function __construct($request) {
        parent::__construct($request);

        $this->tb_cliente = new Db_Cliente();
        $this->tb_empreendimento = new Empreendimento();
    }

    public function indexAction(){
        $idEmp = $_POST['idEmp'];
        
        
        //railan alt
        if (!Login::isLogado()) {
            $this->redir(array("modulo" => "sc", "controller" => "login", "action"=>"index"));
        }
        
        $empreendimentos = $this->tb_empreendimento->getDefaultAdapter()->select()
            ->distinct('e.id')
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.id'));
        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }
        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        $cliente = $this->tb_cliente->fetchRow();

        // $this->set('lotes', Lote::lotes($idEmp));
        $this->set('contratos', Contrato::contratos($idEmp));
        $this->set('distratos', Distrato::distratos($idEmp));
        $this->set("empreendimentos", $empreendimentos);
        $this->set('inadimplentes', Contrato::inadimplentes($idEmp));
        $this->set('agendamentos', Empreendimento::listarAgendamentos($idEmp));
        $this->set('juridicos', Juridico::listarJuridicos($idEmp));
        $this->set("cliente", $cliente);        
        
        $permissoesPainel = array(
            'painelLotesDisponiveis' => ACL::hasPermission( Login::getUsuario(), Db_Action::findByNome ( "painelLotesDisponiveis", Db_Controller::findByName ( __CLASS__ ))),
            'painelTotalContratos' => ACL::hasPermission( Login::getUsuario(), Db_Action::findByNome ( "painelTotalContratos", Db_Controller::findByName ( __CLASS__ ))),
            'painelTotalDistratos' => ACL::hasPermission( Login::getUsuario(), Db_Action::findByNome ( "painelTotalDistratos", Db_Controller::findByName ( __CLASS__ ))),
            'painelTotalInadimplentes' => ACL::hasPermission( Login::getUsuario(), Db_Action::findByNome ( "painelTotalInadimplentes", Db_Controller::findByName ( __CLASS__ ))),
            'graficoVendas' => ACL::hasPermission( Login::getUsuario(), Db_Action::findByNome ( "graficoVendas", Db_Controller::findByName ( __CLASS__ ))),
            'graficoParcelasPagas' => ACL::hasPermission( Login::getUsuario(), Db_Action::findByNome ( "graficoParcelasPagas", Db_Controller::findByName ( __CLASS__ ))),
            'graficoDistratos' => ACL::hasPermission( Login::getUsuario(), Db_Action::findByNome ( "graficoDistratos", Db_Controller::findByName ( __CLASS__ ))),
            'graficoLotes' => ACL::hasPermission( Login::getUsuario(), Db_Action::findByNome ( "graficoLotes", Db_Controller::findByName ( __CLASS__ )))
        );

        //conta a quantidade de cards sem permisso para ajustar o tamanho dos cards
        $qtdPermissaoCards = 0;
        
        if (!$permissoesPainel['painelLotesDisponiveis']) {
            $qtdPermissaoCards++;
        }

        if (!$permissoesPainel['painelTotalContratos']) {
            $qtdPermissaoCards++;
        }

        if (!$permissoesPainel['painelTotalDistratos']) {
            $qtdPermissaoCards++;
        }

        if (!$permissoesPainel['painelTotalInadimplentes']) {
            $qtdPermissaoCards++;
        }

        $larguraCards = '';

        switch ($qtdPermissaoCards) {
            case 1:
                $larguraCards = "<div class='col-lg-4 col-sm-6'>";
                break;
            case 2:
                $larguraCards = "<div class='col-lg-6 col-sm-6'>";
                break;
            case 3:
                $larguraCards = "<div class='col-lg-3 col-sm-6'>";
                break;
            default:
                $larguraCards = "<div class='col-lg-3 col-sm-6'>";
        }

        $permissoesPainel['larguraCards'] = $larguraCards;

        $this->set('permissoesPainel', $permissoesPainel);

        $this->display('index');
    }

    public function visualizarAction()
    {
        header("Content-type: text/html; charset=ISO-8859-1");
        $id = explode('_', $_POST['id']);

        if ($id[1] == 'A') { //Visualizar Agendamento
            $agendamento = Empreendimento::getDefaultAdapter()->select()
                ->from(array('r' => TB_RELACIONAMENTO), ['assunto', 'data'])
                ->join(array('c' => TB_CONTRATO), 'c.id = r.idContrato', ['idContrato'=>'id', 'dt_contrato'])
                ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', ['quadra', 'lote'])
                ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', ['nm_pessoa'])
                ->join(array('pU' => TB_PESSOA), 'pU.id = r.usuario', 'nm_pessoa as nmUsuario')
                ->join(array('ta' => TB_AGRUPADA), 'ta.idCampo = r.agr_idStatus AND ta.idTabela = "11"', ['descricao'])
                ->where("r.id = '".$id[0]."'")
                ->query()->fetch();

            $agendamento['dtCadastro'] = Helper::getDate($agendamento['data']);

            $this->set('agendamentos', $agendamento);
            $this->display('visualizar');
        } elseif($id[1] == 'R'){ //Reagendamento
            $agendamento = Empreendimento::getDefaultAdapter()->select()
                ->from(array('r' => TB_RELACIONAMENTO), ['assunto', 'data', 'dt_retorno'])
                ->join(array('c' => TB_CONTRATO), 'c.id = r.idContrato', ['idContrato'=>'id', 'dt_contrato'])
                ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', ['quadra', 'lote'])
                ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', ['nm_pessoa'])
                ->join(array('pU' => TB_PESSOA), 'pU.id = r.usuario', 'nm_pessoa as nmUsuario')
                ->join(array('ta' => TB_AGRUPADA), 'ta.idCampo = r.agr_idStatus AND ta.idTabela = "11"', ['descricao'])
                ->where("r.id = '".$id[0]."'")
                ->query()->fetch();

            $agendamento['dtCadastro'] = Helper::getDate($agendamento['data']);
            $agendamento['dtret'] = Helper::getDate($agendamento['dt_retorno']);

            $this->set('agendamentos', $agendamento);
            $this->display('reagendar');
        } else {  //Visualizar Jurdico
            $juridico = (new Juridico())->getDados($id[0]);

            $juridico['tipoProcesso'] = 'R�u';
            if ($juridico['fl_tipo'] == 'A') {
                $juridico['tipoProcesso'] = 'Autor';
            }
            $juridico['dt_notificacao'] = Helper::getDate($juridico['dt_notificacao']);
            $juridico['dt_audiencia'] = Helper::getDate($juridico['dt_audiencia']);

            $this->set('juridicos', $juridico);
            $this->display('visualizarJuridicos');
        }
    }
    public function reagendarAction()
    {
        $dadosAgendamento = $this -> tb_relacionamento->getDefaultAdapter()->select()
            ->from(['r'=> TB_RELACIONAMENTO],'*')
            ->join(['co' =>  TB_CONTRATO], 'co.id = r.idContrato', ['id_contrato'=>'id'])
            ->join(['pe'=>TB_PESSOA], 'co.id_pessoa = pe.id', 'nm_pessoa')
            ->join(['lo' =>  TB_LOTES], 'lo.id = co.id_lote', ['quadra','lote'])
            ->where('r.id ='. $_GET['id'])
            ->query()->fetch();

        $dadosAgendamento['dt_retorno'] = Helper::getDate($dadosAgendamento['dt_retorno']);
        echo json_encode([
            'data' => $dadosAgendamento
        ]);
    }
    public function reagendamentosalvarAction()
    {
        if ($this->_isGet) {
            $id = (int)$_GET["id"];
            $dt_reagendar = Helper::getInputDate($_GET["novaData"]);
            try {

                $TB_RELACIONAMENTO = new Relacionamento();
                $contato = $TB_RELACIONAMENTO->fetchRow('id = ' . $id);
                // Cria relacionamento
                (new Relacionamento())->saveContato(52, date('Y-m-d'), $contato->idContrato, 'Log: Alterado retorno do contato de ' . Helper::getDate($contato->dt_retorno) . ' para ' . Helper::getDate($dt_reagendar)) . '.'; 
                $contato->dt_retorno = $dt_reagendar;
                $contato->save();
               
                $this->redir(array("modulo" => "sc", "controller" => "admin", 'action' => 'index'), array("msg" => "Alterado com sucesso"));
            } catch (Exception $e) {
                $this->redir(array("modulo" => "sc", "controller" => "admin", 'action' => 'index'), array("exception" => $e->getMessage()));
            }
            
        }
    }
}
