<?php
class ActionController extends Controller {

    public function indexAction() {
        $this->redir(array("controller"=>"action","action"=>"listar"));
    }

    public function adicionarAction() {
        $controllers = Db_Controller::fetchAll();
        $this->set("controllers",$controllers);

        $this->display("form");
    }

    public function editarAction() {
        $controllers = Db_Controller::fetchAll();
        $this->set("controllers",$controllers);
        $this->set("action",Db_Action::find($_GET["id"]));
        $this->display("form");
    }

    public function saveAction() {

        if (Login::isLogado () && ACL::hasPermission ( Login::getUsuario (), Db_Action::findByNome ( "adicionar", Db_Controller::findByName ( __CLASS__ ) ) )) {

            $a = new Db_Action();

            $a->setId($_POST["id"]);
            $a->setNome($_POST["nome"]);
            $a->setControllerId($_POST["controllerId"]);
            $a->setPrivate($_POST["private"]);
            $acao = 'i';
            if ($_POST["id"])
                $acao = 'u';

            $this->set("action",$a);

            if($this->validar()) {
                $a->setLog(Login::getUsuario()->getLogin().' - '.date('d/m/Y').' - '.$acao);
                $a->save();
                $this->redir(array("controller" => "action", "action" => "listar"),array("msg" => "OK"));
            }else {
                $this->adicionarAction();
            }
        }else {
            throw new Exception("O usurio no tem permisso de acessar essa action.");
        }
    }

    private function validar() {
        //validao vazio
        $campos = array ("nome", "controllerId", "private");
        foreach ( $campos as $cp ) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "nome" :
                        $msg = "O campo Nome  obrigatrio.";
                        break;
                    case "controller" :
                        $msg = "O campo Controller  obrigatrio.";
                        break;
                    case "private" :
                        $msg = "Selecione se a action  protegida.";
                        break;
                }
                $this->_helper->addMensagem ( $cp, $msg );
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function listarAction() {
        $this->set("botoes",array("Adicionar" => array("c" => "action", "a" => "adicionar")));
        $this->set("subtitulo","Actions");

        $count = Db_Action::fetchAll(null, true);

        /*Total de linhas*/
        $totalItems = $count[0]->count;

        /*Seta as opes do paginador*/
        $pager_options = array(
                'mode'       => 'Sliding',   // Sliding or Jumping mode. See below.
                'perPage'    => 10,   // Total rows to show per page
                'delta'      => 4,   // See below
                'totalItems' => $totalItems,
        );

        /*Instancia o paginador*/
        $pager = Pager::factory($pager_options);
        /* The following code will retreive the result using the pager options */

        /*Seta o offset para colocar na query*/
        list($from, $to) = $pager->getOffsetByPageId();

        /*Ajuste para MySQL que comea o offset com 0*/
        $from = $from - 1;

        /*A quanditade de linhas por query*/
        $perPage = $pager_options['perPage'];

        $actions = Db_Action::fetchAll(null, false, $from, $perPage);
        $this->set("actions",$actions);
        $this->set("action",array("c" => "action", "a" => "pesquisar"));
        $this->set('paginacao',$pager->links);
        if($_GET["msg"] == "OK") {
            $this->_helper->addMensagem("ok","Operao realizada com sucesso!");
        }elseif($_GET["msg"] == "FAIL") {
            $this->_helper->addMensagem("fail","Erro! No foi possvel continuar a operao!");
        }

        $this->display();
    }

    public function pesquisarAction() {

        $count = Db_Action::fullSearch($_GET["termo"], true);
        /*Total de linhas*/
        $totalItems = $count[0]->count;

        /*Seta as opes do paginador*/
        $pager_options = array(
                'mode'       => 'Sliding',   // Sliding or Jumping mode. See below.
                'perPage'    => 10,   // Total rows to show per page
                'delta'      => 4,   // See below
                'totalItems' => $totalItems,
        );

        /*Instancia o paginador*/
        $pager = Pager::factory($pager_options);
        /* The following code will retreive the result using the pager options */

        /*Seta o offset para colocar na query*/
        list($from, $to) = $pager->getOffsetByPageId();

        /*Ajuste para MySQL que comea o offset com 0*/
        $from = $from - 1;

        /*A quanditade de linhas por query*/
        $perPage = $pager_options['perPage'];

        $actions = Db_Action::fullSearch($_GET["termo"], false, $from, $perPage);
        $this->set("action",array("c" => "action", "a" => "pesquisar"));
        $this->set("subtitulo","Actions");
        $this->set("actions",$actions);
        $this->set("botoes",array("voltar" => array("c" => "action", "a" => "listar")));
        $this->display();
    }

    public function deletarAction() {
        try {
            Db_Action::delete($_GET["id"]);
            $this->redir(array("controller" => "action", "action" => "listar"),array("msg" => "OK"));
        }catch (Exception $e) {
            $this->redir(array("controller" => "action", "action" => "listar"),array("msg" => "FAIL"));
        }

    }





}
