<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';
$empreendimentos = $this->get('empreendimentos');
$dados = $this->get("dados");
?>
<div class="content">
    <div class="page-heading">
        <?= $this->getHeader('Relatrio de', 'Previso de Parcelas', 'fa fa-file-o'); ?>
    </div>
    <div class="widget">
        <div class="widget-content padding">
            <!-- MENSAGENS -->
            <div class="alert alert-danger alert-dismissable msgErros" hidden></div>
            <div class="alert alert-success alert-dismissable msgSucess" hidden>Operao realizada com sucesso.</div>
            <form method="POST" id="form" action="?m=rl&c=relatorioPrevisao&a=relatorio" target="_blank">
                <fieldset>
                    <legend>Informaes Previso Parcelas <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                        <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                            <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                            </svg>
                        </span>
                    </legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-4">
                                <label class="control-label">
                                    Empreendimento:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2 empreendimento" required="required" id="empreendimento" name="empreendimento" data-placeholder="Escolha o empreendimento">
                                    <option value=""></option>
                                    <?php if ($empreendimentos) :
                                        foreach ($empreendimentos as $empreendimento) : ?>
                                            <option <?php if ($empreendimento['id_empreendimento'] == $dados["id_empreendimento"]) : ?>selected <?php endif; ?> value="<?php echo $empreendimento['id_empreendimento']; ?>"><?php echo $empreendimento['nm_empreendimento']; ?></option>
                                    <?php endforeach;
                                    endif; ?>
                                </select>
                            </div>
                            <div class="form-group col-sm-6">
                                <label class="control-label">
                                    Cliente:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2 contrato" required="required" id="contratoParcela" name="idContrato" data-placeholder="Escolha o cliente">
                                    <option value=""></option>
                                    <?php echo $this->get("contratos"); ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-2">
                                <label class="control-label">
                                    Data inicial:<span class="require" style="color: red">*</span>
                                </label>
                                <input type="text" class="form-control data datepicker-input" id="de" name="de" placeholder="Data inicial" required="required" value="<?php echo $dados["de"] ?>" />
                            </div>
                            <div class="form-group col-sm-2">
                                <label class="control-label">
                                    Data final:<span class="require" id="periodoDias" style="font-size: 12px">(Mx 90 dias)</span>
                                </label>
                                <input type="text" class="form-control data datepicker-input" id="ate" name="ate" placeholder="Data final" required="required" value="<?php echo $dados["ate"] ?>" />
                            </div>
                            <div class="form-group col-sm-4">
                                <label class="control-label" for="previsaoParcelasBanco">
                                    Banco:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2 previsaoParcelasBanco" data-placeholder="Escolha o banco" id="previsaoParcelasBanco" required="required" name="previsaoParcelasBanco" require>
                                    <option value="">Selecione...</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3">
                                <label>Clientes:</label><br>
                                <div class="checkbox">
                                    <label for="Adimplente" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="tp_clientes[]" id="Adimplente" value="A" /> Adimplente</label>
                                    <label for="Inadimplente" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="tp_clientes[]" id="Inadimplente" value="I" /> Inadimplente</label>
                                </div>
                            </div>
                            <div class="form-group col-sm-8">
                                <label>Tipo de parcela:</label><br>
                                <div class="checkbox">
                                    <label for="Normal" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="Normal" value="N" /> Normal</label>
                                    <label for="Sinal" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="Sinal" value="S" /> Sinal</label>
                                    <label for="Intercalada" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="Intercalada" value="I" /> Intercalada</label>
                                    <label for="Chave" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="Chave" value="C" /> Chave</label>
                                    <label for="Negociada" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="Negociada" value="G" /> Negociada</label>
                                    <label for="Quitacao" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="Quitacao" value="Q" /> Quitao</label>
                                    <label for="Avulsa" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="Avulsa" value="A" /> Avulsa</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3">
                                <label>Parcelas:</label><br>
                                <div class="checkbox">
                                    <label><input type="radio" class="form-control icheck" name="parcelaEmissao" id="emissaoTodos" value="" checked>
                                    Todas</label>
                                    <label><input type="radio" class="form-control icheck" name="parcelaEmissao" id="emitidos" value="emitidos">
                                    Apenas com boletos emitidos</label>
                                </div>
                            </div>
                            <div class="form-group col-sm-6">
                                <label class="control-label">
                                    Ordenar por:
                                </label><br>
                                <div class="checkbox">
                                   <label for="quadra"><input type="radio" class="form-control icheck" name="ordena" id="quadra" value="quadra" checked />
                                    Quadra</label>

                                    <label for="lote"><input type="radio" class="form-control icheck" name="ordena" id="lote" value="lote" />
                                    Lote</label>

                                    <label for="dt_parcela"><input type="radio" class="form-control icheck" name="ordena" id="dt_parcela" value="dt_parcela" />
                                    Data de vencimento</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-4">
                                <label class="control-label">
                                    Tipo de impresso:
                                </label><br>
                                <div class="checkbox">
                                    <label><input type="radio" class="form-control icheck" name="tpImpressao" id="pdf" value="pdf" checked /> PDF</label>
                                    <label><input type="radio" class="form-control icheck" name="tpImpressao" id="html" value="html" /> HTML</label>
                                    <label><input type="radio" class="form-control icheck tipo col-sm-3" name="tpImpressao" id="tipoRelatorioExcel" value="xls" /> Excel</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </fieldset>
                <fieldset>
                    <legend>Operaes</legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-2">
                                <input type="button" class="btn btn-primary col-sm-12 fDesabilitaBtn" id="gerar" value="Gerar">
                            </div>
                        </div>
                    </div>
                </fieldset>
            </form>

        </div>
    </div>
</div>
<div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg ">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-hidden="true">&times;</button>
                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                    Tutorial</h2>
            </div>

            <div class="modal-body tableFix" style="max-height:600px;">
                <fieldset >
                    <legend>Previso de Parcelas - Relatrio de Parcelas a Receber</legend>
                    <div class="row" style="margin-right: 0px;margin-left: 0px;">
                        <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/oDrEFm1M-Sg?si=zkzMMaFtmTBrusga" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                    </div>
                    <div></div>
                </fieldset>
            </div>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>