<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';

$empreendimentos = $this->get('empreendimentos');
$dados = $this->get("dados");
$formaBaixa = $this->get('formaBaixa');
?>
<div id="show" class="content">
    <div class="page-heading">
        <?= $this->getHeader('Relatrio', 'Parcelas Pagas', 'fa fa-file-o'); ?>
    </div>
    <div class="widget">
        <form action="<?= $this->_helper->getLink(array("m" => "rl", "c" => "relatorioPagas", "a" => 'relatorio')); ?>" method="POST" id="form" target="receiver">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <div class="alert alert-danger alert-dismissable msgErros" hidden></div>
                <div class="alert alert-success alert-dismissable msgSucess" hidden>Operao realizada com sucesso.</div>
                <?php if ($_GET['msg'] == 'fail') : ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?= $_GET['exception'] ?><br>
                    </div>
                <?php endif; ?>
                <legend>Relatrio de Parcelas Pagas <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                    <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                        <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                            <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                        </svg>
                    </span>
                </legend>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-6">
                            <label class="control-label">
                                Empreendimento:<span class="require" style="color: red">*</span>
                            </label>
                            <select class="form-control select2 empreendimentoParcelaPaga" id="empreendimento_relatorio_parcela_paga" name="empreendimento_relatorio_parcela_paga" required="required" data-placeholder="Selecione o empreendimento">
                                <option value="">Selecione ...</option>
                                <option value="">Selecione ...</option>
                                <?php if ($empreendimentos) {
                                    foreach ($empreendimentos as $empreendimento) {
                                        $select = ($empreendimento['id_empreendimento'] == $dados["id_empreendimento"]) ? 'selected' : '';
                                        echo '<option value="' . $empreendimento['id_empreendimento'] . '" ' . $select . '>' . $empreendimento['nm_empreendimento'] . '</option>';
                                    }
                                }
                                ?>
                            </select>
                        </div>
                        <div class="form-group col-sm-6">
                            <label class="control-label">
                                Clientes:<span class="require" style="color: red">*</span>
                            </label>
                            <select class="form-control select2 clienteParcelaPaga" name="cliente_relatorio_parcela_paga" data-placeholder="Selecione o cliente" id="cliente_relatorio_parcela_paga" required="required">
                                <option value="">Escolha o Cliente</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-6">
                            <label class="control-label">
                                Quadra/Lote:<span class="require" style="color: red">*</span>
                            </label>
                            <select class="form-control select2 quadraParcelaPaga" name="quadra_relatorio_parcela_paga" data-placeholder="Selecione quadra/lote" id="quadra_relatorio_parcela_paga" required="required">
                                <option value="">Escolha a wuadra/lote</option>
                            </select>
                            </select>
                        </div>
                        <div class="form-group col-sm-6">
                            <label class="control-label">
                                Banco: <span class="require" style="color: red">(Obs.: deixe em branco para emitir baixas sem vnculo bancrio.)</span>
                            </label>
                            <select class="form-control select2 banco_boleto" name="banco" id="banco" data-placeholder="Selecione o banco">
                                <option value="">Escolha o banco</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-3">
                            <label class="control-label" for="dePagamento">
                                Data pagamento inicial:<span class="require" style="color: red">*</span>
                            </label>
                            <input type="text" class="form-control data datepicker-input" id="dePagamento" placeholder="Selecione a data inicial" name="dePagamento" />
                        </div>
                        <div class="form-group col-sm-3">
                            <label class="control-label" for="atePagamento">
                                Data final:<span class="require" style="color: red">*</span> <span style=" font-size: 9pt"><span style="color: red" class="span120dias" hidden>Mximo 120 dias (pdf)</span></span>
                            </label>
                            <input type="text" class="form-control data datepicker-input" id="atePagamento" placeholder="Selecione a data final" name="atePagamento" />
                        </div>
                        <div class="form-group col-sm-3">
                            <label class="control-label" for="deCredito">
                                Data crdito inicial:<span class="require" style="color: red">*</span>
                            </label>
                            <input type="text" class="form-control data datepicker-input" id="deCredito" placeholder="Selecione a data inicial" name="deCredito" />
                        </div>
                        <div class="form-group col-sm-3">
                            <label class="control-label" for="ateCredito">
                                Data final:<span class="require" style="color: red">*</span>
                                <span style="font-size: 9pt">
                                    <span style="color: red" class="span120dias" hidden>
                                        Mximo 120 dias (pdf)
                                    </span>
                                </span>
                            </label>
                            <input type="text" class="form-control data datepicker-input" id="ateCredito" placeholder="Selecione a data final" name="ateCredito" />
                        </div>
                    </div>
                </div>
                <div class="middle" style="display:block">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-8">
                                <label class="control-label">Tipos de parcelas:</label><br>
                                <div class="checkbox">
                                    <label><input type="checkbox" name="tp_parcela[]" class="icheck" value="N" checked>Normal</label>
                                    <label><input type="checkbox" name="tp_parcela[]" class="icheck" value="S" checked>Sinal</label>
                                    <label><input type="checkbox" name="tp_parcela[]" class="icheck" value="C" checked>Chave</label>
                                    <label><input type="checkbox" name="tp_parcela[]" class="icheck" value="G" checked>Negociada</label>
                                    <label><input type="checkbox" name="tp_parcela[]" class="icheck" value="Q" checked>Quitao</label>
                                    <label><input type="checkbox" name="tp_parcela[]" class="icheck" value="I" checked>Intercalada</label>
                                    <label><input type="checkbox" name="tp_parcela[]" class="icheck" value="A" checked>Avulsa</label>
                                </div>
                            </div>
                        </div>
                    </div>                
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label>Tipos de baixa:</label><br>
                                <div class="checkbox">
                                    <label><input type="checkbox" name="tp_pagamento[]" id="Banco" class="icheck" value="B" checked> Banco</label>
                                    <label><input type="checkbox" name="tp_pagamento[]" id="Tesouraria" class="icheck" value="T" checked> Tesouraria</label>
                                    <label><input type="checkbox" name="tp_pagamento[]" id="Outros" class="icheck" value="O"> Outros</label>
                                </div>
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label">
                                    Forma de baixa
                                </label>
                                <select name="formaBaixa[]" multiple id="formaBaixa" class="form-control select2" data-placeholder="Selecione a forma de baixa">
                                    <option value=""></option>
                                    <?php foreach ($formaBaixa as $baixa): ?>
                                        <option value="<?= $baixa['idCampo'] ?>"><?= $baixa['descricao'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="totalizarBaixa">Totalizar forma de baixa:</label><br>
                                <div class="checkbox">
                                    <label><input type="radio" class="form-control icheck tipo col-sm-3" name="totalizarBaixa" checked value="N" />No</label>
                                    <label><input type="radio" class="form-control icheck tipo col-sm-3" name="totalizarBaixa" value="S" />Sim</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3">
                                <label class="control-label">Tipo de relatrio:</label><br>
                                <div class="checkbox">
                                    <label><input type="radio" id="sint" class="form-control icheck tipo col-sm-3" name="tipo" value="P" />Sinttico</label>
                                    <label><input type="radio" id="anali" class="form-control icheck tipo col-sm-3" name="tipo" value="PC" checked />Analtico</label>
                                </div>
                            </div>
                            <div class="form-group col-sm-3">
                                <label>Exibir parceiro(s):</label><br>
                                <div class="checkbox">
                                    <label><input type="radio" id="parceiroS" class="form-control icheck tipo col-sm-3" name="parceiro" checked value="1" />Sim</label>
                                    <label><input type="radio" id="parceiroN" class="form-control icheck tipo col-sm-3" name="parceiro" value="N" />No</label>
                                </div>
                            </div>
                            <div class="form-group col-sm-3">
                                <div id="divSubTotalizar" hidden>
                                    <label class="control-label" for="subtotalizar">Subtotalizar:</label><br>
                                    <div class="checkbox">
                                        <label><input type="radio" id="subtotalizarN" class="form-control icheck tipo col-sm-3" name="subtotalizar" checked value="N" />No</label>
                                        <label><input type="radio" id="subtotalizarS" class="form-control icheck tipo col-sm-3" name="subtotalizar" value="S" />Sim</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3">
                                <label class="control-label">Exibir observaes de baixa?</label><br>
                                <div class="checkbox">
                                    <label><input type="radio" id="exibirS" class="form-control icheck tipo col-sm-3" name="exibirInfo" value="S" />Sim</label>
                                    <label><input type="radio" id="exibirN" class="form-control icheck tipo col-sm-3" name="exibirInfo" checked value="N" />No</label>
                                </div>
                            </div>
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="ordem">Ordenar por:</label><br>
                                <div class="checkbox">
                                    <label><input type="radio" id="ordemQ" class="form-control icheck tipo col-sm-3" name="ordem" value="Q" checked />Quadra/Lote</label>
                                    <label><input type="radio" id="ordemP" class="form-control icheck tipo col-sm-3" name="ordem" value="P" />Cliente</label>
                                    <label><input type="radio" id="ordemPG" class="form-control icheck tipo col-sm-3" name="ordem" value="PG" />Data de pagamento</label>
                                    <label><input type="radio" id="ordemC" class="form-control icheck tipo col-sm-3" name="ordem" value="C" />Data crdito</label>
                                </div>
                            </div>

                            <div class="form-group col-sm-3" style="display:none">
                                <label class="control-label">Gerar em:</label><br>
                                <div class="checkbox">
                                    <label><input type="radio" id="tipoRelatorioPdf" class="form-control icheck tipo col-sm-3" name="tipoRelatorio" checked value="pdf" />PDF</label>
                                    <label><input type="radio" id="tipoRelatorioHtml" class="form-control icheck tipo col-sm-3" name="tipoRelatorio" value="html" />HTML</label>
                                    <label><input type="radio" id="tipoRelatorioExcel" class="form-control icheck tipo col-sm-3" name="tipoRelatorio" value="xls" />Excel</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <input id="visualizarInput" name="visualizar" value="false" style="display: none">
                <div style="display:flex; justify-content:center; align-items:center">
                        <p id="hide-content" class="expandirMenu centralizador" style="display:none; cursor:pointer"><i class="fa fa-chevron-down"></i></p>
                </div>
                <legend>Operaes:</legend>
                <div class="row">
                    <div class="col-sm-12">                     
                        <div class="form-group col-sm-2">
                            <span id="pesquisar" class="btn btn-primary col-sm-12 fDesabilitaBtn" style="color:white; border-radius:5px"><i class="fa fa-search" aria-hidden="true"></i> Buscar</span>
                        </div>
                        <div class="form-group col-sm-2">
                            <button id="pdf" class="btn btn-danger col-sm-12 fDesabilitaBtn" style="color:white; border-radius:5px"><i class="fa fa-file-pdf-o" aria-hidden="true"></i> PDF
                        </div>
                        <div class="form-group col-sm-2">
                            <button id="xls" class="btn btn-success col-sm-12 fDesabilitaBtn" style="color:white; border-radius:5px"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Excel
                        </div>                     
                        <div name="receiver" overflow="auto" id="receiver" seamless="seamless" ></div>
                    </div>
                </div>                                      
                <br>
            </div>
        </form>
    </div>
</div>
</div>
<div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg ">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-hidden="true">&times;</button>
                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                    Tutorial</h2>
            </div>

            <div class="modal-body tableFix" style="max-height:600px;">
                <fieldset >
                    <legend>Parcelas Pagas - Relatrio de Todas as Parcelas Pagas no intervalo solicitado</legend>
                    <div class="row" style="margin-right: 0px;margin-left: 0px;">
                        <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/wUylOATD_vM?si=D6eOKjs-m-LLRQXw" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                    </div>
                    <div></div>
                </fieldset>
            </div>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>