<?php
$relatorio = $this->get('relatorio');
$empreendimentoInfo = $this->get('empreendimentoInfo');
?>
<page backtop="-1mm" backbottom="-1mm">
<style type="text/css">
    table.tabela td {
        border-collapse: collapse;
        padding: 3px 5px 3px 5px;
    }

    table tr td.linhaEscura {
        background-color: #ccc;
    }

    table th {
        background-color: #ccc;
        border: 1px solid #000000;
        padding: 3px 5px 3px 5px;
    }

    table {
        font-family: arial;
        border-collapse: collapse;
    }

    header td {
        background-color: #B8B8B8;
    }

</style>
<div style="margin-bottom:20px;"></div>
<div style=" width:800px;">
    <table style="font-family: arial;">
        <tr>
            <td valign="top" style="width: 170px;" rowspan="2">
                <!-- Logomarca Cliente Acade -->
                <?php
                $clienteAcade = $this->get("clienteAcade");
                $dsEmpreendimentoPathLogo = $relatorio['empreendimento']['ds_path_logo'];
                $dsEndLogomarca = $clienteAcade['ds_end_logomarca'];
                if ($dsEmpreendimentoPathLogo && file_exists($dsEmpreendimentoPathLogo)){
                    echo '<img src="'.$dsEmpreendimentoPathLogo.'" alt="'.$relatorio['empreendimento'].'" height="120">';
                }
                elseif ($dsEndLogomarca && file_exists($dsEndLogomarca)) {
                    echo '<img src="' . $dsEndLogomarca . '" alt="' . $clienteAcade['nm_fantasia'] . '" height="120">';
                } else {
                    echo '<img style="float: left; " src="' . LOGOMARCA_DEFAULT . '" alt="LogoPadrao" height="80">';
                }

                ?>
            </td>
            <td align="center" width="400" style="font-size: 11pt;">
                <strong style="text-align: center;margin-top: 20px;">RELATRIO DE IMPOSTO DE RENDA</strong><br/><br/>
                <span
                    style="font-size: 9pt;"><strong>
                        Loteamento: </strong><?php echo $relatorio['empreendimento']['nm_empreendimento'] ?></span><br/>
                <?php if($relatorio['empreendimento']['tp_pessoa'] == 'J'): ?>
                    <span style="font-size: 9pt;">
                        <strong>Empresa: </strong><?php echo $relatorio['empreendimento']['nm_empresa'] ?>
                    </span><br/>
                    <span style="font-size: 9pt;">
                        <strong>CNPJ: </strong><?php echo $relatorio['empreendimento']['cnpj']; ?>
                    </span><br/>
                <?php else: ?>
                    <span style="font-size: 9pt;">
                        <strong>Nome: </strong><?php echo $relatorio['empreendimento']['nm_empresa'] ?>
                    </span><br/>
                    <span style="font-size: 9pt;">
                        <strong>CPF: </strong><?php echo $relatorio['empreendimento']['cnpj']; ?>
                    </span><br/>
                <?php endif; ?>
                <?php if ($relatorio['periodo']) { ?>
                    <span style="font-size: 9pt;"><strong>Perodo: </strong><?php echo $relatorio['periodo']; ?></span>
                <?php } ?>
            </td>
        </tr>
    </table>
</div>
<div style="margin-top:10px;">&nbsp;</div>
<div style="margin-left:5px; width:800px; float: left">
    <span style="font-size: 10pt;">
        <strong>Cliente: </strong><?php echo ($relatorio['contrato'][0]['nm_pessoa'] == '') ? end($relatorio['contrato'])['nm_pessoa'] : $relatorio['contrato'][0]['nm_pessoa'] ?>
        <br/>
        <strong>CPF: </strong><?php echo ($relatorio['contrato'][0]['nr_cpf'] == '') ? end($relatorio['contrato'])['nr_cpf'] : $relatorio['contrato'][0]['nr_cpf'] ?>
    </span><br/><br/>
    <?php $count = count($relatorio['contrato']);
    if ($count) {
        ?>
        <?php
        $i = 1;
        foreach ($relatorio['contrato'] AS $idContrato => $contrato) :
            $seq = 0;
            ?>
            <span style="font-size: 10pt;">
                <strong><?= ($empreendimentoInfo['ds_grupo'] != '') ? $empreendimentoInfo['ds_grupo']:''?> </strong><?php echo $contrato['quadra'] . '  ' ?>
                <strong><?= ($empreendimentoInfo['ds_subgrupo'] != '') ? $empreendimentoInfo['ds_subgrupo']:''?> </strong><?php echo $contrato['lote'] . '  ' ?>
                <strong>Contrato: </strong><?php echo $contrato['id_contrato'] . '  ' ?>
                <?php if ($contrato['porcentagem_participacao_contrato'] != null && $contrato['porcentagem_participacao_contrato'] < 100) : ?>
                    <strong>Participao: </strong><?= $contrato['porcentagem_participacao_contrato'] . '%' ?>
                <?php endif; ?>
            </span>
            <table id="contrato" name="contrato" style="font-size: 12px" width="800px" align="center">

                <tr class="header">
                    <td width="20px;" align="center">
                        <strong>Sequencial</strong></td>
                    <td align="center" width="30px;">
                        <strong><?= ($empreendimentoInfo['ds_grupo'] != '') ? $empreendimentoInfo['ds_grupo']:''?></strong></td>
                    <td align="center" width="30px;">
                        <strong><?= ($empreendimentoInfo['ds_subgrupo'] != '') ? $empreendimentoInfo['ds_subgrupo']:''?></strong></td>
                    <td align="center" width="45px;">
                        <strong>Parcela</strong></td>
                    <td align="center" width="45px;">
                        <strong>Tipo Parcela</strong></td>
                    <td align="center" width="60px;">
                        <strong>Vencto</strong></td>
                    <td align="center" width="60px;">
                        <strong>Pagto</strong></td>
                    <td align="center" width="60px;">
                        <strong>Valor Parcela</strong></td>
                    <td align="right" width="60px;">
                        <strong>Desconto</strong></td>
                    <td align="right" width="60px;">
                        <strong>Multa</strong></td>
                    <td align="right" width="60px;">
                        <strong>Juros</strong></td>
                    <td align="right" width="80px;">
                        <strong>Valor Pago</strong></td>
                </tr>
                <?php
                $totalAcumulado = 0;
                foreach ($contrato['parcelas'] as $parcela) :

                    if ($i % 2 == 0) {
                        $cor = "#CCCCCC";
                    } else {
                        $cor = "#FFFFFF";
                    }

                    $i++;
                    ?>
                    <tr style="font-size: 12px; background-color: <?php echo $cor; ?>;">
                        <td width="20px" align="center">
                            <?php $seq++;
                            echo str_pad($seq, 3, '0', STR_PAD_LEFT) ?></td>
                        <td align="center"><?php echo $contrato['quadra'] ?></td>
                        <td align="center"><?php echo $contrato['lote'] ?></td>
                        <!-- ADICIONA O CAMPO CASO SEJA COMPLETO -->
                        <?php if ($relatorio['tipo']) : ?>
                            <td align="center"><?php echo $parcela['id_parcela_contrato'] ?></td>
                        <?php endif; ?>
                        <td align="right">
                            <?php
                            switch ($parcela['tp_parcela']) {
                                case 'S':
                                    echo $parcela['id_parcela'] . '/' . $contrato['nr_parcela_sinal'] . '-' . $parcela['tp_parcela'];
                                    break;
                                case 'I':
                                    echo $parcela['id_parcela'] . '/' . $contrato['nr_intercalada'] . '-' . $parcela['tp_parcela'];
                                    break;
                                case 'G':
                                    echo $parcela['id_parcela'] . '/' . $parcela['nr_negociacao'] . '-' . $parcela['tp_parcela'];
                                    break;
                                case 'C':
                                    echo $parcela['id_parcela'] . '/' . $contrato['nr_parcela_entrega'] . '-' . $parcela['tp_parcela'];
                                    break;
                                case 'Q':
                                    echo $parcela['id_parcela'] . '/' . $contrato['total']['quitacao'] . '-' . $parcela['tp_parcela'];
                                    break;
                                default:
                                    echo $parcela['id_parcela'] . '/' . $contrato['nr_parcela'] . '-' . $parcela['tp_parcela'];
                                    break;
                            }
                            ?></td>
                        <td
                            align="center"><?php
                            switch ($parcela['tp_parcela']) {
                                case 'S':
                                    echo 'Sinal';
                                    break;
                                case 'I':
                                    echo 'Intercalada';
                                    break;
                                case 'G':
                                    echo 'Negociao';
                                    break;
                                case 'C':
                                    echo 'Entrega';
                                    break;
                                case 'Q':
                                    echo 'Quitao';
                                    break;
                                default:
                                    echo 'Mensal';
                                    break;
                            }
                            ?></td>
                        <td
                            align="center"><?php echo Helper::getDate($parcela['dt_parcela']) ?></td>
                        <td
                            align="center"><?php echo Helper::getDate($parcela['dt_pagamento']) ?></td>
                        <td
                            align="right"><?php echo Helper::getMoney($parcela['vl_parcela']) ?></td>
                        <td
                            align="right"><?php echo Helper::getMoney($parcela['desconto']) ?></td>
                        <td
                            align="right"><?php echo Helper::getMoney($parcela['vl_multa']) ?></td>
                        <td
                            align="right"><?php echo Helper::getMoney($parcela['vl_juros']) ?></td>
                        <td                       
                            align="right"><?php $totalAcumulado += $parcela['vl_total_pago']; echo Helper::getMoney($parcela['vl_total_pago']) ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                <tr>
                    <td colspan="11" align="right"><strong>Total: </strong></td>
                    <td align="right"><?php echo Helper::getMoney($totalAcumulado) ?></td>
                </tr>
                <tr>
                    <td width="690px" colspan="8">&nbsp;</td>
                </tr>
            </table>
        <?php endforeach; ?>

        <table id="contrato" name="contrato" style="font-size: 10px;" width="800px" align="right">
            <tr>
                <td><strong>Nmero de Parcelas:</strong> <?= $relatorio['total']['parcela'] ?></td>
            </tr>
            <tr>
                <td><strong>Total de Parcelas:</strong> <?= $_SESSION['simboloMoeda'].' ' . Helper::getMoney($relatorio['total']['valor']) ?>
                </td>
            </tr>
            <tr>
                <td><strong>Total de Desconto:</strong> <?= $_SESSION['simboloMoeda'].' ' . Helper::getMoney($relatorio['total']['desconto']) ?></td>
            </tr>
            <tr>
                <td><strong>Total de Multa:</strong> <?= $_SESSION['simboloMoeda'].' ' . Helper::getMoney($relatorio['total']['multa']) ?></td>
            </tr>
            <tr>
                <td><strong>Total de Juros:</strong> <?= $_SESSION['simboloMoeda'].' ' . Helper::getMoney($relatorio['total']['juros']) ?></td>
            </tr>
            <tr>
                <td><strong>Total:</strong> <?= $_SESSION['simboloMoeda'].' ' . Helper::getMoney($relatorio['total']['total']) ?></td>
            </tr>
        </table>
    <?php
    }
    ?>
</div>
</page>