<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';

$empreendimentos = $this->get('empreendimentos');
$dados = $this->get("dados");
$formaBaixa = $this->get('formaBaixa');

?>
<div id="show" class="content">
    <div class="page-heading">
        <?= $this->getHeader('Relatrio', 'Price', 'fa fa-file-o'); ?>
    </div>
    <div class="widget">
        <form action="<?= $this->_helper->getLink(array("m" => "rl", "c" => "relatorioExtratoPrice", "a" => 'relatorio')); ?>" method="POST" id="form" target="receiver">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <div class="alert alert-danger alert-dismissable msgErros" hidden></div>
                <div class="alert alert-success alert-dismissable msgSucess" hidden>Operao realizada com sucesso.</div>
                <?php if ($_GET['msg'] == 'fail') : ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?= $_GET['exception'] ?><br>
                    </div>
                <?php endif; ?>
                <legend>Relatrio Price <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span></legend>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-6">
                            <label class="control-label">
                                Empreendimento:<span class="require" style="color: red">*</span>
                            </label>
                            <select class="form-control select2 empreendimentoParcelaPaga" id="empreendimento_relatorio_parcela_paga" name="empreendimento_relatorio_parcela_paga" required="required" data-placeholder="Selecione o empreendimento">
                                <option value="">Selecione ...</option>
                                <option value="">Selecione ...</option>
                                <?php if ($empreendimentos) {
                                    foreach ($empreendimentos as $empreendimento) {
                                        $select = ($empreendimento['id_empreendimento'] == $dados["id_empreendimento"]) ? 'selected' : '';
                                        echo '<option value="' . $empreendimento['id_empreendimento'] . '" ' . $select . '>' . $empreendimento['nm_empreendimento'] . '</option>';
                                    }
                                }
                                ?>
                            </select>
                        </div>
                        <div class="form-group col-sm-6">
                            <label class="control-label">
                                Clientes:<span class="require" style="color: red">*</span>
                            </label>
                            <select class="form-control select2 clienteExtratoPrice" name="cliente_relatorio_parcela_paga" data-placeholder="Selecione o cliente" id="cliente_relatorio_parcela_paga" required="required">
                                <option value="">Escolha o Cliente</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-6">
                            <label class="control-label">
                                Quadra/Lote:<span class="require" style="color: red">*</span>
                            </label>
                            <select class="form-control select2 quadraExtratoPrice" name="quadra_relatorio_parcela_paga" data-placeholder="Selecione quadra/lote" id="quadra_relatorio_parcela_paga" required="required">
                                <option value="">Escolha a wuadra/lote</option>
                            </select>
                            </select>
                        </div>
                        <div class="form-group col-sm-3">
                            <label class="control-label" for="correcao">
                                Correo:<span class="require" style="color: red">*</span>
                            </label>
                            <input type="text" class="form-control data datepicker-input" id="correcao" placeholder="Selecione a data de correo" name="correcao" value="<?= date('d/m/Y'); ?>" />
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-3">
                            <label class="control-label" for="dePagamento">
                                Perodo de Vencimento Inicial:<span class="require" style="color: red">*</span>
                            </label>
                            <input type="text" class="form-control data datepicker-input" id="dePagamento" placeholder="Selecione a data inicial" name="dePagamento" />
                        </div>
                        <div class="form-group col-sm-3">
                            <label class="control-label" for="atePagamento">
                            Perodo Final:<span class="require" style="color: red">*</span> <span style=" font-size: 9pt"><span style="color: red" class="span120dias" hidden>Mximo 120 dias (pdf)</span></span>
                            </label>
                            <input type="text" class="form-control data datepicker-input" id="atePagamento" placeholder="Selecione a data final" name="atePagamento" />
                        </div>
                        <div class="form-group col-sm-3">
                            <label class="control-label" for="deCredito">
                                Data Crdito Inicial:<span class="require" style="color: red">*</span>
                            </label>
                            <input type="text" class="form-control data datepicker-input" id="deCredito" placeholder="Selecione a data inicial" name="deCredito" />
                        </div>
                        <div class="form-group col-sm-3">
                            <label class="control-label" for="ateCredito">
                                Data Final:<span class="require" style="color: red">*</span> <span style=" font-size: 9pt"><span style="color: red" class="span120dias" hidden>Mximo 120 dias (pdf)</span></span>
                            </label>
                            <input type="text" class="form-control data datepicker-input" id="ateCredito" placeholder="Selecione a data final" name="ateCredito" />
                        </div>                                
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-4">
                            <label>Tipo de Baixa:</label><br>
                            <div class="checkbox">
                                <label><input type="checkbox" name="tp_pagamento[]" id="Banco" class="icheck" value="B" checked> Banco</label>
                                <label><input type="checkbox" name="tp_pagamento[]" id="Tesouraria" class="icheck" value="T" checked> Tesouraria</label>
                                <label><input type="checkbox" name="tp_pagamento[]" id="Outros" class="icheck" value="O" checked> Outros</label>
                            </div>
                        </div>
                        <div class="form-group col-sm-8">
                            <label class="control-label">Tipos de Parcelas:</label><br>
                            <div class="checkbox">
                                <label><input type="checkbox" name="tp_parcela[]" class="icheck" value="N" checked>Normal</label>
                                <label><input type="checkbox" name="tp_parcela[]" class="icheck" value="S" checked>Sinal</label>
                                <label><input type="checkbox" name="tp_parcela[]" class="icheck" value="C" checked>Chave</label>
                                <label><input type="checkbox" name="tp_parcela[]" class="icheck" value="G" checked>Negociada</label>
                                <label><input type="checkbox" name="tp_parcela[]" class="icheck" value="Q" checked>Quitao</label>
                                <label><input type="checkbox" name="tp_parcela[]" class="icheck" value="I" checked>Intercalada</label>
                                <label><input type="checkbox" name="tp_parcela[]" class="icheck" value="A" checked>Avulsa</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-4">
                            <label class="control-label">Tipo de Relatrio:</label><br>
                            <div class="checkbox">
                                <label><input type="radio" id="tipoS" class="form-control icheck tipo col-sm-3" name="tipo" value="S" checked />Sinttico</label>
                                <label><input type="radio" id="tipoA" class="form-control icheck tipo col-sm-3" name="tipo" value="A" />Analtico</label>
                            </div>
                        </div>
                        <div class="form-group col-sm-6">
                            <label class="control-label" for="ordem">Ordenar Por:</label><br>
                            <div class="checkbox">
                                <label><input type="radio" id="ordemQ" class="form-control icheck tipo col-sm-3" name="ordem" value="Q" checked />Quadra/Lote</label>
                                <label><input type="radio" id="ordemP" class="form-control icheck tipo col-sm-3" name="ordem" value="P" />Cliente</label>
                                <label><input type="radio" id="ordemPG" class="form-control icheck tipo col-sm-3" name="ordem" value="PG" />Data de pagamento</label>
                                <label><input type="radio" id="ordemC" class="form-control icheck tipo col-sm-3" name="ordem" value="C" />Data crdito</label>
                            </div>
                        </div>

                        <div class="form-group col-sm-3" style="display:none">
                            <label class="control-label">Gerar em:</label><br>
                            <div class="checkbox">
                                <label><input type="radio" id="tipoRelatorioPdf" class="form-control icheck tipo col-sm-3" name="tipoRelatorio" checked value="pdf" />PDF</label>
                                <label><input type="radio" id="tipoRelatorioHtml" class="form-control icheck tipo col-sm-3" name="tipoRelatorio" value="html" />HTML</label>
                                <label><input type="radio" id="tipoRelatorioExcel" class="form-control icheck tipo col-sm-3" name="tipoRelatorio" value="xls" />Excel</label>
                            </div>
                        </div>
                    </div>
                </div>

                <input id="visualizarInput" name="visualizar" value="false" style="display: none">
                <div style="display:flex; justify-content:center; align-items:center">
                        <p id="hide-content" class="expandirMenu centralizador" style="display:none; cursor:pointer"><i class="fa fa-chevron-down"></i></p>
                </div>
                <legend>Operaes:</legend>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-2">
                            <button id="pdf" class="btn btn-primary col-sm-12 fDesabilitaBtn" style="color:white; border-radius:5px"><i class="fa fa-file-pdf-o" aria-hidden="true"></i> PDF
                        </div>
                        <div class="form-group col-sm-2">
                            <button id="xls" class="btn btn-danger col-sm-12 fDesabilitaBtn" style="color:white; border-radius:5px"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Excel
                        </div>
                        <div class="form-group col-sm-2">
                            <button id="html" class="btn btn-success col-sm-12 fDesabilitaBtn" style="color:white; border-radius:5px"><i class="fa fa-file-code-o" aria-hidden="true"></i> HTML
                        </div> 
                        <div name="receiver" overflow="auto" id="receiver" seamless="seamless" ></div>
                    </div>
                </div>                                      
                <br>
            </div>
        </form>
    </div>
</div>
</div>

<?php require_once 'layout/includes/footer.php'; ?>