<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>
    <style>
        .checkFlex{
            display: flex;
            flex-direction: row;
            align-content: flex-start;
            align-items: flex-end;
            flex-wrap: wrap;
        }
        .checkFlex > label{
            width: 100%;
        }
    </style>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader('Relatorio', 'Contrato', 'fa fa-file-o'); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>

                <form action="" method="POST" target="_blank">
                    <fieldset>
                        <legend>Informaes Relatrio Contrato <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                            <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                                <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                    <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                                </svg>
                            </span>
                        </legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="id_empreendimento">
                                        Empreendimento:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2 empreendimento"
                                            required="required"
                                            id="empreendimento" name="empreendimento"
                                            data-placeholder="Escolha o empreendimento">
                                        <option value="">Selecione...</option>
                                        <?php foreach ($this->get("empreendimentos") as $emp):
                                            $selected = '';
                                            if($emp['id'] == $_POST['empreendimento']){
                                                $selected = 'selected';
                                            }
                                            ?>
                                            <option <?php echo $selected; ?> value="<?php echo $emp["id"]; ?>"><?php echo $emp["nm_empreendimento"]; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group col-sm-12">
                                        <label class="control-label"> Tipo de relatrio</label>
                                        <select class="form-control select2" name="tipoContrato" id="tipo">
                                            <option value="">Todos</option>
                                            <option value="0">Ativos</option>
                                            <option value="1">Inativos</option>
                                            <option value="assinado">Assinados</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="dtInicio">
                                        A partir de:<span class="required" style="color: red">*</span>
                                    </label>
                                    <input type="text" class="form-control data datepicker-input" id="dataInicio"
                                           name="dataInicio" value=""/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="dtFim">
                                        At:
                                    </label>
                                    <input type="text" class="form-control data datepicker-input" id="dataFinal"
                                           name="dataFinal" value=""/>
                                </div>
                                <div class="form-group col-sm-3 checkFlex">
                                    <label class="control-label">
                                        Exibir nome do corretor no relatrio?</label><br>
                                    <div class="checkbox">
                                        <label><input type="radio" class="form-control icheck" name="corretor" id="s" value="1"/> Sim</label>
                                        <label><input type="radio" class="form-control icheck" name="corretor" id="n" value="0" checked/> No</label>
                                    </div>
                                </div>
                                <div class="form-group col-sm-3 checkFlex">
                                    <label class="control-label">
                                        Exibir assinaturas no relatrio?</label><br>
                                    <div class="checkbox">
                                        <label><input type="radio" class="form-control icheck" name="assinaturas" id="s" value="1"/> Sim</label>
                                        <label><input type="radio" class="form-control icheck" name="assinaturas" id="n" value="0" checked/> No</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label">
                                        Exibir sinais de acordo com o campo "Incluir Parc. Sinal" no cadastro do contrato?</label><br>
                                    <div class="checkbox">
                                        <label><input type="radio" class="form-control icheck modelo" name="tipoParcela" id="sim" value="0" checked/> Sim</label>
                                        <label><input type="radio" class="form-control icheck modelo" name="tipoParcela" id="nao" value="1" /> No</label>
                                    </div>
                                </div>
                                <div class="form-group col-sm-6 checkFlex">
                                    <label class="control-label" for="tipoRelatorio">
                                        Ordenar por:
                                    </label><br>
                                    <div class="checkbox">
                                        <label>
                                            <input checked type="radio" class="form-control icheck tipo" name="ordena" id="quadraLote" value="quadraLote" /> Quadra/Lote
                                        </label>
                                        <label>
                                            <input type="radio" class="form-control icheck icheck tipo" name="ordena" id="data" value="data" checked/> Data contrato
                                        </label>
                                        <label>
                                            <input type="radio" class="form-control icheck icheck tipo" name="ordena" id="numeroContrato" value="numeroContrato" /> Nmero de contrato
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group col-sm-6 checkFlex" >
                                    <label class="control-label" for="tipoRelatorio">
                                        Tipo de relatrio
                                    </label><br>
                                    <div class="checkbox">
                                        <label><input checked type="radio" class="form-control icheck tipo" name="tipoRelatorio" id="tipoRelatorio" value="pdf" /> PDF</label>
                                        <label><input type="radio" class="form-control icheck icheck tipo" name="tipoRelatorio" id="tipoRelatorio" value="html" /> HTML</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group col-sm-12 checkFlex" >
                                    <label>Forma de pagamento:</label><br>
                                    <div class="checkbox">
                                        <label><input type="checkbox" name="tp_pagamento[]" id="Parcelado" class="icheck" value="PC" checked> Parcelado</label>
                                        <label><input type="checkbox" name="tp_pagamento[]" id="Avista" class="icheck" value="AV" checked> A vista </label>
                                        <label><input type="checkbox" name="tp_pagamento[]" id="Permuta" class="icheck" value="PM" checked> Permuta</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="submit" id="btnSalvar" class="btn btn-primary col-sm-6 fDesabilitaBtn"
                                           value="Gerar">
                                </div>
                            </div>
                        </div>
                    </fieldset>
            </div>
        </div>
    </div>
<div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg ">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-hidden="true">&times;</button>
                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                    Tutorial</h2>
            </div>

            <div class="modal-body tableFix" style="max-height:600px;">
                <fieldset >
                    <legend>Contratos - Relatrio de Contratos Gerados no Sistema</legend>
                    <div class="row" style="margin-right: 0px;margin-left: 0px;">
                        <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/Ur-hROEKyG8?si=ILWSvui0hqKqvBY9" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>                        
                    </div>
                    <div></div>
                </fieldset>
            </div>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>