<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>
    <style>
        .checkFlex{
            display: flex;
            flex-direction: row;
            align-content: flex-start;
            align-items: flex-end;
            flex-wrap: wrap;
        }
        .checkFlex > label{
            width: 100%;
        }
    </style>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader('Relatorio', 'Jurdico', 'fa fa-file-o'); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>

                <form action="" method="POST" target="_blank">
                    <fieldset>
                        <legend>Informaes Relatrio Jurdico <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span></legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="id_empreendimento">
                                        Empreendimento:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2 empreendimento"
                                            required="required"
                                            id="empreendimento" name="empreendimento"
                                            data-placeholder="Escolha o empreendimento">
                                        <option value="">Selecione...</option>
                                        <?php foreach ($this->get("empreendimentos") as $emp):
                                            $selected = '';
                                            if($emp['id'] == $_POST['empreendimento']){
                                                $selected = 'selected';
                                            }
                                            ?>
                                            <option <?php echo $selected; ?> value="<?php echo $emp["id"]; ?>"><?php echo $emp["nm_empreendimento"]; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="control-label">
                                        Contrato:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2 contrato"
                                            required="required"
                                            id="contrato_relatorio" name="id_Contrato"
                                            data-placeholder="Escolha o contrato">
                                        <option value=""></option>
                                        <?php echo $this->get("contratos"); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="id_tipo_audiencia">
                                        Tipo de audincia:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2" name="id_tipo_audiencia"
                                            data-placeholder="Escolha o tipo de audincia"
                                            id="id_tipo_audiencia" required="required">
                                        <option value="">Selecione ...</option>
                                        <option value="*"> Todos </option>
                                        <?php foreach ($this->get("tpAudiencia") as $tipo): ?>
                                            <option
                                                value="<?= $tipo['idCampo']; ?>" <?= ($tipo['idCampo'] == $processo['id_tipo_audiencia']) ? 'selected' : '' ?>>
                                                <?= $tipo['descricao'] ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="control-label">Processo:</label><br>
                                    <div class="checkbox">
                                        <label><input type="checkbox" name="fl_tipo[]" class="icheck" value="R" checked>Ru</label>
                                        <label><input type="checkbox" name="fl_tipo[]" class="icheck" value="A" checked>Autor</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="col-sm-6">
                                    <div class="form-group col-sm-6 checkFlex" >
                                        <label class="control-label" for="tipoRelatorio">
                                            Tipo de relatrio
                                        </label><br>
                                        <div class="checkbox">
                                            <label><input checked type="radio" class="form-control icheck tipo" name="tipoRelatorio" id="tipoRelatorio" value="pdf" /> PDF</label>
                                            <label><input type="radio" class="form-control icheck icheck tipo" name="tipoRelatorio" id="tipoRelatorio" value="excel" /> Excel</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="submit" id="btnSalvar" class="btn btn-primary col-sm-6 fDesabilitaBtn" value="Gerar">
                                </div>
                            </div>
                        </div>
                    </fieldset>
            </div>
        </div>
    </div>
<?php require_once 'layout/includes/footer.php'; ?>