<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';
$empreendimentos = $this->get('empreendimentos');
?>
<div class="content">
    <div class="page-heading">
        <?= $this->getHeader('Relatrio', 'Previsto x Realizado', 'fa fa-file-o'); ?>
    </div>
    <div class="widget">
        <div class="widget-content padding">
            <!-- MENSAGENS -->
            <div class="alert alert-danger alert-dismissable msgErros" hidden></div>
            <div class="alert alert-success alert-dismissable msgSucess" hidden>Operao realizada com sucesso.
            </div>
            <form action="?m=rl&c=previstovsRealizado&a=relatorio" method="POST" id="form" name="form" target="_blank">
                <fieldset>
                    <legend>Informaes Previsto x Realizado <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                        <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                            <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                            </svg>
                        </span>
                    </legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="id_empreendimento">
                                    Empreendimento:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2" required="required" id="empreendimento_id" name="empreendimento_id" data-placeholder="Escolha o empreendimento">
                                    <?php foreach ($empreendimentos as $empreendimento) : ?>
                                        <option value="<?= $empreendimento['id'] ?>"><?= $empreendimento['nm_empreendimento'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row" id="divDatas" hidden>
                        <div class="col-sm-12">
                            <div class="form-group col-sm-2">
                                <label class="control-label">
                                    Data inicial:<span class="require" style="color: red">*</span></label>
                                </label>
                                <input type="text" class="form-control data datepicker-input" id="de" required="required" name="de" placeholder="Digite data inicial" required/>
                            </div>
                            <div class="form-group col-sm-2">
                                <label class="control-label" for="dtFim">
                                    Data final:<span class="require" style="color: red">*</span></label>
                                </label>
                                <input type="text" class="form-control data datepicker-input" id="ate" required="required" name="ate" placeholder="Digite data final" required/>
                            </div>
                        </div>
                    </div>
                    <div class="row" id="divAno" hidden>
                        <div class="col-sm-12">
                            <div class="form-group col-sm-2">
                                <label class="control-label" for="ano">
                                    Ano:<span class="require" style="color: red">*</span>
                                </label>
                                <input type="text" class="form-control ano" id="ano" required="required" name="ano" placeholder="Digite o ano" />
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="col-sm-12">
                                <label>Tipos de parcelas:<span class="require" style="color: red">*</span></label><br>
                                <div class="checkbox">
                                    <label for="normal" class="control-label"> <input checked class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="normal" value="N" />
                                        Normal</label>

                                    <label for="sinal" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="sinal" value="S" />
                                        Sinal</label>

                                    <label for="intercalada" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="intercalada" value="I" />
                                        Intercalada</label>

                                    <label for="chave" class="control-label"> <input checked class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="chave" value="C" />
                                        Chave</label>

                                    <label for="negociada" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="negociada" value="G" />
                                        Negociada</label>

                                    <label for="quitacao" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="quitacao" value="Q" />
                                        Quitao</label>

                                    <label for="avulsa" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="avulsa" value="A" />
                                        Avulsa</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-4">
                                <label><br>Tipos pagamentos:<span class="require" style="color: red">*</span></label><br>
                                <div class="checkbox">
                                    <label for="Banco"><input checked class="checkbox icheck" type="checkbox" name="tp_pagamento[]" id="Banco" value="B" />
                                        Banco</label>
                                    <label for="Tesouraria"><input checked class="checkbox icheck" type="checkbox" name="tp_pagamento[]" id="Tesouraria" value="T" />
                                        Tesouraria</label>
                                    <label for="Outros"><input class="checkbox icheck" type="checkbox" name="tp_pagamento[]" id="Outros" value="O" />
                                        Outros</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-4">
                                <label>Pesquisar por:</label><br>
                                <div class="checkbox">
                                    <label><input type="radio" id="periodoData" class="icheck tipo col-sm-3" name="periodo" checked value="D" />Perodo de datas</label>
                                    <label><input type="radio" id="periodoAno" class="icheck tipo col-sm-3" name="periodo" value="A" />Ano</label>
                                </div>
                            </div>
                        </div>
                    </div>

                </fieldset>
                <fieldset>
                    <legend>Operaes</legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-2">
                                <input type="button" class="btn btn-primary col-sm-12 fDesabilitaBtn" id="gerarRel" value="Gerar">
                            </div>
                        </div>
                    </div>
                </fieldset>
            </form>
        </div>
    </div>
</div>
<div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg ">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-hidden="true">&times;</button>
                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                    Tutorial</h2>
            </div>

            <div class="modal-body tableFix" style="max-height:600px;">
                <fieldset >
                    <legend>Previsto X Realizado - Total dos Valores a Receber e os que Realmente Foram Recebidos</legend>
                    <div class="row" style="margin-right: 0px;margin-left: 0px;">
                        <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/mld_s_y3T4U?si=J5CWf2SyVMjIcmis" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>                        
                    </div>
                    <div></div>
                </fieldset>
            </div>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>