<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';
$empreendimentos = $this->get('empreendimentos');
$dados = $this->get("dados");
?>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader('Relatrio','Inadimplentes','fa fa-file-o'); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <form  action="?m=rl&c=inadimplentes&a=relatorio" method="POST" target="_blank">
                    <fieldset>
                        <legend>Informaes de Inadimplentes <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                            <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                                <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                    <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                                </svg>
                            </span>
                        </legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="empreendimento_relatorio_parcela_paga">
                                        Empreendimento:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2 empreendimentoParcelaPaga"
                                            required="required"
                                            id="empreendimento_relatorio_parcela_paga" name="empreendimento_relatorio_parcela_paga"
                                            data-placeholder="Escolha o empreendimento">
                                        <option value=""></option>
                                        <?php if ($empreendimentos):
                                            foreach ($empreendimentos as $empreendimento):?>
                                                <option
                                                    <?php if ($empreendimento['id_empreendimento'] == $dados["id_empreendimento"]): ?>selected <?php endif; ?>
                                                    value="<?php echo $empreendimento['id_empreendimento']; ?>"><?php echo $empreendimento['nm_empreendimento']; ?></option>
                                            <?php endforeach;
                                        endif;?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="cliente_relatorio_parcela_paga">
                                        Contrato:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2 cliente_relatorio_parcela_paga"
                                            required="required"
                                            id="cliente_relatorio_parcela_paga" name="cliente_relatorio_parcela_paga"
                                            data-placeholder="Escolha o contrato">
                                        <?php
                                        if ($dados["id_empreendimento"]) {
                                            $instanceLote = new Lote();
                                            $selectLotes = $instanceLote->getDefaultAdapter()->select();
                                            $clientes = $selectLotes->from(array('l' => TB_LOTES), array('id_lote' => 'id', 'id_empreendimento'))
                                                ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id', 'id_pessoa'))
                                                ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa', 'id'))
                                                ->where('l.id_empreendimento = ?', $dados["id_empreendimento"])->order('p.nm_pessoa')->group('p.id')->query()->fetchAll();
                                            if ($clientes): ?>
                                                <option value="*">Todos</option>
                                                <?php
                                                foreach ($clientes as $cliente):?>
                                                    <option
                                                        <?php if ($cliente['id'] == $dados["id_cliente"]): ?>selected <?php endif; ?>
                                                        value="<?php echo $cliente['id']; ?>"><?php echo $cliente['nm_pessoa']; ?></option>
                                                <?php endforeach;
                                            endif;
                                        } else {
                                            ?>
                                            <option value="">Selecione ...</option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group col-sm-4">
                                    <label class="control-label" for="de">
                                        A partir de: <span class="require" style="color: red">*</span>
                                    </label>
                                    <input type="text" class="form-control data datepicker-input" id="de"
                                           name="de"
                                           value="<?php echo $dados["de"] ?>"/>
                                </div>
                                <div class="form-group col-sm-4">
                                    <label class="control-label" for="dtFim">
                                        At: <span class="require" style="color: red">*</span>
                                    </label>
                                    <input type="text" class="form-control data datepicker-input" id="ate"
                                           name="ate"
                                           value="<?php echo $dados["ate"] ?>"/>
                                </div>
                                <div class="form-group col-sm-4">
                                    <label class="control-label" for="dataBase">
                                        Data base:
                                    </label>
                                    <input type="text" class="form-control data datepicker-input" id="dataBase"
                                           name="dataBase"
                                           value="<?php echo date("d/m/Y"); ?>"/>
                                </div>
                            </div>
                            <div class="col-6 containerFiltro2AVia">
                                <label class="control-label">
                                    Exibir por:
                                </label>
                                <div class="checkbox"><br>
                                    <label><input checked type="radio" class="form-control icheck" name="dtVencimento" id="dtVencimento" value="0"> Dt. Vencimento</label>
                                    <label><input type="radio" class="form-control icheck" name="dtVencimento" id="dtVencimento2Via" value="1"> Apenas Dt. 2 Via</label>
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <label class="control-label">
                                        Exibir 2 Via?
                                    </label><br>
                                    <div class="checkbox">
                                        <label><input checked type="radio" class="form-control icheck" name="segundaVia" value="S" /> Sim</label>
                                        <label><input type="radio" class="form-control icheck" name="segundaVia" value="N" /> No</label>
                                    </div>
                                </div>
                                <div class="form-group col-sm-1 divVazia" id="divVazia" hidden></div>
                                <div class="form-group col-sm-2" id="divInadimplentes">
                                    <label class="control-label" for="tipo">
                                        Exibir profisso?
                                    </label><br>
                                    <div class="checkbox">
                                        <label for="fl_profissaoS"><input type="radio" class="form-control icheck" name="fl_profissao" id="fl_profissaoS" value="1" /> Sim</label>
                                        <label for="fl_profissaoN"><input checked type="radio" class="form-control icheck" name="fl_profissao" id="fl_profissaoN" value="0" /> No</label>
                                    </div>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label" for="opcoes">
                                        Exibir cliente jurdico?
                                    </label><br>
                                    <div class="checkbox">
                                        <label for="juridicoS" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="juridico[]" id="checkboxS" value="juridicoS"/> Em jurdico</label>
                                        <label for="juridicoN" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="juridico[]" id="checkboxN" value="juridicoN"/> Sem jurdico</label>
                                    </div>
                                </div>
                                <div class="form-group col-sm-1 divVazia" id="divVazia" hidden></div>
                                <div class="col-sm-6">
                                    <div class="col-sm-12">
                                        <label>Tipos de parcelas:</label><br>
                                        <div class="checkbox">
                                            <label for="Normal" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="Normal" value="N"/> Normal</label>
                                            <label for="Sinal" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="Sinal" value="S"/> Sinal</label>
                                            <label for="Intercalada" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="Intercalada" value="I"/> Intercalada</label>
                                            <label for="Chave" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="Chave" value="C"/> Chave</label>
                                            <label for="Negociada" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="Negociada" value="G"/> Negociada</label>
                                            <label for="Quitacao" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="Quitacao" value="Q"/> Quitao</label>
                                            <label for="Avulsa" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="Avulsa" value="A"/> Avulsa</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <label class="control-label" for="tipo">
                                        Tipo de relatrio:<span class="require" style="color: red">*</span>
                                    </label><br>
                                    <div class="checkbox">
                                        <label><input type="radio" class="form-control icheck" name="tipo" id="sintetico" value="N" /> Sinttico</label>
                                        <label><input type="radio" class="form-control icheck" name="tipo" id="analitico" value="PNC" checked /> Analtico</label>
                                    </div>
                                </div>
                                <div class="col-sm-2">
                                    <label class="control-label" for="tipoRelatorio">
                                        Tipo de impresso:
                                    </label><br>
                                    <div class="checkbox">
                                        <label><input checked type="radio" class="form-control icheck tipo" name="tipoRelatorio" id="tipoRelatorio" value="pdf" /> PDF</label>
                                        <label><input type="radio" class="form-control icheck icheck tipo" name="tipoRelatorio" id="tipoRelatorio" value="html" /> HTML</label>
                                        <label><input type="radio" class="form-control icheck icheck tipo" name="tipoRelatorio" id="tipoRelatorioExcel" value="xls"/> Excel</label>
                                    </div>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label" for="opcoes">
                                        Exibir contratos
                                    </label><br>
                                    <div class="checkbox">
                                        <label for="parcelado/avista" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="pagamento[]" id="checkboxS" value="parcelado/avista"/> Parcelados/a Vista</label>
                                        <label for="permuta" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="pagamento[]" id="checkboxN" value="permuta"/> Permutados</label>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group col-sm-12" >
                                        <label class="control-label" for="opcoes">
                                            Exibir cliente?
                                        </label><br>
                                        <div class="checkbox">
                                            <label for="Dias30" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="opcao[]" id="checkboxA" value="opcaoA"/> At 30 dias</label>
                                            <label for="Dias60" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="opcao[]" id="checkboxB" value="opcaoB"/> At 60 dias</label>
                                            <label for="Dias90" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="opcao[]" id="checkboxC" value="opcaoC"/> At 90 dias</label>
                                            <label for="Dias120" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="opcao[]" id="checkboxD" value="opcaoD"/> At 120 dias</label>
                                            <label for="Dias150" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="opcao[]" id="checkboxE" value="opcaoE"/> At 150 dias</label>
                                            <label for="DiasMais" class="control-label"><input checked class="checkbox icheck" type="checkbox" name="opcao[]" id="checkboxF" value="opcaoF"/> Acima de 150 dias</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <br>
                    </fieldset>
                    <fieldset>
                        
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <legend>Operaes</legend>
                                    <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn"
                                           value="Gerar">
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </form>
            </div>
        </div>
    </div>
<div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg ">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-hidden="true">&times;</button>
                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                    Tutorial</h2>
            </div>

            <div class="modal-body tableFix" style="max-height:600px;">
                <fieldset >
                    <legend>Inadimplentes - Relatrio de Inadimplentes no sistema</legend>
                    <div class="row" style="margin-right: 0px;margin-left: 0px;">
                        <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/iD9cZ9bHM-0?si=oA2Yl5AI8kJyzq9b" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>                        
                    </div>
                    <div></div>
                </fieldset>
            </div>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>