<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';
$empreendimentos = $this->get('empreendimentos');
$dados = $this->get("dados");
?>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader('Relatrio','Comunicao','fa fa-file-o'); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <form  action="?m=rl&c=comunicacao&a=relatorio" method="POST" target="_blank">
                    <fieldset>
                        <legend>Informaes de Comunicao <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span></legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-4">
                                    <label class="control-label" for="idEmpreendimento">
                                        Empreendimento:
                                    </label>
                                    <select class="form-control select2 empreendimentoParcelaPaga"
                                            id="idEmpreendimento" name="idEmpreendimento"
                                            data-placeholder="Escolha o empreendimento">
                                        <option value="*">Todos</option>
                                        <?php if ($empreendimentos):
                                            foreach ($empreendimentos as $empreendimento):?>
                                                <option
                                                    <?php if ($empreendimento['id_empreendimento'] == $dados["id_empreendimento"]): ?>selected <?php endif; ?>
                                                    value="<?php echo $empreendimento['id_empreendimento']; ?>"><?php echo $empreendimento['nm_empreendimento']; ?></option>
                                            <?php endforeach;
                                        endif;?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-4">
                                    <label class="control-label" for="de">
                                        A partir de: <span class="require" style="color: red">*</span>
                                    </label>
                                    <input type="text" class="form-control data datepicker-input" required id="de"
                                           name="de"
                                           value="<?php echo $dados["de"] ?>"/>
                                </div>
                                <div class="form-group col-sm-4">
                                    <label class="control-label" for="dtFim">
                                        At: <span class="require" style="color: red">*</span>
                                    </label>
                                    <input type="text" class="form-control data datepicker-input" required id="ate"
                                           name="ate"
                                           value="<?php echo $dados["ate"] ?>"/>
                                </div>
                                <div class="form-group col-sm-4" >
                                    <label class="control-label" for="tipoRelatorio">
                                        Tipo de relatrio
                                    </label><br>
                                    <div class="checkbox">
                                        <label><input checked type="radio" class="form-control icheck tipo" name="tipoRelatorio" id="tipoRelatorioP" value="pdf" /> PDF</label>
                                        <label><input type="radio" class="form-control icheck icheck tipo" name="tipoRelatorio" id="tipoRelatorioH" value="html" /> HTML</label>
                                        <label><input type="radio" class="form-control icheck icheck tipo" name="tipoRelatorio" id="tipoRelatorioExcelX" value="xls"/> Excel</label>
                                    </div>
                                </div>
                                <div class="form-group col-sm-4" >
                                    <label class="control-label" for="tipoRelatorio">
                                        Mtodo de comunicao
                                    </label><br>
                                    <div class="checkbox">
                                        <label><input checked type="radio" class="form-control icheck tipo" name="tipoEnvio"  value="" /> Todos</label>
                                        <label><input type="radio" class="form-control icheck icheck tipo" name="tipoEnvio"  value="1"/> E-mail</label>
                                        <label><input type="radio" class="form-control icheck icheck tipo" name="tipoEnvio"  value="2" /> WhatsApp</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn"
                                           value="Gerar">
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </form>
            </div>
        </div>
    </div>
<?php require_once 'layout/includes/footer.php'; ?>