<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';
$empreendimentos = $this->get('empreendimentos');
$dados = $this->get("dados");
?>
    <div class="content">
    <div class="page-heading">
        <?= $this->getHeader('Relatrio de','Comisses','fa fa-file-o'); ?>
    </div>
    <div class="widget">
        <div class="widget-content padding">
            <?php if (count($this->_helper->getMensagens()) > 0): ?>
                <div class="alert alert-danger alert-dismissable">
                    <?php foreach ($this->_helper->getMensagens() as $message): ?>
                        <?= $message ?><br>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
            <form action="<?= $this->_helper->getLink(array("m" => "rl", "c" => "comissao", "a" => 'relatorio')); ?>" method="POST" target="_blank">
                <fieldset>
                    <legend>
                        Informaes Relatrio de Comisses <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                        <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                            <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                            </svg>
                        </span>
                    </legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="empreendimento_relatorio_comissoes">
                                    Empreendimento:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2 empreendimento_relatorio_comissoes"
                                        required="required"
                                        id="empreendimento_relatorio_comissoes" name="empreendimento_relatorio_comissoes"
                                        data-placeholder="Escolha o empreendimento">
                                    <option value="">Selecione ...</option>
                                    <?php if ($empreendimentos):
                                        foreach ($empreendimentos as $empreendimento):?>
                                            <option
                                                <?php if ($empreendimento['id_empreendimento'] == $dados["id_empreendimento"]): ?>selected <?php endif; ?>
                                                value="<?= $empreendimento['id_empreendimento']; ?>"><?= $empreendimento['nm_empreendimento']; ?></option>
                                        <?php endforeach;
                                    endif; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="tipoRelatorio">
                                    Filtrar relatrio por:
                                </label><br>
                                <div style="padding-top: 5px;">
                                    <input type="radio" class="form-control icheck" name="comissao" id="corretor" checked value="C"/>
                                    <label for="corretor">Corretor</label>
                                    <input type="radio" class="form-control icheck" name="comissao" id="parceiro" value="P" />
                                    <label for="parceiro">Parceiro</label>
                                </div>
                            </div>
                            <div class="form-group col-sm-4" id="divCorretor">
                                <label class="control-label" for="corretor_relatorio_comissoes">
                                    Corretor:<span class="require" style="color: red">*</span>
                                </label>
                                <select name="corretor_relatorio_comissoes" id="corretor_relatorio_comissoes"
                                        class="form-control select2 corretor_relatorio_comissoes corretor"
                                        data-placeholder="Escolha o corretor" disabled>
                                    <option value="">Selecione ...</option>
                                </select>
                            </div>
                            <div class="form-group col-sm-4" hidden id="divParceiro">
                                <label class="control-label" for="corretor_relatorio_comissoes">
                                    Parceiro:<span class="require" style="color: red">*</span>
                                </label>
                                <select name="idParceiro" id="idParceiro"
                                        class="form-control select2 corretor"
                                        data-placeholder="Escolha o parceiro" disabled>
                                    <option value="">Selecione ...</option>
                                </select>
                                <input type="hidden" id="tipoComissao" name="tipoComissao">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="corretor_relatorio_comissoes">
                                    Exibir distratados:
                                </label>
                                <div style="padding-top: 5px;">
                                    <input type="radio" class="form-control icheck" name="distratado" id="sim" checked value="1"/>
                                    <label for="sim">Sim</label>
                                    <input type="radio" class="form-control icheck" name="distratado" id="nao" value="0" />
                                    <label for="nao">No</label>
                                </div>
                            </div>
                            <div class="form-group col-sm-7">
                                <label>Tipos de parcela:</label><br>
                                <div style="padding-top: 3px;" class="checkbox">
                                    <input  class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="normal" checked value="N"/>
                                    <label for="normal" style="padding-right:20px;padding-left:0px" class="control-label">Normal</label>

                                    <input  class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="sinal" checked value="S"/>
                                    <label for="sinal" style="padding-right:20px;padding-left:0px" class="control-label">Sinal</label>

                                    <input  class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="intercalada" checked value="I"/>
                                    <label for="intercalada" style="padding-right:20px;padding-left:0px" class="control-label">Intercalada</label>

                                    <input  class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="chave" checked value="C"/>
                                    <label for="chave" style="padding-right:20px;padding-left:0px" class="control-label">Chave</label>

                                    <input  class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="negociada" checked value="G"/>
                                    <label for="negociada" style="padding-right:20px;padding-left:0px" class="control-label">Negociada</label>
                                    <br>
                                    <input  class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="quitacao" checked value="Q"/>
                                    <label for="quitacao" style="padding-right:20px;padding-left:0px" class="control-label">Quitao</label>
                                
                                    <input  class="checkbox icheck" type="checkbox" name="tp_parcela[]" id="avulsa" checked value="A"/>
                                    <label for="avulsa" style="padding-right:20px;padding-left:0px" class="control-label">Avulsa</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="deContrato">
                                    Data contrato:
                                </label>
                                <input  type="text" class="form-control data datepicker-input filtroContrato" id="deContrato" placeholder="Data inicial"
                                        name="deContrato" value=""/>
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="deContrato">
                                    at:
                                </label>
                                <input   type="text" class="form-control data datepicker-input filtroContrato"  id="ateContrato" placeholder="Data final"
                                         name="ateContrato" value=""/>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="dePagamento">
                                    Data de pagamento:
                                </label>
                                <input  type="text" class="form-control data datepicker-input filtroParcela" id="dePagamento" placeholder="Data inicial"
                                        name="dePagamento"  value="<?= $dados["de"] ?>"/>

                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="dePagamento">
                                    at:
                                </label>
                                <input  type="text" class="form-control data datepicker-input filtroParcela" id="atePagamento" placeholder="Data final"
                                        name="atePagamento"  value="<?= $dados["ate"] ?>"/>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="deContrato">
                                    Data de crdito:
                                </label>
                                <input   type="text" class="form-control data datepicker-input filtroParcela" id="deCredito" placeholder="Data inicial"
                                         name="deCredito" value="<?= $dados["de"] ?>"/>
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="deContrato">
                                    at:
                                </label>
                                <input  type="text" class="form-control data datepicker-input filtroParcela" id="ateCredito" placeholder="Data final"
                                        name="ateCredito" value="<?= $dados["ate"] ?>"/>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="tipoRelatorio">
                                    Tipo de relatrio:
                                </label><br>
                                <div class="form-group col-sm-1" style="width: 100px; padding-top: 5px;">
                                    <input type="radio" class="form-control icheck" name="tipoRelatorio" id="pdf" value="pdf" checked/>
                                    <label for="pdf">PDF</label>
                                </div>
                                <div class="form-group col-sm-6" style="padding-top: 5px;">
                                    <input type="radio" class="form-control icheck" name="tipoRelatorio" id="html" value="html" />
                                    <label for="html">HTML</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </fieldset>
                <fieldset>
                    <legend>Operaes</legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-2">
                                <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Gerar">
                            </div>
                        </div>
                    </div>
                </fieldset>
            </form>
        </div>
    </div>
<div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg ">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-hidden="true">&times;</button>
                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                    Tutorial</h2>
            </div>

            <div class="modal-body tableFix" style="max-height:600px;">
                <fieldset >
                    <legend>Comisso - Relatrio de Comisses dos Corretores e Parceiros</legend>
                    <div class="row" style="margin-right: 0px;margin-left: 0px;">
                        <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/GrCetjZvJqI?si=RusXPsXitpaMEj3F" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>                        
                    </div>
                    <div></div>
                </fieldset>
            </div>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>