<?php

require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';

$empreendimentos = $this->get('empreendimentos');

$dados = $this->get("dados");

?>
    <div id="conteudo">
        <h2 class="lista"><?php echo $this->get("subtitulo");?></h2>
        <form action="<?php echo $this->_helper->getLink(array("m"=>"rl", "c"=>"boletos", "a"=>'relatorio'));?>" method="POST"  target="_blank">
            <fieldset>
                <legend>Relat&oacute;rio de boletos:</legend>
                <table>
                    <?php if($this->_helper->getMensagem("index")):?>
                        <tr>
                            <td colspan="2"><div class="error"><?php echo $this->_helper->getMensagem("index");?></div></td>
                        </tr>
                    <?php endif;?>
                    <?php if($this->_helper->getMensagem("empreendimento_relatorio_parcela_paga")):?>
                        <tr>
                            <td colspan="2"><div class="error"><?php echo $this->_helper->getMensagem("empreendimento_relatorio_parcela_paga");?></div></td>
                        </tr>
                    <?php endif;?>
                    <tr>
                        <td><label for="empreendimento_relatorio_parcela_paga"><strong>Empreendimento:</strong></label><span class="require" style="color: red">*</span></td>
                        <td>
                            <select name="empreendimento_relatorio_parcela_paga" id="empreendimento_relatorio_parcela_paga" class="empreendimento_relatorio_parcela_paga">
                                <option value="">Selecione ...</option>
                                <?php if($empreendimentos):
                                    foreach($empreendimentos as $empreendimento):?>
                                        <option <?php if($empreendimento['id_empreendimento'] == $dados["id_empreendimento"]):?>selected <?php endif; ?> value="<?php echo $empreendimento['id_empreendimento'];?>"><?php echo $empreendimento['nm_empreendimento'];?></option>
                                    <?php endforeach;
                                endif;?>
                            </select>
                        </td>
                    </tr>
                    <?php if($this->_helper->getMensagem("cliente_relatorio_parcela_paga")):?>
                        <tr>
                            <td colspan="2"><div class="error"><?php echo $this->_helper->getMensagem("cliente_relatorio_parcela_paga");?></div></td>
                        </tr>
                    <?php endif;?>
                    <tr>
                        <td><label for="cliente_relatorio_parcela_paga"><strong>Clientes:</strong></label><span class="require" style="color: red">*</span></td>
                        <td>
                            <select name="cliente_relatorio_parcela_paga" id="cliente_relatorio_parcela_paga" class="cliente_relatorio_parcela_paga">

                                <?php
                                if($dados["id_empreendimento"]) {
                                    $instanceLote = new Lote();
                                    $selectLotes = $instanceLote->getDefaultAdapter()->select();
                                    $clientes = $selectLotes->from(array('l'=>TB_LOTES), array('id_lote'=>'id','id_empreendimento'))
                                        ->join(array('c'=>TB_CONTRATO), 'l.id = c.id_lote', array('id','id_pessoa'))
                                        ->join(array('p'=>TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa','id'))
                                        ->where('l.id_empreendimento = ?', $dados["id_empreendimento"])->order('p.nm_pessoa')->group('p.id')->query()->fetchAll();
                                    if($clientes): ?>
                                        <option value="*">Todos</option>
                                        <?php
                                        foreach($clientes as $cliente):?>
                                            <option <?php if($cliente['id'] == $dados["id_cliente"]):?>selected <?php endif; ?> value="<?php echo $cliente['id'];?>"><?php echo $cliente['nm_pessoa'];?></option>
                                        <?php endforeach;
                                    endif;
                                } else { ?>
                                    <option value="">Selecione ...</option>
                                <?php }?>

                            </select>
                        </td>
                    </tr>
                    <?php if($this->_helper->getMensagem("data")):?>
                        <tr>
                            <td colspan="2"><div class="error"><?php echo $this->_helper->getMensagem('data');?></div></td>
                        </tr>
                    <?php endif; ?>
                    <tr>
                        <td><label for="tipo">Tipo de relat&oacute;rio: </label></td>
                        <td>
                            <select id="tipo" name="tipo">
                                <option <?php if($dados["tipo"]=="PE") echo 'selected="selected"' ?> value="PE">Boletos Enviados</option>
                                <option <?php if($dados["tipo"]=="PNE") echo 'selected="selected"' ?> value="PNE">Boletos N&atilde;o enviados</option>
                            </select>
                        </td>
                    </tr>
                    <?php if($this->_helper->getMensagem("tp_pagamento")):?>
                        <tr>
                            <td colspan="2"><div class="error"><?php echo $this->_helper->getMensagem('tp_pagamento');?></div></td>
                        </tr>
                    <?php endif; ?>
                    <tr>
                        <td><label>Tipos de pagamentos:</label></td>
                        <td>
                            <input name="tp_pagamento[]" id="Banco" type="checkbox" value="B" checked /> <label for="Banco">Banco&nbsp;</label>
                            <input name="tp_pagamento[]" id="Tesouraria" type="checkbox" value="T" checked /> <label for="Tesouraria">Tesouraria&nbsp;</label>
                            <input name="tp_pagamento[]" id="Outros" type="checkbox" value="O" checked /> <label for="Outros">Outros</label>
                        </td>
                    </tr>
                    <?php if($this->_helper->getMensagem("tp_parcela")):?>
                        <tr>
                            <td colspan="2"><div class="error"><?php echo $this->_helper->getMensagem('tp_parcela');?></div></td>
                        </tr>
                    <?php endif; ?>
                    <tr>
                        <td><label>Tipos de Parcelas:</label></td>
                        <td>
                            <input name="tp_parcela[]" id="Normal" type="checkbox" checked value="N" /><label for="Normal">Normal&nbsp;&nbsp;&nbsp;</label>
                            <input name="tp_parcela[]" id="Sinal" type="checkbox" checked value="S" /><label for="Sinal">Sinal&nbsp;&nbsp;&nbsp;</label>
                            <input name="tp_parcela[]" id="Intercalada" type="checkbox" checked value="I" /><label for="Intercalada">Intercalada&nbsp;&nbsp;&nbsp;</label>
                            <input name="tp_parcela[]" id="Chave" type="checkbox" checked value="C" /><label for="Chave">Chave&nbsp;&nbsp;&nbsp;</label>
                            <input name="tp_parcela[]" id="Negociada" type="checkbox" checked value="G" /><label for="Negociada">Negociada&nbsp;&nbsp;&nbsp;</label>
                            <input name="tp_parcela[]" id="Quitacao" type="checkbox" checked value="Q" /><label for="Quitacao">Quita&ccedil;&atilde;o&nbsp;&nbsp;&nbsp;</label>
                        </td>
                    </tr>
                    <tr>
                        <td><label for="de">A partir de:</label></td>
                        <td><input name="de" id="de" type="text" class="data" size="10" value="<?php echo $dados["de"]?>" /> <label for="ate">at&eacute;</label>
                            <input name="ate" id="ate" type="text" class="data" size="10" value="<?php echo $dados["ate"]?>" /><label for=""> Ex: 01/01/2010 (dia/mes/ano)</label></td>
                    </tr>
                    <tr>
                        <td><label>Tipo relat&oacute;rio:</label></td>
                        <td>
                            <input id="pdf" name="gera" type="radio" value="pdf" checked /><label for="pdf"> PDF&nbsp;&nbsp;</label>
                            <input id="html" name="gera" type="radio" value="html" /><label for="html">HTML</label>
                        </td>
                    </tr>
                    <tr>
                        <td>Ordenar por:</td>
                        <td>
                            <input id="quadraLote" name="ordena" type="radio" value="quadraLote" checked /><label for="quadraLote">  Quadra/Lote&nbsp;&nbsp;</label>
                            <input id="dataPgto" name="ordena" type="radio" value="dataPgto" /><label for="dataPgto">Data Pagamento</label>
                        </td>
                    </tr>
                    </table>
                </fieldset>
            <fieldset>
                <legend>Opera&ccedil;&otilde;es:</legend>
                <table>
                    <tr>
                        <td><input name="submit" type="submit" value="Gerar relat&oacute;rio" class="button fDesabilitaBtn" /></td>
                    </tr>
                </table>
            </fieldset>
        </form>

    </div>
<?php require_once 'layout/includes/footer.php';?>