<?php

class TransferenciaRelatorioController extends Controller
{

    public function __construct($request)
    {
        parent::__construct($request);
    }

    public function indexAction()
    {
        if ($this->_isPost) {
            $tbClienteAcade = new Db_Cliente();
            $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

            $tb_emp = new Empreendimento();
            $adapter = $tb_emp->getAdapter();

            $dtTipoTransferencia = ($_POST['tpTransferencia'] == 'L') ? 'dt_transferencia' : (($_POST['tpData'] == 'C') ? 'dt_recebimento_termo' : 'data');

            $where = "t.{$dtTipoTransferencia} between '" . Helper::getInputDate($_POST['de']) . "' and '" . Helper::getInputDate($_POST['ate']) . "'";
            $where .= " and l.id_empreendimento = {$_POST['id_empreendimento']}";

            $empreendimentoInfo = $tb_emp->getAdapter()->select()->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento'))
                ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
                ->where('em.id = '.$_POST['id_empreendimento'])->query()->fetch();
            $this->set("empreendimentoInfo", $empreendimentoInfo);

            if ($_POST['tpTransferencia'] == 'T') {
                $tipoRelatorio = 'relTransfTitulo';
                $transferencia = $adapter->select()
                    ->from(array('c' => TB_CONTRATO), null)
                    ->join(array('t' => TB_TRANSFERENCIA), 't.idContrato = c.id', array('data', 'idContrato', 'id', 'dt_recebimento_termo'))
                    ->join(array('p' => TB_PESSOA), 't.idCedente = p.id', array('cedente' => 'nm_pessoa'))
                    ->join(array('p2' => TB_PESSOA), 't.idReceptor = p2.id', array('receptor' => 'nm_pessoa'))
                    ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('lote', 'quadra'))
                    ->where($where)
                    ->order('data DESC')
                    ->query()->fetchAll();

                if(count($_POST['status']) == 1){ //Verifica se foi marcado apenas 1 status
                    if($_POST['status'][0] == 1){ //Se o status marcado  pendente
                        foreach($transferencia as $t =>$transf){
                            if($transf['dt_recebimento_termo'] != null){
                                unset($transferencia[$t]);
                            }
                        }
                    } else{ //Se for apenas confirmado
                        foreach($transferencia as $t =>$transf){
                            if($transf['dt_recebimento_termo'] == null){
                                unset($transferencia[$t]);
                            }
                        }
                    }
                }
            } else {
                $tipoRelatorio = 'relTransfLote';
                $transferencia = $adapter->select()
                    ->from(array('t' => TB_TRANSFERENCIA_LOTE), array('*'))
                    ->join(array('c' => TB_CONTRATO), 'c.id = t.id_contrato', null)
                    ->join(array('p' => TB_PESSOA), 'p.id = c.id_pessoa', 'nm_pessoa')
                    ->join(array('l' => TB_LOTES), 'l.id = t.id_lote_origem', array('loteOrigem' => 'lote', 'quadraOrigem' => 'quadra'))
                    ->join(array('lDestino' => TB_LOTES), 'lDestino.id = t.id_lote_destino', array('loteDestino' => 'lote', 'quadraDestino' => 'quadra'))
                    ->where($where)
                    ->order(array('t.dt_transferencia DESC','t.id_contrato','l.quadra','lDestino.quadra','l.lote','lDestino.lote'))
                    ->query()->fetchAll();
            }

            if (count($transferencia)) {
                $empreendimento = $tb_emp->fetchRow('id = ' . $_POST['id_empreendimento'])->toArray();
                $this->set('emp', $empreendimento);
                $this->set('transferencias', $transferencia);
                $this->set('tpData', $_POST['tpData']);

                $this->_lastView = $tipoRelatorio;
                $this->display($tipoRelatorio);
                $this->displayMPDF($tipoRelatorio);
            } else {
                $this->carregarDados();
                $this->_helper->addMensagem('erro', 'No foram encontrados registros.');
                $this->display("index");
            }
        }
        $this->carregarDados();
        $this->display("index");
    }

    public function carregarDados()
    {
        //instancia as classes necessrias
        $instanceEmpreendimento = new Empreendimento();
        $empreendimento = $instanceEmpreendimento->getDefaultAdapter();

        $empreendimento = $empreendimento->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('nm_empreendimento'))
            ->join(array('l' => TB_LOTES), 'e.id = l.id_empreendimento', array('id_lote' => 'id', 'id_empreendimento'))
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'id_lote'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {
            }
        }
        $empreendimento = $empreendimento->group('e.id')->order('nm_empreendimento')->query()->fetchAll();
        $this->set('empreendimentos', $empreendimento);
    }

    public function validarAction()
    {
        //validao vazio
        $campos = array('id_empreendimento', 'de','ate');
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case 'id_empreendimento' :
                        $msg = "O campo Empreendimento  obrigatrio.";
                        break;
                    case "de" :
                        $msg = "O campo Data Inicial  obrigatrio.";
                        break;
                    case "ate" :
                        $msg = "O campo Data Final  obrigatrio.";
                        break;
                    default:
                        $msg = '';
                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }
        //Verifica se no tem relatrio
        $tb_emp = new Empreendimento();
        $adapter = $tb_emp->getAdapter();
        $dtTipoTransferencia = ($_POST['tpTransferencia'] == 'L') ? 'dt_transferencia' : 'data';
        $where = "t.{$dtTipoTransferencia} between '" . Helper::getInputDate($_POST['de']) . "' and '" . Helper::getInputDate($_POST['ate']) . "'";
        $where .= " and l.id_empreendimento = {$_POST['id_empreendimento']}";
        if ($_POST['tpTransferencia'] == 'T') {
            $tipoRelatorio = 'relTransfTitulo';
            $transferencia = $adapter->select()
                ->from(array('c' => TB_CONTRATO), null)
                ->join(array('t' => TB_TRANSFERENCIA), 't.idContrato = c.id', array('data', 'idContrato', 'id'))
                ->join(array('p' => TB_PESSOA), 't.idCedente = p.id', array('cedente' => 'nm_pessoa'))
                ->join(array('p2' => TB_PESSOA), 't.idReceptor = p2.id', array('receptor' => 'nm_pessoa'))
                ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('lote', 'quadra'))
                ->where($where)
                ->order('data DESC')
                ->query()->fetchAll();
        } else {
            $tipoRelatorio = 'relTransfLote';
            $transferencia = $adapter->select()
                ->from(array('t' => TB_TRANSFERENCIA_LOTE), array('*'))
                ->join(array('c' => TB_CONTRATO), 'c.id = t.id_contrato', null)
                ->join(array('p' => TB_PESSOA), 'p.id = c.id_pessoa', 'nm_pessoa')
                ->join(array('l' => TB_LOTES), 'l.id = t.id_lote_origem', array('loteOrigem' => 'lote', 'quadraOrigem' => 'quadra'))
                ->join(array('lDestino' => TB_LOTES), 'lDestino.id = t.id_lote_destino', array('loteDestino' => 'lote', 'quadraDestino' => 'quadra'))
                ->where($where)
                ->order(array('t.dt_transferencia DESC','t.id_contrato','l.quadra','lDestino.quadra','l.lote','lDestino.lote'))
                ->query()->fetchAll();
        }
        if (count($transferencia)) {
            $empreendimento = $tb_emp->fetchRow('id = ' . $_POST['id_empreendimento'])->toArray();
            $this->set('emp', $empreendimento);
            $this->set('transferencias', $transferencia);
        }
        if (!$transferencia) {
            $msg = "No foram encontrados nenhum registro.";
            $this->_helper->addMensagem('danger', $msg);
        }
//        Mensagem de Erros
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            echo json_encode(true);
        }

    }

}