<?php

class SpedController extends Controller
{


    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_empreendimento = new Empreendimento();
    }

    public function indexAction()
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        set_time_limit(0);

        //instancia as classes necessrias
        $instanceEmpreendimento = new Empreendimento();
        $empreendimento = $instanceEmpreendimento->getDefaultAdapter();

        $empreendimento = $empreendimento->select()->distinct('e.id')
            ->from(array('e' => TB_EMPREENDIMENTO), array('nm_empreendimento', 'id'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {
            }
        }
        $empreendimento = $empreendimento->group('e.id')->order('nm_empreendimento')->query()->fetchAll();
        $this->set('empreendimentos', $empreendimento);

        if ($this->_isPost) {
            // o empreendimento escolhido.
            $empreendimento = addslashes(base64_decode($_POST['empreendimento']));
            $dtInicial = Helper::getInputDate($_POST['dtInicial']);
            $dtFinal = Helper::getInputDate($_POST['dtFinal']);

            $ordem = ($_POST['ordem'] == 'Q') ? array('quadra', 'lote') : 'nm_pessoa';

            $contratosPF = Zend_Db_Table::getDefaultAdapter()->select()
                ->from(array('l' => TB_LOTES), array('lote', 'quadra'))
                ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'nr_parcela', 'vl_parcela', 'nr_parcela_sinal', 'vl_sinal', 'nr_intercalada', 'vl_intercalada', 'nr_parcela_entrega', 'vl_parcela_entrega', 'dt_contrato', 'inclui_sinal_contrato', 'fl_distrato', 'fl_itens_contrato'))
                ->join(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('nm_pessoa'))
                ->join(array('pf' => TB_PESSOA_FISICA), 'pe.id = pf.id_pessoa', array('cpf_cnpj' => 'nr_cpf'))
                ->where('id_empreendimento = ' . $empreendimento)
                ->group('c.id')->order($ordem)->query()->fetchAll();

            $contratosPJ = Zend_Db_Table::getDefaultAdapter()->select()
                ->from(array('l' => TB_LOTES), array('lote', 'quadra'))
                ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'nr_parcela', 'vl_parcela', 'nr_parcela_sinal', 'vl_sinal', 'nr_intercalada', 'vl_intercalada', 'nr_parcela_entrega', 'vl_parcela_entrega', 'dt_contrato', 'inclui_sinal_contrato', 'fl_distrato', 'fl_itens_contrato'))
                ->join(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('nm_pessoa'))
                ->join(array('pj' => TB_PESSOA_JURIDICA), 'pe.id = pj.id_pessoa', array('cpf_cnpj' => 'nr_cnpj'))
                ->where('id_empreendimento = ' . $empreendimento)
                ->group('c.id')->order($ordem)->query()->fetchAll();

            $contratos = array_merge($contratosPF, $contratosPJ);

            // Verifica se tem registros, caso n?o tenha nem chama o relat?rio.
            if (count($contratos) == 0) {
                $this->_helper->addMensagem('fail', 'Informaes no encontradas!');
                $this->display('index');
                exit;
            }
            //Verifica o checkbox de outros para excluir ou no o tipo de baixa
            $tipoExcluido = "O";
            if ($_POST['outros'] == 1) {
                $tipoExcluido = false;
            }

            $aux = array();
            $i = 0;

            $filtroData = ($_POST['filtroData'] == 'DP') ? 'dt_pagamento' : 'dt_credito';

            $adapter = $this->tb_empreendimento->getAdapter();
            foreach ($contratos as $contrato) {
                //Busca as parcelas do contrato, excluindo o tipo de baixa 'O' de acordo com o checkbox do formulario.
                $valores = Parcela::valorParcelasPagasByContrato($contrato['id_contrato'], $dtInicial, $dtFinal, $tipoExcluido, $_POST['filtroData']);
                $valoresHistorico = Parcela::valorParcelasPagasHistoricoByContrato($contrato['id_contrato'], $dtInicial, $dtFinal, $tipoExcluido, $_POST['filtroData']);

                if (is_null($valores['valorParcela']) && is_null($valoresHistorico['valorParcela'])) {
                    unset($aux[$i]);
                    continue;
                }

                $aux[$i]['lote'] = $contrato['lote'];
                $aux[$i]['quadra'] = $contrato['quadra'];
                $aux[$i]['cliente'] = $contrato['nm_pessoa'];
                $aux[$i]['contrato'] = $contrato['id_contrato'];
                $aux[$i]['desconto'] = $valores['desconto'] + $valoresHistorico['desconto'];
                $aux[$i]['acrescimo'] = $valores['acrescimo'] + $valoresHistorico['acrescimo'];
                $aux[$i]['valorDaParcela'] = ($valores['valorParcela'] + $valoresHistorico['valorParcela'])-$aux[$i]['desconto']+$aux[$i]['acrescimo'];
                $aux[$i]['vl_juros'] = $valores['valorJuros'] + $valoresHistorico['valorJuros'];
                $aux[$i]['vl_multa'] = $valores['valorMulta'] + $valoresHistorico['valorMulta'];
                $aux[$i]['vl_total_pago'] = $valores['valorTotal'] + $valoresHistorico['valorTotal'];

                $dt = explode('-', $contrato['dt_contrato']);
                $dataContrato = $dt[2] . '/' . $dt[1] . '/' . $dt[0];

                $aux[$i]['dt_contrato'] = $dataContrato;
                $aux[$i]['cpf_cnpj'] = $contrato['cpf_cnpj'];
                $aux[$i]['vlVenda'] = ($contrato['vl_parcela'] * $contrato['nr_parcela']) + ($contrato['vl_intercalada'] * $contrato['nr_intercalada']) + ($contrato['vl_parcela_entrega'] * $contrato['nr_parcela_entrega']);
                if ($contrato['inclui_sinal_contrato'] == 1) {
                    $aux[$i]['vlVenda'] += $contrato['vl_sinal'];
                }

                //Busca os valores dos itens adicionais se existirem
                if ($contrato['fl_itens_contrato'] == '1') {
                    $itensContrato = ContratoItens::findByContrato($contrato['id_contrato']);

                    if (count($itensContrato) > 0)
                        foreach ($itensContrato as $item) {
                            $aux[$i]['vlVenda'] += $item['vl_parcela'] * $item['qt_parcelas'];
                        }
                }

                if ($contrato['fl_distrato'] != '1') {
                    $parciais = $adapter->select()
                        ->from(array('p' => TB_PARCELA), array('valorRecebido' => new Zend_Db_Expr('sum(vl_total_pago)')))
                        ->where("id_contrato = " . $contrato['id_contrato'])
                        ->where($filtroData . " < '{$dtInicial}'")
                        ->where('tp_baixa != "' . $tipoExcluido . '"')
                        ->where("pago = '1'")
                        ->query()->fetch();
                } else {
                    $parciais = $adapter->select()
                        ->from(array('p' => TB_PARCELA_HISTORICO), array('valorRecebido' => new Zend_Db_Expr('sum(vl_total_pago)')))
                        ->where("id_contrato = " . $contrato['id_contrato'])
                        ->where($filtroData . " < '{$dtInicial}'")
                        ->where('tp_baixa != "' . $tipoExcluido . '"')
                        ->where("pago = '1'")
                        ->query()->fetch();
                }
                $aux[$i]['valorRecebido'] = $parciais['valorRecebido'];


                $i++;

            }
            $empreendimentoInfo = $instanceEmpreendimento->getAdapter()->select()->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento'))
                ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
                ->where('em.id = '.$_POST['empreendimento'])->query()->fetch();
            $this->set("empreendimentoInfo", $empreendimentoInfo);

            $empreendimento = $this->tb_empreendimento->fetchRow("id = {$empreendimento}");
            $this->set('filtros', array('empreendimento' => $empreendimento['nm_empreendimento'], 'dtInicial' => $_POST['dtInicial'], 'dtFinal' => $_POST['dtFinal'], 'outros' => $_POST['outros'], 'filtroData' => $_POST['filtroData']));


            $this->set('clientes', $aux);
            $this->display('relatorioSped');
            $this->displayMPDF("sped" . date("d/m/Y") . ".pdf", true, "L", "A4", array(1, 1, 1, 1));


        } else {
            $this->display('index');
        }

    }

    public function validarAction()
    {
        $campos = array('empreendimento' => 'Selecione o Empreendimento', 'dtInicial' => 'Informe a data inicial', 'dtFinal' => 'Informe a data final');
        foreach ($campos as $campo => $msg) {
            if ($_POST[$campo] == "") {
                $this->_helper->addMensagem($campo, $msg);
            }
        }
        // Verifica se tem registros.
        if ($this->_isPost) {
            $empreendimento = addslashes(base64_decode($_POST['empreendimento']));
            $dtInicial = Helper::getInputDate($_POST['dtInicial']);
            $dtFinal = Helper::getInputDate($_POST['dtFinal']);
            $ordem = ($_POST['ordem'] == 'Q') ? array('quadra', 'lote') : 'nm_pessoa';

            $contratosPF = Zend_Db_Table::getDefaultAdapter()->select()
                ->from(array('l' => TB_LOTES), array('lote', 'quadra'))
                ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'nr_parcela', 'vl_parcela', 'nr_parcela_sinal', 'vl_sinal', 'nr_intercalada', 'vl_intercalada', 'nr_parcela_entrega', 'vl_parcela_entrega', 'dt_contrato', 'inclui_sinal_contrato', 'fl_distrato', 'fl_itens_contrato'))
                ->join(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('nm_pessoa'))
                ->join(array('pf' => TB_PESSOA_FISICA), 'pe.id = pf.id_pessoa', array('cpf_cnpj' => 'nr_cpf'))
                ->where('id_empreendimento = ' . $empreendimento)
                ->group('c.id')->order($ordem)->query()->fetchAll();

            $contratosPJ = Zend_Db_Table::getDefaultAdapter()->select()
                ->from(array('l' => TB_LOTES), array('lote', 'quadra'))
                ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'nr_parcela', 'vl_parcela', 'nr_parcela_sinal', 'vl_sinal', 'nr_intercalada', 'vl_intercalada', 'nr_parcela_entrega', 'vl_parcela_entrega', 'dt_contrato', 'inclui_sinal_contrato', 'fl_distrato', 'fl_itens_contrato'))
                ->join(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('nm_pessoa'))
                ->join(array('pj' => TB_PESSOA_JURIDICA), 'pe.id = pj.id_pessoa', array('cpf_cnpj' => 'nr_cnpj'))
                ->where('id_empreendimento = ' . $empreendimento)
                ->group('c.id')->order($ordem)->query()->fetchAll();

            $contratos = array_merge($contratosPF, $contratosPJ);
          
            $tipoExcluido = "O";
            if ($_POST['outros'] == 1) {
                $tipoExcluido = false;
            }

            foreach ($contratos as $k => &$contrato) {
                //Busca as parcelas do contrato, excluindo o tipo de baixa 'O' de acordo com o checkbox do formulario.
                $valores = Parcela::valorParcelasPagasByContrato($contrato['id_contrato'], $dtInicial, $dtFinal, $tipoExcluido, $_POST['filtroData']);
                $valoresHistorico = Parcela::valorParcelasPagasHistoricoByContrato($contrato['id_contrato'], $dtInicial, $dtFinal, $tipoExcluido, $_POST['filtroData']);

                if (is_null($valores['valorParcela']) && is_null($valoresHistorico['valorParcela'])) {
                    unset($contratos[$k]);
                    continue;
                }
            }

            if (!$contratos) {
                $msg = "Nenhum resultado foi encontrado.";
                $this->_helper->addMensagem('danger', $msg);
            }
        }
        //Mensagem de Erros
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            echo json_encode(true);
        }
    }
}

?>
