<?php

/**
 * Created by PhpStorm.
 * User: programacao-03
 * Date: 30/10/15
 * Time: 09:11
 */
class RelatorioPrevisaoController extends Controller
{

    public function indexAction()
    {
        $this->set("subtitulo", "Relatrio de Previso de Parcelas");
        $this->carregarDados();
        $this->display("index");
    }

    private function carregarDados()
    {
        $instanceEmpreendimento = new Empreendimento();
        $empreendimento = $instanceEmpreendimento->getDefaultAdapter();
        $empreendimento = $empreendimento->select()->from(array('e' => TB_EMPREENDIMENTO), array('nm_empreendimento'))
            ->join(array('l' => TB_LOTES), 'e.id = l.id_empreendimento', array('id_lote' => 'id', 'id_empreendimento'))
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'id_lote'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {
            }
        }
        $empreendimento = $empreendimento->group('e.id')->order('nm_empreendimento')->query()->fetchAll();
        $this->set('empreendimentos', $empreendimento);
    }

    public function validarAction()
    {
        $campos = array("empreendimento");
        foreach ($campos as $cp) {
            if ($_POST[$cp] == "") {
                switch ($cp) {
                    case "empreendimento":
                        $msg = "O campo Empreendimento  obrigatrio.";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }
        if ($_POST['de'] == '' || $_POST['ate'] == '') {
            $msg = 'Os campos datas devem ser informado.';
            $this->_helper->addMensagem('data', $msg);
        } elseif (strtotime(Helper::dataParaAmericano($_POST['de']) . '+3 month') <= strtotime(Helper::dataParaAmericano($_POST['ate']))) {
            if ($_POST['tpImpressao'] != 'html' && $_POST['tpImpressao'] != 'xls') {
                $msg = 'O perodo precisa ser no mximo 90 dias.';
                $this->_helper->addMensagem('data', $msg);
            }
        }
        if (count($_POST['tp_parcela']) == 0) {
            $msg = "Selecione pelo menos um tipo de parcela.";
            $this->_helper->addMensagem('tp_parcela', $msg);
        }

        if (count($_POST['tp_clientes']) == 0) {
            $msg = "Selecione pelo menos um tipo de cliente.";
            $this->_helper->addMensagem('tp_clientes', $msg);
        }

        $tbEmpreendimento = new Empreendimento();
        $empreendimento = $tbEmpreendimento->fetchRow('id = ' . $_POST['empreendimento']);
        $db = Zend_Db_Table::getDefaultAdapter();

        foreach ($_POST['tp_parcela'] as $tipo) {
            if ($tipo == 'G' || $tipo == 'Q') {
                $tp_parcelas[] = "'" . $tipo . "'";
            } else $tp_parcelas[] = "'" . $tipo . "','" . $tipo . "E'";
        }
        $tp_parcelas = '(' . implode(',', $tp_parcelas) . ')';

        $id_banco = $_POST['previsaoParcelasBanco'];

        $idContrato = null;

        if ($_POST['idContrato'] != 'Todos') {
            $idContrato = $_POST['idContrato'];
        }

        $parcelasRelatorio = Parcela::ParcelasRelatorioPrevisao($empreendimento, $tp_parcelas, $_POST, false, $id_banco, '', $idContrato);

        $tb_parcela = new Parcela();
        $parcelas = $tb_parcela->getAdapter()->select()
        ->from(array('p' => TB_PARCELA), array('id_contrato,count(id_contrato) as qtd'))
        //->where('p.id_contrato = "'.$contrato['id_contrato'].'"')
        ->where('p.tp_parcela NOT IN ("SE", "NE", "IE", "CE", "E")')
        ->where('p.pago = "0"')
        ->where('dt_parcela < ?',date('Y-m-d'))
        ->group('p.id_contrato')
        ->query()->fetchAll();
        $parcelasIndexado = [];
        foreach($parcelas as $parcela){
            $parcelasIndexado[$parcela['id_contrato']]=$parcela['qtd'];
        }
        foreach($parcelasRelatorio as $key=>$relatorio){
            foreach($relatorio as $k=>$contrato){
                if($parcelasIndexado[$contrato['id_contrato']]){
                    $parcelasRelatorio[$key][$k]['inadimplente'] = $parcelasIndexado[$contrato['id_contrato']];
                }
                else{
                    $parcelasRelatorio[$key][$k]['inadimplente'] = 0;
                }
            }
        } 
        if(count($_POST['tp_clientes']) == 1 && $_POST['tp_clientes'][0] == 'A'){
            foreach($parcelasRelatorio as $key=>$relatorio){
                foreach($relatorio as $k=>$contrato){
                    if($contrato['inadimplente'] > 0){
                        unset($parcelasRelatorio[$key][$k]);
                        // sort($parcelasRelatorio);
                    }
                }
            }
        }elseif($_POST['tp_clientes'][0] == 'I'){
            foreach($parcelasRelatorio as $key=>$relatorio){
                foreach($relatorio as $k=>$contrato){
                    if($contrato['inadimplente'] == 0){
                        unset($parcelasRelatorio[$key][$k]);
                        sort($parcelasRelatorio);
                    }
                }
            }
        }

        if (!$parcelasRelatorio[0] && !$parcelasRelatorio[1]) {
            $msg = "No foram encontradas nenhuma parcela.";
            $this->_helper->addMensagem('danger', $msg);
        }

        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            echo json_encode(true);
        }
    }

    public function carregaBancosByEmpAction()
    {
        if ($this->_isPost) {
            $search_emp = $_POST['emp'];

            try {
                if (isset($search_emp) && !empty($search_emp)) {
                    $bancos = new Banco();
                    $bancos = $bancos->fetchAll($bancos->select()
                        ->where('id_empreendimento = ' . $search_emp . ' AND fl_ativo = "1"'))->toArray();
                    $lista = array();
                    $lista[] = array('id' => '*', 'text' => utf8_encode('Todos'));
                    foreach ($bancos as &$banco) {
                        $banco['nmBanco'] = Banco::findBancoNome($banco['cd_banco']);
                        $lista[] = array('id' => $banco['id'], 'text' => utf8_encode($banco['nmBanco']) . ' - Ag.: ' . $banco['agencia'] . '-' . $banco['agencia_dv'] . '  Cc.: ' . $banco['conta_corrente'] . '-' . $banco['conta_corrente_dv']);
                    }

                    echo json_encode($lista);
                }
            } catch (Exception $e) {
             
            }
        }
    }


    public function contratoByEmpreendimentoAction() 
    {
        $contratos = new Contrato();
        $contratos = Contrato::byEmpreendimentoextrato($_POST['id_empreendimento'], Contrato::CONTRATO_GERADO, array("nm_pessoa", "lote", "quadra", "id"));
        
        $lista = array();

        foreach ($contratos as $contrato) {
            $lista[] = array(
                'id' => $contrato['id'],
                'text' => utf8_encode($contrato['nm_pessoa']) . ' - Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . utf8_encode($contrato['id'])
            );
        }

        if (!empty($lista)) {
            array_unshift($lista, array(
                'id' => 'Todos',
                'text' => utf8_encode('Todos')
            ));
        }
        echo json_encode($lista);
    }

    public function relatorioAction()
    {
        if ($this->_isPost) {
            $tbClienteAcade = new Db_Cliente();
            $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

            ini_set('memory_limit', '3000M');
            set_time_limit(0);

            $banco_id = '';

            if (isset($_POST['previsaoParcelasBanco'])) {
                $banco_id = $_POST['previsaoParcelasBanco'];
            }

            $tbEmpreendimento = new Empreendimento();
            $empreendimento = $tbEmpreendimento->fetchRow('id = ' . $_POST['empreendimento']);
            $db = Zend_Db_Table::getDefaultAdapter();
            foreach ($_POST['tp_parcela'] as $tipo) {
                if ($tipo == 'G' || $tipo == 'Q') {
                    $tp_parcelas[] = "'" . $tipo . "'";
                } else $tp_parcelas[] = "'" . $tipo . "','" . $tipo . "E'";
            }
            $tp_parcelas = '(' . implode(',', $tp_parcelas) . ')';
            if ($_POST['idContrato'] == 'Todos'){
                $parcelasRelatorio = Parcela::ParcelasRelatorioPrevisao($empreendimento, $tp_parcelas, $_POST, true, $banco_id, $_POST['parcelaEmissao']);
            } else {
                $idContrato = $_POST['idContrato'];
                $parcelasRelatorio = Parcela::ParcelasRelatorioPrevisao($empreendimento, $tp_parcelas, $_POST, true, $banco_id, $_POST['parcelaEmissao'], $idContrato);
            }

            $tb_parcela = new Parcela();
            $parcelas = $tb_parcela->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('id_contrato,count(id_contrato) as qtd'))
            //->where('p.id_contrato = "'.$contrato['id_contrato'].'"')
            ->where('p.tp_parcela NOT IN ("SE", "NE", "IE", "CE", "E")')
            ->where('p.pago = "0"')
            ->where('dt_parcela < ?',date('Y-m-d'))
            ->group('p.id_contrato')
            ->query()->fetchAll();
            $parcelasIndexado = [];
            foreach($parcelas as $parcela){
                $parcelasIndexado[$parcela['id_contrato']]=$parcela['qtd'];
            }
            foreach($parcelasRelatorio as $key=>$relatorio){
                foreach($relatorio as $k=>$contrato){
                    if($parcelasIndexado[$contrato['id_contrato']]){
                        $parcelasRelatorio[$key][$k]['inadimplente'] = $parcelasIndexado[$contrato['id_contrato']];
                    }
                    else{
                        $parcelasRelatorio[$key][$k]['inadimplente'] = 0;
                    }
                }
            }

            if(count($_POST['tp_clientes']) == 1){
                foreach($parcelasRelatorio as $key=>$relatorio){
                    foreach($relatorio as $k=>$contrato){
                        if($_POST['tp_clientes'][0] == 'A' && $contrato['inadimplente'] > 0){
                            unset($parcelasRelatorio[$key][$k]);
                        }elseif($_POST['tp_clientes'][0] == 'I' && $contrato['inadimplente'] == 0){
                            unset($parcelasRelatorio[$key][$k]);
                            
                        }
                    }
                }
                sort($parcelasRelatorio);
            }
            //Ordena as parcelas para ficarem as parcelas pagas no array de pagas e as no pagas no array de no pagas.
            foreach ($parcelasRelatorio as $pRelatorio) {
                foreach ($pRelatorio as $parcela) {
                    if (!is_null($parcela['dt_pagamento'])) {
                        $parcelasPagas[] = $parcela;
                    } else {
                        $parcelasNaoPagas[] = $parcela;
                    }
                }
            }

            $valorTotalSemJurosEMulta = $valorTotalComJurosEMulta = $valorRecebidoSemJurosEMulta = $valorRecebidoComJurosEMulta = $jurosRecebido = $multaRecebida = 0;
            $valorTotalDesconto = 0;
            foreach ($parcelasPagas as $key => $parcela) {
                $jurosRecebido += $parcela['vl_juros'];
                $multaRecebida += $parcela['vl_multa'];
                $valorTotalSemJurosEMulta += $parcela['vl_parcela'];
                $valorTotalComJurosEMulta += $parcela['vl_total_pago'];
                $valorTotalDesconto += $parcela['desconto'];
                $select = $db->select()->from(TB_PARCELA, 'count(*)')
                    ->where('id_contrato = ?', $parcela['id_contrato'])
                    ->where('tp_parcela = ?', $parcela['tp_parcela']);
                if ($parcela['tp_parcela'] == 'G') {
                    $select->where("id_negociacao = {$parcela['id_negociacao']}");
                }
                $quantidade = $select->query()->fetch();
                $parcelasPagas[$key]['id_parcela'] = $parcela['id_parcela'] . '/' . $quantidade['count(*)'] . '-' . $parcela['tp_parcela'];
            }
            $valorRecebidoSemJurosEMulta = $valorTotalSemJurosEMulta;
            $valorRecebidoComJurosEMulta = $valorTotalComJurosEMulta;

            $valorNaoRecebidoSemJurosEMulta = $valorNaoRecebidoComJurosEMulta = 0;
            foreach ($parcelasNaoPagas as $key => $parcela) {
                $select = $db->select()->from(TB_PARCELA, 'count(*)')
                    ->where('id_contrato = ?', $parcela['id_contrato'])
                    ->where('tp_parcela = ?', $parcela['tp_parcela']);

                if ($parcela['tp_parcela'] == 'G' && $parcela['id_negociacao']) {
                    $select->where("id_negociacao = {$parcela['id_negociacao']}");
                }
                $atraso = Helper::date_diff($parcela["dt_parcela"], date('Y-m-d'));
                if ($atraso > 0) {
                    $multa = $parcela["vl_parcela"] * ($parcela["multa"] / 100);
                    $juros = $parcela["vl_parcela"] * ($parcela["juros"] / 100);
                    $juros *= $atraso;
                } else {
                    $multa = 0;
                    $juros = 0;
                }

                $quantidade = $select->query()->fetch();
                $parcelasNaoPagas[$key]['atraso'] = $atraso >= 0 ? number_format($atraso, 0) : 0;
                $parcelasNaoPagas[$key]['id_parcela'] = $parcela['id_parcela'] . '/' . $quantidade['count(*)'] . '-' . $parcela['tp_parcela'];
                $parcelasNaoPagas[$key]['vl_multa'] = $multa;
                $parcelasNaoPagas[$key]['vl_juros'] = $juros;
                $parcelasNaoPagas[$key]["receber"] = $parcela["vl_parcela"] + $multa + $juros - $parcelasNaoPagas[$key]['desconto'];
                $valorNaoRecebidoSemJurosEMulta += $parcela['vl_parcela'];
                $valorNaoRecebidoComJurosEMulta += $parcelasNaoPagas[$key]["receber"];
            }

            $valorTotalComJurosEMulta += $valorNaoRecebidoComJurosEMulta;
            $valorTotalSemJurosEMulta += $valorNaoRecebidoSemJurosEMulta;
            $quantidadeParcelasRecebidas = count($parcelasPagas);
            $quantidadeParcelasNaoRecebidas = count($parcelasNaoPagas);
            $quantidadeParcelasTotal = $quantidadeParcelasRecebidas + $quantidadeParcelasNaoRecebidas;

            $relatorio = array(
                'empreendimento' => $empreendimento->nm_empreendimento,
                'jurosRecebido' => $jurosRecebido,
                'multaRecebida' => $multaRecebida,
                'valorAReceberSemJurosEMulta' => $valorNaoRecebidoSemJurosEMulta,
                'valorAReceberComJurosEMulta' => $valorNaoRecebidoComJurosEMulta,
                'valorRecebidoSemJurosEMulta' => $valorRecebidoSemJurosEMulta,
                'valorRecebidoComJurosEMulta' => $valorRecebidoComJurosEMulta,
                'valorTotalSemJurosEMulta' => $valorTotalSemJurosEMulta,
                'valorTotalComJurosEMulta' => $valorTotalComJurosEMulta,
                'quantidadeParcelasTotal' => $quantidadeParcelasTotal,
                'quantidadeParcelasRecebidas' => $quantidadeParcelasRecebidas,
                'quantidadeParcelasNaoRecebidas' => $quantidadeParcelasNaoRecebidas,
                'desconto' => $valorTotalDesconto,
            );

            $empreendimento = new Empreendimento();
            $empreendimentoInfo = $empreendimento->getAdapter()->select()->from(array('em' => TB_EMPREENDIMENTO), array('ds_path_logo'))
                ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
                ->where('id = ' . $_POST['empreendimento'])
                ->query()->fetch();
            $this->set("empreendimentoInfo", $empreendimentoInfo);

            $bancoNome = '';

            if ($banco_id != '*') {
                $banco = new Banco();

                $bancoData = $banco->getAdapter()->select()
                    ->from(array('bc' => TB_BANCO), array(''))
                    ->join(array('agrp' => TB_AGRUPADA), 'bc.cd_banco=agrp.idCampo', array('agrp.descricao'))
                    ->where('bc.id=' . $banco_id)
                    ->query()->fetch();
                $bancoNome = $bancoData['descricao'];
            } else {
                $bancoNome = 'Todos';
            }

            $this->set('bancoNome', $bancoNome);
            $this->set('tpCliente', $_POST['tp_clientes']);
            $this->set('relatorio', $relatorio);
            $this->set('parcelasPagas', $parcelasPagas);
            $this->set('parcelasNaoPagas', $parcelasNaoPagas);
            $this->set('periodo', $_POST['de'] . ' at&eacute; &nbsp;' . $_POST['ate']);
            if ($_POST['tpImpressao'] == 'pdf' || $_POST['tpImpressao'] == 'html') {
                $this->display("relPrevisao");
            }
            if ($_POST['tpImpressao'] == 'pdf') {
                $this->displayMPDF('Relatorio_' . time() . '.pdf');
            } elseif ($_POST['tpImpressao'] == 'xls') {

                $colunas = [
                    'Cliente',
                    'Contrato',
                    Helper::exibeAbreviacao(($empreendimentoInfo['ds_subgrupo'] != '') ? $empreendimentoInfo['ds_subgrupo'] : ''),
                    Helper::exibeAbreviacao(($empreendimentoInfo['ds_grupo'] != '') ? $empreendimentoInfo['ds_grupo'] : ''),
                    'Baixa',
                    'Parcela',
                    'Vencto',
                    'Valor',
                    'Desconto',
                    'Multa',
                    'Juros',
                    'Total',
                ];
                $linhas[] = ['PARCELAS PAGAS'];
                $linhas[] = [''];

                if ($parcelasPagas) {



                    foreach ($parcelasPagas as $k => $parcela) {
                        $linhas[] = [
                            $parcela["nm_pessoa"],
                            $parcela["id_contrato"],
                            $parcela["lote"],
                            $parcela["quadra"],
                            $parcela["id_parcela_contrato"],
                            $parcela["id_parcela"],
                            Helper::getDate($parcela["dt_parcela"]),
                            Helper::getMoney($parcela["vl_parcela"]),
                            Helper::getMoney($parcela["desconto"]),
                            Helper::getMoney($parcela["vl_multa"]),
                            Helper::getMoney($parcela["vl_juros"]),
                            Helper::getMoney($parcela["vl_total_pago"])
                        ];
                    }
                }
                $linhas[] = [''];

                $linhas[] = [
                    'Cliente',
                    'Contrato',
                    Helper::exibeAbreviacao(($empreendimentoInfo['ds_subgrupo'] != '') ? $empreendimentoInfo['ds_subgrupo'] : ''),
                    Helper::exibeAbreviacao(($empreendimentoInfo['ds_grupo'] != '') ? $empreendimentoInfo['ds_grupo'] : ''),
                    'Baixa',
                    'Parcela',
                    'Vencto',
                    'Valor',
                    'Desconto',
                    'Multa',
                    'Juros',
                    'Receber',

                ];

                $linhas[] = ['PARCELAS NAO PAGAS'];

                if ($parcelasNaoPagas) {

                    $linhas[] = [''];

                    foreach ($parcelasNaoPagas as $key => $parc) {
                        $linhas[] = [
                            $parc["nm_pessoa"],
                            $parc["id_contrato"],
                            $parc["lote"],
                            $parc["quadra"],
                            $parc["id_parcela_contrato"],
                            $parc["id_parcela"],
                            Helper::getDate($parc["dt_parcela"]),
                            Helper::getMoney($parc["vl_parcela"]),
                            Helper::getMoney($parc["desconto"]),
                            Helper::getMoney($parc["vl_multa"]),
                            Helper::getMoney($parc["vl_juros"]),
                            Helper::getMoney($parc["receber"]),
                        ];
                    }
                }
                $this->geraExcel($colunas, $linhas);
            }
        } else {
            $this->indexAction();
        }
    }
}
