<?php

class RelatorioPagasController extends Controller 
{
    public function indexAction()
    {
        $instanceEmpreendimento = new Empreendimento();
        $empreendimento = $instanceEmpreendimento->getDefaultAdapter();

        $empreendimento = $empreendimento->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('id_empreendimento' => 'id', 'nm_empreendimento'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {

            }
        }
        $empreendimento = $empreendimento->group('e.id')->order('nm_empreendimento')->query()->fetchAll();
        $this->set('empreendimentos', $empreendimento);
        $this->set('formaBaixa', (new TabelaAgrupada)->fetchAll('idTabela = "28"')->toArray());
        
        $this->display("index");
    }

    public function relatorioAction()
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        ini_set('memory_limit', '3000M');
        set_time_limit(0);
        if ($this->validarAction()) {
            /*
             * Executa o relatorio de nao pagas apos setar os parametros de execucao
              * Passa como parametro o tipo de relatorio (analitico ou sintetico)
              */
            $this->relatorioP();
        }
    }

    public function relatorioP()
    {
        $tpParcelas = array();
        if (count($_POST['tp_parcela'])) {
            foreach ($_POST['tp_parcela'] as $tipo) {
                if ($tipo == 'Q') {
                    $tpParcelas[] = '"' . $tipo . '"';
                }elseif($tipo == 'G'){
                    $tpParcelas[] = '"' . $tipo . '", "E"';
                } else {
                    $tpParcelas[] = '"' . $tipo . '", "' . $tipo . 'E"';
                }
            }
            $tpParcelas = '(' . implode(',', $tpParcelas) . ')';
        }

        if (count($_POST['tp_pagamento'])) {
            foreach ($_POST['tp_pagamento'] as $tipo) {
                $tipoPg[] = '"' . $tipo . '"';
            }
        }

        $tipoPg = '(' . implode(',', $tipoPg) . ')';

        if (count($_POST['formaBaixa'])) {
            $formaBaixa = implode('","', $_POST['formaBaixa']);
        }

        $instanceEmpreendimento = new Empreendimento();

        $relatorio['empreendimento'] = $instanceEmpreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.rgi', 'e.id', 'e.porcAdmin','ds_path_logo'))
            ->join(array('c' => Db_Cidade::TABLE_NAME), 'e.cd_cidade = c.id', array('cidade_nome' => 'c.nome', 'cidade_uf' => 'c.uf'))
            ->joinLeft(array('t' => TB_TIPO_LOTEAMENTO), 'e.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
            ->where('e.id = ?', $_POST['empreendimento_relatorio_parcela_paga'])->query()->fetch();

        $instanceContrato = new Contrato();
        $instanceContrato = $instanceContrato->getDefaultAdapter()->select()
            ->from(array('c' => TB_CONTRATO), array('id_contrato' => 'c.id', 'id_lote' => 'c.id_lote', 'nr_parcela',
                'nr_parcela_sinal', 'nr_intercalada', 'nr_parcela_entrega'))
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('l.quadra', 'l.lote'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('p.nm_pessoa', 'p.endereco', 'p.nm_bairro', 'id_pessoa' => 'p.id'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', 'nr_cpf')
            ->joinLeft(array("pj" => TB_PESSOA_JURIDICA), "p.id = pj.id_pessoa", 'nr_cnpj');

        //testa se foi selecionado algum contrato ou se esta sendo selecionado "todos"
        if ($_POST['cliente_relatorio_parcela_paga'] != '*') {
            $instanceContrato->where('p.id = ?', $_POST['cliente_relatorio_parcela_paga']);
        }

        if ($_POST['quadra_relatorio_parcela_paga'] != '*') {
            $instanceContrato->where('l.id = ?', $_POST['quadra_relatorio_parcela_paga']);
        }

        $relatorio['contrato'] = $instanceContrato->where('l.id_empreendimento = ?', $relatorio['empreendimento']['id'])
            ->order(array('p.nm_pessoa', 'l.lote', 'l.quadra'))
            ->query()->fetchAll();

        if ($_POST['banco'] != '*') {
            $relatorio['banco'] = Banco::findBanco($_POST['banco'])->descricao;
        }

        //Seta os valores do quadro resumo ao final do relatorio para acrescimos
        $parcela_quantidade = 0;
        $parcela_valor = 0;
        $total_valor = 0;
        $valorPorcAdmin = 0;
        $count = count($relatorio['contrato']);
        $getVlContrato= 0;
        if ($count) {

            $tbAgrupada = new TabelaAgrupada();

            $vlTotalDesconto = 0;
            $vlTotalMulta = 0;
            $vlTotalJuros = 0;
            $contratosCredito = array();

            //Dados para resumo de parcerias e valores das parcelas
            $totalParcelas = array(
                'N' => array('valor' => 0, 'qtd' => 0),
                'S' => array('valor' => 0, 'qtd' => 0),
                'I' => array('valor' => 0, 'qtd' => 0),
                'C' => array('valor' => 0, 'qtd' => 0),
                'Q' => array('valor' => 0, 'qtd' => 0),
                'G' => array('valor' => 0, 'qtd' => 0),
                'A' => array('valor' => 0, 'qtd' => 0),
            );
            $parcerias = ParceriaComissao::findByEmpreendimento($relatorio['empreendimento']['id']);

            //percorre todos os contratos selecionados
            foreach ($relatorio['contrato'] as $key => &$contrato) {
                $parcela_quitacao_quantidade_contrato = 0;

                if ($_POST['dePagamento'] && $_POST['deCredito']) {
                    //Busca todas as parcelas do contrato de acordo com os parametros utilizando a data de pagamento e de credito
                    $parcelas = Parcela::parcelaByContrato($contrato['id_contrato'], $_POST['dePagamento'], $_POST['atePagamento'], $tpParcelas, 1, $tipoPg,
                        array('de' => $_POST['deCredito'], 'ate' => $_POST['ateCredito']), false, $formaBaixa);
                    $parcelasHistorico = Parcela::parcelaHistoricoByContrato($contrato['id_contrato'], $_POST['dePagamento'], $_POST['atePagamento'], $tpParcelas, 1, $tipoPg,
                        array('de' => $_POST['deCredito'], 'ate' => $_POST['ateCredito']), $formaBaixa);
                } elseif (!$_POST['dePagamento'] && $_POST['deCredito']) {
                    //Busca todas as parcelas do contrato de acordo com os parametros utilizando a data de credito
                    $parcelas = Parcela::parcelaByContrato($contrato['id_contrato'], $_POST['deCredito'], $_POST['ateCredito'], $tpParcelas, 1, $tipoPg, 'C', false, $formaBaixa);
                    $parcelasHistorico = Parcela::parcelaHistoricoByContrato($contrato['id_contrato'], $_POST['deCredito'], $_POST['ateCredito'], $tpParcelas, 1, $tipoPg, true, $formaBaixa);
                } else {
                    //Busca todas as parcelas do contrato de acordo com os parametros utilizando a data de pagamento
                    $parcelas = Parcela::parcelaByContrato($contrato['id_contrato'], $_POST['dePagamento'], $_POST['atePagamento'], $tpParcelas, 1, $tipoPg, false, false, $formaBaixa);
                    $parcelasHistorico = Parcela::parcelaHistoricoByContrato($contrato['id_contrato'], $_POST['dePagamento'], $_POST['atePagamento'], $tpParcelas, 1, $tipoPg, false, $formaBaixa);
                }
                $contrato['parcelas'] = array_merge($parcelasHistorico, $parcelas);

                if (count($contrato['parcelas']) == 0) {
                    unset($relatorio['contrato'][$key]);
                    continue;
                }

                foreach ($contrato['parcelas'] as $kParcela => &$parc) {

                    //Calcula o valor total pago novamente, pois em alguns clientes estava ocorrendo o problema de em algumas parcelas vir com 1 ou dois centavos de diferena.
                    $contrato['parcelas'][$kParcela]['vl_total_pago'] = number_format($contrato['parcelas'][$kParcela]['vl_total_pago'], 2, '.', '');;
                    //testa se foi selecionado algum banco ou se esta sendo selecionado "todos"
                    if ($_POST['banco'] != '*') {
                        if($parc['id_banco'] != $_POST['banco']){
                            unset($contrato['parcelas'][$kParcela]);
                            continue;
                        }
                    }

                    if ($parc['fm_baixa']) {
                        $tipoPagamento = $tbAgrupada->fetchRow("idTabela = '28' AND idCampo = '{$parc['fm_baixa']}'")->toArray();
                        $totalFormaBaixa[$tipoPagamento['descricao']]['total'] += $parc['vl_total_pago'];
                        $totalFormaBaixa[$tipoPagamento['descricao']]['prefixo'] = $parc['fm_baixa'];
                    }

                    $parcela_valor += $parc['vl_parcela'];
                    $total_valor += $parc['vl_total_pago'];
                    $parcela_quantidade++;

                    //Teste para parcelas negociadas e quitacao (adicionar o numero da negociacao e a quantidade de parcelas de quitacao
                    switch ($parc['tp_parcela']) {
                        case 'G' :
                            $parc['nr_negociacao'] = Negociacao::getNumeroParcelasById($parc['id_negociacao']);
                            break;
                        case 'Q' :
                            $parcela_quitacao_quantidade_contrato++;
                            break;
                    }

                    if ($parc['tp_baixa'] != 'O') {
                        $valorPorcAdmin += $parc['vl_total_pago'];
                    }
                    
                    $idsNegociacao = null;
                    $idsRenegociacao = null;
                    foreach ($contrato['parcelas'] as $parcela) {
                        if ($parcela['id_negociacao']) {
                            $idsNegociacao[] = $parcela['id_negociacao'];
                        }

                        if ($parcela['id_renegociacao']) {
                            $idsRenegociacao[] = $parcela['id_renegociacao'];
                        }
                    }

                    if ($idsNegociacao != null) {
                        $idsNegociacao = implode('","', $idsNegociacao);
                    }

                    if ($idsRenegociacao != null) {
                        $idsRenegociacao = implode('","', $idsRenegociacao);
                    }

                    $qtdGeralParc = (new Parcela())->getQtdeParcelas($contrato['id_contrato'], $idsNegociacao, $idsRenegociacao);

                    switch ($parc['tp_parcela']) {
                        case 'S':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $contrato['nr_parcela_sinal'] . '-' . $parc['tp_parcela'];
                            break;
                        case 'I':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $contrato['nr_intercalada'] . '-' . $parc['tp_parcela'];
                            break;
                        case 'G':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $parc['nr_negociacao'] . '-' . $parc['tp_parcela'];
                            break;
                        case 'C':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $contrato['nr_parcela_entrega'] . '-' . $parc['tp_parcela'];
                            break;
                        case 'Q':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $qtdGeralParc['QtdeQuitadas'] . '-' . $parc['tp_parcela'];
                            break;
                        case 'A':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $qtdGeralParc['QtdeAvulsas'] . '-' . $parc['tp_parcela'];
                            break;
                        case 'N':
                            if ($parc['nr_tipo_parcela']) {
                                $parc['qtdeParcelas'] = $parc['nr_tipo_parcela'];
                            } else {
                                $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $qtdGeralParc['QtdeNormal'] . '-' . $parc['tp_parcela'];
                            }
                            break;
                        case 'E':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $parc['id_parcela'] . '-' . $parc['tp_parcela'];
                            break;
                        case 'NE':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $parc['id_parcela'] . '-' . $parc['tp_parcela'];
                            break;
                        case 'SE':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $parc['id_parcela'] . '-' . $parc['tp_parcela'];
                            break;
                        case 'IE':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $parc['id_parcela'] . '-' . $parc['tp_parcela'];
                            break;
                        case 'CE':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $parc['id_parcela'] . '-' . $parc['tp_parcela'];
                            break;
                    }

                    //Calculo do valor por tipo de parcela
                    $totalParcelas[$parc['tp_parcela']]['valor'] += $parc['vl_parcela'];
                    $totalParcelas[$parc['tp_parcela']]['qtd']++;

                    //calcula o valor do juros
                    $juros = (float)$parc['vl_total_pago'] - (float)$parc['vl_parcela'];
                    $juros = $juros - (float)$parc['vl_multa'] - (float)$parc['desconto'];

                    $juros = round($juros, 2);
                    //caso o juros sej maior que 0 o mesmo recebe o novo valor calculado.
                    if ($parc['vl_juros'] > 0 && $juros > 0) {
                        $parc['vl_juros'] = $juros;
                    }
                    
                    //Calculo do saldo da parcela
                    $parc['saldo'] = (float)$parc['vl_total_pago'] - ((float)$parc['vl_parcela'] + (float)$parc['vl_multa'] + (float)$parc['vl_juros'] - (float)$parc['desconto']);

                    $vlTotalDesconto += $parc['desconto'];
                    $vlTotalMulta += $parc['vl_multa'];
                    $vlTotalJuros += $parc['vl_juros'];

                    if ($parc['tp_parcela'] == 'S'&&(int)$contrato['nr_parcela_sinal']){
                        $getVlContrato += Contrato::getVlContrato($contrato['id_contrato']);
                    }
                    /**
                     * Cria um array para cada parcela para que possa ser exibido separado as parcelas do contrato,
                     * e necessario copiar o objeto do tipo array para evitar altera-lo na memoria.
                     */
                    if ($_POST['ordem'] == 'C') {
                        if (is_array($relatorio['contrato'][$key])) {
                            $contratoCred = new ArrayObject($contrato);
                            $contratoCred['parcelas'] = array();
                            $contratoCred['parcelas'][0] = new ArrayObject($parc);
                            array_push($contratosCredito, $contratoCred);
                        }
                    }

                    if ($_POST['ordem'] == 'PG') {
                        if (is_array($relatorio['contrato'][$key])) {
                            $contratoCred = new ArrayObject($contrato);
                            $contratoCred['parcelas'] = array();
                            $contratoCred['parcelas'][0] = new ArrayObject($parc);
                            array_push($contratosCredito, $contratoCred);
                        }
                    }
                    
                }
                // Quantidade total de parcelas do contrato
                $contrato['total']['quitacao'] = $parcela_quitacao_quantidade_contrato;
            }
            //Calculo dos totais para cada parceiro
            $auxParceria = array();
            foreach ($parcerias as $parceiro) {
                $valorComissao = 0;

                //Teste para calculo das comissoes referentes a cada tipo
                switch ($parceiro['tp_comissao']) {
                    case 'PL' :
                        $valorComissao = $getVlContrato * ((float)$parceiro['pc_comissao'] /100);
                        break;
                    case 'P' :
                        if ($parceiro['fl_parcela_normal'] == '1')
                            $valorComissao += $totalParcelas['N']['valor'] * ($parceiro['pc_comissao'] / 100);
                        if ($parceiro['fl_parcela_sinal'] == '1')
                            $valorComissao += $totalParcelas['S']['valor'] * ($parceiro['pc_comissao'] / 100);
                        if ($parceiro['fl_parcela_intercalada'] == '1')
                            $valorComissao += $totalParcelas['I']['valor'] * ($parceiro['pc_comissao'] / 100);
                        if ($parceiro['fl_parcela_chave'] == '1')
                            $valorComissao += $totalParcelas['C']['valor'] * ($parceiro['pc_comissao'] / 100);
                        if ($parceiro['fl_parcela_negociada'] == '1')
                            $valorComissao += $totalParcelas['G']['valor'] * ($parceiro['pc_comissao'] / 100);
                        if ($parceiro['fl_parcela_quitacao'] == '1')
                            $valorComissao += $totalParcelas['Q']['valor'] * ($parceiro['pc_comissao'] / 100);
                        if ($parceiro['fl_parcela_avulsa'] == '1')
                            $valorComissao += $totalParcelas['A']['valor'] * ($parceiro['pc_comissao'] / 100);
                        break;
                    case 'F' :
                        if ($parceiro['fl_parcela_normal'] == '1')
                            $valorComissao += $totalParcelas['N']['qtd'] * $parceiro['pc_comissao'];
                        if ($parceiro['fl_parcela_sinal'] == '1')
                            $valorComissao += $totalParcelas['S']['qtd'] * $parceiro['pc_comissao'];
                        if ($parceiro['fl_parcela_intercalada'] == '1')
                            $valorComissao += $totalParcelas['I']['qtd'] * $parceiro['pc_comissao'];
                        if ($parceiro['fl_parcela_chave'] == '1')
                            $valorComissao += $totalParcelas['C']['qtd'] * $parceiro['pc_comissao'];
                        if ($parceiro['fl_parcela_negociada'] == '1')
                            $valorComissao += $totalParcelas['G']['qtd'] * $parceiro['pc_comissao'];
                        if ($parceiro['fl_parcela_quitacao'] == '1')
                            $valorComissao += $totalParcelas['Q']['qtd'] * $parceiro['pc_comissao'];
                        if ($parceiro['fl_parcela_avulsa'] == '1')
                            $valorComissao += $totalParcelas['A']['qtd'] * $parceiro['pc_comissao'];
                        break;
                }
                
                $parceiro['comissao'] = $valorComissao;
                $auxParceria[] = $parceiro;
            }
            $relatorio['parcerias'] = $auxParceria;
        }
        //Reordena os contratos aps a remoo dos que n]ao sero usados
        sort($relatorio['contrato']);      
        //ordena a lista de parcelas de acordo com a opcao selecionada com a funcao de ordenacao
        if ($_POST['ordem'] == 'P') {
            usort($relatorio['contrato'], function ($a, $b) {
                if ($a['nm_pessoa'] == $b['nm_pessoa']) {
                    return 0;
                }
                return ($a['nm_pessoa'] < $b['nm_pessoa']) ? -1 : 1;

            });
        }
        //Ordena pela data de credito ou por quadra caso selecionado utilizando o multisort
        if ($_POST['ordem'] == 'C') {
            foreach ($contratosCredito as $key => $row) {
                $credito[$key] = strtotime(Helper::dataParaAmericano($row['parcelas'][0]["dt_credito"]));
                $pagamento[$key] = strtotime(Helper::dataParaAmericano($row['parcelas'][0]["dt_pagamento"]));
            }
            array_multisort($credito, SORT_ASC, $pagamento, SORT_ASC, $contratosCredito);
            $relatorio['contrato'] = $contratosCredito;

        } elseif($_POST['ordem'] == 'PG') {
            foreach ($contratosCredito as $key => $row) {
                $credito[$key] = strtotime(Helper::dataParaAmericano($row['parcelas'][0]["dt_credito"]));
                $pagamento[$key] = strtotime(Helper::dataParaAmericano($row['parcelas'][0]["dt_pagamento"]));
            }
            array_multisort( $pagamento, SORT_ASC, $credito, SORT_ASC, $contratosCredito);
            $relatorio['contrato'] = $contratosCredito;
        } elseif ($_POST['ordem'] == 'Q') {
            foreach ($relatorio['contrato'] as $key => $row) {
                $quadra[$key] = $row['quadra'];
                $lote[$key] = $row['lote'];
            }
            array_multisort($quadra, SORT_ASC, $lote, SORT_ASC, $relatorio['contrato']);
        }
        $relatorio['total']['parcela'] = $parcela_quantidade;
        $relatorio['total']['desconto'] = $vlTotalDesconto;
        $relatorio['total']['multa'] = $vlTotalMulta;
        $relatorio['total']['juros'] = $vlTotalJuros;
        $relatorio['total']['valor'] = $parcela_valor;
        $relatorio['total']['total'] = $total_valor;
        if ($relatorio['empreendimento']['porcAdmin'] > 0) {
            $valor = (float)$relatorio['empreendimento']['porcAdmin'];
            $relatorio['total']['porcAdmin'] = $valorPorcAdmin * ($valor / 100);
        }
        $relatorio['todos'] = ($_POST['cliente_relatorio_parcela_paga'] == '*' && $_POST['quadra_relatorio_parcela_paga'] == '*') ? true : false;
        $relatorio['tipo'] = $_POST['tipo'] == 'PC' ? true : false;
        $relatorio['periodoPagamento'] = $_POST['dePagamento'] . " at " . $_POST['atePagamento'];
        $relatorio['periodoCredito'] = $_POST['deCredito'] . " at " . $_POST['ateCredito'];

        if ($_POST['totalizarBaixa'] == 'S'){
            $this->set('totalFormaBaixa', $totalFormaBaixa);
        }
        $this->set('visualizar', $_POST['visualizar']);
        $this->set('relatorio', $relatorio);
        //verifica se existem parcelas para nao exibir o relatorio em branco
        //Mensagem de Erros
        if ($parcela_quantidade == 0 && $this->isAjax()) {
            echo json_encode(array('msgErros' => utf8_encode('No exitem parcelas a serem exibidas!')));
            exit;
        } else {
            if ($this->isAjax()) {
                if ($_POST['visualizar'] != 'false'){
                    echo $this->display("relatorio");
                    exit;
                } else {
                    echo 'true';
                    exit;
                }
            }
        }
        
        if ($_POST['tipoRelatorio'] == 'pdf' && $_POST['visualizar'] == 'false') {
            $this->displayMPDF('Relatorio_' . time() . '.pdf');
        } elseif ($_POST['tipoRelatorio'] == 'xls' && $_POST['visualizar'] == 'false')  {
            //Utilizado for pois o foreach causa erro no excell
            for ($i = 0; $i < count($relatorio['contrato']); $i++) {
                for ($j = 0; $j < count($relatorio['contrato'][$i]['parcelas']); $j++) {
                    //Ordena as parcelas caso alguma tenha sido removida
                    sort($relatorio['contrato'][$i]['parcelas']);
                    if ($relatorio['tipo']) {
                        $colunas = [
                            'Cliente',
                            'CPF/CNPJ',
                            Helper::exibeAbreviacao(($relatorio['empreendimento']['ds_grupo'] != '') ? $relatorio['empreendimento']['ds_grupo']:''),
                            Helper::exibeAbreviacao(($relatorio['empreendimento']['ds_subgrupo'] != '') ? $relatorio['empreendimento']['ds_subgrupo']:''),
                            'Contrato',
                            'Baixa',
                            'Parcela',
                            'Vencto',
                            'Pagto',
                            'Crdito',
                            'Valor',
                            'Descto',
                            'Multa',
                            'Juros',
                            'Total',
                            'Tb',
                            'Saldo'
                        ];

                        $linhas[] = [
                            $relatorio['contrato'][$i]['nm_pessoa'],
                            $relatorio['contrato'][$i]['nr_cpf'] ? $relatorio['contrato'][$i]['nr_cpf'] : $relatorio['contrato'][$i]['nr_cnpj'],
                            $relatorio['contrato'][$i]['quadra'],
                            $relatorio['contrato'][$i]['lote'],
                            $relatorio['contrato'][$i]['id_contrato'],
                            $relatorio['contrato'][$i]['parcelas'][$j]['id_parcela_contrato'],
                            $relatorio['contrato'][$i]['parcelas'][$j]['qtdeParcelas'],
                            Helper::getDate($relatorio['contrato'][$i]['parcelas'][$j]['dt_parcela']),
                            Helper::getDate($relatorio['contrato'][$i]['parcelas'][$j]['dt_pagamento']),
                            Helper::getDate($relatorio['contrato'][$i]['parcelas'][$j]['dt_credito']),
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['vl_parcela']),
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['desconto']),
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['vl_multa']),
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['vl_juros']),
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['vl_total_pago']),
                            $relatorio['contrato'][$i]['parcelas'][$j]['tp_baixa'],
                            $relatorio['contrato'][$i]['parcelas'][$j]['fm_baixa'],
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['saldo'])
                        ];
                    } else {

                        $colunas = [
                            'Cliente',
                            Helper::exibeAbreviacao(($relatorio['empreendimento']['ds_grupo'] != '') ? $relatorio['empreendimento']['ds_grupo']:''),
                            Helper::exibeAbreviacao(($relatorio['empreendimento']['ds_subgrupo'] != '') ? $relatorio['empreendimento']['ds_subgrupo']:''),
                            'Contrato',
                            'Parcela',
                            'Vencto',
                            'Pagto',
                            'Crdito',
                            'Valor',
                            'Multa',
                            'Juros',
                            'Total',
                            'Tb'
                        ];

                        $linhas[] = [
                            $relatorio['contrato'][$i]['nm_pessoa'],
                            $relatorio['contrato'][$i]['quadra'],
                            $relatorio['contrato'][$i]['lote'],
                            $relatorio['contrato'][$i]['id_contrato'],
                            $relatorio['contrato'][$i]['parcelas'][$j]['qtdeParcelas'],
                            Helper::getDate($relatorio['contrato'][$i]['parcelas'][$j]['dt_parcela']),
                            Helper::getDate($relatorio['contrato'][$i]['parcelas'][$j]['dt_pagamento']),
                            Helper::getDate($relatorio['contrato'][$i]['parcelas'][$j]['dt_credito']),
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['vl_parcela']),
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['vl_multa']),
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['vl_juros']),
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['vl_total_pago']),
                            $relatorio['contrato'][$i]['parcelas'][$j]['tp_baixa']
                        ];
                    }
                }
            }

            $this->geraExcel($colunas, $linhas);

        } else {
            $this->display("relatorio");
        }
    }

    public function validarAction()
    {
        //validacao para evitar campos vazios
        $campos = array("empreendimento_relatorio_parcela_paga", "cliente_relatorio_parcela_paga","quadra_relatorio_parcela_paga");
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "" ||  $_POST[$cp] == null){
                switch ($cp) {
                    case "empreendimento_relatorio_parcela_paga" :
                        $msg = "O campo Empreendimento  obrigatrio.";
                        break;
                    case "cliente_relatorio_parcela_paga" :
                        $msg = "O campo Cliente  obrigatrio.";
                        break;
                    case "quadra_relatorio_parcela_paga" :
                        $msg = "O campo Quadra/Lote  obrigatrio.";
                        break;

                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }
        if (count($_POST['tp_pagamento']) == 0)
            $this->_helper->addMensagem('tp_pagamento', 'Selecione pelo menos um tipo de pagamento.');

        if (count($_POST['tp_parcela']) == 0)
            $this->_helper->addMensagem('tp_parcela', 'Selecione pelo menos um tipo de parcela.');

        if ($_POST['tipoRelatorio'] == 'pdf' || $_POST['tipoRelatorio'] == 'xls')
        {//Testa as datas de pagamento e de credito
            if ($_POST['dePagamento'] == '' || $_POST['atePagamento'] == '') {
                if ($_POST['deCredito'] == '' || $_POST['ateCredito'] == '') {
                    $msg = 'Ao menos um perodo deve ser preenchido.';
                    $this->_helper->addMensagem('data', $msg);
                } elseif ((strtotime(Helper::getInputDate($_POST['deCredito']) . '+4 month') <= strtotime(Helper::getInputDate($_POST['ateCredito'])) && $_POST['cliente_relatorio_parcela_paga'] == '*') && ($_POST['tipoRelatorio'] != 'xls')) {
                    $msg = 'O perodo precisa ser de no mximo 120 dias.';
                    $this->_helper->addMensagem('data', $msg);
                }
            } elseif ($_POST['deCredito'] == '' || $_POST['ateCredito'] == '') {
                if ($_POST['dePagamento'] == '' || $_POST['atePagamento'] == '') {
                    $msg = 'Ao menos um perodo deve ser preenchido.';
                    $this->_helper->addMensagem('data', $msg);
                } elseif ((strtotime(Helper::getInputDate($_POST['dePagamento']) . '+4 month') <= strtotime(Helper::getInputDate($_POST['atePagamento'])) && $_POST['cliente_relatorio_parcela_paga'] == '*') && ($_POST['tipoRelatorio'] != 'xls')) {
                    $msg = 'O perodo precisa ser de no mximo 120 dias.';
                    $this->_helper->addMensagem('data', $msg);
                }
            } elseif ((strtotime(Helper::getInputDate($_POST['dePagamento']) . '+4 month') <= strtotime(Helper::getInputDate($_POST['atePagamento'])) && $_POST['cliente_relatorio_parcela_paga'] == '*') && ($_POST['tipoRelatorio'] != 'xls')) {
                $msg = 'O perodo precisa ser de no mximo 120 dias.';
                $this->_helper->addMensagem('data', $msg);
            } elseif ((strtotime(Helper::getInputDate($_POST['deCredito']) . '+4 month') <= strtotime(Helper::getInputDate($_POST['deCredito'])) && $_POST['cliente_relatorio_parcela_paga'] == '*') && ($_POST['tipoRelatorio'] != 'xls')) {
                $msg = 'O perodo precisa ser de no mximo 120 dias.';
                $this->_helper->addMensagem('data', $msg);
            }
        }
        
        //Mensagem de Erros
        if (count($this->_helper->getMensagens()) > 0)  {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            return !(count($this->_helper->getMensagens()) > 0);
        }
    }

    public function clienteParcelasPagasAction()
    {
        $id_empreendimento = $_POST['id_empreendimento'];
        $instanceLote = new Lote();
        $selectLotes = $instanceLote->getDefaultAdapter()->select();
        $clientes = $selectLotes->from(array('l' => TB_LOTES), array('id_lote' => 'id', 'id_empreendimento','quadra','lote'))
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'id_pessoa'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa', 'id'))
            ->where('l.id_empreendimento = ?', $id_empreendimento)
            ->order('p.nm_pessoa')
            ->group('p.id')
            ->query()->fetchAll();

        $lista[] = array('id'=>'','text'=>'');
        $lista[] = array('id'=>'*','text'=>'Todos');
        foreach ($clientes as $cliente) {
            $lista[] = array(
                'id' => $cliente['id'],
                'text' => utf8_encode($cliente['nm_pessoa']),
            );
        }
        echo json_encode($lista);
    }

    public function loteByEmpreendimentoAction()
    {
        $instanceLote = new Lote();
        $selectLotes = $instanceLote->getDefaultAdapter()->select();
        $lotes = $selectLotes->from(array('l' => TB_LOTES), array('id_lote' => 'id', 'id_empreendimento', 'quadra', 'lote'))
            ->where('l.id_empreendimento = ?', $_POST["id_empreendimento"])
            ->order(array('l.quadra', 'l.lote'))->query()->fetchAll();

        $lista[] = array('id'=>'','text'=>'');
        $lista[] = array('id'=>'*','text'=>'Todos');
        foreach ($lotes as $lote) {
            $lista[] = array(
                'id' => $lote['id_lote'],
                'text' => ' Quadra: ' . utf8_encode($lote['quadra']) . ' - Lote: ' . utf8_encode($lote['lote']),
            );
        }
        echo json_encode($lista);
    }

    public function bancoByEmpreendimentosAction()
    {
        $bancos = new Banco();
        $bancos = $bancos->fetchAll($bancos->select()->where('id_empreendimento = '.$_POST['id_empreendimento']))->toArray();
        $lista[] = array('id'=>'','text'=>'');
        $lista[] = array('id'=>'*','text'=>'Todos');
        foreach ($bancos as &$banco) {
            $banco['nmBanco'] = Banco::findBancoNome($banco['cd_banco']);
            $lista[] = array(
                'id' => $banco['id'],
                'text' => utf8_encode($banco['nmBanco']) . ' - Ag: ' . $banco['agencia'] . ' - ' . $banco['agencia_dv'] . ' - Conta' .$banco['conta_corrente'] .' -' . $banco['conta_corrente_dv'],
            );
        }
        echo json_encode($lista);
    }
}