<?php

class RelatorioIRController extends Controller
{
    public function indexAction()
    {
        $this->set("subtitulo", "Relatrio de Imposto de Renda");
        $this->set('nomeTela', "Relatrio de Imposto de Renda");

        $instanceEmpreendimento = new Empreendimento();
        $empreendimento = $instanceEmpreendimento->getDefaultAdapter();

        $empreendimento = $empreendimento->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('id_empreendimento' => 'id', 'nm_empreendimento'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimento = $empreendimento->group('e.id')->order('nm_empreendimento')->query()->fetchAll();

        $this->set('empreendimentos', $empreendimento);

        $this->display("index");
    }

    public function relatorioAction()
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());
        ini_set('memory_limit', '3000M');
        set_time_limit(0);

        if ($this->validarAction()) {
            /*
             * Executa o relatrio de Imposto de renda caso os campos sejam validados.
             */
            $this->relatorio();
        }
    }

    public function relatorio()
    {
        $tpParcelas = array();
        
        if (count($_POST['tp_parcela'])) {
            foreach ($_POST['tp_parcela'] as $tipo) {
                if ($tipo == 'G' || $tipo == 'Q') {
                    $tpParcelas[] = '"' . $tipo . '"';
                } else {
                    $tpParcelas[] = '"' . $tipo . '", "' . $tipo . 'E"';
                }
            }
            $tpParcelas = '(' . implode(',', $tpParcelas) . ')';
        }

        if (count($_POST['tp_pagamento'])) {
            foreach ($_POST['tp_pagamento'] as $tipo) {
                $tipoPg[] = '"' . $tipo . '"';
            }
        }

        $tipoPg = '(' . implode(',', $tipoPg) . ')';

        $instanceEmpreendimento = new Empreendimento();

        $relatorio['empreendimento'] = $instanceEmpreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.rgi', 'e.id', 'e.porcAdmin', 'e.ds_path_logo'))
            ->join(array('c' => Db_Cidade::TABLE_NAME), 'e.cd_cidade = c.id', array('cidade_nome' => 'c.nome', 'cidade_uf' => 'c.uf'))
            ->where('e.id = ?', $_POST['empreendimento_relatorio_imposto'])->query()->fetch();

        $empresaResp = Empreendimento::getPessoaJuridica($_POST['empreendimento_relatorio_imposto']);

        $relatorio['empreendimento']['nm_empresa'] = $empresaResp['nm_pessoa'];
        $relatorio['empreendimento']['cnpj'] = $empresaResp['nr_cnpj'] ? $empresaResp['nr_cnpj'] : $empresaResp['nr_cpf'];
        $relatorio['empreendimento']['tp_pessoa'] = $empresaResp['tp_pessoa'];
        
        $instanceContrato = new Contrato();
        $contratos = $instanceContrato->getAdapter()->select()
            ->from(array('c' => TB_CONTRATO), array('id_contrato' => 'c.id', 'id_lote' => 'c.id_lote', 'nr_parcela',
                'nr_parcela_sinal', 'nr_intercalada', 'nr_parcela_entrega', 'porcentagem_participacao_contrato'))
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('l.quadra', 'l.lote'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('p.nm_pessoa', 'p.endereco', 'p.nm_bairro', 'id_pessoa' => 'p.id'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', array('nr_cpf'))
            // ->joinLeft(array('tr' => TB_TRANSFERENCIA), "c.id = tr.idContrato AND YEAR(data) = {$_POST['ano']} AND 
            //                             (idCedente = {$_POST['cliente_relatorio_imposto']} OR idReceptor = {$_POST['cliente_relatorio_imposto']})", array('dataRecepcao' => 'data'))
            ->joinLeft(array('tr' => TB_TRANSFERENCIA), "c.id = tr.idContrato AND 
                (idCedente = {$_POST['cliente_relatorio_imposto']} OR idReceptor = {$_POST['cliente_relatorio_imposto']})", array('dataRecepcao' => 'data'))
            ->where('p.id = ?', $_POST['cliente_relatorio_imposto']);

            if ($_POST['tpCliente'] == 'A') {
                $contratos = $contratos->where('c.fl_distrato = "0"');
            } elseif ($_POST['tpCliente'] == 'I') {
                $contratos = $contratos->where('c.fl_distrato = "1"');
            }

        $relatorio['contrato'] = $contratos->where('l.id_empreendimento = ?', $relatorio['empreendimento']['id'])
            ->order(array('p.nm_pessoa', 'l.lote', 'l.quadra'))
            ->group('id_contrato')
            ->query()->fetchAll();
        
        foreach ($relatorio['contrato'] as $contrato) {
            if ($contrato['porcentagem_participacao_contrato']) {
                $contratoOutrosCompradores[] = $contrato['id_contrato'];
            }
        }

        $outrosCompradores = $this->buscaOutrosCompradores($_POST['cliente_relatorio_imposto']);
        
        if ($outrosCompradores) {
            $relatorio['contrato'] = array_merge($relatorio['contrato'], $outrosCompradores);
        }

        $empreendimentoInfo = $instanceEmpreendimento->getAdapter()->select()->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento'))
            ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
            ->where('id = ?', $relatorio['empreendimento']['id'])
            ->query()->fetch();
        $this->set("empreendimentoInfo", $empreendimentoInfo);

        $transferencias = Transferencia::getDefaultAdapter()->select()
            ->from(array('t' => TB_TRANSFERENCIA), array('id_contrato' => 'idContrato', 'data', 'idCedente', 'idReceptor', 'id'))
            ->where('t.idCedente = ' . $_POST['cliente_relatorio_imposto'])
            ->group('id_contrato')
            ->query()->fetchAll();

        if (count($transferencias) > 0) {
            foreach ($transferencias as $t) {
                $porcentagemParticipacaoCedentes = TransferenciaCedentes::getDefaultAdapter()->select()
                    ->from(array('tc' => TB_TRANSFERENCIA_CEDENTES), 'porcentagem_participacao_contrato')
                    ->where('tc.id_transferencia = ' . $t['id'])
                    ->query()->fetchAll();

                $porcentagem = 0;

                foreach ($porcentagemParticipacaoCedentes as $p) {
                    $porcentagem += $p['porcentagem_participacao_contrato'];
                }

                $contratoTransf = Contrato::findContratoByIdRelatorio($t['id_contrato']);
                $contratoTransf['dataCedimento'] = $t['data'];
                //Coloca o nome da pessoa
                $contratoTransf['id_pessoa'] = $_POST['cliente_relatorio_imposto'];
                $pessoaTransf = Pessoa::findById($contratoTransf['id_pessoa']);
                $contratoTransf['nm_pessoa'] = $pessoaTransf['nm_pessoa'];
                $contratoTransf['nr_cpf'] = $pessoaTransf['nr_cpf'] ? $pessoaTransf['nr_cpf'] : $pessoaTransf['nr_cnpj'];
                $contratoTransf['porcentagem_participacao_contrato'] = 100.00 - $porcentagem;

                $relatorio['contrato'][] = $contratoTransf;
            }
        }

        if (!$transferencias) {
            $transferenciasCedentes = TransferenciaCedentes::getDefaultAdapter()->select()
                ->from(array('tc' => TB_TRANSFERENCIA_CEDENTES), array('id_transferencia', 'id_pessoa', 'porcentagem_participacao_contrato'))
                ->join(['t' => TB_TRANSFERENCIA], 'tc.id_transferencia = t.id', ['id_contrato' => 'idContrato', 'data'])
                ->where('tc.id_pessoa = ' . $_POST['cliente_relatorio_imposto'])
                ->group('id_contrato')
                ->query()->fetchAll();

            if (count($transferenciasCedentes) > 0) {
                foreach ($transferenciasCedentes as $t) {
                    $contratoTransf = Contrato::findContratoByIdRelatorio($t['id_contrato']);
                    //Coloca o nome da pessoa
                    $contratoTransf['id_pessoa'] = $_POST['cliente_relatorio_imposto'];
                    $pessoaTransf = Pessoa::findById($contratoTransf['id_pessoa']);
                    $contratoTransf['nm_pessoa'] = $pessoaTransf['nm_pessoa'];
                    $contratoTransf['nr_cpf'] = $pessoaTransf['nr_cpf'] ? $pessoaTransf['nr_cpf'] : $pessoaTransf['nr_cnpj'];
                    $contratoTransf['porcentagem_participacao_contrato'] = $t['porcentagem_participacao_contrato'];
    
                    $relatorio['contrato'][] = $contratoTransf;
                }
            }
        }

        $parcela_quantidade = 0;
        $parcela_normal_quantidade = 0;
        $parcela_sinal_quantidade = 0;
        $parcela_intercalada_quantidade = 0;
        $parcela_negociada_quantidade = 0;
        $parcela_quitacao_quantidade = 0;
        $parcela_entrega_quantidade = 0;
        $parcela_valor = 0;
        $total_valor = 0;
        $valorPorcAdmin = 0;
        $count = count($relatorio['contrato']);
        
        if ($count) {
            $vlTotalDesconto = 0;
            $vlTotalMulta = 0;
            $vlTotalJuros = 0;
            
            //percorre todos os contratos da pessoa selecionada
            foreach ($relatorio['contrato'] as $key => &$contrato) {
                //Periodo de um ano selecionado
                $de = '01/01/' . $_POST['ano'];
                $ate = '31/12/' . $_POST['ano'];
                
                $parcela_quitacao_quantidade_contrato = 0;

                if (isset($contrato['dataCedimento'])) {
                    if (Helper::getInputDate($ate) > $contrato['dataCedimento']) {
                        $ate = Helper::getDate($contrato['dataCedimento']);
                    }
                }
                
                if (isset($contrato['dataRecepcao'])) {
                    if (Helper::getInputDate($de) < $contrato['dataRecepcao']) {
                        $de = Helper::getDate($contrato['dataRecepcao']);
                    }
                }
                
                //Caso o ano da data que consta na transferencia for diferente da informada no formulrio o sistema pula para o prximo contrato.
                if (date('Y', strtotime(Helper::dataParaAmericano($de))) != $_POST['ano'] || date('Y', strtotime(Helper::dataParaAmericano($ate))) != $_POST['ano'])
                {
                    unset($relatorio['contrato'][$key]);
                    continue;
                }
                
                $datas = Transferencia::buscaDatasTransferencias($_POST['cliente_relatorio_imposto'], $contrato['id_contrato'], $_POST['ano']);
                
                if (count($datas) > 1)
                {
                    $de = Helper::getDate($datas[0]['data']);
                    $ate = Helper::getDate($datas[count($datas) - 1]['data']);
                }

                //Busca todas as parcelas do contrato de acordo com os parametros
                $parcelas = Parcela::parcelaByContrato($contrato['id_contrato'], $de, $ate, $tpParcelas, 1, $tipoPg);
                $parcelasHistorico = Parcela::parcelaHistoricoByContrato($contrato['id_contrato'], $de, $ate, $tpParcelas, 1, $tipoPg);
                $contrato['parcelas'] = array_merge($parcelasHistorico, $parcelas);

                if (count($contrato['parcelas']) == 0) {
                    unset($relatorio['contrato'][$key]);
                    continue;
                }

                foreach ($contrato['parcelas'] as $k => &$parc) {
                    if ($contrato['dataCedimento'] == $parc['dt_pagamento']) {
                        unset($contrato['parcelas'][$k]);
                        continue;
                    }

                    if ($contrato['porcentagem_participacao_contrato']) {
                        $parc['vl_parcela'] = ($parc['vl_parcela'] / 100) * $contrato['porcentagem_participacao_contrato'];
                        $parc['vl_total_pago'] = ($parc['vl_total_pago'] / 100) * $contrato['porcentagem_participacao_contrato'];
                    }

                    $parcela_valor += $parc['vl_parcela'];
                    $total_valor += $parc['vl_total_pago'];
                    $parcela_quantidade++;
                    switch ($parc['tp_parcela']) {
                        case 'N' :
                            $parcela_normal_quantidade++;
                            break;
                        case 'S' :
                            $parcela_sinal_quantidade++;
                            break;
                        case 'C' :
                            $parcela_entrega_quantidade++;
                            break;
                        case 'I' :
                            $parcela_intercalada_quantidade++;
                            break;
                        case 'G' :
                            $parcela_negociada_quantidade++;
                            $parc['nr_negociacao'] = Negociacao::getNumeroParcelasById($parc['id_negociacao']);
                            break;
                        case 'Q' :
                            $parcela_quitacao_quantidade++;
                            $parcela_quitacao_quantidade_contrato++;
                            break;
                    }
                    if ($parc['tp_baixa'] != 'O') {
                        $valorPorcAdmin += $parc['vl_total_pago'];
                    }

                    $vlTotalDesconto += $parc['desconto'];
                    $vlTotalMulta += $parc['vl_multa'];
                    $vlTotalJuros += $parc['vl_juros'];
                }

                // Quantidade total de parcelas do tipo quitacao do contrato (unico meio de se contabilizar)
                $contrato['total']['quitacao'] = $parcela_quitacao_quantidade_contrato;

            }
        }
        //verifica se existem parcelas para no exibir o relatrio em branco
        if ($parcela_quantidade == 0 && $this->isAjax()) {
            echo json_encode(array('msgErros' => utf8_encode('No exitem parcelas a serem exibidas!')));
            exit;
        } else {
            if ($this->isAjax()) {
                echo 'true';
                exit;
            }
        }


        $relatorio['total']['parcela'] = $parcela_quantidade;
        $relatorio['total']['parcela_normal'] = $parcela_normal_quantidade;
        $relatorio['total']['parcela_sinal'] = $parcela_sinal_quantidade;
        $relatorio['total']['parcela_intercalada'] = $parcela_intercalada_quantidade;
        $relatorio['total']['parcela_negociada'] = $parcela_negociada_quantidade;
        $relatorio['total']['desconto'] = $vlTotalDesconto;
        $relatorio['total']['multa'] = $vlTotalMulta;
        $relatorio['total']['juros'] = $vlTotalJuros;
        $relatorio['total']['valor'] = $parcela_valor;
        $relatorio['total']['total'] = $total_valor;

        if ($relatorio['empreendimento']['porcAdmin'] > 0) {
            $valor = (float)$relatorio['empreendimento']['porcAdmin'];
            $relatorio['total']['porcAdmin'] = $valorPorcAdmin * ($valor / 100);
        }

        $relatorio['periodo'] = $_POST['ano'];

        $this->set('relatorio', $relatorio);

        $this->display("relatorio");
        $this->displayMPDF('Relatorio_' . time() . '.pdf');
    }

    public function relatorioByImpostoAction() {
        
        $id_empreendimento = $_POST['id_empreendimento'];
        $instanceLote = new Lote();
        $selectLotes = $instanceLote->getDefaultAdapter()->select();
        
        $clientes = $selectLotes->from(array('l' => TB_LOTES), array('id_lote' => 'id', 'id_empreendimento'))
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('idContrato' => 'id', 'id_pessoa'));
        
        if ($_POST['tpCliente'] == 'A') {    
            $clientes = $clientes->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa', 'id'))
                ->joinLeft(['pf' => TB_PESSOA_FISICA], 'p.id = pf.id_pessoa', 'nr_cpf')
                ->joinLeft(['pj' => TB_PESSOA_JURIDICA], 'p.id = pj.id_pessoa', 'nr_cnpj')
                ->where('c.fl_distrato = "0"')
                ->where('l.id_empreendimento = ?', $id_empreendimento)->order('p.nm_pessoa')->group('p.id');
        } elseif ($_POST['tpCliente'] == 'I') {
            $clientes = $clientes->joinLeft(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa', 'id'))
                ->joinLeft(['pf' => TB_PESSOA_FISICA], 'p.id = pf.id_pessoa', 'nr_cpf')
                ->joinLeft(['pj' => TB_PESSOA_JURIDICA], 'p.id = pj.id_pessoa', 'nr_cnpj')
                ->where('c.fl_distrato = "1"')
                ->where('l.id_empreendimento = ?', $id_empreendimento)->order('p.nm_pessoa')->group('p.id');
        } else {
            $clientes = $clientes->joinLeft(array('t' => TB_TRANSFERENCIA), 'c.id = t.idContrato')
                ->joinLeft(array('p' => TB_PESSOA), 't.idCedente = p.id', array('nm_pessoa', 'id'))
                ->joinLeft(['pf' => TB_PESSOA_FISICA], 'p.id = pf.id_pessoa', 'nr_cpf')
                ->joinLeft(['pj' => TB_PESSOA_JURIDICA], 'p.id = pj.id_pessoa', 'nr_cnpj')
                ->joinLeft(['tc' => TB_TRANSFERENCIA_CEDENTES], 't.id = tc.id_transferencia')
                ->joinLeft(array('p2' => TB_PESSOA), 'tc.id_pessoa = p2.id', array('nmOutroComprador' => 'nm_pessoa', 'idOutroComprador' => 'id'))
                ->joinLeft(['pf2' => TB_PESSOA_FISICA], 'p2.id = pf2.id_pessoa', ['nrCpfOutroComprador' => 'nr_cpf'])
                ->joinLeft(['pj2' => TB_PESSOA_JURIDICA], 'p.id = pj2.id_pessoa', ['nrCnpjOutroComprador' => 'nr_cnpj'])
                ->where('l.id_empreendimento = ?', $id_empreendimento)->order('p.nm_pessoa')->group(['p.nm_pessoa', 'p2.nm_pessoa']);
        }

        $clientes = $clientes->query()->fetchAll();
        
        $lista[] = array('id' => '', 'text' => '');

        foreach ($clientes as $cliente) {
            
            if ($cliente['id'] == null || $cliente['id'] == '') {
                continue;
            }

            if ($_POST['tpCliente'] == 'A') {
                $lista[] = array(
                    'id' => $cliente['id'],
                    'text' => utf8_encode($cliente['nm_pessoa']) . " (" . ($cliente['nr_cpf'] ? $cliente['nr_cpf'] : $cliente['nr_cnpj']) . ")"
    
                );
            } elseif ($_POST['tpCliente'] == 'I') {
                $lista[] = array(
                    'id' => $cliente['id'],
                    'text' => utf8_encode($cliente['nm_pessoa']) . " (" . ($cliente['nr_cpf'] ? $cliente['nr_cpf'] : $cliente['nr_cnpj']) . ")",
                    'estilo' => 'color:red'
                );      
            } else {
                $lista[] = array(
                    'id' => $cliente['id'],
                    'text' => utf8_encode($cliente['nm_pessoa']) . " (" . ($cliente['nr_cpf'] ? $cliente['nr_cpf'] : $cliente['nr_cnpj']) . ")"
                );
    
                if ($cliente['nmOutroComprador'])
                {
                    $lista[] = array(
                        'id' => $cliente['idOutroComprador'],
                        'text' => utf8_encode($cliente['nmOutroComprador']) . " (" . ($cliente['nrCpfOutroComprador'] ? $cliente['nrCpfOutroComprador'] : $cliente['nrCnpjOutroComprador']) . ")"
                    );  
                }
            }

            if ($cliente['idContrato']) {
                $contratos[]['id_contrato'] = $cliente['idContrato'];
            }
        }

        foreach ($contratos as $contrato) {
            $outrosCessionarios = (new Transferencia())->getDefaultAdapter()->select()
                ->from(['c' => TB_CONTRATO], '')
                ->joinLeft(['t' => TB_TRANSFERENCIA], 'c.id = t.idContrato', '')
                ->joinLeft(['tc' => TB_TRANSFERENCIA_CESSIONARIOS], 't.id = tc.id_transferencia', ['id_pessoa' => 'id_cessionario'])
                ->joinLeft(['cp' => TB_CONTRATO_PESSOA], 'c.id = cp.id_contrato')
                ->joinLeft(['p' => TB_PESSOA], 'tc.id_cessionario = p.id OR cp.id_pessoa = p.id', 'nm_pessoa')
                ->joinLeft(['pf' => TB_PESSOA_FISICA], 'p.id = pf.id_pessoa', 'nr_cpf')
                ->joinLeft(['pj' => TB_PESSOA_JURIDICA], 'p.id = pj.id_pessoa', 'nr_cnpj')
                ->where('c.id = ' . $contrato['id_contrato'])
                ->group('p.id')
                ->query()->fetchAll();
                
            foreach ($outrosCessionarios as $cessionario) {
                $listaOutrosCessionarios[] = array(
                    'id' => $cessionario['id_pessoa'],
                    'text' => utf8_encode($cessionario['nm_pessoa']) . " (" . ($cessionario['nr_cpf'] ? $cessionario['nr_cpf'] : $cessionario['nr_cnpj']) . ")"
    
                );
            }
        }

        if ($listaOutrosCessionarios) {
            $lista = array_merge($lista, $listaOutrosCessionarios);
        }
        
        echo json_encode($lista);
    }

    //Valida os campos do formulrio para gerar o relatrio
    public function validarAction()
    {
        //validao para evitar campos vazios
        $campos = array("empreendimento_relatorio_imposto", "cliente_relatorio_imposto");
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "empreendimento_relatorio_imposto" :
                        $msg = "O campo Empreendimento  obrigatrio.";
                        break;
                    case "cliente_relatorio_imposto" :
                        $msg = "O campo Cliente  obrigatrio.";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }
        if (count($_POST['tp_pagamento']) == 0)
            $this->_helper->addMensagem('tp_pagamento', 'Selecione pelo menos um tipo de pagamento.');

        if (count($_POST['tp_parcela']) == 0)
            $this->_helper->addMensagem('tp_parcela', 'Selecione pelo menos um tipo de parcela.');

        if ($_POST['ano'] == '') {
            $msg = 'O perodo  obrigatrio.';
            $this->_helper->addMensagem('data', $msg);
        }
        //Mensagem de Erros
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            return !(count($this->_helper->getMensagens()) > 0);
        }
    }

    public function buscaOutrosCompradores($idCliente)
    {
        $contratosOutrosCompradores = (new ContratoPessoa)->getDefaultAdapter()->select()
            ->from(['cp' => TB_CONTRATO_PESSOA], ['id_contrato'])
            ->where('cp.id_pessoa = ' . $idCliente)
            ->query()->fetchAll();

        foreach ($contratosOutrosCompradores as $outros) {
            $lista[] = $outros['id_contrato'];
        }
            
        $contratosOutrosCompradores = implode('","', $lista);
        
        $instanceContrato = new Contrato();

        $contratos = $instanceContrato->getAdapter()->select()
            ->from(array('c' => TB_CONTRATO), array('id_contrato' => 'c.id', 'id_lote' => 'c.id_lote', 'nr_parcela',
                'nr_parcela_sinal', 'nr_intercalada', 'nr_parcela_entrega'))
            ->join(['cp' => TB_CONTRATO_PESSOA], 'c.id = cp.id_contrato', ['porcentagem_participacao_contrato'])
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('l.quadra', 'l.lote'))
            ->join(array('p' => TB_PESSOA), 'cp.id_pessoa = p.id', array('p.nm_pessoa', 'p.endereco', 'p.nm_bairro', 'id_pessoa' => 'p.id'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', array('nr_cpf'))
            ->joinLeft(array('tr' => TB_TRANSFERENCIA), "c.id = tr.idContrato AND 
                (idCedente = {$idCliente} OR idReceptor = {$idCliente})", array('dataRecepcao' => 'data'))
            ->where('p.id = ?', $idCliente)
            ->where('c.id IN ("' . $contratosOutrosCompradores . '")')
            ->order(array('p.nm_pessoa', 'l.lote', 'l.quadra'))
            ->group('id_contrato')
            ->query()->fetchAll();

        return $contratos;
    }
} 