<?php

class RelatorioExtratoPriceController extends Controller
{
    public function indexAction()
    {
        $instanceEmpreendimento = new Empreendimento();
        $empreendimento = $instanceEmpreendimento->getDefaultAdapter();

        $empreendimento = $empreendimento->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('id_empreendimento' => 'id', 'nm_empreendimento'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {

            }
        }
        $empreendimento = $empreendimento->group('e.id')->order('nm_empreendimento')->query()->fetchAll();
        $this->set('empreendimentos', $empreendimento);
        $this->set('formaBaixa', (new TabelaAgrupada)->fetchAll('idTabela = "28"')->toArray());
        
        $this->display("index");
    }

    public function relatorioAction()
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        ini_set('memory_limit', '3000M');
        set_time_limit(0);
        if ($this->validarAction()) {
            /*
             * Executa o relatorio de nao pagas apos setar os parametros de execucao
              * Passa como parametro o tipo de relatorio (analitico ou sintetico)
              */
            $this->relatorioP();
        }
    }

    public function relatorioP()
    {
        $tpParcelas = array();
        if (count($_POST['tp_parcela'])) {
            foreach ($_POST['tp_parcela'] as $tipo) {
                if ($tipo == 'Q') {
                    $tpParcelas[] = '"' . $tipo . '"';
                }elseif($tipo == 'G'){
                    $tpParcelas[] = '"' . $tipo . '", "E"';
                } else {
                    $tpParcelas[] = '"' . $tipo . '", "' . $tipo . 'E"';
                }
            }
            $tpParcelas = '(' . implode(',', $tpParcelas) . ')';
        }

        if (count($_POST['tp_pagamento'])) {
            foreach ($_POST['tp_pagamento'] as $tipo) {
                $tipoPg[] = '"' . $tipo . '"';
            }
        }

        $tipoPg = '(' . implode(',', $tipoPg) . ')';

        if (count($_POST['formaBaixa'])) {
            $formaBaixa = implode('","', $_POST['formaBaixa']);
        }

        $instanceEmpreendimento = new Empreendimento();
        $relatorio['empreendimento'] = $instanceEmpreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.rgi', 'e.id', 'e.porcAdmin','ds_path_logo'))
            ->join(array('c' => Db_Cidade::TABLE_NAME), 'e.cd_cidade = c.id', array('cidade_nome' => 'c.nome', 'cidade_uf' => 'c.uf'))
            ->joinLeft(array('t' => TB_TIPO_LOTEAMENTO), 'e.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
            ->where('e.id = ?', $_POST['empreendimento_relatorio_parcela_paga'])->query()->fetch();

        $instanceContrato = new Contrato();
        $instanceContrato = $instanceContrato->getDefaultAdapter()->select()
            ->from(array('c' => TB_CONTRATO), array('id_contrato' => 'c.id', 'id_lote' => 'c.id_lote', 'nr_parcela',
                'nr_parcela_sinal', 'nr_intercalada', 'nr_parcela_entrega', 'dt_contrato', 'dt_reajuste', 'tx_juros', 'id_indice'))
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('l.quadra', 'l.lote'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('p.nm_pessoa', 'p.endereco', 'p.nm_bairro', 'id_pessoa' => 'p.id'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', 'nr_cpf')
            ->joinLeft(array("pj" => TB_PESSOA_JURIDICA), "p.id = pj.id_pessoa", 'nr_cnpj')
            ->join(array('i' => TB_INDICE_EMPREENDIMENTO), 'i.id_indice_empreendimento = c.id_indice', ['fl_periodo', 'fl_residuo', 'indice_adicional', 'fl_periodo_adc', 'id_indice as idIndice'])
            ->joinLeft(array('ag' => TB_AGRUPADA), 'i.id_indice = ag.idCampo and ag.idTabela = "12"', array('descricao'));

        //testa se foi selecionado algum contrato ou se esta sendo selecionado "todos"
        if ($_POST['cliente_relatorio_parcela_paga'] != '*') {
            $instanceContrato->where('p.id = ?', $_POST['cliente_relatorio_parcela_paga']);
        }

        if ($_POST['quadra_relatorio_parcela_paga'] != '*') {
            $instanceContrato->where('l.id = ?', $_POST['quadra_relatorio_parcela_paga']);
        }

        $relatorio['contrato'] = $instanceContrato->where('l.id_empreendimento = ?', $relatorio['empreendimento']['id'])
            ->order(array('p.nm_pessoa', 'l.lote', 'l.quadra'))
            ->query()->fetchAll();

        //Seta os valores do quadro resumo ao final do relatorio para acrescimos
        $parcela_quantidade = 0;
        $parcela_valor = 0;
        $total_valor = 0;
        $valorPorcAdmin = 0;
        $count = count($relatorio['contrato']);
        $getVlContrato= 0;
        if ($count) {

            $tbAgrupada = new TabelaAgrupada();

            $vlTotalDesconto = 0;
            $vlTotalMulta = 0;
            $vlTotalJuros = 0;
            $contratosCredito = array();

            //Dados para resumo de parcerias e valores das parcelas
            $totalParcelas = array(
                'N' => array('valor' => 0, 'qtd' => 0),
                'S' => array('valor' => 0, 'qtd' => 0),
                'I' => array('valor' => 0, 'qtd' => 0),
                'C' => array('valor' => 0, 'qtd' => 0),
                'Q' => array('valor' => 0, 'qtd' => 0),
                'G' => array('valor' => 0, 'qtd' => 0),
                'A' => array('valor' => 0, 'qtd' => 0),
            );
            $parcerias = ParceriaComissao::findByEmpreendimento($relatorio['empreendimento']['id']);

            //percorre todos os contratos selecionados
            foreach ($relatorio['contrato'] as $key => &$contrato) {
                $parcela_quitacao_quantidade_contrato = 0;
                
                if ($_POST['dePagamento'] && $_POST['deCredito']) {
                    //Busca todas as parcelas do contrato de acordo com os parametros utilizando a data de pagamento e de credito
                    $parcelas = Parcela::parcelaTodasByContrato($contrato['id_contrato'], $_POST['dePagamento'], $_POST['atePagamento'], $tpParcelas,
                    array('de' => $_POST['deCredito'], 'ate' => $_POST['ateCredito']), false, $formaBaixa);
                } elseif (!$_POST['dePagamento'] && $_POST['deCredito']) {
                    //Busca todas as parcelas do contrato de acordo com os parametros utilizando a data de credito
                    $parcelas = Parcela::parcelaByContrato($contrato['id_contrato'], $_POST['deCredito'], $_POST['ateCredito'], $tpParcelas, 1, $tipoPg, 'C', false, $formaBaixa);
                } else {
                    //Busca todas as parcelas do contrato de acordo com os parametros utilizando a data de pagamento
                    $parcelas = Parcela::parcelaTodasByContrato($contrato['id_contrato'], $_POST['dePagamento'], $_POST['atePagamento'], $tpParcelas);
                }

                foreach ($parcelas as &$parc) {
                    //Calculando o nmero de dias entre a data de Vencimento da Parcela e a data de pagamento.
                    if ($parc['tp_baixa'] == null && new DateTime(Helper::dataParaAmericano($parc['dt_parcela'])) > new DateTime(Helper::dataParaAmericano($_POST['correcao']))) {
                        $jurosdia = $contrato['tx_juros'] / 30;
                        $firstDate  = new DateTime(Helper::dataParaAmericano($_POST['correcao']));
                        $secondDate = new DateTime(Helper::dataParaAmericano($parc['dt_parcela']));
                        $intvl = $firstDate->diff($secondDate);
                        $nrdias = $intvl->days;
                        //Calculando o valor de desconto da Tabela PRICE
                        $vl_parcela = (float)$parc['vl_parcela'];
                        $vlrfinal = $vl_parcela/pow(1+($jurosdia/100),$nrdias);
                        $parc['amort'] = $vlrfinal;
                        $parc['jurosAmort'] = $vl_parcela - $vlrfinal;
                    }
                }

                foreach ($parcelas as &$parc) {
                    if ($parc['tp_baixa'] != null) {
                        $dataPagamento = new DateTime(Helper::dataParaAmericano($parc['dt_pagamento']));
                        $dataContrato = new DateTime(Helper::dataparaAmericano($contrato['dt_contrato']));
                        $intvlr = $dataContrato->diff($dataPagamento);
                        $nrdiasP = $intvlr->days;
                        $vl_parcela = (float)$parc['vl_parcela'];
                        $vlrFinalP = $vl_parcela/pow(1+($jurosdia/100),$nrdiasP);
                        $parc['amortP'] = $vlrFinalP;
                        $parc['jurosAmortP'] = $vl_parcela - $vlrFinalP;
                    }
                }

                $contrato['parcelas'] = array_merge($parcelas);

                if (count($contrato['parcelas']) == 0) {
                    unset($relatorio['contrato'][$key]);
                    continue;
                }

                foreach ($contrato['parcelas'] as $kParcela => &$parc) {

                    //Calcula o valor total pago novamente, pois em alguns clientes estava ocorrendo o problema de em algumas parcelas vir com 1 ou dois centavos de diferena.
                    $contrato['parcelas'][$kParcela]['vl_total_pago'] = number_format($contrato['parcelas'][$kParcela]['vl_total_pago'], 2, '.', '');;

                    if ($parc['fm_baixa']) {
                        $tipoPagamento = $tbAgrupada->fetchRow("idTabela = '28' AND idCampo = '{$parc['fm_baixa']}'")->toArray();
                        $totalFormaBaixa[$tipoPagamento['descricao']]['total'] += $parc['vl_total_pago'];
                        $totalFormaBaixa[$tipoPagamento['descricao']]['prefixo'] = $parc['fm_baixa'];
                    }

                    $parcela_valor += $parc['vl_parcela'];
                    $total_valor += $parc['vl_total_pago'];
                    $parcela_quantidade++;

                    //Teste para parcelas negociadas e quitacao (adicionar o numero da negociacao e a quantidade de parcelas de quitacao
                    switch ($parc['tp_parcela']) {
                        case 'G' :
                            $parc['nr_negociacao'] = Negociacao::getNumeroParcelasById($parc['id_negociacao']);
                            break;
                        case 'Q' :
                            $parcela_quitacao_quantidade_contrato++;
                            break;
                    }

                    if ($parc['tp_baixa'] != 'O') {
                        $valorPorcAdmin += $parc['vl_total_pago'];
                    }

                    $qtdGeralParc = (new Parcela())->getQtdeParcelas($contrato['id_contrato']);

                    switch ($parc['tp_parcela']) {
                        case 'S':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $contrato['nr_parcela_sinal'] . '-' . $parc['tp_parcela'];
                            break;
                        case 'I':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $contrato['nr_intercalada'] . '-' . $parc['tp_parcela'];
                            break;
                        case 'G':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $parc['nr_negociacao'] . '-' . $parc['tp_parcela'];
                            break;
                        case 'C':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $contrato['nr_parcela_entrega'] . '-' . $parc['tp_parcela'];
                            break;
                        case 'Q':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $qtdGeralParc['QtdeQuitadas'] . '-' . $parc['tp_parcela'];
                            break;
                        case 'A':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $qtdGeralParc['QtdeAvulsas'] . '-' . $parc['tp_parcela'];
                            break;
                        case 'N':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $qtdGeralParc['QtdeNormal'] . '-' . $parc['tp_parcela'];
                            break;
                        case 'E':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $parc['id_parcela'] . '-' . $parc['tp_parcela'];
                            break;
                        case 'NE':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $parc['id_parcela'] . '-' . $parc['tp_parcela'];
                            break;
                        case 'SE':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $parc['id_parcela'] . '-' . $parc['tp_parcela'];
                            break;
                        case 'IE':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $parc['id_parcela'] . '-' . $parc['tp_parcela'];
                            break;
                        case 'CE':
                            $parc['qtdeParcelas'] = $parc['id_parcela'] . '/' . $parc['id_parcela'] . '-' . $parc['tp_parcela'];
                            break;
                    }

                    //Calculo do valor por tipo de parcela
                    $totalParcelas[$parc['tp_parcela']]['valor'] += $parc['vl_parcela'];
                    $totalParcelas[$parc['tp_parcela']]['qtd']++;

                    //calcula o valor do juros
                    $juros = (float)$parc['vl_total_pago'] - (float)$parc['vl_parcela'];
                    $juros = $juros - (float)$parc['vl_multa'] - (float)$parc['desconto'];

                    $juros = round($juros, 2);
                    //caso o juros sej maior que 0 o mesmo recebe o novo valor calculado.
                    if ($parc['vl_juros'] > 0 && $juros > 0) {
                        $parc['vl_juros'] = $juros;
                    }

                    //Calculo do saldo da parcela
                    $parc['saldo'] = (float)$parc['vl_total_pago'] - ((float)$parc['vl_parcela'] + (float)$parc['vl_multa'] + (float)$parc['vl_juros'] - (float)$parc['desconto']);

                    $vlTotalDesconto += $parc['desconto'];
                    $vlTotalMulta += $parc['vl_multa'];
                    $vlTotalJuros += $parc['vl_juros'];

                    if ($parc['tp_parcela'] == 'S'&&(int)$contrato['nr_parcela_sinal']){
                        $getVlContrato += Contrato::getVlContrato($contrato['id_contrato']);
                    }
                    /**
                     * Cria um array para cada parcela para que possa ser exibido separado as parcelas do contrato,
                     * e necessario copiar o objeto do tipo array para evitar altera-lo na memoria.
                     */
                    if ($_POST['ordem'] == 'C') {
                        if (is_array($relatorio['contrato'][$key])) {
                            $contratoCred = new ArrayObject($contrato);
                            $contratoCred['parcelas'] = array();
                            $contratoCred['parcelas'][0] = new ArrayObject($parc);
                            array_push($contratosCredito, $contratoCred);
                        }
                    }

                    if ($_POST['ordem'] == 'PG') {
                        if (is_array($relatorio['contrato'][$key])) {
                            $contratoCred = new ArrayObject($contrato);
                            $contratoCred['parcelas'] = array();
                            $contratoCred['parcelas'][0] = new ArrayObject($parc);
                            array_push($contratosCredito, $contratoCred);
                        }
                    }
                    
                }
                // Quantidade total de parcelas do contrato
                $contrato['total']['quitacao'] = $parcela_quitacao_quantidade_contrato;
            }
            
        }
        //Reordena os contratos aps a remoo dos que n]ao sero usados
        sort($relatorio['contrato']);      
        //ordena a lista de parcelas de acordo com a opcao selecionada com a funcao de ordenacao
        if ($_POST['ordem'] == 'P') {
            usort($relatorio['contrato'], function ($a, $b) {
                if ($a['nm_pessoa'] == $b['nm_pessoa']) {
                    return 0;
                }
                return ($a['nm_pessoa'] < $b['nm_pessoa']) ? -1 : 1;

            });
        }
        //Ordena pela data de credito ou por quadra caso selecionado utilizando o multisort
        if ($_POST['ordem'] == 'C') {
            foreach ($contratosCredito as $key => $row) {
                $credito[$key] = strtotime(Helper::dataParaAmericano($row['parcelas'][0]["dt_credito"]));
                $pagamento[$key] = strtotime(Helper::dataParaAmericano($row['parcelas'][0]["dt_pagamento"]));
            }
            array_multisort($credito, SORT_ASC, $pagamento, SORT_ASC, $contratosCredito);
            $relatorio['contrato'] = $contratosCredito;

        } elseif($_POST['ordem'] == 'PG') {
            foreach ($contratosCredito as $key => $row) {
                $credito[$key] = strtotime(Helper::dataParaAmericano($row['parcelas'][0]["dt_credito"]));
                $pagamento[$key] = strtotime(Helper::dataParaAmericano($row['parcelas'][0]["dt_pagamento"]));
            }
            array_multisort( $pagamento, SORT_ASC, $credito, SORT_ASC, $contratosCredito);
            $relatorio['contrato'] = $contratosCredito;
        } elseif ($_POST['ordem'] == 'Q') {
            foreach ($relatorio['contrato'] as $key => $row) {
                $quadra[$key] = $row['quadra'];
                $lote[$key] = $row['lote'];
            }
            array_multisort($quadra, SORT_ASC, $lote, SORT_ASC, $relatorio['contrato']);
        }
        $relatorio['total']['parcela'] = $parcela_quantidade;
        $relatorio['total']['desconto'] = $vlTotalDesconto;
        $relatorio['total']['multa'] = $vlTotalMulta;
        $relatorio['total']['juros'] = $vlTotalJuros;
        $relatorio['total']['valor'] = $parcela_valor;
        $relatorio['total']['total'] = $total_valor;
        if ($relatorio['empreendimento']['porcAdmin'] > 0) {
            $valor = (float)$relatorio['empreendimento']['porcAdmin'];
            $relatorio['total']['porcAdmin'] = $valorPorcAdmin * ($valor / 100);
        }
        $relatorio['todos'] = ($_POST['cliente_relatorio_parcela_paga'] == '*' && $_POST['quadra_relatorio_parcela_paga'] == '*') ? true : false;        
        $relatorio['periodoPagamento'] = $_POST['dePagamento'] . " at " . $_POST['atePagamento'];
        $relatorio['periodoCredito'] = $_POST['deCredito'] . " at " . $_POST['ateCredito'];
        $relatorio['dtCorrecao'] = $_POST['correcao'];
        $relatorio['dataAtual'] = date('Y-m-d');

        if ($relatorio['tipo'] = $_POST['tipo'] == 'S') {
            $relatorio['tipo'] = 'S';            
        } elseif ($relatorio['tipo'] = $_POST['tipo'] == 'A'){
            $relatorio['tipo'] = 'A';
        }

        if ($_POST['totalizarBaixa'] == 'S'){
            $this->set('totalFormaBaixa', $totalFormaBaixa);
        }
        $this->set('visualizar', $_POST['visualizar']);
        $this->set('relatorio', $relatorio);
        //verifica se existem parcelas para nao exibir o relatorio em branco
        //Mensagem de Erros
        if ($parcela_quantidade == 0 && $this->isAjax()) {
            echo json_encode(array('msgErros' => utf8_encode('No exitem parcelas a serem exibidas!')));
            exit;
        } else {
            if ($this->isAjax()) {
                if ($_POST['visualizar'] != 'false'){
                    echo $this->display("relatorio");
                    exit;
                } else {
                    echo 'true';
                    exit;
                }
            }
        }

        if ($_POST['tipoRelatorio'] == 'pdf') {
            $this->displayMPDF('Relatorio_' . time() . '.pdf');
        } elseif ($_POST['tipoRelatorio'] == 'html') {
                $this->display('relatorio');
                exit;
        }elseif ($_POST['tipoRelatorio'] == 'xls')  {
            //Utilizado for pois o foreach causa erro no excell
            for ($i = 0; $i < count($relatorio['contrato']); $i++) {
                for ($j = 0; $j < count($relatorio['contrato'][$i]['parcelas']); $j++) {
                    //Ordena as parcelas caso alguma tenha sido removida
                    sort($relatorio['contrato'][$i]['parcelas']);
                    if ($relatorio['tipo'] == 'A') {
                        $colunas = [
                            'Cliente',
                            Helper::exibeAbreviacao(($relatorio['empreendimento']['ds_grupo'] != '') ? $relatorio['empreendimento']['ds_grupo']:''),
                            Helper::exibeAbreviacao(($relatorio['empreendimento']['ds_subgrupo'] != '') ? $relatorio['empreendimento']['ds_subgrupo']:''),
                            'Data Vencimento',
                            'Parcela',
                            'Vl. Original',
                            'Indexador',
                            'Juros Indice',
                            'Data Base',
                            'Correo',
                            'Amortizao',
                            'Juros',
                            'Sld Corrigido',
                            'Acrscimos',
                            'Total',
                            'Dt. Baixa',
                            'Vl. Baixa',
                            'Amortizao',
                            'Juros Emb',
                            'Acrsc./Decrsc.',
                            'Recto. Liquido'
                        ];

                        $linhas[] = [
                            $relatorio['contrato'][$i]['nm_pessoa'],
                            $relatorio['contrato'][$i]['quadra'],
                            $relatorio['contrato'][$i]['lote'],
                            Helper::getDate($relatorio['contrato'][$i]['parcelas'][$j]['dt_parcela']),
                            $relatorio['contrato'][$i]['parcelas'][$j]['qtdeParcelas'],
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['vl_parcela']),
                            $relatorio['contrato'][$i]['descricao'],
                            $relatorio['contrato'][$i]['parcelas'][$j]['vl_indice'],
                            Helper::getDate($relatorio['contrato'][$i]['parcelas'][$j]['dt_reajuste']),
                            $_POST['correcao'],
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['amort']),
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['jurosAmort']),
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['amort'] + $relatorio['contrato'][$i]['parcelas'][$j]['jurosAmort']),
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['acrescimo']),
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['vl_parcela']),
                            Helper::getDate($relatorio['contrato'][$i]['parcelas'][$j]['dt_pagamento']),
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['vl_total_pago']),
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['amortP']),
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['jurosAmortP']),
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['vl_juros'] + 
                                            $relatorio['contrato'][$i]['parcelas'][$j]['vl_multa'] +
                                            $relatorio['contrato'][$i]['parcelas'][$j]['acrescimo'] -
                                            $relatorio['contrato'][$i]['parcelas'][$j]['desconto']),
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['vl_total_pago'])
                        ];
                    
                    } else {

                        $colunas = [
                            'Cliente',
                            Helper::exibeAbreviacao(($relatorio['empreendimento']['ds_grupo'] != '') ? $relatorio['empreendimento']['ds_grupo']:''),
                            Helper::exibeAbreviacao(($relatorio['empreendimento']['ds_subgrupo'] != '') ? $relatorio['empreendimento']['ds_subgrupo']:''),
                            'Data Vencimento',
                            'Parcela',
                            'Vl. original',
                            'Qtd. Indexadpr',
                            'Indexador',
                            'Juros Contrato',
                            'Dt. Base',
                            'Correo',
                            'Amortizao',
                            'Juros Amort.',
                            'Dt. Baixa',
                            'Vl. Baixa',
                            'Recto. Liquido'
                        ];

                        $linhas[] = [
                            $relatorio['contrato'][$i]['nm_pessoa'],
                            $relatorio['contrato'][$i]['quadra'],
                            $relatorio['contrato'][$i]['lote'],
                            Helper::getDate($relatorio['contrato'][$i]['parcelas'][$j]['dt_parcela']),
                            $relatorio['contrato'][$i]['parcelas'][$j]['qtdeParcelas'],
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['vl_parcela']),
                            $relatorio['contrato'][$i]['parcelas'][$j]['vl_indice'],
                            $relatorio['contrato'][$i]['descricao'],
                            $relatorio['contrato'][$i]['tx_juros'],
                            Helper::getDate($relatorio['contrato'][$i]['parcelas'][$j]['dt_reajuste']),
                            $_POST['correcao'],
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['amort']),
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['jurosAmort']),
                            Helper::getDate($relatorio['contrato'][$i]['parcelas'][$j]['dt_pagamento']),
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['vl_total_pago']),
                            Helper::getMoney($relatorio['contrato'][$i]['parcelas'][$j]['vl_total_pago'])

                        ];
                    }
                }
            }

            $this->geraExcel($colunas, $linhas);

        } else {
            $this->display("relatorio");
        }
        
    }

    public function validarAction()
    {
        //validacao para evitar campos vazios
        $campos = array("empreendimento_relatorio_parcela_paga", "cliente_relatorio_parcela_paga","quadra_relatorio_parcela_paga");
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "" ||  $_POST[$cp] == null){
                switch ($cp) {
                    case "empreendimento_relatorio_parcela_paga" :
                        $msg = "O campo Empreendimento  obrigatrio.";
                        break;
                    case "cliente_relatorio_parcela_paga" :
                        $msg = "O campo Cliente  obrigatrio.";
                        break;
                    case "quadra_relatorio_parcela_paga" :
                        $msg = "O campo Quadra/Lote  obrigatrio.";
                        break;

                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }
        if (count($_POST['tp_pagamento']) == 0)
            $this->_helper->addMensagem('tp_pagamento', 'Selecione pelo menos um tipo de pagamento.');

        if (count($_POST['tp_parcela']) == 0)
            $this->_helper->addMensagem('tp_parcela', 'Selecione pelo menos um tipo de parcela.');

        if ($_POST['tipoRelatorio'] == 'pdf' || $_POST['tipoRelatorio'] == 'xls' || $_POST['tipoRelatorio'] == 'html')
        {//Testa as datas de pagamento e de credito
            if ($_POST['dePagamento'] == '' || $_POST['atePagamento'] == '') {
                if ($_POST['deCredito'] == '' || $_POST['ateCredito'] == '') {
                    $msg = 'Ao menos um perodo deve ser preenchido.';
                    $this->_helper->addMensagem('data', $msg);
                } elseif ((strtotime(Helper::getInputDate($_POST['deCredito']) . '+4 month') <= strtotime(Helper::getInputDate($_POST['ateCredito'])) && $_POST['cliente_relatorio_parcela_paga'] == '*') && ($_POST['tipoRelatorio'] != 'xls' ) && ($_POST['tipoRelatorio'] != 'html')) {
                    $msg = 'O perodo precisa ser de no mximo 120 dias.';
                    $this->_helper->addMensagem('data', $msg);
                }
            } elseif ($_POST['deCredito'] == '' || $_POST['ateCredito'] == '') {
                if ($_POST['dePagamento'] == '' || $_POST['atePagamento'] == '') {
                    $msg = 'Ao menos um perodo deve ser preenchido.';
                    $this->_helper->addMensagem('data', $msg);
                } elseif ((strtotime(Helper::getInputDate($_POST['dePagamento']) . '+4 month') <= strtotime(Helper::getInputDate($_POST['atePagamento'])) && $_POST['cliente_relatorio_parcela_paga'] == '*') && ($_POST['tipoRelatorio'] != 'xls') && ($_POST['tipoRelatorio'] != 'html')) {
                    $msg = 'O perodo precisa ser de no mximo 120 dias.';
                    $this->_helper->addMensagem('data', $msg);
                }
            } elseif ((strtotime(Helper::getInputDate($_POST['dePagamento']) . '+4 month') <= strtotime(Helper::getInputDate($_POST['atePagamento'])) && $_POST['cliente_relatorio_parcela_paga'] == '*') && ($_POST['tipoRelatorio'] != 'xls') && ($_POST['tipoRelatorio'] != 'html')) {
                $msg = 'O perodo precisa ser de no mximo 120 dias.';
                $this->_helper->addMensagem('data', $msg);
            } elseif ((strtotime(Helper::getInputDate($_POST['deCredito']) . '+4 month') <= strtotime(Helper::getInputDate($_POST['deCredito'])) && $_POST['cliente_relatorio_parcela_paga'] == '*') && ($_POST['tipoRelatorio'] != 'xls') && ($_POST['tipoRelatorio'] != 'html')) {
                $msg = 'O perodo precisa ser de no mximo 120 dias.';
                $this->_helper->addMensagem('data', $msg);
            }
        }
        
        //Mensagem de Erros
        if (count($this->_helper->getMensagens()) > 0)  {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            return !(count($this->_helper->getMensagens()) > 0);
        }
    }

    public function clienteExtratoPriceAction()
    {
        $id_empreendimento = $_POST['id_empreendimento'];
        $instanceLote = new Lote();
        $selectLotes = $instanceLote->getDefaultAdapter()->select();
        $clientes = $selectLotes->from(array('l' => TB_LOTES), array('id_lote' => 'id', 'id_empreendimento','quadra','lote'))
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'id_pessoa', 'tx_juros'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa', 'id'))
            ->where('l.id_empreendimento = ?', $id_empreendimento)
            ->where('c.tx_juros IS NOT NULL')
            ->order('p.nm_pessoa')
            ->group('p.id')
            ->query();

            $lista[] = array('id'=>'','text'=>'');
            $lista[] = array('id'=>'*','text'=>'Todos');
        foreach ($clientes as $cliente) {
            $lista[] = array(
                'id' => $cliente['id'],
                'text' => utf8_encode($cliente['nm_pessoa']),
            );
        }
        echo json_encode($lista);
    }

    public function loteByEmpreendimentoAction()
    {
        $instanceLote = new Lote();
        $selectLotes = $instanceLote->getDefaultAdapter()->select();
        $lotes = $selectLotes->from(array('l' => TB_LOTES), array('id_lote' => 'id', 'id_empreendimento', 'quadra', 'lote'))
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('tx_juros'))
            ->where('l.id_empreendimento = ?', $_POST["id_empreendimento"])
            ->where('c.tx_juros IS NOT NULL')
            ->order(array('l.quadra', 'l.lote'))->query();

            $lista[] = array('id'=>'','text'=>'');
            $lista[] = array('id'=>'*','text'=>'Todos');
        foreach ($lotes as $lote) {
            $lista[] = array(
                'id' => $lote['id_lote'],
                'text' => ' Quadra: ' . utf8_encode($lote['quadra']) . ' - Lote: ' . utf8_encode($lote['lote']),
            );
    }
        echo json_encode($lista);
    }

}