<?php

/**
 * Description of CartasEnviadasController
 *
 * @author acade
 */
class RelatorioContratoController extends Controller
{

    protected $tb_empreendimento;
    protected $tb_contrato;
    private $tb_docusign;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_empreendimento = new Empreendimento();
        $this->tb_contrato = new Contrato();
        $this->tb_docusign = new DocusignEventos();
    }

    public function indexAction()
    {
        $total_valor = 0;
        $itensContrato = 0;
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());
        if ($this->_isPost && $this->validar()) {
            $tipoContrato = $_POST['tipoContrato'];
            $tipoPg[] = '';
            if($_POST['tp_pagamento']){
                if (count($_POST['tp_pagamento'])) {
                    foreach ($_POST['tp_pagamento'] as $k =>$tipo) {
                        $tipoPg[$k] = '"' . $tipo . '"';
                    }
                }
                $tipoPg = '(' . implode(',', $tipoPg) . ')';
            }
            
            $contratos = $this->tb_empreendimento->getAdapter()->select()->distinct()
                ->from(array('emp' => TB_EMPREENDIMENTO), array())
                ->join(array('lote' => TB_LOTES), 'lote.id_empreendimento = emp.id', array('quadra', 'lote', 'id'))
                ->join(array('cont' => TB_CONTRATO), 'cont.id_lote = lote.id', array('*', 'idProposta' => 'nr_proposta', 'idContrato' => 'id'))
                ->join(array('p' => TB_PESSOA), 'p.id = cont.id_pessoa', 'nm_pessoa')
                ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', 'nr_cpf')
                ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'p.id = pj.id_pessoa', 'nr_cnpj')
                ->join(array('ie' => TB_INDICE_EMPREENDIMENTO), 'ie.id_indice_empreendimento = cont.id_indice', ['fl_periodo', 'fl_residuo', 'indice_adicional', 'fl_periodo_adc', 'id_indice as idIndice'])
                ->joinLeft(array('pes' => TB_PESSOA), 'pes.id = cont.id_corretor', array('nmCorretor'=>'nm_pessoa'))
                ->where('cont.fl_fm_pagamento in' . $tipoPg)
                ->where('emp.id=' . $_POST["empreendimento"] . ' and  cont.dt_contrato >= "' . Helper::getInputDate($_POST["dataInicio"]) . '"  and cont.dt_contrato <= "' . Helper::getInputDate($_POST["dataFinal"]) . '"');
                
            switch ($_POST['ordena']) {
                case 'quadraLote':
                    $contratos->order(array('lote.quadra', 'lote.lote'));
                    break;
                case 'data':
                    $contratos->order(array('cont.dt_contrato'));
                    break;
                case 'numeroContrato':
                    $contratos->order(array('cont.id'));
                    break;
            }

            if ($tipoContrato != ''){
                if($tipoContrato == 'assinado'){
                    $contratos = $contratos->joinRight(array('de' => TB_DOCUSIGN_EVENTO), 'de.envelopeId = cont.docusign_envelope_id and de.envelopeEvento = "recipient-completed"')->group('cont.id');

                }
                else{
                    $contratos = $contratos->where('cont.fl_distrato = "' . $tipoContrato.'"');
                }
            }
            $contratos = $contratos->query()->fetchAll();

            //No foi usado foreach pois acontecia um bug desconhecido repetindo valores
            for ($i=0; $i < sizeof($contratos); $i++) { 
                $tbAgrupada = AgrupadaGeral::buscar('12', $contratos[$i]['idIndice']);
                $contratos[$i]['descricao'] = $tbAgrupada['descricao'];

                $contratos[$i]['outros_compradores'] = $this->tb_contrato->getAdapter()->select()->distinct()
                    ->from(['c' => TB_CONTRATO], [''])
                    ->join(['cp' => TB_CONTRATO_PESSOA], 'cp.id_contrato = c.id', ['*'])
                    ->join(['p' => TB_PESSOA], 'cp.id_pessoa = p.id', 'nm_pessoa')
                    ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', 'nr_cpf')
                    ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'p.id = pj.id_pessoa', 'nr_cnpj')
                    ->where('c.id = ' . $contratos[$i]['id'])
                    ->query()->fetchAll();
            }
            
            if (count($contratos) > 0) {
                $totalGeral = 0;
                $auxContratos = array();
                foreach ($contratos as $contrato) {
                    //Valores Totais
                    $totalMensal = $contrato['vl_parcela'] * $contrato['nr_parcela'];
                    $totalIntercalada = $contrato['vl_intercalada'] * $contrato['nr_intercalada'];
                    $totalChave = $contrato['vl_parcela_entrega'] * $contrato['nr_parcela_entrega'];
                    //Sinal
                    $vlSinal = 0;
                    $sinais = array();
                    $sinal = Sinal::findByContrato($contrato['idContrato']);
                    if (count($sinal) > 0) {
                        foreach ($sinal as $s) {
                            $sinais[$s['valor']][] = $s;
                            $vlSinal += $s['valor'];
                        }
                        $contrato['sinal'] = $sinais;
                    }
                    //Exibio do valor da Parcela, se o sinal contrato for igual a 1
                    if ($contrato['inclui_sinal_contrato'] == 0 && $_POST['tipoParcela'] == 1) {
                        $vlSinal = 0;
                        $contrato['sinal'] = array();
                    }
                    $contrato['adicionais'] = array();
                    $itensContrato = ContratoItens::findByContrato($contrato['idContrato']);
                    if (count($itensContrato) > 0) {
                        foreach ($itensContrato as $item) {
                            switch ($item['tp_parcela']) {
                                case 'N':
                                    $totalMensal += ($item['vl_parcela'] * $item['qt_parcelas']);
                                    $contrato['adicionais'][] = $item;
                                    break;
                                case 'I':
                                    $totalIntercalada += ($item['vl_parcela'] * $item['qt_parcelas']);
                                    $contrato['adicionais'][] = $item;
                                    break;
                                case 'C':
                                    $totalChave += ($item['vl_parcela'] * $item['qt_parcelas']);
                                    $contrato['adicionais'][] = $item;
                                    break;
                            }
                        }
                    }
                    $total_valor += $totalMensal + $totalIntercalada + $totalChave + $vlSinal;
                    $contrato['totalMensal'] = $totalMensal;
                    $contrato['totalIntercalada'] = $totalIntercalada;
                    $contrato['totalChaves'] = $totalChave;
                    $contrato['total'] = $totalMensal + $totalIntercalada + $totalChave + $vlSinal;
                    $contrato['total_pago'] = number_format($total_valor, 2, ',', '.');
                    if($_POST['assinaturas']=="1"){
                        $contrato['lista_assinaturas']=$this->tb_docusign->getById($contrato['docusign_envelope_id'],"recipient-completed");
                    }
                    $comSemResiduo = ($contrato['fl_residuo'] == '1')?' - Com':' - Sem';
                    $caracterSoma = Helper::getNomePeriodo($contrato['fl_periodo']) != ''?' +':'';
                    $indiceAdicional = ($contrato['indice_adicional'] != '0') ? $caracterSoma . str_replace('.',',',number_format($contrato['indice_adicional'], 2)) . '%' : '';
                    $contrato['indice'] = $contrato['descricao'] . ' ' . Helper::getNomePeriodo($contrato['fl_periodo']) . ' ' . $indiceAdicional . ' ' . Helper::getNomePeriodo($contrato['fl_periodo_adc']).$comSemResiduo.' Resduo';
                    $totalGeral += $contrato['total'];
                    $auxContratos[] = $contrato;
                }
                $contratos = $auxContratos;
                $this->set('contratos', $contratos);
                $this->set('tipoContrato',$tipoContrato);
                //Pegando o valor do ndice
                $indice = $this->tb_contrato->getAdapter()->select()->distinct()
                    ->from(array('c' => TB_CONTRATO), array('id_indice'))
                    ->join(array('a' => TB_AGRUPADA), 'c.id_indice = a.idCampo and a.idTabela = "12"', array('*'))
                    ->where('a.idTabela = "12"')
                    ->query()->fetchAll();
                $this->set('indice', $indice);
                $empreendimento = $this->tb_empreendimento->fetchRow("id = {$_POST['empreendimento']}");

                $empreendimentoInfo = $this->tb_empreendimento->getAdapter()->select()
                    ->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento','ds_path_logo'))
                    ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
                    ->where('id = ' . $_POST['empreendimento'])
                    ->query()->fetch();
                $this->set("empreendimentoInfo", $empreendimentoInfo);
                $this->set('empreendimento', $empreendimento);
                $this->set('contrato', $contratos);
                $this->display('gerar');
                if ($_POST['tipoRelatorio'] != 'html')
                    $this->displayMPDF('contrato.pdf', true, 'P');
            } else {
                $this->_helper->addMensagem('fail', 'No foi encontrado nenhum contrato.');
                $this->carregarDados();
                $this->display("index");
            }
        } else {
            $this->carregarDados();
            $this->display("index");
        }
    }

    private function carregarDados()
    {
        $empreendimentos = $this->tb_empreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('nm_empreendimento', 'id'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        $this->set('empreendimentos', $empreendimentos);
    }

    private function validar()
    {
        $campos = array('empreendimento', 'dataInicio', 'dataFinal');
        foreach ($campos as $cp) {
            if ($_POST[$cp] == "") {
                $this->_helper->addMensagem('fail', 'Todos os campos so obrigatrios.');
                return false;
            }
        }
        if(!$_POST['tp_pagamento']){
            $this->_helper->addMensagem('fail', 'Adicione pelo menos uma forma de pagamento.');
            return false;
        }
        return true;
    }

}

?>