<?php

class RelParcelaController extends Controller
{

    public function indexAction()
    {
        $this->set("subtitulo", "Relat&oacute;rio de Parcelas");
        $this->carregarDados();
        $this->display("index");
    }

    private function carregarDados()
    {
        //instancia as classes necessrias
        $instanceEmpreendimento = new Empreendimento();
        $empreendimento = $instanceEmpreendimento->getDefaultAdapter();
        $empreendimento = $empreendimento->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('nm_empreendimento'))
            ->join(array('l' => TB_LOTES), 'e.id = l.id_empreendimento', array('id_lote' => 'id', 'id_empreendimento'))
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'id_lote'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {
            }
        }

        $empreendimento = $empreendimento->group('e.id')->order('nm_empreendimento')->query()->fetchAll();
        $this->set('empreendimentos', $empreendimento);
    }

    public function relatoriosAction()
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        ini_set('memory_limit', '3000M');
        set_time_limit(0);

        if ($this->validarAction()) {
            $this->relatorioAction();
        }
    }
    //Gera relatrio completo de parcelas pagas
    public function gerarRelatorio($relatorio)
    {
        $id_empreendimento = $_POST['empreendimento_relatorio_parcela_paga'];
        $tp_pagamento = $_POST['tp_pagamento'];
        $dataBase = $_POST["dataBase"];

        if ((in_array('T', $tp_pagamento) && in_array('B', $tp_pagamento) && in_array('O', $tp_pagamento)) || !$tp_pagamento) {
            $tp_pagamento = 'TODOS';
        } else {
            // cria o filtro para os tipos de pagamento
            $pgs = '';
            for ($i = 0; $tp_pagamento[$i]; $i++) {
                if ($i == 0) {
                    $pgs = "'" . $tp_pagamento[$i] . "'";
                } else {
                    $pgs .= ",'" . $tp_pagamento[$i] . "'";
                }
            }
            $tp_pagamento = $pgs;
        }

        $tp_parcelas = array();

        if (count($_POST['tp_parcela'])) {
            foreach ($_POST['tp_parcela'] as $tipo) {
                if ($tipo == 'G' || $tipo == 'Q') {
                    $tp_parcelas[] = "'" . $tipo . "'";
                } else $tp_parcelas[] = "'" . $tipo . "','" . $tipo . "E'";
            }
            $tp_parcelas = '(' . implode(',', $tp_parcelas) . ')';
        }

        $tb_parcelas = new Parcela;
        $select = $tb_parcelas->getAdapter()->select();

        $empreendimento = $select->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.rgi', 'e.id', 'e.porcAdmin'))
            ->join(array('c' => Db_Cidade::TABLE_NAME), 'e.cd_cidade = c.id', array('cidade_nome' => 'c.nome', 'cidade_uf' => 'c.uf'))
            ->where('e.id = ?', $_POST['empreendimento_relatorio_parcela_paga'])->query()->fetch();

        $campoData = "P.dt_parcela";
        $ignorePagoOuNao = false;
        if ($relatorio == 'PARCELA_ENVIADA') {
            $fl_envio = '1';
            $ignorePagoOuNao = true;
            $relTitulo = 'BOLETOS ENVIADOS';
        } elseif ($relatorio == 'PARCELA_NAO_ENVIADA') {
            $fl_envio = '0';
            $ignorePagoOuNao = true;
            $relTitulo = 'BOLETOS NO ENVIADOS';
        }

        $this->set('relTitulo', $relTitulo);

        //Parcela
        $select = $tb_parcelas->getAdapter()->select();

        $select->from(array('P' => TB_PARCELA), array( 
            'id_parcela_contrato',
            'id_contrato',
            'id_parcela',
            'tp_parcela',
            'dt_parcela',
            'dt_credito',
            'desconto',
            'dt_pagamento',
            'tp_baixa',
            'vl_parcela',
            'vl_juros',
            'vl_multa',
            'id_negociacao',
            'vl_total_pago',
            'nr_tipo_parcela'
        ))
            ->where('id_empreendimento = ?', $id_empreendimento)
            ->where('P.tp_parcela in ' . $tp_parcelas)
            ->join(array('C' => TB_CONTRATO), 'P.id_contrato = C.id', array())
            ->join(array('L' => TB_LOTES), 'L.id = C.id_lote', array('lote', 'quadra'))
            ->join(array('PS' => TB_PESSOA), 'PS.id = C.id_pessoa', array('nm_pessoa'));

        if ($_POST['ordena'] == 'quadraLote') {
            $select->order(array('L.quadra', 'L.lote'));
        } else if ($_POST['ordena'] == 'dataPgto') {
            $select->order(array('P.dt_pagamento'));
        } else {
            $select->order(array('P.dt_credito'));
        }

        if ($tp_pagamento != 'TODOS' && $tp_pagamento) {
            $select->where("tp_baixa in (" . $tp_pagamento . ")");
        }
        if ($_POST['cliente_relatorio_parcela_paga'] && $_POST['cliente_relatorio_parcela_paga'] != '*')
            $select = $select->where('C.id_pessoa = ?', $_POST['cliente_relatorio_parcela_paga']);
        if (isset($fl_envio))
            $select->where('P.fl_envio = ?', $fl_envio);
        if (!$ignorePagoOuNao)
            $select->where('P.pago = ?', $isPago);
        if ($_POST['de'] && $_POST['ate']) {
            $select->where($campoData . ' >= ?', Helper::getInputDate($_POST['de']))->where($campoData . ' <= ?', Helper::getInputDate($_POST['ate']));
            $this->set('periodo', $_POST['de'] . ' at&eacute; &nbsp;' . $_POST['ate']);
        }

        $rsItens = $select->query()->fetchAll();

        //Parcela Historico
        $select = $tb_parcelas->getAdapter()->select();
        $select->from(array('P' => TB_PARCELA_HISTORICO), array(
            'id_parcela_contrato',
            'id_contrato',
            'id_parcela',
            'dt_parcela',
            'dt_credito',
            'desconto',
            'dt_pagamento',
            'tp_baixa',
            'vl_parcela',
            'vl_juros',
            'vl_multa',
            'id_negociacao',
            'vl_total_pago'
        ))
            ->where('id_empreendimento = ?', $id_empreendimento)
            ->where('P.tp_parcela in ' . $tp_parcelas)
            ->join(array('C' => TB_CONTRATO), 'P.id_contrato = C.id', array('fl_distrato'))
            ->join(array('L' => TB_LOTES), 'L.id = C.id_lote', array('lote', 'quadra'))
            ->join(array('PS' => TB_PESSOA), 'PS.id = C.id_pessoa', array('nm_pessoa'));

        if ($_POST['ordena'] == 'quadraLote') {
            $select->order(array('L.quadra', 'L.lote'));
        } else if ($_POST['ordena'] == 'dataPgto') {
            $select->order(array('P.dt_pagamento'));
        } else {
            $select->order(array('P.dt_credito'));
        }

        if ($tp_pagamento != 'TODOS' && $tp_pagamento) {
            $select->where("tp_baixa in (" . $tp_pagamento . ")");
        }

        if ($_POST['cliente_relatorio_parcela_paga'] && $_POST['cliente_relatorio_parcela_paga'] != '*')
            $select = $select->where('C.id_pessoa = ?', $_POST['cliente_relatorio_parcela_paga']);
        if (isset($fl_envio))
            $select->where('P.fl_envio = ?', $fl_envio);
        if (!$ignorePagoOuNao)
            $select->where('P.pago = ?', $isPago);
        if ($_POST['de'] && $_POST['ate']) {
            $select->where($campoData . ' >= ?', Helper::getInputDate($_POST['de']))->where($campoData . ' <= ?', Helper::getInputDate($_POST['ate']));
            $this->set('periodo', $_POST['de'] . ' at&eacute; &nbsp;' . $_POST['ate']);
        }

        $rsItens2 = $select->query()->fetchAll();

        //testa se existem parcelas - RELATORIO DE BOLETOS ENVIADOS
        if (!$rsItens && !$rsItens2) {
            $this->_helper->addMensagem('index', 'No existem resultados a serem exibidos.');
            $this->display('index');
            exit;
        }

        $relatorio = new Report(array('style' => 'border-collapse:collapse;', 'align' => 'center'));
        $itens = array();

        $total_vl_parcela = 0;
        $total_vl_multa = 0;
        $total_vl_juros = 0;
        $total_vl_desconto = 0;
        $total_com_partic = 0;
        $total_sem_partic = 0;
        $total_porcAdmin = 0;

        $header = array(

            'nm_pessoa' => array('_label' => 'Nome', '_font-weight' => 'bold', '_border' => '1px solid #000', 'width' => '200px', 'padding' => '3px', 'font-size' => '10px'),
            'lote' => array('_label' => 'Lote', '_font-weight' => 'bold', '_border' => '1px solid #000', 'text-align' => 'center', 'padding' => '3px', 'font-size' => '10px'),
            'quadra' => array('_label' => 'Qdr.', '_font-weight' => 'bold', '_border' => '1px solid #000', 'text-align' => 'center', 'padding' => '3px', 'font-size' => '10px'),
            'id_parcela_contrato' => array('_label' => 'Baixa', '_font-weight' => 'bold', '_border' => '1px solid #000', 'width' => '55px', 'text-align' => 'center', 'padding' => '3px', 'font-size' => '10px'),
            'id_parcela' => array('_label' => 'Parcela', '_font-weight' => 'bold', '_border' => '1px solid #000', 'width' => '45px', 'text-align' => 'center', 'padding' => '3px', 'font-size' => '10px'),
            'dt_parcela' => array('_label' => 'Vencto.', '_font-weight' => 'bold', '_border' => '1px solid #000', 'text-align' => 'center', 'padding' => '3px', 'font-size' => '10px'),
            'dt_pagamento' => array('_label' => 'Pagto.', '_font-weight' => 'bold', '_border' => '1px solid #000', 'text-align' => 'center', 'padding' => '3px', 'font-size' => '10px'),
            'dt_credito' => array('_label' => 'Cr&eacute;dito', '_font-weight' => 'bold', '_border' => '1px solid #000', 'text-align' => 'center', 'padding' => '3px', 'font-size' => '10px'),
            'vl_parcela' => array('_label' => 'Valor', '_font-weight' => 'bold', '_border' => '1px solid #000', 'text-align' => 'center', 'padding' => '3px', 'font-size' => '10px', 'text-align' => 'center'),
            'desconto' => array('_label' => 'Descto.', '_font-weight' => 'bold', '_border' => '1px solid #000', '_text-align' => 'center', 'padding' => '3px', 'font-size' => '10px', 'text-align' => 'center'),
            'vl_multa' => array('_label' => 'Multa.', '_font-weight' => 'bold', '_border' => '1px solid #000', 'text-align' => 'center', 'padding' => '3px', 'font-size' => '10px', 'text-align' => 'center'),
            'vl_juros' => array('_label' => 'Juros.', '_font-weight' => 'bold', '_border' => '1px solid #000', 'padding' => '3px', 'font-size' => '10px', 'text-align' => 'center'),
            'vl_total_pago' => array('_label' => 'Total', '_font-weight' => 'bold', '_border' => '1px solid #000', 'text-align' => 'center', 'padding' => '3px', 'font-size' => '10px', 'text-align' => 'right'),
            'tp_baixa' => array('_label' => 'Pg', '_font-weight' => 'bold', '_border' => '1px solid #000', '_text-align' => 'center', 'padding' => '3px', 'font-size' => '10px', 'text-align' => 'right'),
            'saldo' => array('_label' => 'Saldo', '_font-weight' => 'bold', '_border' => '1px solid #000', '_text-align' => 'center', 'padding' => '3px', 'font-size' => '10px', 'text-align' => 'right'),

        );

        foreach ($rsItens as $item) {

            //calcula o valor do juros
            $juros = (float)$item['vl_total_pago'] - (float)$item['vl_parcela'];
            $juros = $juros - (float)$item['vl_multa'];

            $juros = round($juros, 2);
            //caso o juros sej maior que 0 o mesmo recebe o novo valor calculado.
            if ($item['vl_juros'] > 0 && $juros > 0) {
                $item['vl_juros'] = $juros;
            }

            if ($item['vl_total_pago']) {
                $saldo = ($item['vl_parcela'] + $item['vl_juros'] + $item['vl_multa'] - $item['desconto']) - $item['vl_total_pago'];
            } else {
                $saldo = $item['vl_parcela'] - $item['vl_total_pago'] - $item['desconto'];
            }

            $total_vl_parcela += $item['vl_parcela'];
            $total_vl_multa += $item['vl_multa'];
            $total_vl_juros += $item['vl_juros'];
            $total_vl_desconto += $item['desconto'];

            $vl_pago = $item['vl_total_pago'];
            $vl_parcela = $item['vl_parcela'];

            $total_com_partic += $item['vl_total_pago'];
            if ($item['tp_baixa'] != "O") {
                $total_porcAdmin += $item['vl_total_pago'] * ($empreendimento['porcAdmin'] / 100);
            }
            $select->reset()->from(TB_PARCELA, 'count(*)')->where('id_contrato = ?', $item['id_contrato']);
            if ($item['tp_parcela'] == 'S') {
                $quantidade = $select->where('tp_parcela = ?', 'S')->query()->fetch();
            } elseif ($item['tp_parcela'] == 'I') {
                $quantidade = $select->where('tp_parcela = ?', 'I')->query()->fetch();
            } elseif ($item['tp_parcela'] == 'G') {
                if($item['id_negociacao'])
                    $quantidade = $select->where("tp_parcela = 'G' and id_negociacao = {$item['id_negociacao']}")->query()->fetch();
                else $quantidade = 1;
            } elseif ($item['tp_parcela'] == 'Q') {
                $quantidade = $select->where('tp_parcela = ?', 'Q')->query()->fetch();
            } else {
                $quantidade = $select->where('tp_parcela = ?', 'N')->query()->fetch();
            }

            $item['id_parcela'] = $item['id_parcela'] . '/' . $quantidade['count(*)'] . '-' . $item['tp_parcela'];
            $item['vl_parcela'] = number_format($item['vl_parcela'], 2, ',', '.');
            $item['vl_multa'] = number_format($item['vl_multa'], 2, ',', '.');
            $item['vl_juros'] = number_format($item['vl_juros'], 2, ',', '.');
            $item['desconto'] = number_format($item['desconto'], 2, ',', '.');
            $item['vl_total_pago'] = number_format($item['vl_total_pago'], 2, ',', '.');
            $item['dt_parcela'] = $this->_helper->getDate($item['dt_parcela']);
            $item['dt_pagamento'] = $this->_helper->getDate($item['dt_pagamento']);
            $item['dt_credito'] = $this->_helper->getDate($item['dt_credito']);

            $saldo2 = ($saldo < 0 && $saldo > -1) ? 0 : $saldo;

            $item['saldo'] = number_format($saldo2, 2, ',', '.');
            $itens[] = $item;
        }

        foreach ($rsItens2 as $item) {

            if ($item['vl_total_pago']) {
                $saldo = ($item['vl_parcela'] + $item['vl_juros'] + $item['vl_multa'] - $item['desconto']) - $item['vl_total_pago'];
            } else {
                $saldo = $item['vl_parcela'] - $item['vl_total_pago'] - $item['desconto'];
            }
            $total_vl_parcela += $item['vl_parcela'];
            $total_vl_multa += $item['vl_multa'];
            $total_vl_juros += $item['vl_juros'];
            $total_vl_desconto += $item['desconto'];

            $vl_pago = $item['vl_total_pago'];
            $vl_parcela = $item['vl_parcela'];

            $total_com_partic += $item['vl_total_pago'];
            if ($item['tp_baixa'] != "O") {
                $total_porcAdmin += $item['vl_total_pago'] * ($empreendimento['porcAdmin'] / 100);
            }
            $select->reset()->from(TB_PARCELA, 'count(*)')->where('id_contrato = ?', $item['id_contrato']);
            if ($item['tp_parcela'] == 'S') {
                $quantidade = $select->where('tp_parcela = ?', 'S')->query()->fetch();
            } elseif ($item['tp_parcela'] == 'I') {
                $quantidade = $select->where('tp_parcela = ?', 'I')->query()->fetch();
            } elseif ($item['tp_parcela'] == 'G') {
                $quantidade = $select->where("tp_parcela = 'G' and id_negociacao = {$item['id_negociacao']}")->query()->fetch();
            } elseif ($item['tp_parcela'] == 'Q') {
                $quantidade = $select->where('tp_parcela = ?', 'Q')->query()->fetch();
            } else {
                $quantidade = $select->where('tp_parcela = ?', 'N')->query()->fetch();
            }

            $item['id_parcela'] = $item['id_parcela'] . '/' . $quantidade['count(*)'] . '-' . $item['tp_parcela'];
            $item['vl_parcela'] = number_format($item['vl_parcela'], 2, ',', '.');
            $item['vl_multa'] = number_format($item['vl_multa'], 2, ',', '.');
            $item['vl_juros'] = number_format($item['vl_juros'], 2, ',', '.');
            $item['desconto'] = number_format($item['desconto'], 2, ',', '.');
            $item['vl_total_pago'] = number_format($item['vl_total_pago'], 2, ',', '.');
            $item['dt_parcela'] = $this->_helper->getDate($item['dt_parcela']);
            $item['dt_pagamento'] = $this->_helper->getDate($item['dt_pagamento']);
            $item['dt_credito'] = $this->_helper->getDate($item['dt_credito']);
            $saldo2 = ($saldo < 0 && $saldo > -1) ? 0 : $saldo;

            $item['saldo'] = number_format($saldo2, 2, ',', '.');
            $itens[] = $item;
        }

        $totais = array(
            'parcela' =>  $_SESSION['simboloMoeda']. ' '. number_format($total_vl_parcela, 2, ',', '.'),
            'juros' => $_SESSION['simboloMoeda']. ' '. number_format($total_vl_juros, 2, ',', '.'),
            'multa' =>  $_SESSION['simboloMoeda']. ' ' . number_format($total_vl_multa, 2, ',', '.'),
            'desconto' =>  $_SESSION['simboloMoeda']. ' '. number_format($total_vl_desconto, 2, ',', '.'),
            'totalComPartic' => $_SESSION['simboloMoeda']. ' '. number_format($total_com_partic, 2, ',', '.'),
            'totalSemPartic' =>  $_SESSION['simboloMoeda']. ' '. number_format($total_sem_partic, 2, ',', '.'),
            'porcAdmin' =>  $_SESSION['simboloMoeda']. ' '. number_format($total_porcAdmin, 2, ',', '.')
        );

        $this->set('totais', $totais);
        $this->set('empreendimento', $empreendimento);

        $relatorio->setHeader($header);
        $relatorio->setItens($itens);
        $this->set('report', $relatorio->run());
        $this->set('topContent', 'topContent.php');
        $this->set('footerContent', 'rodapeRelatorioCompleto.php');
        $this->set('relSubtitulo', '<b>Empreendimento: </b>' . $empreendimento['nm_empreendimento']);
        $this->display('report');

        if ($_POST['gera'] == 'html') {
            $this->display('report');
            exit;
        }
        $this->displayMPDF('Relatorio_Completo_Parcelas_Pagas_' . time() . '.pdf');

    }

    //SELECIONA RELATORIOS A SER GERADOS e gera o Nao pagas sintetico e o Pagas Sintetico
    public function relatorioAction()
    {
        //Consulta para pegar a logo do cliente.
        $clienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $clienteAcade->fetchRow()->toArray());

        $tp_pagamento = $_POST['tp_pagamento'];

        $de = $_POST['de'];
        $ate = $_POST['ate'];

        // Listagem das parcelas dos clientes detalhadas, direciona pra outras funcoes exceto os relatorios de pagas sintetico, nao pagas sintetico e em negociacao
        if ($_POST['tipo'] == 'PE') {
            $this->gerarRelatorio('PARCELA_ENVIADA');
            exit;
        } elseif ($_POST['tipo'] == 'PNE') {
            $this->gerarRelatorio('PARCELA_NAO_ENVIADA');
            exit;
        } elseif ($_POST['tipo'] == 'PCL') {
            $this->gerarRelPgtoCliente();
            exit;
        } elseif ($_POST['tipo'] == 'PP') {
            $this->gerarRelPrimeirasParcelas();
            exit;
        } elseif ($_POST['tipo'] == 'UP') {
            $this->gerarRelUltimasParcelas();
            exit;
        } elseif ($_POST['tipo'] == 'PNP') {
            $this->gerarRelNegociadasPagas();
            exit;
        }

        $tp_parcelas = array();
        $tp_parcelasNPagas = array();

        if (count($_POST['tp_parcela'])) {
            foreach ($_POST['tp_parcela'] as $tipo) {
                if ($tipo == 'G' || $tipo == 'Q') {
                    $tp_parcelas[] = "'" . $tipo . "'";
                    $tp_parcelasNPagas[] = "'" . $tipo . "'";
                } else {
                    $tp_parcelas[] = "'" . $tipo . "','" . $tipo . "E'";
                    $tp_parcelasNPagas[] = "'" . $tipo . "'";
                }
            }
            $tp_parcelas = '(' . implode(',', $tp_parcelas) . ')';
            $tp_parcelasNPagas = '(' . implode(',', $tp_parcelasNPagas) . ')';
        }

        $instanceEmpreendimento = new Empreendimento();
        $instanceEmpreendimento = $instanceEmpreendimento->getDefaultAdapter();

        $relatorio['empreendimento'] = $instanceEmpreendimento->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.rgi', 'e.id', 'e.porcAdmin', 'e.ds_path_logo'))
            ->join(array('c' => Db_Cidade::TABLE_NAME), 'e.cd_cidade = c.id', array('cidade_nome' => 'c.nome', 'cidade_uf' => 'c.uf'))
            ->where('e.id = ?', $_POST['empreendimento_relatorio_parcela_paga'])->query()->fetch();

        $relatorio2['empreendimento'] = $instanceEmpreendimento->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.rgi', 'e.id', 'e.porcAdmin', 'e.ds_path_logo'))
            ->join(array('c' => Db_Cidade::TABLE_NAME), 'e.cd_cidade = c.id', array('cidade_nome' => 'c.nome', 'cidade_uf' => 'c.uf'))
            ->where('e.id = ?', $_POST['empreendimento_relatorio_parcela_paga'])->query()->fetch();

        $instanceContrato = new Contrato();
        $instanceContrato = $instanceContrato->getDefaultAdapter();
        $instanceContrato = $instanceContrato->select()->from(array('c' => TB_CONTRATO), array('id_contrato' => 'c.id', 'id_lote' => 'c.id_lote'))
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('l.quadra', 'l.lote'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('p.nm_pessoa', 'p.endereco', 'p.nm_bairro', 'id_pessoa' => 'p.id'));

        $compMsg = "pelos clientes";
        if ($_POST['cliente_relatorio_parcela_paga'] && $_POST['cliente_relatorio_parcela_paga'] != '*') {
            $instanceContrato = $instanceContrato->where('c.id_pessoa = ?', $_POST['cliente_relatorio_parcela_paga']);
            $compMsg = "por esse cliente nesse periodo";
        }
        $titulo = 'PAGAS';
        $paga = '1';
        $msg = "Este empreendimento no possui parcelas pagas $compMsg.";

        $campoData = "dt_pagamento";
        if ($_POST["tipo"] == "N") {
            $paga = '0';
            $titulo = "NO PAGAS";
            $msg = "Este empreendimento no possui parcelas atrasadas $compMsg.";
            $campoData = "dt_parcela";
        }
        if ($_POST["tipo"] == "PN") {
            $titulo = "EM NEGOCIAO";
            $msg = "Este empreendimento no possui parcelas em negociao $compMsg.";
        }

        if ($_POST['ordena'] == 'quadraLote') {
            $instanceContrato->order(array('l.quadra', 'l.lote'));
        }

        $relatorio['contrato'] = $instanceContrato->where('l.id_empreendimento = ?', $relatorio['empreendimento']['id'])
            ->order(array('p.nm_pessoa', 'l.lote', 'l.quadra'))->query()->fetchAll();

        $relatorio2['contrato'] = $instanceContrato->where('l.id_empreendimento = ?', $relatorio2['empreendimento']['id'])
            ->order(array('p.nm_pessoa', 'l.lote', 'l.quadra'))->query()->fetchAll();
        $parcela_quantidade = 0;
        $parcela_normal_quantidade = 0;
        $parcela_sinal_quantidade = 0;
        $parcela_intercalada_quantidade = 0;
        $parcela_negociada_quantidade = 0;
        $pacela_total = 0;
        $count = count($relatorio2['contrato']);

        if ($count) {

            $instanceParcela = new Parcela();
            $instanceParcela = $instanceParcela->getDefaultAdapter();

            $instanceParcela2 = new ParcelaHistorico();
            $instanceParcela2 = $instanceParcela2->getDefaultAdapter();

          //Parcelas Em Negociao
            for ($j = 0; $j < $count; $j++) {
                if ($_POST['tipo'] == 'PN') {
                    $select = $instanceParcela->select()
                        ->from(TB_PARCELA, array('id_parcela', 'tp_parcela', 'acrescimo', 'desconto', 'dt_parcela', 'vl_parcela',
                        'vl_juros', 'vl_multa', 'vl_total_pago', 'dt_pagamento', 'dt_credito','nr_tipo_parcela'))
                        ->where('id_contrato = ?', $relatorio['contrato'][$j]['id_contrato'])
                        ->where('tp_parcela IN ("E", "NE", "SE", "IE", "CE")');

                    if ($_POST['de'] && $_POST['ate']) {
                        $select = $select->where('dt_parcela >= ?', Helper::getInputDate($_POST['de']))
                        ->where('dt_parcela <= ?', Helper::getInputDate($_POST['ate']));
                        $relatorio['periodo'] = $_POST['de'] . ' at&eacute; &nbsp;' . $_POST['ate'];
                    }
                    $parcela = $select->query()->fetchAll();

                    //testa se existem parcelas - RELATORIO DE PARCELAS EM NEGOCIAO
                    //Mensagem de Erros
                    if (!$parcela && $this->isAjax()) {
                        echo json_encode(array('msgErros' => utf8_encode('No existem parcelas a serem exibidas!')));
                        exit;
                    } else {
                        if ($this->isAjax()) {
                            echo 'true';
                            exit;
                        }
                    }
                    $totalParc = count($parcela);
                    if ($totalParc > 0) {
                        $relatorio['parcela'][$relatorio['contrato'][$j]['id_contrato']] = $parcela;
                        $parcela_quantidade += count($parcela);
                        $parcela_sinal_quantidade += count($parcela);
                        $parcela_sinal_quantidade += count($parcela);
                        $parcela_intercalada_quantidade += count($parcela);
                        $parcela_negociada_quantidade += count($parcela);
                        $parcela_valor = 0;
                        $parcela_total = 0;
                        for ($y = 0; $y < $totalParc; $y++) {
                            $parcela_valor += $parcela[$y]['vl_parcela'];
                            $parcela_total += is_null($parcela[$y]['vl_total_pago']) ? $parcela[$y]['vl_parcela'] + $parcela[$y]['acrescimo'] + $parcela[$y]['desconto'] : $parcela[$y]['vl_total_pago'];
                        }
                    } else {
                        unset($relatorio['contrato'][$j]);
                    }
                }else {

                    // Se o for selecionado o cliente ou for requisitado relatorio completo entao os pagamentos serao detalhados
                    if ($_POST['cliente_relatorio_parcela_paga'] != '*' || $_POST['tipo'] == 'PC') {

                        // cliente detalhado
                        $select = $instanceParcela->select()
                            ->from(TB_PARCELA, array('id_parcela', 'tp_parcela', 'acrescimo', 'desconto', 'dt_parcela', 'vl_parcela',
                                'vl_juros', 'vl_multa', 'vl_total_pago', 'dt_pagamento', 'dt_credito','nr_tipo_parcela'))
                            ->where('id_contrato = ?', $relatorio['contrato'][$j]['id_contrato'])
                            ->where('pago = ?', (($_POST["tipo"] == 'N') ? '0' : '1'));

                        //Testa se vai incluir os tipos de parcelas de pagos ou de nao pagos
                        if ($_POST['tipo'] == 'N' || $_POST['tipo'] == 'PNC') {
                            $select = $select->where('tp_parcela in ' . $tp_parcelasNPagas);
                        } else $select = $select->where('tp_parcela in ' . $tp_parcelas);

                        // cria o filtro para os tipos de pagamento
                        if ($_POST['tipo'] != 'N') {
                            $pgs = '';
                            for ($i = 0; $tp_pagamento[$i]; $i++) {
                                if ($i == 0) {
                                    $pgs = "'" . $tp_pagamento[$i] . "'";
                                } else {
                                    $pgs .= ",'" . $tp_pagamento[$i] . "'";
                                }
                            }
                            $select->where("tp_baixa in(" . $pgs . ")");
                        }

                        if ($_POST['de'] && $_POST['ate']) {
                            $select = $select->where($campoData . ' >= ?', Helper::getInputDate($_POST['de']))->where($campoData . ' <= ?', Helper::getInputDate($_POST['ate']));
                            $relatorio['periodo'] = $_POST['de'] . ' at&eacute; &nbsp;' . $_POST['ate'];
                        }
                        if ($_POST['ordena'] == 'dataPgto') {
                            $select->order(array('dt_pagamento'));
                        }

                        $parcela = $select->query()->fetchAll();

                        //testa se existem parcelas - RELATORIO DE PARCELAS NAO PAGAS e PAGAS
                        //Mensagem de Erros
                        if (!$parcela && $this->isAjax()) {
                            echo json_encode(array('msgErros' => utf8_encode('No existem parcelas a serem exibidas!')));
                            exit;
                        } else {
                            if ($this->isAjax()) {
                                echo 'true';
                                exit;
                            }
                        }

                        $totalParc = count($parcela);
                        if ($totalParc > 0) {
                            $relatorio['parcela'][$relatorio['contrato'][$j]['id_contrato']] = $parcela;
                            $parcela_quantidade += count($parcela);
                            $parcela_normal_quantidade += count($parcela);
                            $parcela_sinal_quantidade += count($parcela);
                            $parcela_intercalada_quantidade += count($parcela);
                            $parcela_negociada_quantidade += count($parcela);
                            $parcela_valor = 0;
                            $parcela_total = 0;
                            for ($y = 0; $y < $totalParc; $y++) {
                                $parcela_valor += $parcela[$y]['vl_parcela'];
                                $parcela_total += is_null($parcela[$y]['vl_total_pago']) ? $parcela[$y]['vl_parcela'] + $parcela[$y]['acrescimo'] + $parcela[$y]['desconto'] : $parcela[$y]['vl_total_pago'];
                            }
                        } else {
                            unset($relatorio['contrato'][$j]);
                        }

                        // cliente detalhado
                        $select = $instanceParcela2->select()
                            ->from(TB_PARCELA_HISTORICO, array('id_parcela', 'tp_parcela', 'acrescimo', 'desconto', 'dt_parcela', 'vl_parcela',
                                'vl_juros', 'vl_multa', 'vl_total_pago', 'dt_pagamento', 'dt_credito','nr_tipo_parcela'))
                            ->where('id_contrato = ?', $relatorio2['contrato'][$j]['id_contrato'])
                            ->where('pago = ?', (($_POST["tipo"] == 'N') ? '0' : '1'));
                        //Testa se vai incluir os tipos de parcelas de pagos ou de nao pagos
                        if ($_POST['tipo'] == 'N' || $_POST['tipo'] == 'PNC') {
                            $select = $select->where('tp_parcela in ' . $tp_parcelasNPagas);
                        } else $select = $select->where('tp_parcela in ' . $tp_parcelas);

                        // cria o filtro para os tipos de pagamento
                        if ($_POST['tipo'] != 'N') {
                            for ($i = 0; $tp_pagamento[$i]; $i++) {
                                if ($i == 0) {
                                    $pgs = "'" . $tp_pagamento[$i] . "'";
                                } else {
                                    $pgs .= ",'" . $tp_pagamento[$i] . "'";
                                }
                            }
                            $select->where("tp_baixa in(" . $pgs . ")");
                        }
                        if ($_POST['de'] && $_POST['ate']) {
                            $select = $select->where($campoData . ' >= ?', Helper::getInputDate($_POST['de']))->where($campoData . ' <= ?', Helper::getInputDate($_POST['ate']));
                            $relatorio2['periodo'] = $_POST['de'] . ' at&eacute; &nbsp;' . $_POST['ate'];
                        }
                        if ($_POST['ordena'] == 'dataPgto') {
                            $select->order(array('dt_pagamento'));
                        }

                        $parcela2 = $select->query()->fetchAll();

                        $totalParc = count($parcela2);
                        if ($totalParc > 0) {
                            $relatorio2['parcela'][$relatorio2['contrato'][$j]['id_contrato']] = $parcela2;
                            $parcela_quantidade += count($parcela2);
                            $parcela_normal_quantidade += count($parcela2);
                            $parcela_sinal_quantidade += count($parcela2);
                            $parcela_intercalada_quantidade += count($parcela2);
                            $parcela_negociada_quantidade += count($parcela2);
                            for ($y = 0; $y < $totalParc; $y++) {
                                $parcela_valor += $parcela2[$y]['vl_parcela'];
                                $parcela_total += is_null($parcela2[$y]['vl_total_pago']) ? $parcela2[$y]['vl_parcela'] + $parcela2[$y]['acrescimo'] + $parcela2[$y]['desconto'] : $parcela2[$y]['vl_total_pago'];
                            }
                        } else {
                            unset($relatorio2['contrato'][$j]);
                        }

                    } else {
                        // todos resumido
                        $select = $instanceParcela->select()
                            ->from(TB_PARCELA, array('count(id_parcela) AS quantidade_parcela',
                                'sum(acrescimo) AS total_acrescimo', 'sum(desconto) AS total_desconto',
                                'sum(vl_parcela) AS total_vl_parcela', 'sum(vl_juros) AS total_vl_juros',
                                'sum(vl_multa) AS total_vl_multa', 'sum(vl_total_pago) AS total_vl_total_pago'))
                            ->where('id_contrato = ?', $relatorio['contrato'][$j]['id_contrato'])
                            ->where('pago = ?', (($_POST["tipo"] == 'N') ? '0' : '1'));
                        //Testa se vai incluir os tipos de parcelas de pagos ou de nao pagos
                        if ($_POST['tipo'] == 'N' || $_POST['tipo'] == 'PNC') {
                            $select = $select->where('tp_parcela in ' . $tp_parcelasNPagas);
                        } else $select = $select->where('tp_parcela in ' . $tp_parcelas);

                        if ($_POST['de'] && $_POST['ate']) {
                            $select = $select->where($campoData . ' >= ?', Helper::getInputDate($_POST['de']))->where($campoData . ' <= ?', Helper::getInputDate($_POST['ate']));
                        }

                        $pgs = '';
                        for ($i = 0; $tp_pagamento[$i]; $i++) {
                            if ($i == 0) {
                                $pgs = "'" . $tp_pagamento[$i] . "'";
                            } else {
                                $pgs .= ",'" . $tp_pagamento[$i] . "'";
                            }
                        }
                        // Resumo das parcelas pagas/nao_pagas
                        $parcela = $select->query()->fetchAll();

                        //testa se existem parcelas - nao foi encontrado o tipo de relatorio que usa este if
                        if (!$parcela && $this->isAjax()) {
                            echo json_encode(array('msgErros' => utf8_encode('No existem parcelas a serem exibidas!')));
                            exit;
                        } else {
                            if ($this->isAjax()) {
                                echo 'true';
                                exit;
                            }
                        }
                        // Quantidade total de parcelas do contrato
                        $totalParcContrato = $instanceParcela->select()
                            ->from(TB_PARCELA, array('count(id_parcela) AS total'))
                            ->where('id_contrato = ?', $relatorio['contrato'][$j]['id_contrato']);
                        //Testa se vai incluir os tipos de parcelas de pagos ou de nao pagos e faz fetch
                        if ($_POST['tipo'] == 'N' || $_POST['tipo'] == 'PNC') {
                            $totalParcContrato = $totalParcContrato->where('tp_parcela in ' . $tp_parcelasNPagas)->query()->fetch();
                        } else {
                            $totalParcContrato = $totalParcContrato->where('tp_parcela in ' . $tp_parcelas)->query()->fetch();
                        }
                        $parcela_valor = 0;
                        $parcela_total = 0;
                        if (count($parcela) && $parcela[0]['quantidade_parcela'] > 0) {
                            $parcela[0]['total_parcelas_contrato'] = $totalParcContrato['total'];
                            $relatorio['parcela'][$relatorio['contrato'][$j]['id_contrato']] = $parcela;
                            $parcela_quantidade += $parcela[0]['quantidade_parcela'];
                            $parcela_valor += $parcela[0]['total_vl_parcela'];
                            $parcela_total += is_null($parcela[0]['total_vl_total_pago']) ? $parcela[0]['total_vl_parcela'] + $parcela[0]['total_acrescimo'] + $parcela[0]['total_desconto'] : $parcela[0]['total_vl_total_pago'];

                        } else {
                            unset($relatorio['contrato'][$j]);
                        }
                    }
                }
            }

            if ($relatorio['contrato'][0]['id_contrato'] && $relatorio2['contrato'][0]['id_contrato']) {
                $contador = $instanceParcela->select()->from(TB_PARCELA, 'count(*) AS qtd')->where('id_contrato = ?', $relatorio['contrato'][0]['id_contrato'])->where("tp_parcela = 'N'")->query()->fetch();
                $parcela_normal_quantidade = $contador['qtd'];
                $contador = $instanceParcela->select()->from(TB_PARCELA, 'count(*) AS qtd')->where('id_contrato = ?', $relatorio['contrato'][0]['id_contrato'])->where("tp_parcela = 'S'")->query()->fetch();
                $parcela_sinal_quantidade = $contador['qtd'];
                $contador = $instanceParcela->select()->from(TB_PARCELA, 'count(*) AS qtd')->where('id_contrato = ?', $relatorio['contrato'][0]['id_contrato'])->where("tp_parcela = 'I'")->query()->fetch();
                $parcela_intercalada_quantidade = $contador['qtd'];
                $contador = $instanceParcela->select()->from(TB_PARCELA, 'count(*) AS qtd')->where('id_contrato = ?', $relatorio['contrato'][0]['id_contrato'])->where("tp_parcela = 'G'")->query()->fetch();
                $parcela_negociada_quantidade = $contador['qtd'];

                $contador = $instanceParcela2->select()->from(TB_PARCELA_HISTORICO, 'count(*) AS qtd')->where('id_contrato = ?', $relatorio2['contrato'][0]['id_contrato'])->where("tp_parcela = 'N'")->query()->fetch();
                $parcela_normal_quantidade = $contador['qtd'];
                $contador = $instanceParcela2->select()->from(TB_PARCELA_HISTORICO, 'count(*) AS qtd')->where('id_contrato = ?', $relatorio2['contrato'][0]['id_contrato'])->where("tp_parcela = 'S'")->query()->fetch();
                $parcela_sinal_quantidade = $contador['qtd'];
                $contador = $instanceParcela2->select()->from(TB_PARCELA_HISTORICO, 'count(*) AS qtd')->where('id_contrato = ?', $relatorio2['contrato'][0]['id_contrato'])->where("tp_parcela = 'I'")->query()->fetch();
                $parcela_intercalada_quantidade = $contador['qtd'];
                $contador = $instanceParcela2->select()->from(TB_PARCELA_HISTORICO, 'count(*) AS qtd')->where('id_contrato = ?', $relatorio2['contrato'][0]['id_contrato'])->where("tp_parcela = 'G'")->query()->fetch();
                $parcela_negociada_quantidade = $contador['qtd'];

            }
        }

        $relatorio['total']['parcela'] = $parcela_quantidade;
        $relatorio['total']['parcela_normal'] = $parcela_normal_quantidade;
        $relatorio['total']['parcela_sinal'] = $parcela_sinal_quantidade;
        $relatorio['total']['parcela_intercalada'] = $parcela_intercalada_quantidade;
        $relatorio['total']['parcela_negociada'] = $parcela_negociada_quantidade;
        $relatorio['total']['valor'] = $parcela_valor;
        $relatorio['total']['total'] = $parcela_total;

        $relatorio2['total']['parcela'] = $parcela_quantidade;
        $relatorio2['total']['parcela_normal'] = $parcela_normal_quantidade;
        $relatorio2['total']['parcela_sinal'] = $parcela_sinal_quantidade;
        $relatorio2['total']['parcela_intercalada'] = $parcela_intercalada_quantidade;
        $relatorio2['total']['parcela_negociada'] = $parcela_negociada_quantidade;
        $relatorio2['total']['valor'] = $parcela_valor;
        $relatorio2['total']['total'] = $parcela_total;

        if ($relatorio['empreendimento']['porcAdmin'] > 0)
            $relatorio['total']['porcAdmin'] = $parcela_total * ($relatorio['empreendimento']['porcAdmin'] / 100);

        $relatorio['todos'] = $_POST['cliente_relatorio_parcela_paga'] == '*' ? true : false;
        $relatorio['tipo'] = $_POST['tipo'] == 'N' ? true : false;

        if ($relatorio2['empreendimento']['porcAdmin'] > 0)
            $relatorio2['total']['porcAdmin'] = $parcela_total * ($relatorio2['empreendimento']['porcAdmin'] / 100);

        $relatorio2['todos'] = $_POST['cliente_relatorio_parcela_paga'] == '*' ? true : false;
        $relatorio2['tipo'] = $_POST['tipo'] == 'N' ? true : false;


        $this->set('relatorio', $relatorio);
        $this->set('relatorio2', $relatorio2);

        $this->set('titulo', $titulo);

        if ($_POST['gera'] == 'html') {
            $this->display('relatorio');
            exit;
        }
        $this->display("relatorio");
        if ($_POST['gera'] == 'pdf') {
            $this->displayPDF('Relatorio_' . time() . '.pdf');
        }
    }


    public function gerarRelPgtoCliente()
    {
        $tb_parcelas = new Parcela();
        $tb_contrato = new Contrato();
        $tb_empreendimento = new Empreendimento();
        $idEmp = $_POST['empreendimento_relatorio_parcela_paga'];
        $tp_parcelas = array();

        if (count($_POST['tp_parcela'])) {
            foreach ($_POST['tp_parcela'] as $tipo)
                $tp_parcelas[] = "'" . $tipo . "'";
            $tp_parcelas = '(' . implode(',', $tp_parcelas) . ')';
        }

        $filtroCliente = "1";
        if ($_POST['cliente_relatorio_parcela_paga'] != '*') {
            $filtroCliente = 'c.id_pessoa = ' . $_POST['cliente_relatorio_parcela_paga'];
        }


        $empreendimento = new Empreendimento();
        $empreendimentoInfo = $empreendimento->getAdapter()
            ->select()->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento','ds_path_logo','nm_empreendimento'))
            ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
            ->where('id = '. $idEmp)
            ->query()->fetch();
        $this->set("empreendimentoInfo", $empreendimentoInfo);

        $contratos = $tb_contrato->getAdapter()->select()->distinct()
            ->from(array('c' => TB_CONTRATO), array('vl_contrato' => '(nr_parcela*c.vl_parcela)', 'dt_contrato', 'id_contrato' => 'id'))
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('quadra', 'lote'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa', 'tp_pessoa'))
            ->join(array('pa' => TB_PARCELA), 'pa.id_contrato = c.id', null)
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', 'nr_cpf')
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pj.id_pessoa = p.id', 'nr_cnpj')
            ->where('id_empreendimento = ' . $idEmp)
            ->where($filtroCliente)
            ->where("dt_pagamento between '" . Helper::getInputDate($_POST['de']) . "' and '" . Helper::getInputDate($_POST['ate']) . "'")
            ->order('p.nm_pessoa')->query()->fetchAll();

            $baixas = $_POST['tp_pagamento'];
        isset($tipo['B']) ? $tipo['B'] = 'Banco' : '';
        isset($tipo['T']) ? $tipo['T'] = 'Tesouraria' : '';
        isset($tipo['O']) ? $tipo['O'] = 'Outros' : '';
        if (count($baixas) == 3) {
            $filtroBaixa = "tp_baixa in ('O','T','B')";
            $tipo_pagamento = "Todos";
        } else {
            $filtroBaixa = '';
            $tipo_pagamento = '';
            for ($i = 0; $baixas[$i]; $i++) {
                if ($i == 0) {
                    $filtroBaixa = "'" . $baixas[$i] . "'";
                    $tipo_pagamento = $tipo[$baixas[$i]];
                } else {
                    $filtroBaixa .= ",'" . $baixas[$i] . "'";
                    $tipo_pagamento .= " e " . $tipo[$baixas[$i]];
                }
            }
            $filtroBaixa = "tp_baixa in (" . $filtroBaixa . ")";
        }

        for ($i = 0; $i < count($contratos); $i++) {
            $contratos[$i]['parcelas'] = $tb_parcelas->fetchAll("id_contrato = " . $contratos[$i]['id_contrato'] . " AND pago = '1' AND $filtroBaixa
                                                                AND dt_pagamento between '" . Helper::getInputDate($_POST['de']) . "' and '" . Helper::getInputDate($_POST['ate']) . "' AND tp_parcela in " . $tp_parcelas, 'dt_pagamento ASC')->toArray();
        }

        for ($i = 0; $i < count($contratos); $i++) {
            $contratos[$i]['parcelas'] = $tb_parcelas->fetchAll("id_contrato = " . $contratos[$i]['id_contrato'] . " AND pago = '1' AND $filtroBaixa
                                                                AND dt_pagamento between '" . Helper::getInputDate($_POST['de']) . "' and '" . Helper::getInputDate($_POST['ate']) . "' AND tp_parcela in " . $tp_parcelas, 'dt_pagamento ASC')->toArray();
        }

        $emp = $tb_empreendimento->fetchRow('id = ' . $idEmp)->toArray();
        $relatorio['clientes'] = $contratos;
        $relatorio['empreendimento'] = $emp['nm_empreendimento'];
        $relatorio['periodo'] = "de {$_POST['de']} a {$_POST['ate']}";
        $relatorio['tipo_pagamento'] = $tipo_pagamento;

        $this->set('relatorio', $relatorio);
        $this->_lastView = 'relPagamentoClientes';

        //Consulta para pegar a logo do cliente.
        $clienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $clienteAcade->fetchRow()->toArray());

        //Mensagem de Erros
        if (count($contratos) == 0 && $this->isAjax()) {
            echo json_encode(array('msgErros' => utf8_encode('No existem parcelas a serem exibidas!')));
            exit;
        } else {
            if ($this->isAjax()) {
                echo 'true';
                exit;
            }
        }

        if ($_POST['gera'] == 'pdf') {
            $this->display('relPagamentoClientes');
            $this->displayMPDF('Relatorio_' . time() . '.pdf');
        } elseif ($_POST['gera'] == 'xls') {
            foreach ($relatorio['clientes'] as $cliente) {
                foreach ($cliente AS $contrato) {
                    if ($cliente['tp_pessoa'] == 'J') {
                        $cpf_cnpj = $cliente['nr_cnpj'];
                    } else {
                        $cpf_cnpj = $cliente['nr_cpf'];
                    }

                    $vl_pago = $cliente['vl_pago'];
                    if (!$vl_pago) {
                        $vl_pago = '0,00';
                    }
                }

                $totalParcelas = count($cliente['parcelas']);
                if ($totalParcelas > 0) {
                    $colunas = [
                        ' ',
                        'CPF/CNPJ',
                        'Contrato',
                        'Data',
                        'Valor',
                        Helper::exibeAbreviacao(($empreendimentoInfo['ds_subgrupo'] != '') ? $empreendimentoInfo['ds_subgrupo'] : ''),
                        Helper::exibeAbreviacao(($empreendimentoInfo['ds_grupo'] != '') ? $empreendimentoInfo['ds_grupo'] : ''),
                        ' ',
                        ' '
                    ];
                    $linhas[] = [
                        $cliente['nm_pessoa'],
                        $cpf_cnpj,
                        $cliente['id_contrato'],
                        Helper::getDate($cliente['dt_contrato']),
                        number_format($cliente['vl_contrato'], 2, ',', '.'),
                        $cliente['lote'],
                        $cliente['quadra']
                    ];
                    $linhas[] = [''];
                    $linhas[] = [
                        'Baixa',
                        'Parcela',
                        'Vencto',
                        'Pagto',
                        'Valor',
                        'Multa',
                        'Juros',
                        'Descto',
                        'Total'
                    ];
                    $linhas[] = [''];
                    foreach ($cliente['parcelas'] as $parcela) {
                        $linhas[] = [
                            $parcela['id_parcela_contrato'],
                            $parcela['tp_parcela'] . ' ' . $parcela['id_parcela'],
                            Helper::getDate($parcela['dt_parcela']),
                            Helper::getDate($parcela['dt_pagamento']),
                            number_format($parcela['vl_parcela'], 2, ',', '.'),
                            number_format($parcela['vl_multa'], 2, ',', '.'),
                            number_format($parcela['vl_juros'], 2, ',', '.'),
                            number_format($parcela['desconto'], 2, ',', '.'),
                            number_format($parcela['vl_total_pago'], 2, ',', '.'),
                        ];
                    }
                    $linhas[] = [''];
                }
            }
            $this->geraExcel($colunas, $linhas);
        } else {
            $this->display('relPagamentoClientes');
        }
    }

    private function gerarRelPrimeirasParcelas()
    {

        $tb_empreendimento = new Empreendimento();
        $adapter = $tb_empreendimento->getAdapter();

        $idEmp = $_POST['empreendimento_relatorio_parcela_paga'];

        $cliente = $_POST['cliente_relatorio_parcela_paga'];

        $baixas = $_POST['tp_pagamento'];

        $tp_parcelas = array();
        if (count($_POST['tp_parcela'])) {
            foreach ($_POST['tp_parcela'] as $tipo)
                $tp_parcelas[] = "'" . $tipo . "'";
            $tp_parcelas = '(' . implode(',', $tp_parcelas) . ')';
        }

        $periodo = '1';
        if ($_POST['de'] && $_POST['ate']) {
            $periodo = "dt_parcela between '" . Helper::getInputDate($_POST['de']) . "' and '" . Helper::getInputDate($_POST['ate']) . "'";
            $periodoTexto = 'De: ' . $_POST['de'] . ' at&eacute; &nbsp;' . $_POST['ate'];
        }


        $empreendimentoInfo = $tb_empreendimento->getAdapter()->select()->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento'))
            ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))->query()->fetch();
        $this->set("empreendimentoInfo", $empreendimentoInfo);

        $filtroCliente = '1';
        if ($cliente != '*') {
            $filtroCliente = 'c.id_pessoa = ' . $cliente;
        }

        $clientes = $adapter->select()->distinct()
            ->from(array('c' => TB_CONTRATO), null)
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('quadra', 'lote'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa', 'id'))
            ->join(array('pa' => TB_PARCELA), 'pa.id_contrato = c.id', array('dt_parcela', 'tp_parcela', 'vl_parcela', 'id_contrato', 'id_parcela','nr_tipo_parcela'))
            ->where('id_empreendimento = ' . $idEmp)
            ->where("id_parcela = '1'")
            ->where($filtroCliente)
            ->where($periodo)
            ->where("tp_parcela in $tp_parcelas")
            ->where("pago = '0'")
            ->order('pa.dt_parcela')->query()->fetchAll();

        //Mensagem de Erros
        if (!$clientes && $this->isAjax()) {
            echo json_encode(array('msgErros' => utf8_encode('No existem parcelas a serem exibidas!')));
            exit;
        } else {
            if ($this->isAjax()) {
                echo 'true';
                exit;
            }
        }
        function sortByOrder($a, $b) {
            return $a['dt_parcela'] <= $b['dt_parcela'];
        }

        usort($clientes, 'sortByOrder');

        $arrCli = array();
        foreach ($clientes as $cli) {
            $arrCli[$cli['nm_pessoa']][$cli['id_contrato']] = $cli;
            $arrCli[$cli['nm_pessoa']][$cli['id_contrato']]['parcelas'][] = $cli;
        }
        $clientes = $arrCli;
        $this->set('clientes', $clientes);
        $this->set('periodo', $periodoTexto);
        $this->set('empreendimento', $tb_empreendimento->fetchRow('id = ' . $idEmp));

        $this->display('gerarRelPrimeirasParcelas');
        if ($_POST['gera'] == 'html') {
            $this->display('gerarRelPrimeirasParcelas');
            exit;
        }
        $this->displayMPDF('Relatorio_' . time() . '.pdf');
        $this->indexAction();
    }

    private function gerarRelUltimasParcelas()
    {

        $tb_empreendimento = new Empreendimento();
        $adapter = $tb_empreendimento->getAdapter();

        $idEmp = $_POST['empreendimento_relatorio_parcela_paga'];

        $cliente = $_POST['cliente_relatorio_parcela_paga'];

        $baixas = $_POST['tp_pagamento'];

        $tp_parcelas = array();
        if (count($_POST['tp_parcela'])) {
            foreach ($_POST['tp_parcela'] as $tipo)
                $tp_parcelas[] = "'" . $tipo . "'";
            $tp_parcelas = '(' . implode(',', $tp_parcelas) . ')';
        }

        $periodo = '1';
        if ($_POST['de'] && $_POST['ate']) {
            $periodo = "dt_parcela > '" . Helper::getInputDate($_POST['de']) .  "'";
            $periodoTexto = 'De: ' . $_POST['de'] . ' at&eacute; &nbsp;' . $_POST['ate'];
        }

        $empreendimentoInfo = $tb_empreendimento->getAdapter()->select()->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento'))
            ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))->query()->fetch();
        $this->set("empreendimentoInfo", $empreendimentoInfo);

        $filtroCliente = '1';
        if ($cliente != '*') {
            $filtroCliente = 'c.id_pessoa = ' . $cliente;
        }
        $clientes = $adapter->select()->distinct()
            ->from(array('c' => TB_CONTRATO), null)
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('quadra', 'lote'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa', 'id'))
            ->join(array('pa' => TB_PARCELA), 'pa.id_contrato = c.id', array('dt_parcela', 'tp_parcela', 'vl_parcela', 'id_contrato', 'id_parcela','nr_tipo_parcela'))
            ->where('id_empreendimento = ' . $idEmp)
            ->where($filtroCliente)
            ->where($periodo)
            ->where("tp_parcela in $tp_parcelas")
            ->where("pago = '0'")
            ->order('pa.dt_parcela')->query()->fetchAll();

        function sortByOrder($a, $b) {
            return $a['dt_parcela'] >= $b['dt_parcela'];
        }

        usort($clientes, 'sortByOrder');

        $arrCli = array();
        foreach ($clientes as $cli) {
            $arrCli[$cli['nm_pessoa']][$cli['id_contrato']] = $cli;
            $arrCli[$cli['nm_pessoa']][$cli['id_contrato']]['parcelas'][] = $cli;
        }
        foreach($arrCli as $cl => $cliente){
            foreach($cliente as $c => $pess){
                if($pess['dt_parcela'] < Helper::getInputDate($_POST['de']) || $pess['dt_parcela'] > Helper::getInputDate($_POST['ate'])){
                    unset($arrCli[$cl]);
                }
            }
        }
        $clientes = $arrCli;

        //Mensagem de Erros
        if (!$clientes && $this->isAjax()) {
            echo json_encode(array('msgErros' => utf8_encode('No existem parcelas a serem exibidas!')));
            exit;
        } else {
            if ($this->isAjax()) {
                echo 'true';
                exit;
            }
        }
        $this->set('clientes', $clientes);
        $this->set('periodo', $periodoTexto);
        $this->set('empreendimento', $tb_empreendimento->fetchRow('id = ' . $idEmp));


        $this->display('gerarRelUltimasParcelas');
        if ($_POST['gera'] == 'html') {
            $this->display('gerarRelUltimasParcelas');
            exit;
        }
        $this->displayMPDF('Relatorio_' . time() . '.pdf');
        $this->indexAction();
    }

    public function gerarEmNegociacao()
    {

        $tb_empreendimento = new Empreendimento();

        $idEmp = $_POST['empreendimento_relatorio_parcela_paga'];
        $emp = $tb_empreendimento->fetchRow('id = ' . $idEmp)->toArray();
        $relatorio['empreendimento'] = $emp['nm_empreendimento'];

        $adapter = $tb_empreendimento->getAdapter();

        $parcelasTotal = $adapter->select()->from(array('pa' => TB_PARCELA), array('rows' => '(COUNT(pa.vl_parcela))', 'total' => '(SUM(pa.vl_parcela))'))->join(array('c' => TB_CONTRATO), 'c.id = id_contrato', null);
        $parcelasPagas = $adapter->select()->from(array('pa' => TB_PARCELA), array('rows' => '(COUNT(pa.vl_parcela))',
            'total' => '(SUM(pa.vl_parcela))',
            'juros' => '(SUM(IF(vl_juros is null,0.00,vl_juros)))',
            'multa' => '(SUM(IF(vl_multa is null,0.00,vl_multa)))',
            'desc' => '(SUM(IF(vl_multa is null,0.00,pa.desconto)))',
            'acr' => '(SUM(IF(vl_multa is null,0.00,pa.acrescimo)))',
        ))->join(array('c' => TB_CONTRATO), 'c.id = id_contrato', null)->where('pago = "1"');
        $parcelasnPagas = $adapter->select()->from(array('pa' => TB_PARCELA), array('rows' => '(COUNT(pa.vl_parcela))', 'total' => '(SUM(pa.vl_parcela))'))->join(array('c' => TB_CONTRATO), 'c.id = id_contrato', null)->where('pago = "0"');

        $idEmp = $_POST['empreendimento_relatorio_parcela_paga'];

        if ($_POST['cliente_relatorio_parcela_paga'] != '*') {
            $filtroCliente = 'c.id_pessoa = ' . $_POST['cliente_relatorio_parcela_paga'];
            $parcelasTotal = $parcelasTotal->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', 'nm_pessoa')->where($filtroCliente);
            $parcelasPagas = $parcelasPagas->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', 'nm_pessoa')->where($filtroCliente);
            $parcelasnPagas = $parcelasnPagas->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', 'nm_pessoa')->where($filtroCliente);
        }

        $baixas = $_POST['tp_pagamento'];
        $tipo['B'] = 'Banco';
        $tipo['T'] = 'Tesouraria';
        $tipo['O'] = 'Outros';
        if (count($baixas) == 1) {
            $filtroBaixa = "tp_baixa = '" . $baixas[0] . "'";
            $tipo_pagamento = $tipo[$baixas[0]];
        } elseif (count($baixas) == 2) {
            $filtroBaixa = "tp_baixa in ('" . $baixas[0] . "','" . $baixas[1] . "')";
            $tipo_pagamento = "{$tipo[$baixas[0]]} ou {$tipo[$baixas[1]]}";
        } else {
            $filtroBaixa = "tp_baixa in ('" . $baixas[0] . "','" . $baixas[1] . "','" . $baixas[2] . "')";
            $tipo_pagamento = "{$tipo[$baixas[0]]}, {$tipo[$baixas[1]]} ou {$tipo[$baixas[2]]}";
        }
        $relatorio['tipo_pagamento'] = $tipo_pagamento;

        if ($_POST['de'] && $_POST['ate']) {
            $parcelasTotal = $parcelasTotal->where('dt_parcela' . ' >= ?', Helper::getInputDate($_POST['de']))->where('dt_parcela' . ' <= ?', Helper::getInputDate($_POST['ate']));
            $parcelasPagas = $parcelasPagas->where('dt_parcela' . ' >= ?', Helper::getInputDate($_POST['de']))->where('dt_parcela' . ' <= ?', Helper::getInputDate($_POST['ate']));
            $parcelasnPagas = $parcelasnPagas->where('dt_parcela' . ' >= ?', Helper::getInputDate($_POST['de']))->where('dt_parcela' . ' <= ?', Helper::getInputDate($_POST['ate']));
            $relatorio['periodo'] = $_POST['de'] . ' at&eacute; &nbsp;' . $_POST['ate'];
        }

        $parcelasTotal = $parcelasTotal->join(array('l' => TB_LOTES), 'c.id_lote = l.id')->where('id_empreendimento = ' . $idEmp);
        $parcelasPagas = $parcelasPagas->join(array('l' => TB_LOTES), 'c.id_lote = l.id')->where('id_empreendimento = ' . $idEmp);
        $parcelasnPagas = $parcelasnPagas->join(array('l' => TB_LOTES), 'c.id_lote = l.id')->where('id_empreendimento = ' . $idEmp);

        $parcelasTotal = $parcelasTotal->where('tp_parcela in ("N","S","I","Q")')->query()->fetch();
        $parcelasPagas = $parcelasPagas->where('tp_parcela in ("N","S","I","Q")')->query()->fetch();
        $parcelasnPagas = $parcelasnPagas->where('tp_parcela in ("N","S","I","Q")')->query()->fetch();

        $relatorio['cliente'] = $parcelasTotal['nm_pessoa'];
        $relatorio['parcSjuros'] = $parcelasPagas['total'];
        $relatorio['totalSjuros'] = $parcelasTotal['total'];
        $relatorio['parcPagas'] = $parcelasPagas['total'] + $parcelasPagas['juros'] + $parcelasPagas['multa'] + $parcelasPagas['acr'] - $parcelasPagas['desc'];
        $relatorio['parcNPagas'] = $parcelasnPagas['total'];
        $relatorio['totalParcelas'] = $parcelasTotal['rows'];
        $relatorio['totalParcelasPagas'] = $parcelasPagas['rows'];
        $relatorio['totalParcelasNPagas'] = $parcelasnPagas['rows'];
        $relatorio['parcJuros'] = $parcelasPagas['juros'];
        $relatorio['parcMulta'] = $parcelasPagas['multa'];
        $relatorio['desc'] = $parcelasPagas['desc'];
        $relatorio['acr'] = $parcelasPagas['acr'];
        $relatorio['parcTotal'] = ($parcelasTotal['total'] + $parcelasPagas['juros'] + $parcelasPagas['multa'] + $parcelasPagas['acr'] - $parcelasPagas['desc']);
        $relatorio['percPagas'] = ($parcelasPagas['total']) ? round(($relatorio['parcPagas'] * 100) / $relatorio['parcTotal'], 2) : 0;
        $relatorio['percNPagas'] = ($parcelasTotal['total']) ? 100 - $relatorio['percPagas'] : 0;

        $this->set('relatorio', $relatorio);

        $this->_lastView = 'relPercentuais';
        if ($_POST['gera'] == 'html') {
            $this->_lastView = 'relPercentuais';
            exit;
        }
        $this->display('relPercentuais');
        $this->displayMPDF('Relatorio_' . time() . '.pdf');
    }

    public function gerarRelNegociadasPagas()
    {
        $tb_parcelas = new Parcela();
        $tb_contrato = new Contrato();
        $tb_empreendimento = new Empreendimento();
        $idEmp = $_POST['empreendimento_relatorio_parcela_paga'];


        $filtroCliente = "1";
        if ($_POST['cliente_relatorio_parcela_paga'] != '*') {
            $filtroCliente = 'c.id_pessoa = ' . $_POST['cliente_relatorio_parcela_paga'];
        }


        $empreendimento = new Empreendimento();
        $empreendimentoInfo = $empreendimento->getAdapter()
            ->select()->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento','ds_path_logo','nm_empreendimento'))
            ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
            ->where('id = '. $idEmp)
            ->query()->fetch();
        $this->set("empreendimentoInfo", $empreendimentoInfo);

        $contratos = $tb_contrato->getAdapter()->select()->distinct()
            ->from(array('c' => TB_CONTRATO), array('vl_contrato' => '(nr_parcela*c.vl_parcela)', 'dt_contrato', 'id_contrato' => 'id'))
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('quadra', 'lote'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa', 'tp_pessoa'))
            ->join(array('pa' => TB_PARCELA), 'pa.id_contrato = c.id', null)
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', 'nr_cpf')
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pj.id_pessoa = p.id', 'nr_cnpj')
            ->where('id_empreendimento = ' . $idEmp)
            ->where($filtroCliente)
            ->where("dt_pagamento between '" . Helper::getInputDate($_POST['de']) . "' and '" . Helper::getInputDate($_POST['ate']) . "'")
            ->order('p.nm_pessoa')->query()->fetchAll();

            $baixas = $_POST['tp_pagamento'];
        if (count($baixas) == 3) {
            $filtroBaixa = "tp_baixa in ('O','T','B')";
            $tipo_pagamento = "Todos";
        } else {
            $filtroBaixa = '';
            $tipo_pagamento = '';
            for ($i = 0; $baixas[$i]; $i++) {
                if ($i == 0) {
                    $filtroBaixa = "'" . $baixas[$i] . "'";
                } else {
                    $filtroBaixa .= ",'" . $baixas[$i] . "'";
                }
            }
            $filtroBaixa = "tp_baixa in (" . $filtroBaixa . ")";
        }
        for ($i = 0; $i < count($contratos); $i++) {
            
            $contratos[$i]['parcelas'] = $tb_parcelas->getAdapter()->select()
                ->from(array('P' => TB_PARCELA), array('*'))
                ->joinLeft(array('N' => TB_NEGOCIACAO), 'P.id_negociacao = N.id', array('nr_quantidade_parcela', 'logNegociacao' =>'log'))
                // ->where('P.id_contrato = ' . $contratos[$i]['id_contrato'])
                ->where("P.id_contrato = " . $contratos[$i]['id_contrato'] . " AND P.pago = '1' AND " . $filtroBaixa ." AND P.dt_pagamento between '" . Helper::getInputDate($_POST['de']) . "' and '" . Helper::getInputDate($_POST['ate']) . "' AND P.tp_parcela = 'G' ", 'P.dt_pagamento ASC')
                ->query()->fetchAll();
            $contratos[$i]['parcelasNeg'] = $tb_parcelas->fetchAll("id_contrato = " . $contratos[$i]['id_contrato'] . " AND  tp_parcela in ('NE', 'SE', 'IE', 'CE', 'E')", 'dt_parcela ASC')->toArray();
            if($contratos[$i]['parcelas']){
                $contratoParcela[$i] = $contratos[$i]['parcelas'];
            }
        }


        $emp = $tb_empreendimento->fetchRow('id = ' . $idEmp)->toArray();
        $relatorio['clientes'] = $contratos;
        $relatorio['empreendimento'] = $emp['nm_empreendimento'];
        $relatorio['periodo'] = "de {$_POST['de']} a {$_POST['ate']}";
        $relatorio['tipo_pagamento'] = $tipo_pagamento;

        $this->set('relatorio', $relatorio);
        $this->_lastView = 'relNegociadasPagas';

        //Consulta para pegar a logo do cliente.
        $clienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $clienteAcade->fetchRow()->toArray());

        //Mensagem de Erros
        if (count($contratoParcela) == 0 && $this->isAjax()) {
            echo json_encode(array('msgErros' => utf8_encode('No existem parcelas a serem exibidas!')));
            exit;
        } else {
            if ($this->isAjax()) {
                echo 'true';
                exit;
            }
        }

        if ($_POST['gera'] == 'pdf') {
            $this->display('relNegociadasPagas');
            $this->displayMPDF('Relatorio_' . time() . '.pdf');
        }
    }

    public function clienteParcelasAction()
    {
        $id_empreendimento = $_POST['id_empreendimento'];
        $instanceLote = new Lote();
        $selectLotes = $instanceLote->getDefaultAdapter()->select();
        $clientes = $selectLotes->from(array('l'=>TB_LOTES), array('id_lote'=>'id','id_empreendimento'))
            ->join(array('c'=>TB_CONTRATO), 'l.id = c.id_lote', array('id','id_pessoa'))
            ->join(array('p'=>TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa','id'))
            ->where('l.id_empreendimento = ?', $id_empreendimento)->order('p.nm_pessoa')->group('p.id')->query()->fetchAll();

        $lista[] = array('id'=>'','text'=>'');
        $lista[] = array('id'=>'*','text'=>'Todos');
        foreach ($clientes as $cliente) {
            $lista[] = array(
                'id' => $cliente['id'],
                'text' => utf8_encode($cliente['nm_pessoa']),
            );
        }
        echo json_encode($lista);
    }

    public function validarAction()
    {
        //validao vazio
        $campos = array("empreendimento_relatorio_parcela_paga", "cliente_relatorio_parcela_paga","de","ate");
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "empreendimento_relatorio_parcela_paga" :
                        $msg = "O campo Empreendimento  obrigatrio.";
                        break;
                    case "cliente_relatorio_parcela_paga" :
                        $msg = "O campo Cliente  obrigatrio.";
                        break;
                    case "de" :
                        $msg = "O campo Data Inicial  obrigatrio.";
                        break;
                    case "ate" :
                        $msg = "O campo Data Final  obrigatrio.";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }
        if (count($_POST['tp_pagamento']) == 0)
            $this->_helper->addMensagem('tp_pagamento', 'Selecione pelo menos um tipo de pagamento.');
        if (count($_POST['tp_parcela']) == 0)
            $this->_helper->addMensagem('tp_parcela', 'Selecione pelo menos um tipo de parcela.');

        if ($_POST['de'] && $_POST['ate'] == '') {
            $msg = 'Quando a data "apartir de:" for preenchida a data "at:" deve ser preenchida.';
            $this->_helper->addMensagem('data', $msg);
        }

        //Mensagem de Erros
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            return !(count($this->_helper->getMensagens()) > 0);
        }

    }

}