<?php

/**
 * Description of CartasEnviadasController
 *
 * @author acade
 */
class RelJuridicoController extends Controller
{

    protected $tb_empreendimento;
    protected $tb_contrato;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_empreendimento = new Empreendimento();
        $this->tb_contrato = new Contrato();
    }

    public function indexAction()
    {
        $total_valor = 0;
        $itensContrato = 0;
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());
        if ($this->_isPost && $this->validar()) {
            ini_set('memory_limit', '3000M');
            set_time_limit(0);
            
            $tb_empreendimento = new Empreendimento();
            $empCliente = $tb_empreendimento->fetchRow('id = ' . $_POST['empreendimento']);
            $this->set('empCliente', $empCliente);
            
            if(count($_POST['fl_tipo']) == 2){
                $processo = '("A", "R")';
            }elseif(count($_POST['fl_tipo']) == 0){
                $processo = '';
            }else{
                $processo = '("'. $_POST['fl_tipo'][0] . '")';
            }
            $listaJuridico = Juridico::getListaRelatorio($_POST['empreendimento'], $_POST['id_Contrato'], $processo, $_POST['id_tipo_audiencia']);
            $this->set('listaJuridico', $listaJuridico);
            
            if(!$listaJuridico){
                $this->_helper->addMensagem ( 'index', 'No h dados com os critrios selecionados.');
                $this->carregarDados();
                $this->display("index");
            }else{
                if($_POST['tipoRelatorio'] == 'pdf'){
                    $this->display('relatorio');
                    $this->displayMPDF('juridico' . time() . '.pdf');
                }else{
                    for ($i = 0 ; $i < count($listaJuridico); $i ++){

                        $colunas = [
                            'Cliente',
                            'Contrato',
                            'Quadra',
                            'Lote',
                            'Tipo',
                            'Audincia',
                            'Data de notificao',
                            'Data da audincia',
                            'Processo',
                            'Resumo do processo',
                            'Local'
                        ];

                        $linhas[] = [
                            $listaJuridico[$i]['nm_pessoa'],
                            $listaJuridico[$i]['id_contrato'],
                            $listaJuridico[$i]['quadra'],
                            $listaJuridico[$i]['lote'],
                            $listaJuridico[$i]['fl_tipo'] == 'R' ? 'Ru' : 'Autor',
                            $listaJuridico[$i]['tipoAudiencia'],
                            Helper::dataParaBrasil($listaJuridico[$i]['dt_notificacao']),
                            Helper::dataParaBrasil($listaJuridico[$i]['dt_audiencia']),
                            $listaJuridico[$i]['ds_processo'],
                            $listaJuridico[$i]['ds_resumo'],
                            $listaJuridico[$i]['ds_local']
                        ];
                    }
                    $this->geraExcel($colunas, $linhas); 
                }
                
            }
            

            
        } else {
            $this->carregarDados();
            $this->display("index");
        }
    }

    private function carregarDados()
    {
        
        $empreendimentos = $this->tb_empreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('nm_empreendimento', 'id'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }
        
        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        $this->set('empreendimentos', $empreendimentos);
        $this->set('tpAudiencia', Db_TabelaAgrupada::findByTabelaId(18));
    }


    private function validar()
    {
        $campos = array('empreendimento', 'id_Contrato');

        foreach ($campos as $cp) {
            if ($_POST[$cp] == "") {
                $this->_helper->addMensagem('fail', 'Todos os campos so obrigatrios.');
                return false;
            }
        }
        
        return true;
    }

    public function contratoByEmpreendimentoAction()
    {
        $listaJuridico = Juridico::getLista($_POST['id_empreendimento']);

        $lista = array();
        $lista[] = ['id' =>  '*', 'text' => 'Todos'];
        
        foreach ($listaJuridico as $juridico) {
            $lista[] = array('id' => $juridico['id_juridico'],
                'text' => utf8_encode($juridico['nm_pessoa']) . ' - Contrato: ' . utf8_encode($juridico['id_contrato']));
        }
        echo json_encode($lista);
    }

}

?>