<?php

class RelContatoController extends Controller
{

    public function indexAction()
    {

        $this->set("status", Db_TabelaAgrupada::findByField("idTabela", Db_TabelaAgrupada::TABLE_STATUS_CONTATO, "descricao"));

        //Busca os usuarios do sistema para montar o select
        $usuarios = Db_Usuario::findLista();

        $listaUsuarios = array();
        foreach($usuarios as $k => $user){
            $listaUsuarios[$k]['nome'] = ucfirst($user->getLogin());
            $listaUsuarios[$k]['id'] = $user->getId();
        }

        asort($listaUsuarios);
        $this->set('usuarios', $listaUsuarios);
        //instancia as classes necessrias
        $instanceEmpreendimento = new Empreendimento();
        $empreendimento = $instanceEmpreendimento->getDefaultAdapter();

        $empreendimento = $empreendimento->select()->distinct('e.id')
            ->from(array('e' => TB_EMPREENDIMENTO), array('empreendimento_nome' => 'e.nm_empreendimento', 'empreendimento_id' => 'e.id'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {
            }
        }
        $empreendimento = $empreendimento->order('empreendimento_nome')->query()->fetchAll();

        $this->set('empreendimentos', $empreendimento);

        $this->display('form');
    }

    public function imprimirAction()
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        $TB_RELACIONAMENTO = new Relacionamento();
        $tb_empreendimento = new Empreendimento();
        $adapter = $tb_empreendimento->getAdapter();

        // setandos os filtros
        $filtroContato[] = "e.id = '" . $_POST["idEmpreendimento"] . "'";
        if ($_POST["idContrato"] != "*") {
            $filtroContato[] = "idContrato = '" . $_POST["idContrato"] . "'";
        }
        if ($_POST["idUsuario"] != "*") {
            $filtroContato[] = " usuario = '" . $_POST["idUsuario"] . "'";
        }
        if ($_POST["tipoContato"][0] != "*") {
            $tipoContato = implode('","', $_POST['tipoContato']);
            $filtroContato[] = 'agr_idStatus IN ("' . $tipoContato . '")';
        }

        if ($_POST["tpOrdenacao"] == '1')
        {
            if ($_POST["dataDe"]) {
                $filtroContato[] = "data >= '" . Helper::getInputDate($_POST["dataDe"]) . "'";
            }
            if ($_POST["dataAte"]) {
                $filtroContato[] = "data <= '" . Helper::getInputDate($_POST["dataAte"]) . "'";
            }
        } else {
            if ($_POST["dataDe"]) {
                $filtroContato[] = "dt_retorno >= '" . Helper::getInputDate($_POST["dataDe"]) . "'";
            }
            if ($_POST["dataAte"]) {
                $filtroContato[] = "dt_retorno <= '" . Helper::getInputDate($_POST["dataAte"]) . "'";
            }
        }
        $filtroContato = implode(" AND ", $filtroContato);
        $contatos = $TB_RELACIONAMENTO->getAdapter()->select()->from(array("c" => TB_RELACIONAMENTO))
            ->join(array("cr" => TB_CONTRATO), "c.idContrato = cr.id", "id")
            ->join(array("l" => TB_LOTES), "cr.id_lote = l.id", array("lote", "quadra"))
            ->join(array("p" => TB_PESSOA), "p.id = cr.id_pessoa", "nm_pessoa")
            ->join(array("e" => TB_EMPREENDIMENTO), "l.id_empreendimento = e.id")
            ->join(array("a" => TB_AGRUPADA), "a.idCampo = c.agr_idStatus AND idTabela = '" . Db_TabelaAgrupada::TABLE_STATUS_CONTATO . "'", "descricao")
            ->where($filtroContato)->order(array("p.nm_pessoa", "c.data DESC"))->query()->fetchAll();
 
        $empreendimento = $contatos[0]["nm_empreendimento"];
        $dados = array();

        foreach ($contatos as $contato) {
            $dados[$contato["idContrato"]]["cliente"] = $contato["nm_pessoa"];
            $dados[$contato["idContrato"]]["lote"] = $contato["lote"];
            $dados[$contato["idContrato"]]["quadra"] = $contato["quadra"];
            $dados[$contato["idContrato"]]["contato"][] = array("data" => Helper::getDate($contato["data"]),
                "assunto" => $contato["assunto"],
                "usuario" => isset($contato['usuario']) ? Pessoa::findNomeById($contato["usuario"]) : null,
                "situacao" => $contato["descricao"],
                "dtRetorno" => Helper::getDate($contato['dt_retorno'])
            );
        }

        $empreendimentoInfo = $tb_empreendimento->getAdapter()->select()->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento', 'ds_path_logo'))
            ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
            ->where('em.id = '.$_POST["idEmpreendimento"])
            ->query()->fetch();
        $this->set("empreendimentoInfo", $empreendimentoInfo);

        // dados que sero utilizados pelo relatrio
        $this->set("empreendimento", $empreendimento);
        $this->set("dados", $dados);
        if ($_POST['assinatura'] == '1') {
            $this->set("ass", '1');
        }

        if ($this->_isPost) {
            $this->displayMPDF("imprimir.pdf");
        } else {
            //Busca os usuarios do sistema para montar o select
            $usuarios = Db_Usuario::findLista();

            $listaUsuarios = array();
            foreach($usuarios as $k => $user){
                $listaUsuarios[$k]['nome'] = ucfirst($user->getLogin());
                $listaUsuarios[$k]['id'] = $user->getId();
            }

            asort($listaUsuarios);
            $this->set('usuarios', $listaUsuarios);

            //instancia as classes necessrias
            $instanceEmpreendimento = new Empreendimento();
            $empreendimento = $instanceEmpreendimento->getDefaultAdapter();

            $empreendimento = $empreendimento->select()->distinct('e.id')
                ->from(array('e' => TB_EMPREENDIMENTO), array('empreendimento_nome' => 'e.nm_empreendimento', 'empreendimento_id' => 'e.id'));

            //verifica se o usuario tem o perfil de usuario de empreendimento
            if ($_SESSION['usuario']) {
                try {
                    $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                    $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                    if (count($ids)) {
                        $id = implode(',', $ids);
                        $empreendimento->where("e.id IN({$id})");
                    } else {
                        $empreendimento->where("1");
                    }
                } catch (Exception $e) {
                }
            }

            $empreendimento = $empreendimento->order('empreendimento_nome')->query()->fetchAll();

            $this->set('empreendimentos', $empreendimento);

            $this->display('form');
        }
    }

    /**
     *
     * funo que valida o formulrio
     */
    public function validarAction()
    {
        $campos = array(
            'idContrato' => 'Selecione o contrato!',
            'tipoContato' => "Selecione um tipo!",
            'idEmpreendimento' => "Selecione um Empreendimento!"
        );
        foreach ($campos as $campo => $msg) {
            if ($_POST[$campo] == '') {
                $this->_helper->addMensagem($campo, $msg);
            }
        }

        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        $TB_RELACIONAMENTO = new Relacionamento();
        $tb_empreendimento = new Empreendimento();
        $adapter = $tb_empreendimento->getAdapter();

        // setandos os filtros
        $filtroContato[] = "e.id = '" . $_POST["idEmpreendimento"] . "'";
        if ($_POST["idContrato"] != "*") {
            $filtroContato[] = "idContrato = '" . $_POST["idContrato"] . "'";
        }
        if ($_POST["idUsuario"] != "*") {
            $filtroContato[] = " usuario = '" . $_POST["idUsuario"] . "'";
        }
        if ($_POST["tipoContato"][0] != "*") {
            $tipoContato = implode('","', $_POST['tipoContato']);
            $filtroContato[] = 'agr_idStatus IN ("' . $tipoContato . '")';
        }

        if ($_POST["tpOrdenacao"] == '1')
        {
            if ($_POST["dataDe"]) {
                $filtroContato[] = "data >= '" . Helper::getInputDate($_POST["dataDe"]) . "'";
            }
            if ($_POST["dataAte"]) {
                $filtroContato[] = "data <= '" . Helper::getInputDate($_POST["dataAte"]) . "'";
            }
        } else {
            if ($_POST["dataDe"]) {
                $filtroContato[] = "dt_retorno >= '" . Helper::getInputDate($_POST["dataDe"]) . "'";
            }
            if ($_POST["dataAte"]) {
                $filtroContato[] = "dt_retorno <= '" . Helper::getInputDate($_POST["dataAte"]) . "'";
            }
        }
        $filtroContato = implode(" AND ", $filtroContato);
        $contatos = $TB_RELACIONAMENTO->getAdapter()->select()->from(array("c" => TB_RELACIONAMENTO))
            ->join(array("cr" => TB_CONTRATO), "c.idContrato = cr.id", "id")
            ->join(array("l" => TB_LOTES), "cr.id_lote = l.id", array("lote", "quadra"))
            ->join(array("p" => TB_PESSOA), "p.id = cr.id_pessoa", "nm_pessoa")
            ->join(array("e" => TB_EMPREENDIMENTO), "l.id_empreendimento = e.id")
            ->join(array("a" => TB_AGRUPADA), "a.idCampo = c.agr_idStatus AND idTabela = '" . Db_TabelaAgrupada::TABLE_STATUS_CONTATO . "'", "descricao")
            ->where($filtroContato)->order(array("p.nm_pessoa", "c.data DESC"))->query()->fetchAll();
        $empreendimento = $contatos[0]["nm_empreendimento"];
        $dados = array();

        foreach ($contatos as $contato) {
            $dados[$contato["idContrato"]]["cliente"] = $contato["nm_pessoa"];
            $dados[$contato["idContrato"]]["lote"] = $contato["lote"];
            $dados[$contato["idContrato"]]["quadra"] = $contato["quadra"];
            $dados[$contato["idContrato"]]["contato"][] = array("data" => Helper::getDate($contato["data"]),
                "assunto" => $contato["assunto"],
                "usuario" => isset($contato['usuario']) ? Pessoa::findNomeById($contato["usuario"]) : null,
                "situacao" => $contato["descricao"],
                "dtRetorno" => Helper::getDate($contato['dt_retorno'])
            );
        }
        if (!$contatos) {
            $this->_helper->addMensagem('danger', "Relatrio no encontrado!");
        }

        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            echo json_encode(true);
        }
    }

    public function contratoByEmpreendimentoAction()
    {
        $contratos = Contrato::byEmpreendimento($_POST['id_empreendimento'], Contrato::CONTRATO_TODOS, 2, array("nm_pessoa", "lote", "quadra", "id"));

        $lista = array();
        $lista[] = array('id'=>'*','text'=>'Todos');
        foreach ($contratos as $contrato) {
            if ($contrato['fl_distrato'] == '1')
                $color = 'color: red;';
            else{
                $color = null;
            }

            $lista[] = array('id' => $contrato['id'], 'text' => utf8_encode($contrato['nm_pessoa']) . ' Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . $contrato['id'], 'estilo' => $color);
        }

        echo json_encode($lista);
    }
}

?>
