<?php
class RelAcompanhamentoController extends Controller
{
    protected $tb_empreendimento;
    protected $tb_contrato;
    protected $tb_acompanhamento;
    protected $tb_acompanhamento_itens;
    protected $tb_relacionamento;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_empreendimento = new Empreendimento();
        $this->tb_contrato = new Contrato();
        $this->tb_acompanhamento = new Acompanhamento();
        $this->tb_acompanhamento_itens = new AcompanhamentoItens();
        $this->tb_relacionamento = new Relacionamento();
    }

    public function indexAction()
    {
        $this->set("subtitulo", "Relatrio de Acompanhamento");

        $empreendimentos = $this->tb_empreendimento->getDefaultAdapter()->select()
            ->distinct('e.id')
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.id'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {
            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        $this->set("empreendimentos", $empreendimentos);
        $this->display("index");
    }

    public function gerarAction()
    {
        $id_empreendimento = $_POST['empreendimento'];
        $id_acompanhamento = $_POST['acompanhamentoId'];
        
        $listaItens = $this->tb_acompanhamento_itens->getAdapter()->select()
            ->from(array('ai' => TB_ACOMPANHAMENTO_ITENS), array('id_situacao','id_ordem_sequencial'))
            ->join(array('a' => TB_ACOMPANHAMENTO), 'a.id = ai.id_acompanhamento', array('nm_acompanhamento'))
            ->join(array('t' => TB_AGRUPADA), 't.idCampo = ai.id_situacao', array('descricao'))
            ->where('t.idTabela = ?', '11')
            ->order('ai.id_ordem_sequencial');
        
        $listaItens = $listaItens->where('ai.id_acompanhamento = ?', $id_acompanhamento);
        // transformar o array gerado no tipoContrato (utilizado para exibir os contratos ativos, inativos ou ambos) em uma string
        $distrato = implode("','", $_POST['tipoContrato']);

        $listaItens = $listaItens->query()->fetchAll();
        
        foreach ($listaItens as $item) {
            $idSituacao[] = $item['id_situacao'];
        }

        $idSituacao = implode("','", $idSituacao);

        $dados = $this->tb_acompanhamento->getAdapter()->select()
            ->from(array('r' => TB_RELACIONAMENTO), array('idContrato', 'agr_idStatus as id_situacao'))
            ->join(array('t' => TB_AGRUPADA), 't.idCampo = r.agr_idStatus', array('descricao'))
            ->join(array('c' => TB_CONTRATO), 'c.id = r.idContrato', array(''))
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('quadra', 'lote', 'id_empreendimento'))
            ->join(array('p' => TB_PESSOA), 'p.id = c.id_pessoa', array('nm_pessoa'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', array('cpf' => 'nr_cpf'))
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pj.id_pessoa = p.id', array('cnpj' => 'nr_cnpj'))
            ->where('t.idTabela = ?', '11')
            ->where('r.data BETWEEN "' . Helper::getInputDate($_POST['dataInicio']) . '" AND "' . Helper::getInputDate($_POST['dataFinal']) . '"')
            ->where("c.fl_distrato IN ('$distrato')")
            ->where("r.agr_idStatus IN ('$idSituacao')");
            
        switch ($_POST['ordena']) {
            case 'quadraLote':
                $dados->order(array('l.quadra', 'l.lote'));
                break;
            case 'data':
                $dados->order(array('c.dt_contrato'));
                break;
            case 'numeroContrato':
                $dados->order(array('c.id'));
                break;
            case 'nomeCliente':
                $dados->order(array('p.nm_pessoa'));
                break;
        }

        if ($_POST['idContrato'] != 'todos') {
            $dados = $dados->where("r.idContrato IN ('" . $_POST['idContrato'] . "')");
        } else {
            $dados = $dados->where('l.id_empreendimento = ?', $id_empreendimento);
        }

        $dados = $dados->query()->fetchAll();

        $acompanhamentos = [];

        foreach ($listaItens as $item) {
            foreach ($dados as $dado) {
                if ($item['id_situacao'] != $dado['id_situacao']) {
                    $acompanhamentos[$dado['idContrato']][$item['descricao']] = '-';
                }
            }
        }
        
        foreach ($listaItens as $item) {
            foreach ($dados as $dado) {
                if ($item['id_situacao'] == $dado['id_situacao']) {
                    $acompanhamentos[$dado['idContrato']][$item['descricao']] = 'ok';
                }
            }
        }

        $result = array();
        foreach ($dados as $element) {
            $result[$element['idContrato']][] = $element;
        }

        $empreendimento = $this->tb_empreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.id', 'ds_path_planta'))
            ->where('id = ?', $_POST['empreendimento'])
            ->query()->fetch();

        $tbClienteAcade = new Db_Cliente();

        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());
        $this->set("nmContrato", $_POST['idContrato']);
        $this->set("acompanhamentos", $acompanhamentos);
        $this->set("empreendimento", $empreendimento);
        $this->set("nmAcompanhamento", $listaItens[0]['nm_acompanhamento']);
        $this->set('data', $dados);
        $this->set('result', $result);

        // Validador
        if($this->validarDados($dados)) {
            if ($this->validarAction()) {
                $this->display('relatorio');
                $this->displayMPDF('Relatorio_' . time() . '.pdf');
            } 
        }
        
    }

    public function contratoByEmpreendimentoAction()
    {
        if ($this->isAjax()) {
            if ($_POST['tipoContrato'] == 'inativos')
                $_POST['tipoContrato'] = null;

            $contratos = Contrato::byEmpreendimentoextrato($_POST['id_empreendimento'], Contrato::CONTRATO_GERADO, $_POST['tipoContrato'], array("nm_pessoa", "lote", "quadra", "id"));
            
            $lista = array();

            foreach ($contratos as $contrato) {
                $lista[] = array(
                    'id' => $contrato['id'],
                    'text' => utf8_encode($contrato['nm_pessoa']) . ' - Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . utf8_encode($contrato['id'])
                );
            }

            if (!empty($lista)) {
                array_unshift($lista, array(
                    'id' => 'todos',
                    'text' => utf8_encode('Todos')
                ));
            }
            echo json_encode($lista);
        }
    }

    public function acompanhamentoListAction()
    {
        $acompanhamentos = $this->tb_acompanhamento->getAdapter()->select()
            ->from(array("a" => TB_ACOMPANHAMENTO), array('codigo' => 'id', 'nomeAcompanhamento' => 'nm_acompanhamento'))
            ->order('nm_acompanhamento')
            ->query()->fetchAll();

        $lista = array();

        foreach ($acompanhamentos as $acompanhamento) {
            $lista[] = array(
                'id' => $acompanhamento['codigo'],
                'text' => utf8_encode($acompanhamento['nomeAcompanhamento'])
            );
        }

        echo json_encode($lista);
    }

    public function addMensagem($k, $v)
    {
        $this->mensagem[$k] = $v;
    }
    public function validarAction()
    {   
        $campos = array("empreendimento", "idContrato", "acompanhamentoId","dataInicio", "dataFinal");
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "empreendimento" :
                        $msg = "O campo Empreendimento  obrigatrio.";
                        break;
                    case "idContrato" :
                        $msg = "O campo Contrato  obrigatrio.";
                        break;
                    case "acompanhamentoId" :
                        $msg = "O campo Acompanhamento  obrigatrio.";
                        break;
                    case "dataInicio" :
                        $msg = "O campo Data Inicial  obrigatrio.";
                        break;
                    case "dataFinal" :
                        $msg = "O campo Data Final  obrigatrio";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }

        //Mensagem de Erros
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            if($this->isAjax()) {
                echo json_encode(true);
            }    
            return !(count($this->_helper->getMensagens()) > 0);
        }
    }

    public function validarDados($dados) {
        if($dados) {
            return true;
        } else {
            $msg = "Nenhum resultado encontrato";
            $this->redir(array("modulo" => "rl", "controller" => "relAcompanhamento"), array("msg" => 'fail', "exception" => $msg));
        }
    }
}
