<?php

class ReciboTaxasController extends Controller
{
    public function indexAction()
    {
        $this->redir(array('modulo' => 'rl', 'controller' => 'reciboTaxas', 'action' => 'relatorio'));
    }

    public function relatorioAction()
    {
        $instanceEmpreendimento = new Empreendimento();
        $empreendimento = $instanceEmpreendimento->getDefaultAdapter();

        $empreendimento = $empreendimento->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('id_empreendimento' => 'id', 'nm_empreendimento'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {

            }
        }
        $empreendimento = $empreendimento->group('e.id')->order('nm_empreendimento')->query()->fetchAll();
        $this->set('empreendimentos', $empreendimento);

        if ($this->_isPost) {
            if ($this->validar()) {
                /*
                 * Executa o relatrio de no pagas aps setar os parmetros de execuo
                 * Passa como parmetro o tipo de relatrio (analitico ou sintetico)
                 */
                $this->relatorio();
            } else {
                $this->redir(array('modulo' => 'rl', 'controller' => 'reciboTaxas', 'action' => 'relatorio'),
                    array('msg' => 'fail', 'exception' => 'Todos os campos so obrigatorios.'));
            }
        }

        $this->display("form");
    }

    private function relatorio()
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        ini_set('memory_limit', '3000M');
        set_time_limit(0);

        //Ajusta os filtros para facilitar a consulta
        $dtInicio = Helper::getInputDate($_POST['dtInicio']);
        $dtFinal = Helper::getInputDate($_POST['dtFinal']);
        $tpTaxa = $_POST['tipo_taxa'];
        $idEmp = $_POST['empreendimento_relatorio_taxas'];

        //Busca os registros pelos filtros selecionados
        $registros = new Recibo;
        $registros = $registros->getAdapter()->select()
            ->from(array('r' => TB_RECIBO), array('*'))
            ->join(array('t' => TB_TAXA_VALOR), 'r.id_taxa = t.id_taxas', array())
            ->join(array('e' => TB_EMPREENDIMENTO), 't.id_empreendimento = e.id', array('e.nm_empreendimento','ds_path_logo'))
            ->join(array('agr' => TB_AGRUPADA), 'agr.idCampo = t.id_tipo_taxa AND agr.idTabela = 17', array('dsTaxa' => 'descricao'))
            ->where('r.dt_recibo BETWEEN "' . $dtInicio . '" AND "' . $dtFinal . '"')
            ->where('e.id = ?', $idEmp);

        if ($tpTaxa != '*')
            $registros = $registros->where('agr.idCampo = ?', $tpTaxa);

        $registros = $registros->query()->fetchAll();

        //verifica se existem registros para no exibir o relatrio em branco
        if (!isset($registros) || count($registros) == 0) {
            $this->redir(array('modulo' => 'rl', 'controller' => 'reciboTaxas', 'action' => 'relatorio'),
                array('msg' => 'fail', 'exception' => 'Nenhum Registro encontrado.'));
        }

        //Seta no relatorio e posteriormente na view
        $relatorio['itens'] = $registros;

        //Acumula o valor total do relatorio com os registros vlidos
        $vlTotal = 0;
        foreach ($registros as $registro) {
            $vlTotal += $registro['vl_recibo'];
        }

        $relatorio['total']['registros'] = count($registros);
        $relatorio['total']['valor'] = $vlTotal;

        $relatorio['periodo'] = $_POST['dtInicio'] . " at " . $_POST['dtFinal'];
        $relatorio['tpTaxa'] = $registros[0]['dsTaxa'];
        $relatorio['empreendimento'] = $registros[0]['nm_empreendimento'];

        $this->set('relatorio', $relatorio);

        $this->display("relatorio");
        $this->displayMPDF('Relatorio_' . time() . '.pdf');

    }

    private function validar()
    {
        //validao para evitar campos vazios
        $campos = array('empreendimento_relatorio_taxas', "tipo_taxa", 'dtInicio', 'dtFinal');
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "tipo_taxa" :
                        $msg = "O campo Tipo de Taxa deve ser escolhido.";
                        break;
                    case "empreendimento_relatorio_taxas" :
                        $msg = "O campo Empreendimento deve ser escolhido.";
                        break;
                    case "dtInicio" :
                        $msg = "A data inicial  obrigatria.";
                        break;
                    case "dtFinal" :
                        $msg = "A data final  obrigatria.";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function taxaByEmpreendimentoAction()
    {
        $taxas = TaxaValor::findByEmpreendimento($_POST['id_empreendimento']);

        $lista = array();
        foreach ($taxas as $taxa) {
            $lista[] = array(
                'id' => $taxa['idCampo'],
                'text' => utf8_encode($taxa['descricao'])
            );
        }

        echo json_encode($lista);
    }
} 