<?php

/**
 * Description of ReciboController
 *
 * @author acade
 */
class ReciboController extends Controller
{

    protected $tb_pessoa;
    protected $tb_agrupada;
    protected $tb_pessoa_juridica;
    protected $tb_cliente;
    protected $tb_empreendimento;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_pessoa = new Pessoa();
        $this->tb_pessoa_juridica = new Pessoa_Juridica();
        $this->tb_agrupada = new Db_TabelaAgrupada();
        $this->tb_cliente = new Db_Cliente();
        $this->tb_empreendimento = new Empreendimento();
    }

    public function indexAction()
    {
        $this->set("subtitulo", "Recibo");
        $pessoasFisicas = $this->tb_pessoa->getAdapter()->select()->from(array("p" => TB_PESSOA), array("id", "nm_pessoa"))
            ->join(array("pf" => TB_PESSOA_FISICA), "p.id = pf.id_pessoa", "")->order("nm_pessoa")->query()->fetchAll();
        $pessoasJuridicas = $this->tb_pessoa->getAdapter()->select()->from(array("p" => TB_PESSOA), "id")
            ->join(array("pj" => TB_PESSOA_JURIDICA), "p.id = pj.id_pessoa", "nm_fantasia")->order("nm_fantasia")->query()->fetchAll();

        $instanceEmpreendimento = new Empreendimento();
        $empreendimento = $instanceEmpreendimento->getDefaultAdapter();

        $empreendimento = $empreendimento->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('id_empreendimento' => 'id', 'nm_empreendimento'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {

            }
        }
        $empreendimento = $empreendimento->group('e.id')->order('nm_empreendimento')->query()->fetchAll();

        $pf = array("" => "Selecione");
        $pj = array("" => "Selecione");
        $empreendimentos = array("" => "Selecione");
        foreach ($empreendimento as $e) {
            $empreendimentos[$e['id_empreendimento']] = $e['nm_empreendimento'];
        }

        foreach ($pessoasFisicas as $p) {
            $pf[$p["id"]] = $p["nm_pessoa"];
        }
        foreach ($pessoasJuridicas as $p) {
            $pj[$p["id"]] = $p["nm_fantasia"];
        }

        $this->set('empreendimentos', $empreendimentos);
        $tiposRecibo = array(
            "" => "Selecione...",
            "ec" => "Empreendimento",
            "ad" => "Administração",
            "pf" => "Pessoa Física",
            "pj" => "Pessoa Jurídica"
        );
        $this->set("pessoasFisicas", $pf);
        $this->set("pessoasJuridicas", $pj);
        $this->set("tiposRecibo", $tiposRecibo);
        $this->display("index");
    }

    public function gerarAction()
    {
        if ($this->_isPost) {
            // recupera os dados do emissor e receptor do recibo
            if ($_POST["de"] == 'ec' || $_POST["para"] == 'ec') {
                $dadosEmpreendimento = $this->tb_empreendimento->getAdapter()->select()
                    ->from(array("c" => TB_EMPREENDIMENTO))
                    ->joinLeft(array("m" => TB_CIDADE), "c.cd_cidade = m.id", array("cidade" => "nome", "uf"))
                    ->where('c.id = ?', $_POST['ec'])
                    ->query()->fetch();

                $aux["ec"]["cidade"] = $dadosEmpreendimento["cidade"];
                $aux["ec"]["uf"] = $dadosEmpreendimento["uf"];
                $aux["ec"]["tel"] = '';
                $aux["ec"]["cnpj"] = '';
                $aux["ec"]["cpf"] = '';
                $aux["ec"]["endereco"] = false;
                $aux["ec"]["nome"] = $dadosEmpreendimento["nm_empreendimento"];
                $cidade = $aux["ec"]["cidade"];
            } else {
                $dadosCliente = $this->tb_cliente->getAdapter()->select()
                    ->from(array("c" => TB_CLIENTE))
                    ->joinLeft(array("m" => TB_CIDADE), "c.cd_municipio = m.id", array("cidade" => "nome", "uf"))
                    ->query()->fetch();
                $aux["ad"]["cidade"] = $dadosCliente["cidade"];
                $aux["ad"]["uf"] = $dadosCliente["uf"];
                $aux["ad"]["tel"] = "(" . $dadosCliente["nr_uf_telefone"] . ")" . $dadosCliente["nr_telefone"];
                
               $aux["ad"]["cpfCnpj"] = Helper::getMaskCNPJ($dadosCliente["nr_cnpj"]);
                $aux["ad"]["endereco"] = $dadosCliente["ds_endereco"] . " - " . $dadosCliente["nm_bairro"];
                $aux["ad"]["nome"] = $dadosCliente["nm_razao_social"];
                $cidade = $aux["ad"]["cidade"];
            }
            
            if ($_POST["pf"]) {
                $pessoa = $this->tb_pessoa->getAdapter()->select()
                    ->from(array("p" => TB_PESSOA), array("nome" => "nm_pessoa", "nr_telefone", "nr_celular",
                        "nr_fax", "nr_recado", "endereco", "nm_bairro", "nr_endereco", "ds_complemento"))
                    ->join(array("pf" => TB_PESSOA_FISICA), "pf.id_pessoa = p.id", array("cpf" => "nr_cpf"))
                    ->joinLeft(array("c" => TB_CIDADE), "p.cd_cidade = c.id", array("cidade" => "nome", "uf"))
                    ->where("p.id = '" . $_POST["pf"] . "'")->query()->fetch();
                if ($pessoa["nr_recado"])
                    $pessoa["tel"] = $pessoa["nr_recado"];
                if ($pessoa["nr_fax"])
                    $pessoa["tel"] = $pessoa["nr_fax"];
                if ($pessoa["nr_celular"])
                    $pessoa["tel"] = $pessoa["nr_celular"];
                if ($pessoa["nr_telefone"])
                    $pessoa["tel"] = $pessoa["nr_telefone"];
                if ($pessoa["endereco"])
                    $pessoa["endereco"] .= ", " . $pessoa["nm_bairro"];
                $aux["pf"] = $pessoa;
            }
            if ($_POST["pj"]) {
                $pessoa = $this->tb_pessoa->getAdapter()->select()
                    ->from(array("p" => TB_PESSOA), array("nr_telefone", "nr_celular", "nr_fax", "nr_recado",
                        "endereco", "nm_bairro", "nr_endereco", "ds_complemento"))
                    ->join(array("pj" => TB_PESSOA_JURIDICA), "p.id = pj.id_pessoa", array("cnpj" => "nr_cnpj",
                        "nome" => "nm_fantasia"))
                    ->join(array("c" => TB_CIDADE), "p.cd_cidade = c.id", array("cidade" => "nome", "uf"))
                    ->where("p.id = '" . $_POST["pj"] . "'")->query()->fetch();
                if ($pessoa["nr_recado"])
                    $pessoa["tel"] = $pessoa["nr_recado"];
                if ($pessoa["nr_fax"])
                    $pessoa["tel"] = $pessoa["nr_fax"];
                if ($pessoa["nr_celular"])
                    $pessoa["tel"] = $pessoa["nr_celular"];
                if ($pessoa["nr_telefone"])
                    $pessoa["tel"] = $pessoa["nr_telefone"];
                if ($pessoa["endereco"])
                    $pessoa["endereco"] .= ", " . $pessoa["nm_bairro"];
                $aux["pj"] = $pessoa;
            }
            $dados["de"] = $aux[$_POST["de"]];
            $dados["para"] = $aux[$_POST["para"]];

            $dados["valor"] = $_POST["valor"];
            $dados["referencia"] = $_POST["referencia"];
            $dados["formaPagamento"] = $_POST["formaPagamento"];
            $stamp = strtotime(Helper::getInputDate($_POST["data"]));
            $dados["data"] = $cidade . ", " . date("d", $stamp) . " de " . strtolower(Helper::getMes(date("m", $stamp))) . " de " . date("Y", $stamp) . ".";
            $this->set("dados", $dados);
            
            // CONDIO QUE TRS AS LOGOS DO EMPREENDIMENTO E DO CLIENTE RESPECTIVAMENTE.
            // ec == empreendimento.
            if ($_POST['ec']) {
                $logoempreendimento = $this->tb_empreendimento->getAdapter()->select()
                    ->from(array('em' => TB_EMPREENDIMENTO), array('id', 'ds_path_logo'))
                    ->where('id = ' . $_POST['ec'])
                    ->query()->fetch();
            } 
            $cliente = $this->tb_cliente->getAdapter()->select()
                ->from(array('c' => TB_CLIENTE), array('cd_cliente', 'cd_municipio', 'nm_razao_social', 'ds_end_logomarca'))
                ->query()->fetch();
            
                
            $this->set("logoempreendimento", $logoempreendimento);
            $this->set('cliente', $cliente);
                
            $this->displayMPDF("recibo" . date("d/m/Y") . ".pdf", true, "P", "A4", array(1, 1, 1, 1));
        } else {
            $this->indexAction();

        }
    }

    public function validarAction()
    {
        if (!$_POST["de"] || !$_POST["para"]) {
            $this->_helper->addMensagem("dePara", "Escolha emissor e receptor do recibo");
        } else {
            if (!$_POST["de"] && !$_POST["para"])
                $this->_helper->addMensagem("pfPj", "Escolha uma pessoa");
        }
        if (str_replace(",", ".", $_POST["valor"]) <= 0) {
            $this->_helper->addMensagem("valor", utf8_decode("Digite um valor válido"));
        }
        if (!$_POST["referencia"]) {
            $this->_helper->addMensagem("referencia", "Digite a referencia do recibo");
        }
        if (!$_POST["formaPagamento"]) {
            $this->_helper->addMensagem("formaPagamento", "Digite a forma de pagamento");
        }
        if (!$_POST["data"]) {
            $this->_helper->addMensagem("data", "Digite a data");
        }

        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            echo json_encode(true);
        }
        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function findPessoaFisicaAction()
    {
        $listPessoaFisica = Pessoa::findPessoaFisicaByName($_GET['term']);
        //Pesquisa todas pessoas físicas pelo nome
        $lista[] = array('value'=>'','text'=>'');
        foreach ($listPessoaFisica as $pessoaFisica) {
            $lista[] = array(
                'value' => $pessoaFisica['id'],
                'text' => utf8_encode($pessoaFisica['nm_pessoa']),
            );
        }
        echo json_encode($lista);
    }
    public function findPessoaJuridicaAction()
    {
        //Pesquisa todas pessoas jurídicas pelo nome
        $pessoasJuridicas = Pessoa::findPessoaJuridicaByName($_GET['term']);
        $lista[] = array('value'=>'','text'=>'');
        foreach ($pessoasJuridicas as $pessoasJuridica) {
            $lista[] = array(
                'value' => $pessoasJuridica['id'],
                'text' => utf8_encode($pessoasJuridica['nm_pessoa']),
            );
        }
        echo json_encode($lista);
    }
}

?>
