<?php

/**
 * Description of ProtocoloController
 *
 * @author acade
 */
class ProtocoloController extends Controller
{

    protected $tb_contrato;
    protected $tb_cliente;
    private $tb_municipio;
    protected $tb_empreendimento;
    protected $tb_agrupada;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_contrato = new Contrato();
        $this->tb_cliente = new Db_Cliente();
        $this->tb_municipio = new Db_Cidade();
        $this->tb_empreendimento = new Empreendimento();
        $this->tb_agrupada = new Db_TabelaAgrupada();

    }

    public function indexAction()
    {
        $empreendimentos = $this->tb_empreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('nm_empreendimento', 'id'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        foreach ($empreendimentos as $emp) {
            $ss[$emp["id"]] = $emp["nm_empreendimento"];
        }

        $this->set('empreendimentos', $ss);

        $this->display("index");
    }

    public function gerarAction()
    {
        if ($this->_isPost) {
            $contrato = $this->tb_contrato->getAdapter()->select()->from(array("c" => TB_CONTRATO), "id")
                ->join(array("p" => TB_PESSOA), "c.id_pessoa = p.id", "nm_pessoa")
                ->join(array("l" => TB_LOTES), "c.id_lote = l.id", array("lote", "quadra"))
                ->join(array("e" => TB_EMPREENDIMENTO), "l.id_empreendimento = e.id", "nm_empreendimento")
                ->where("c.id = '" . $_POST["contrato"] . "'")->query()->fetch();


            $cliente = $this->tb_cliente->getAdapter()->select()
                ->from(array('c' => TB_CLIENTE), array('cd_cliente', 'cd_municipio', 'nm_razao_social', 'ds_end_logomarca'))
                ->joinLeft(array('m' => TB_CIDADE), 'm.id = c.cd_municipio', array('nome'))
                ->query()->fetch();
            $this->set('cliente', $cliente);

            $empreendimento = (new Empreendimento())->fetchRow('id = '.$_POST['empreendimento'])->toArray();
            $tipoLoteamento = (new TipoLoteamento())->fetchRow('id_tipo_loteamento = '.$empreendimento['id_tipo_loteamento']);
            $empreendimento['dsGrupo'] = ($tipoLoteamento['ds_grupo'])?$tipoLoteamento['ds_grupo']:'';
            $empreendimento['dsSubgrupo'] = ($tipoLoteamento['ds_subgrupo'])?$tipoLoteamento['ds_subgrupo']:'';

            $contrato["texto"] = $_POST["texto"];
            $this->set("empreendimento", $empreendimento);
            $this->set("contrato", $contrato);
            $this->set("assinatura", $_POST['assinatura']);
            $this->set("data", ", " . date("d") . " de " . strtolower(Helper::getMes(date("m"))) . " de " . date("Y") . ".");

            (new Relacionamento())->saveContato(81, date('Y-m-d'), $contrato['id'], 'Log: Relatrio Emisso de Protocolo.');
            $this->displayMPDF("protocolo" . date("d-m-Y") . ".pdf");
        } else {
            $this->indexAction();
        }
    }

    public function validarAction()
    {
        if (!$_POST["empreendimento"]) {
            $this->_helper->addMensagem("empreendimento", "O campo Empreendimento  obrigatrio.");
        }
        if (!$_POST["contrato"]) {
            $this->_helper->addMensagem("contrato", "O campo Cliente  obrigatrio");
        }
        if (!$_POST["texto"]) {
            $this->_helper->addMensagem("texto", "Escreva a frase do protocolo");
        }
        if (!$_POST["assinatura"]) {
            $this->_helper->addMensagem("assinatura", "Assinatura no pode est vazia");
        }

        //Alterada valida??o, para verificar as informa??es agora pelo AJAX
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            echo json_encode(true);
        }
    }

    public function contratoEmpreendimentoAction($idEmpreendimento = false, $idContrato = false)
    {
        $empreedimento = ($idEmpreendimento) ? $idEmpreendimento : $_POST['id_empreendimento'];
        $idContrato = ($idContrato) ? $idContrato : $_POST["id_contrato"];

        $contratos = Contrato::byEmpreendimento($empreedimento, Contrato::CONTRATO_TODOS, 2, array("nm_pessoa", "lote", "quadra", "id"));
        $lista[] = array('id'=>'','text'=>'');
        foreach ($contratos as $contrato) {
            if ($contrato['fl_distrato'] == '1')
                $color = 'color: red;';
            else
                $color = null;
            $lista[] = array(
                'id' => $contrato['id'],
                'text' => utf8_encode($contrato['nm_pessoa']) . ' Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . $contrato['id'],
                'estilo' => $color
            );
        }
        echo json_encode($lista);
    }

    public function getAssinaturaAction() 
    {
        if($this->isAjax()) {
            try {
                $cliente = $this->tb_cliente->getAdapter()->select()
                    ->from(array('c' => TB_CLIENTE), array('cd_cliente', 'cd_municipio', 'nm_razao_social', 'ds_end_logomarca'))
                    ->joinLeft(array('m' => TB_CIDADE), 'm.id = c.cd_municipio', array('nome'))
                    ->query()->fetch();
                
                header('Content-Type: application/json');
                echo (json_encode($cliente));
            } catch (Exception $e) {
                return $e;
            }
        }
    }

}

?>
