<?php

/**
 * Created by PhpStorm.
 * User: programacao02
 * Date: 14/11/16
 * Time: 14:32
 */

class ProdutividadeController extends Controller
{

    public function __construct($request)
    {

        parent::__construct($request);
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "rl", "controller" => "produtividade", 'action' => 'gerar'));
    }

    public function gerar2Action()
    {
        
        define("ORD_POR_EMPREENDIMENTO", 0);
        define("ORD_POR_EMPREENDIMENTO_RELACIONAMENTO", 1);
        define("ORD_POR_RELACIONAMENTO", 2);
        define("ORD_POR_RELACIONAMENTO_EMPREENDIMENTO", 3);

        try {
            if (!in_array("*", $_POST["idEmpreendimento"])) {
                $filtroContato[] = "e.id IN " . Helper::arrayParaCondicaoIN($_POST['idEmpreendimento']) . " ";
            }

            if (!in_array("*", $_POST["idUsuario"])) {
                $filtroContato[] = " c.usuario IN " . Helper::arrayParaCondicaoIN($_POST["idUsuario"]) . " ";
            }
            if (!in_array("*", $_POST["tipoContato"])) {
                $filtroContato[] = "c.agr_idStatus IN " . Helper::arrayParaCondicaoIN($_POST["tipoContato"]) . " ";
            }
            if ($_POST["dataDe"]) {
                $filtroContato[] = " data >= '" . Helper::getInputDate($_POST["dataDe"]) . "'";
            }
            if ($_POST["dataAte"]) {
                $filtroContato[] = " data <= '" . Helper::getInputDate($_POST["dataAte"]) . "'";
            }

            $this->set("dataDe",$_POST["dataDe"]);
            $this->set("dataAte", $_POST["dataAte"]);

            $filtroContato = implode(" AND ", $filtroContato);

            $ordenamento_flag = $_POST['ordenamento'];

            $TB_RELACIONAMENTO = new Relacionamento();
            $contatos = $TB_RELACIONAMENTO->getAdapter()->select();


           
            $contatos->join(array("cr" => TB_CONTRATO), "c.idContrato = cr.id", array())
                ->join(array("l" => TB_LOTES), "cr.id_lote = l.id", array())
                ->join(array("u" => TB_USUARIO), "u.id = c.usuario", array('login'));

            switch ($ordenamento_flag) {
                case ORD_POR_EMPREENDIMENTO:
                    $contatos->from(array("c" => TB_RELACIONAMENTO), array('qtdRegs' => 'COUNT(*)'));
                    $contatos->join(array("e" => TB_EMPREENDIMENTO), "e.id = l.id_empreendimento", array('nm_empreendimento'));
                    $contatos->group(array('c.usuario', 'e.id'));
                    $contatos->order(array('u.login','nm_empreendimento'));
                    break;

                    break;
                case ORD_POR_RELACIONAMENTO:
                    $contatos->from(array("c" => TB_RELACIONAMENTO), array('qtdRegs' => 'COUNT(*)', 'c.agr_idStatus'));
                    $contatos->join(array("a" => TB_AGRUPADA), "a.idCampo = c.agr_idStatus AND a.idTabela = 11", array('descricao'));
                    $contatos->join(array("e" => TB_EMPREENDIMENTO), "e.id = l.id_empreendimento", array());
                    $contatos->group(array('c.usuario', 'c.agr_idStatus'));
                    $contatos->order(array('u.login','descricao'));
                    break;
                case ORD_POR_EMPREENDIMENTO_RELACIONAMENTO:
                case ORD_POR_RELACIONAMENTO_EMPREENDIMENTO:
                    $contatos->from(array("c" => TB_RELACIONAMENTO), array('qtdRegs' => 'COUNT(*)', 'c.agr_idStatus'));
                    $contatos->join(array("a" => TB_AGRUPADA), "a.idCampo = c.agr_idStatus AND a.idTabela = 11", array('descricao'));
                    $contatos->join(array("e" => TB_EMPREENDIMENTO), "e.id = l.id_empreendimento", array('nm_empreendimento'));
                    $contatos->group(array('c.usuario', 'e.id', 'c.agr_idStatus'));
                    if($ordenamento_flag == ORD_POR_EMPREENDIMENTO_RELACIONAMENTO)
                        $contatos->order(array('u.login', 'nm_empreendimento','descricao'));
                    if($ordenamento_flag == ORD_POR_RELACIONAMENTO_EMPREENDIMENTO)
                        $contatos->order(array('u.login', 'descricao','nm_empreendimento'));
                    break;
            }

            
           
            $resultado = $contatos->where($filtroContato)
                ->query()->fetchAll();

            $usuarios = array_column($resultado, 'login');

            $usuarios = array_unique($usuarios);

            $this->set('usuarios', $usuarios);

            $empreendimentos = array();
            $relacionamentos = array();

            $empreendimentos = array_column($resultado, 'nm_empreendimento');
            $empreendimentos = array_unique($empreendimentos);


            

            $this->set('empreendimentos', $empreendimentos);

            $relacionamentos = array_column($resultado, 'descricao');            

            $this->set('relacionamentos', $relacionamentos);

            
            $resultados_formatados = array('nome' => array(), 'totalizador' => array());

            foreach ($resultado as $item) {
                switch ($ordenamento_flag) {
                    case ORD_POR_EMPREENDIMENTO:

                        $resultados_formatados['nome'][$item['login']][$item['nm_empreendimento']] = $item['qtdRegs'];

                        $resultados_formatados['totalizador'][$item['nm_empreendimento']] += $item['qtdRegs'];
                        break;

                    case ORD_POR_RELACIONAMENTO:

                        $resultados_formatados['nome'][$item['login']][$item['descricao']] = $item['qtdRegs'];

                        $resultados_formatados['totalizador'][$item['descricao']] += $item['qtdRegs'];
                        break;

                    case ORD_POR_EMPREENDIMENTO_RELACIONAMENTO:

                        $resultados_formatados['nome'][$item['login']][$item['nm_empreendimento']][$item['descricao']] = $item['qtdRegs'];

                        $resultados_formatados['totalizador'][$item['nm_empreendimento']][$item['descricao']] += $item['qtdRegs'];

                        break;

                    case ORD_POR_RELACIONAMENTO_EMPREENDIMENTO:
                        $resultados_formatados['nome'][$item['login']][$item['descricao']][$item['nm_empreendimento']] = $item['qtdRegs'];

                        $resultados_formatados['totalizador'][$item['descricao']][$item['nm_empreendimento']] += $item['qtdRegs'];
                        break;
                }
            }

            ksort($resultados_formatados['nome']);
            ksort($resultados_formatados['totalizador']);

            $tbClienteAcade = new Db_Cliente();
            $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

            $tb_empreendimento = new Empreendimento();

            $empreendimentoInfo = '';

            if(count($_POST["idEmpreendimento"]) == 1)
            {
                $condicao = "em.id IN " . Helper::arrayParaCondicaoIN($_POST['idEmpreendimento']) . " ";
                $empreendimentoInfo = $tb_empreendimento->getAdapter()->select()->from(array('em' => TB_EMPREENDIMENTO), array('nm_empreendimento', 'ds_path_logo'))
                ->where($condicao)
                ->query()->fetch();
                $this->set("empreendimentoInfo", $empreendimentoInfo);
            }


            $this->set('ordenamentoFlag',$ordenamento_flag);
            $this->set('resultadosFormatados', $resultados_formatados);
            

            $this->display('gerar');
            $this->displayMPDF("produtividade.pdf");

        } catch (Exception $e) {
            var_dump($e);
            die();
        }
    }

    public function gerarAction()
    {
        $this->set('back', $this->_helper->getLink(array('m' => 'lo', 'c' => 'contato', 'a' => 'index')));
        $this->set("status", Db_TabelaAgrupada::findByField("idTabela", Db_TabelaAgrupada::TABLE_STATUS_CONTATO, "descricao"));

        //Busca os usuarios do sistema para montar o select
        $usuarios = Db_Usuario::findLista(false, false, false, false, true);
        $listaUsuarios = array();
        foreach ($usuarios as $k => $user) {
            $listaUsuarios[$k]['nome'] = ucfirst($user->getLogin());
            $listaUsuarios[$k]['id'] = $user->getId();
        }
        asort($listaUsuarios);

        //instancia as classes necessrias
        $instanceEmpreendimento = new Empreendimento();
        $empreendimento = $instanceEmpreendimento->getDefaultAdapter();

        $empreendimento = $empreendimento->select()->distinct('e.id')
            ->from(array('e' => TB_EMPREENDIMENTO), array('empreendimento_nome' => 'e.nm_empreendimento', 'empreendimento_id' => 'e.id'));


        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {
            }
        }

        $emps = $empreendimento->order('empreendimento_nome')->query()->fetchAll();
        if ($this->_isPost) {
            $tbClienteAcade = new Db_Cliente();
            $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

            $TB_RELACIONAMENTO = new Relacionamento();
            $tb_empreendimento = new Empreendimento();

            // setandos os filtros
            if ($_POST["idEmpreendimento"] != "*") {
                $filtroContato[] = "e.id = '" . $_POST["idEmpreendimento"] . "'";
                $filtroDetalhe = "em.id = '" . $_POST["idEmpreendimento"] . "'";
            } else {
                /* Utilizao da varivel $emps para consulta todos
                 * Criao do $filtroDetalhe para a opo Todos com detalhadamento
                 */
                $empID = array();
                foreach ($emps as $emp) {
                    array_push($empID, $emp['empreendimento_id']);
                }
                $filtroContato[] = "e.id in (" . implode(',', $empID) . ")";
                $filtroDetalhe = "em.id in (" . implode(',', $empID) . ")";
            }

            if ($_POST["idUsuario"] != "*") {
                $filtroContato[] = " usuario = '" . $_POST["idUsuario"] . "'";
            }

            if ($_POST["tipoContato"] != "*") {
                $filtroContato[] = "agr_idStatus = '" . $_POST["tipoContato"] . "'";
            }

            if ($_POST["dataDe"]) {
                $filtroContato[] = "data >= '" . Helper::getInputDate($_POST["dataDe"]) . "'";
            }

            if ($_POST["dataAte"]) {
                $filtroContato[] = "data <= '" . Helper::getInputDate($_POST["dataAte"]) . "'";
            }

            $filtroContato = implode(" AND ", $filtroContato);

            $empreendimentoInfo = $tb_empreendimento->getAdapter()->select()->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento', 'ds_path_logo'))
                ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
                ->where($filtroDetalhe)
                ->query()->fetch();

            $this->set("empreendimentoInfo", $empreendimentoInfo);

            $contatos = $TB_RELACIONAMENTO->getAdapter()->select()
                ->from(array("c" => TB_RELACIONAMENTO), array('qtdeContatos' => 'COUNT(c.id)', 'agr_idStatus'))
                ->join(array("cr" => TB_CONTRATO), "c.idContrato = cr.id", array())
                ->join(array("l" => TB_LOTES), "cr.id_lote = l.id", array())
                ->join(array("e" => TB_EMPREENDIMENTO), "e.id = l.id_empreendimento", array('nm_empreendimento'))
                ->join(array("u" => TB_USUARIO), "u.id = c.usuario", array('login'))
                ->join(array("a" => TB_AGRUPADA), "a.idCampo = c.agr_idStatus AND idTabela = 11", array('idCampo', 'descricao'))
                ->join(array("us" => TB_PESSOA), "us.id = u.id", array('id', 'nm_pessoa'));
            if ($_POST['idUsuario'] == "*" && $_POST['situacao'] == "Si") {
                $contatos->group(($_POST['situacao'] == 'An') ? array('e.nm_empreendimento', 'c.usuario', 'agr_idStatus') : array('agr_idStatus'));
            } else {
                $contatos->group(($_POST['situacao'] == 'An') ? array('e.nm_empreendimento', 'c.usuario', 'agr_idStatus') : array('c.usuario', 'agr_idStatus'));
            }
            $contatos->where($filtroContato);
            $contatos->order(array('us.nm_pessoa', 'e.nm_empreendimento', "a.descricao", 'qtdeContatos'));

            /*
             * Consulta para a opo detalhado;
             */
            if ($_POST['situacao'] == 'De') {

                $contatosdetalhado = $TB_RELACIONAMENTO->getAdapter()->select()->from(array("c" => TB_RELACIONAMENTO))
                    ->join(array("cr" => TB_CONTRATO), "c.idContrato = cr.id", "id")
                    ->join(array("l" => TB_LOTES), "cr.id_lote = l.id", array("lote", "quadra"))
                    ->join(array("p" => TB_PESSOA), "p.id = cr.id_pessoa", "nm_pessoa")
                    ->join(array("e" => TB_EMPREENDIMENTO), "l.id_empreendimento = e.id", array('nm_empreendimento'))
                    ->join(array("u" => TB_USUARIO), "u.id = c.usuario", array('login'))
                    ->join(array("a" => TB_AGRUPADA), "a.idCampo = c.agr_idStatus AND idTabela = '" . Db_TabelaAgrupada::TABLE_STATUS_CONTATO . "'", "descricao")
                    ->where($filtroContato)->order(array("p.nm_pessoa", "c.data DESC"));

                /*
                 * Confere Ativos e Inativos
                 */
                if ($_POST['tipo'] == 'A') {
                    $contatosdetalhado = $contatosdetalhado->where('u.status = "1"');
                }

                if ($_POST['tipo'] == 'I') {
                    $contatosdetalhado = $contatosdetalhado->where('u.status != "1"');
                }

                $contatosdetalhado = $contatosdetalhado->query()->fetchAll();
                /*
                * Foreach para opo detalhado;
                */
                $horadetalhado = array();
                $dados = array();
                foreach ($contatosdetalhado as $contato) {
                    preg_match('(\d{2}:\d{2}:\d{2})', $contato['log'], $horadetalhado); //Funo que retira do log a HORA
                    $dados[$contato["idContrato"]]["cliente"] = $contato["nm_pessoa"];
                    $dados[$contato["idContrato"]]["empreendimento"] = $contato["nm_empreendimento"];
                    $dados[$contato["idContrato"]]["lote"] = $contato["lote"];
                    $dados[$contato["idContrato"]]["quadra"] = $contato["quadra"];
                    $dados[$contato["idContrato"]]["contato"][] = array(
                        "data" => Helper::getDate($contato["data"]),
                        "assunto" => $contato["assunto"],
                        "usuario" => $contato['login'],
                        "situacao" => $contato["descricao"],
                        "hora" => $horadetalhado[0] //Array exato da HORA trazida da funo preg_match

                    );
                }

                //dados que sero utilizados
                $this->set("dados", $dados);
            }

            if ($_POST['tipo'] == 'A') {
                $contatos = $contatos->where('u.status = "1"');
            }

            if ($_POST['tipo'] == 'I') {
                $contatos = $contatos->where('u.status != "1"');
            }

            $contatos = $contatos->query()->fetchAll();

            if (count($contatos) == 0) {
                $this->_helper->addMensagem('erro', 'No foi encontrado nenhum registro.');
            }
            $listaAtividades = array();
            $qtdeTotal = 0;

            foreach ($contatos as $contato) {
                $qtdeTotal += $contato['qtdeContatos'];
            }

            foreach ($contatos as $value => $contato) {
                $listaAtividades[$value]['atividade'] = $contato['descricao'];
                $listaAtividades[$value]['qtde'] = $contato['qtdeContatos'];
                $listaAtividades[$value]['empreendimento'] = $contato['nm_empreendimento'];
                $listaAtividades[$value]['nome'] = $contato['nm_pessoa'];
                $listaAtividades[$value]['porc'] = ($contato['qtdeContatos'] / $qtdeTotal) * 100;
            }

            $cabecalho = array();
            $cabecalho['empreendimento'] = $contatos[0]["nm_empreendimento"];
            $cabecalho['usuario'] = $contatos[0]["login"];
            $cabecalho['periodoData'] = $_POST["dataDe"] . ' ate ' . $_POST["dataAte"];
            $cabecalho['qtdeTotalAtividades'] = count($listaAtividades);
            $cabecalho['qtdeTotal'] = $qtdeTotal;
            switch ($_POST['situacao']) {
                case 'An':
                    $cabecalho['situacao'] = 'ANALTICO';
                    break;
                case 'Si':
                    $cabecalho['situacao'] = 'SINTTICO';
                    break;
                case 'De':
                    $cabecalho['situacao'] = 'DETALHADO';
                    break;
            }
            // dados que sero utilizados pelo relatrio
            $this->set("listaAtividades", $listaAtividades);
            $this->set("cabecalho", $cabecalho);
            $this->set('listaUsuarios', $listaUsuarios);

            $this->display('gerar');
            $this->displayMPDF("produtividade.pdf");
        } else {
            $this->set('empreendimentos', $emps);
            $this->set('usuarios', $listaUsuarios);
        }
        $this->set('empreendimentos', $emps);
        $this->display('form');
    }

    /**
     *
     * funo que valida o formulrio
     */
    public function validarAction()
    {
        if ($this->_isPost) {
            $campos = array(
                'idEmpreendimento' => "Selecione um Empreendimento!",
                'tipoContato' => "Selecione um tipo!",
                'idUsuario' => "Selecione um Usurio!"
            );
            foreach ($campos as $campo => $msg) {
                if ($_POST[$campo] == '') {
                    $this->_helper->addMensagem($campo, $msg);
                }
            }

            // setandos os filtros
            if (!in_array("*", $_POST["idEmpreendimento"])) {
                $filtroContato[] = "e.id IN " . Helper::arrayParaCondicaoIN($_POST['idEmpreendimento']) . " ";
            }

            if (!in_array("*", $_POST["idUsuario"])) {
                $filtroContato[] = " c.usuario IN " . Helper::arrayParaCondicaoIN($_POST["idUsuario"]) . " ";
            }
            if (!in_array("*", $_POST["tipoContato"])) {
                $filtroContato[] = "c.agr_idStatus IN " . Helper::arrayParaCondicaoIN($_POST["tipoContato"]) . " ";
            }
            if ($_POST["dataDe"]) {
                $filtroContato[] = " data >= '" . Helper::getInputDate($_POST["dataDe"]) . "'";
            }
            if ($_POST["dataAte"]) {
                $filtroContato[] = " data <= '" . Helper::getInputDate($_POST["dataAte"]) . "'";
            }

            $filtroContato = implode(" AND ", $filtroContato);

            $TB_RELACIONAMENTO = new Relacionamento();
            $contatos = $TB_RELACIONAMENTO->getAdapter()->select()
                ->from(array("c" => TB_RELACIONAMENTO), array('qtdeContatos' => 'COUNT(c.id)', 'agr_idStatus'))
                ->join(array("cr" => TB_CONTRATO), "c.idContrato = cr.id", array())
                ->join(array("l" => TB_LOTES), "cr.id_lote = l.id", array())
                ->join(array("e" => TB_EMPREENDIMENTO), "e.id = l.id_empreendimento", array('nm_empreendimento'))
                ->join(array("u" => TB_USUARIO), "u.id = c.usuario", array('login'))
                ->join(array("a" => TB_AGRUPADA), "a.idCampo = c.agr_idStatus AND a.idTabela = 11", array('idCampo', 'descricao'))
                ->group(($_POST['situacao'] == 'An') ? array('e.nm_empreendimento', 'c.usuario', 'agr_idStatus') : array('c.usuario', 'agr_idStatus'))
                ->where($filtroContato)
                ->order(array("a.descricao"))
                ->query()->fetchAll();

            if (count($contatos) == 0) {
                $this->_helper->addMensagem('erro', 'No foi encontrado nenhum registro.');
            }

            if ($_POST["dataDe"] == '' || $_POST["dataAte"] == '') {
                $this->_helper->addMensagem('erro', 'O campo Data deve ser preenchido.');
            }
            //Alterada validao, para verificar as informaes agora pelo AJAX
            if (count($this->_helper->getMensagens()) > 0) {
                $msgErros = '';
                foreach ($this->_helper->getMensagens() as $msg => $a)
                    $msgErros .= utf8_encode($a) . '<br>';
                echo json_encode(array('msgErros' => $msgErros));
            } else {
                echo json_encode(true);
            }
        }
    }
}
