<?php

class PrevistovsRealizadoController extends Controller
{
    protected $tb_empreendimento;
    protected $tb_parcela;
    protected $tb_parcela_historico;
    protected $tb_cliente;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_empreendimento = new Empreendimento();
        $this->tb_parcela = new Parcela();
        $this->tb_parcela_historico = new ParcelaHistorico();
        $this->tb_cliente = new Db_Cliente();
    }

    public function indexAction()
    {
        $this->set('empreendimentos', $this->tb_empreendimento->getEmpreendimentos());
        $this->display("index");
    }

    public function relatorioAction()
    {
        ini_set("memory_limit", "3000M");
        //Tipos de parcela e baixa
        $tiposParcela = implode("','", $_POST['tp_parcela']);
        $tiposPagamento = implode("','", $_POST['tp_pagamento']);

        $relatorio = [];
        $tb_empreendimento = new Empreendimento();
        //seleciona o empreendimento pelo id fornecido pelo POST
        $idEmp = $_POST['empreendimento_percentuais'];
        $emp = $tb_empreendimento->fetchRow('id = ' . $_POST["empreendimento_id"] )->toArray();
        $this->set("empreendimentoInfo", $emp);
        $relatorio['empreendimento'] = $emp['nm_empreendimento'];
        $relatorio['tiposPagamento'] = implode(",", $_POST['tp_pagamento']);

        //Datas para relatorio
        if ($_POST['ano']) {
            $dataDe = $_POST['ano'] . '-01-01';
            $dataAte = $_POST['ano'] . '-12-31';
            $relatorio['ano'] = $_POST['ano'];
        } else {
            $dataDe = Helper::getInputDate($_POST['de']);
            $dataAte = Helper::getInputDate($_POST['ate']);
            $relatorio['dataDe'] = $_POST['de'];
            $relatorio['dataAte'] = $_POST['ate'];
        }

        //Consulta db parcelas
        $parcelas = $this->tb_parcela->findParcelasByIdEmpreendimento($_POST['empreendimento_id'], $dataDe, $dataAte, $tiposParcela);

        if ($parcelas) {
            //Qnt valor previsto
            $relatorio['valorPrevistoQuantidadeParc'] = count($parcelas);

            foreach ($parcelas as $parcela) {
                //Valores parcelas(s)
                $vlParcela = $parcela['vl_parcela'];
                $vlMulta = $parcela['vl_multa'];
                $vlJuros = $parcela['vl_juros'];
                $vlAcrescimo = $parcela['acrescimo'];
                $vlDesconto = $parcela['desconto'];
                $totalVlParcela = $vlParcela + ($vlMulta + $vlJuros + $vlAcrescimo - $vlDesconto);

                //Soma parcelas
                $relatorio['valorPrevisto'] += $totalVlParcela;
                if ($parcela['pago'] == '0') {
                    //Parcelas no pagas previstas
                    $relatorio['valorPrevistoNaoRealizado'] += $totalVlParcela;
                    $relatorio['valorPrevistoNaoRealizadoQuantParc'] += 1;
                }
                //Se caso for apenas anual
                if ($_POST['ano']) {
                    //Pega o mes da parcela
                    $dataMes = substr($parcela['dt_parcela'], -5, 2);
                    //Divide os valores
                    $relatorio['mes'][$dataMes]['valorPrevisto'] += $totalVlParcela;

                    if ($parcela['pago'] == '0') {
                        //Parcelas no pagas previstas
                        $relatorio['mes'][$dataMes]['valorPrevistoNaoRealizado'] += $totalVlParcela;
                        $relatorio['mes'][$dataMes]['valorPrevistoNaoRealizadoQuantParc'] += 1;
                    }
                }
            }

            $parcelasPrevistoErealizado = $this->tb_parcela->findParcelasByIdEmpreendimento($_POST['empreendimento_id'], $dataDe, $dataAte, $tiposParcela, $tiposPagamento);

            foreach ($parcelasPrevistoErealizado as $parcela) {
                //Valores parcela(s)
                $vlParcela = $parcela['vl_parcela'];
                $vlMulta = $parcela['vl_multa'];
                $vlJuros = $parcela['vl_juros'];
                $vlAcrescimo = $parcela['acrescimo'];
                $vlDesconto = $parcela['desconto'];
                $totalVlParcela = $vlParcela + ($vlMulta + $vlJuros + $vlAcrescimo - $vlDesconto);

                if ($parcela['pago'] == '1') {
                    //Parcelas pagas previstas
                    $relatorio['valorPrevistoRealizado'] += $totalVlParcela;
                    $relatorio['valorPrevistoRealizadoQuantParc'] += 1;
                }
                //Se caso for apenas anual
                if ($_POST['ano']) {
                    //Pega o mes da parcela
                    $dataMes = substr($parcela['dt_parcela'], -5, 2);

                    if ($parcela['pago'] == '1') {
                        //Parcelas pagas previstas
                        $relatorio['mes'][$dataMes]['valorPrevistoRealizado'] += $totalVlParcela;
                        $relatorio['mes'][$dataMes]['valorPrevistoRealizadoQuantParc'] += 1;
                    }
                }
            }

            //Porcentagem para realizadas e no realizadas
            $relatorio['valorPrevistoRealizadoPorcentagem'] = ( $relatorio['valorPrevistoRealizado'] * 100 ) / $relatorio['valorPrevisto'];
            $relatorio['valorPrevistoNaoRealizadoPorcentagem'] = ( $relatorio['valorPrevistoNaoRealizado'] * 100 ) / $relatorio['valorPrevisto'];

            //Consulta db parcelas (apenas pagas com tipo de pagamento)
            $parcelasPagas = $this->tb_parcela->findParcelasPagasByIdEmpreendimento($_POST['empreendimento_id'], $dataDe, $dataAte, $tiposParcela, $tiposPagamento);
            //Quantidade de parcelas
            $relatorio['valorRecebidoAtivoQuantParc'] = count($parcelasPagas);

            foreach ($parcelasPagas as $parcelaPaga) {
                //Soma valor recebido ativas
                $relatorio['valorRecebidoAtivo'] += $parcelaPaga['vl_total_pago'];

                //Valores em detalhamento
                $relatorio['valorDasParcelas'] += $parcelaPaga['vl_parcela'];
                $relatorio['valorMultas'] += $parcelaPaga['vl_multa'];
                $relatorio['valorJuros'] += $parcelaPaga['vl_juros'];
                $relatorio['valorDesconto'] += $parcelaPaga['desconto'];
                $relatorio['valorAcrescimo'] += $parcelaPaga['acrescimo'];

                //Pagas no vencimento
                if ($parcelaPaga['dt_parcela'] == $parcelaPaga['dt_pagamento']) {
                    $relatorio['pagoNoVencimento'] += $parcelaPaga['vl_total_pago'];
                    $relatorio['pagoNoVencimentoQuantParc'] += 1;
                }

                //Recuperao indimplncia
                if ($parcelaPaga['dt_parcela'] < $parcelaPaga['dt_pagamento']) {
                    $relatorio['recInadimplencia'] += $parcelaPaga['vl_total_pago'];
                    $relatorio['recInadimplenciaQuantParc'] += 1;
                }
                
                //Antecipacao
                if ($parcelaPaga['dt_parcela'] > $parcelaPaga['dt_pagamento']) {
                    $relatorio['valorAntecipado'] += $parcelaPaga['vl_total_pago'];
                    $relatorio['valorAntecipadoQuantParc'] += 1;
                }

                //Se caso for apenas anual
                if ($_POST['ano']) {
                    //Pega o mes da parcela
                    $dataMes = substr($parcelaPaga['dt_pagamento'], -5, 2);
                    
                    //Divide os valores
                    $relatorio['mes'][$dataMes]['valorRecebidoPeriodo'] += $parcelaPaga['vl_total_pago'];
                }
            }
            //Porcentagem pagas, inadimplencia, antecipacao
            $pagamentoTotalParcelas = $relatorio['pagoNoVencimento'] + $relatorio['recInadimplencia'] + $relatorio['valorAntecipado'];
            $relatorio['pagoNoVencimentoPorcentagem'] = ( $relatorio['pagoNoVencimento'] * 100 ) / $pagamentoTotalParcelas;
            $relatorio['recInadimplenciaPorcentagem'] = ( $relatorio['recInadimplencia'] * 100 ) / $pagamentoTotalParcelas;
            $relatorio['valorAntecipadoPorcentagem'] = ( $relatorio['valorAntecipado'] * 100 ) / $pagamentoTotalParcelas;

            //Consulta db parcela_historico
            $parcelasHistPagas = $this->tb_parcela_historico->findParcelasHistPagasByIdEmpreendimento($_POST['empreendimento_id'], $dataDe, $dataAte, $tiposParcela, $tiposPagamento);
            //Quantidade de parcelas em historico
            $relatorio['valorRecebidoHistoricoQuantParc'] = count($parcelasHistPagas);
            $relatorio['quantidadeAtivosHistorico'] = $relatorio['valorRecebidoHistoricoQuantParc'] + $relatorio['valorRecebidoAtivoQuantParc'];

            foreach ($parcelasHistPagas as $parcelaHistPaga) {
                //Soma valor recebido histrico 
                $relatorio['valorRecebidoHistorico'] += $parcelaHistPaga['vl_total_pago'];

                //Valores em detalhamento
                $relatorio['valorDasParcelas'] += $parcelaHistPaga['vl_parcela'];
                $relatorio['valorMultas'] += $parcelaHistPaga['vl_multa'];
                $relatorio['valorJuros'] += $parcelaHistPaga['vl_juros'];
                $relatorio['valorDesconto'] += $parcelaHistPaga['desconto'];
                $relatorio['valorAcrescimo'] += $parcelaHistPaga['acrescimo'];

                //Pagas no vencimento
                if ($parcelaHistPaga['dt_parcela'] == $parcelaHistPaga['dt_pagamento']) {
                    $relatorio['pagoNoVencimento'] += $parcelaHistPaga['vl_total_pago'];
                    $relatorio['pagoNoVencimentoQuantParc'] += 1;
                }

                //Recuperao indimplncia
                if ($parcelaHistPaga['dt_parcela'] < $parcelaHistPaga['dt_pagamento']) {
                    $relatorio['recInadimplencia'] += $parcelaHistPaga['vl_total_pago'];
                    $relatorio['recInadimplenciaQuantParc'] += 1;
                }
                
                //Antecipacao
                if ($parcelaHistPaga['dt_parcela'] > $parcelaHistPaga['dt_pagamento']) {
                    $relatorio['valorAntecipado'] += $parcelaHistPaga['vl_total_pago'];
                    $relatorio['valorAntecipadoQuantParc'] += 1;
                }
                //Se caso for apenas anual
                if ($_POST['ano']) {
                    //Pega o mes da parcela
                    $dataMes = substr($parcelaHistPaga['dt_pagamento'], -5, 2);
                    
                    //Divide os valores
                    $relatorio['mes'][$dataMes]['valorRecebidoPeriodo'] += $parcelaHistPaga['vl_total_pago'];
                }
            }
            //Soma em detalhamento valor total do perodo
            $relatorio['valorTotalPeriodo'] = $relatorio['valorRecebidoAtivo'] + $relatorio['valorRecebidoHistorico'];            
        }
        $this->set('relatorio', $relatorio);
        //Consulta empreendimento cabealho
        $this->set('empreendimento', $this->tb_empreendimento->findEmpreendimentoDados($_POST['empreendimento_id']));
        //Consulta Dados Cliente
        $this->set('cliente', $this->tb_cliente->getCliente());

        $this->display('relatorio');
        $this->displayMPDF('relatorioPrevistoRealizado');
    }

    public function validarAction()
    {
        $campos = array('empreendimento_id');
        $campos[] = $_POST['ano'] ? 'ano' : 'de';
        $campos[] = $_POST['ano'] ? 'ano' : 'ate';

        foreach ($campos as $cp) {
            if ($_POST[$cp] == "") {
                switch ($cp) {
                    case 'empreendimento_id':
                        $msg = "O campo Empreendimento  obrigatrio.";
                        break;
                    case 'de':
                        $msg = "Preencha as datas corretamente.";
                        break;
                    case 'ate':
                        $msg = "Preencha as datas corretamente.";
                        break;
                    default:
                        $msg = '';
                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }

        if (count($_POST['tp_parcela']) == 0) {
            $msg = "Selecione pelo menos um tipo de parcela.";
            $this->_helper->addMensagem('tp_parcela', $msg);
        }

        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            echo json_encode(true);
        }
    }
}
