<?php

class LoteRelatorioController extends Controller
{

    protected $tb_cliente;
    protected $tb_parcela;
    protected $ordem;
    protected $empreendimento;
    protected $contato;
    protected $lote;

    public function __construct($request)
    {
        parent::__construct($request);

        $this->ordem = $_POST['ordem'];
        $this->empreendimento = new Empreendimento();
        $this->contato = new Relacionamento();

        if ($this->ordem == 1) {
            $this->ordem = array("lote", "quadra");
        } else {
            $this->ordem = array("quadra", "lote");
        }

        $this->tb_cliente = new Db_Cliente();
        $this->lote = new Lote();
        $this->tb_parcela = new Parcela();

        $this->set("subtitulo", "Relatrio de Lotes");
        $this->set('nomeTela', "Relatrio de Lotes");
    }

    public function indexAction()
    {
        $this->carregarDados();
        $this->display("index");
    }

    public function relatorioAction()
    {
        ini_set('memory_limit', '1024M');
        set_time_limit(0);

        if ($this->_isPost) {
            //Transforma o array em uma nica varivel
            if (count($_POST['construcao']) == 1) {
                $_POST['construcao'] = $_POST['construcao'][0];
            } else {
                $_POST['construcao'] = '';
            }
            $this->set('flagTipo', $_POST['tipo']);

            $empreendimento = new Empreendimento();
            $empreendimentoInfo = $empreendimento->getAdapter()->select()->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento','ds_path_logo'))
                ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
                ->where('id = ' . $_POST['empreendimento_relatorio_lote'])->query()->fetch();
            $this->set("empreendimentoInfo", $empreendimentoInfo);

            $parcelaSinal = false;

            //Caso o cliente queira exibir a descrio no relatrio
            if ($_POST['exibirObs'] == 'S') {
                $this->set('exibirObs', 'S');
            }
            // v qual o tipo de relatrio
            switch ($_POST['tipo']) {
                // todos os lotes
                case 'T':
                    $lotes = $this->lote->findLotesTodos($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio'], true, $_POST['fl_caucionado']);
                    $width = array('lote' => '30px', 'quadra' => '30px', 'area' => '50px', 'situacao' => '10px', 'contrato' => '45px', 'cliente' => '195px', 'const' => '10px', 'valor' => '65px', 'vendido' => '80px');

                    //Caso sejam todos os lotes e no apenas 1 para exibio de resumo no relatorio
                    if ($_POST['lote_relatorio_lote'] == '*') {
                        $this->set('loteTodos', 'true');
                    }

                    $this->set('tipo', 'TODOS');
                    $this->set('colspan', 4);
                    $this->set('fix', 5);
                    $this->set('padding-left', '2rem');
                    $this->set('largura', $width);
                    break;
                // lotes vendidos com quitados
                case 'V':
                    $lotes = $this->lote->findLotesVendidos($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio']);
                    $width = array('lote' => '30px', 'quadra' => '30px', 'area' => '40px', 'contrato' => '40px', 'cliente' => '195px', 'const' => '10px',
                        'valor' => '65px', 'vendido' => '80px');

                    $this->set('tipo', 'VENDIDOS COM QUITADOS');
                    $this->set('colspan', 4);
                    $this->set('fix', 5);
                    $this->set('padding-left', '2rem');
                    $this->set('largura', $width);
                    break;
                // lotes vendidos sem quitados
                case 'SQ':
                    $lotes = $this->lote->findLotesQuitados($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio'], false, false);
                    $width = array('lote' => '30px', 'quadra' => '30px', 'area' => '40px', 'contrato' => '40px', 'cliente' => '195px', 'const' => '10px',
                        'valor' => '65px', 'vendido' => '80px');

                    $this->set('tipo', 'VENDIDOS SEM QUITADOS');
                    $this->set('colspan', 4);
                    $this->set('fix', 5);
                    $this->set('padding-left', '2rem');
                    $this->set('largura', $width);
                    break;
                // lotes quitados
                case 'Q':
                    $lotes = $this->lote->findLotesQuitados($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio']);
                    $width = array('lote' => '30px', 'quadra' => '30px', 'area' => '50px', 'contrato' => '50px', 'cliente' => '200px', 'const' => '10px',
                    'vlTotalPago' => '80px', 'vendido' => '80px');

                    $this->set('tipo', 'QUITADOS');
                    $this->set('colspan', 4);
                    $this->set('fix', 5);
                    $this->set('padding-left', '2rem');
                    $this->set('largura', $width);
                    break;
                // lotes quitados sinal
                case 'QS':
                    $parcelaSinal = true;
                    $lotes = $this->lote->findLotesQuitados($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio'], $parcelaSinal);
                    $width = array('lote' => '30px', 'quadra' => '30px', 'area' => '50px', 'contrato' => '50px', 'cliente' => '200px', 'const' => '10px',
                        'valor' => '65px', 'vendido' => '80px');

                    $this->set('tipo', 'QUITADOS SINAL');
                    $this->set('colspan', 4);
                    $this->set('fix', 5);
                    $this->set('padding-left', '2rem');
                    $this->set('largura', $width);
                    break;
                // lotes em negociacao
                case 'EN':
                    $lotes = $this->lote->findLotesEmNegociacao($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio']);
                    $width = array('lote' => '50px', 'quadra' => '50px', 'area' => '70px', 'contrato' => '70px', 'cliente' => '170px', 'const' => '80px',
                        'valor' => '65px', 'vendido' => '80px');

                    $this->set('tipo', 'EM NEGOCIAO');
                    $this->set('colspan', 4);
                    $this->set('fix', 5);
                    $this->set('padding-left', '2rem');
                    $this->set('largura', $width);
                    break;
                // lotes reservado para cliente
                case 'RC':
                    $lotes = $this->lote->findLotesReservadosCliente($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio']);
                    $width = array('lote' => '50px', 'quadra' => '50px', 'area' => '70px','cliente' => '170px', 'Corretor' => '120px','DataResenva' => '90px','dataExpiracaoReserva'=>'150px');

                    $this->set('tipo', 'RESERVADOS');
                    $this->set('colspan', 4);
                    $this->set('fix', 5);
                    $this->set('padding-left', '2rem');
                    $this->set('largura', $width);
                    break;
                // lotes em reserva tcnica
                case 'RT':
                    $lotes = $this->lote->findLotesReservaTecnica($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio']);
                    $width = array('lote' => '30px', 'quadra' => '30px', 'area' => '50px', 'contrato' => '70px', 'cliente' => '170px', 'const' => '10px',
                        'valor' => '65px', 'vendido' => '80px' ,'DataResenva' => '90px',);

                    $this->set('tipo', 'EM RESERVA TCNICA');
                    $this->set('colspan', 3);
                    $this->set('fix', 5);
                    $this->set('padding-left', '2rem');
                    $this->set('largura', $width);
                    break;
                // lotes disponveis
                case 'D':
                    $lotes = $this->lote->findLotesDisponiveis($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], true, $_POST['loteRelatorio']);
                    $width = array('lote' => '80px', 'quadra' => '80px', 'area' => '90px', 'const' => '80px', 'valor' => '120px', 'vendido' => '120px');

                    $this->set('tipo', 'DISPONVEIS');
                    $this->set('colspan', 3);
                    $this->set('fix', 4);
                    $this->set('padding-left', '2rem');
                    $this->set('largura', $width);
                    break;
                // lotes detalhado
                case 'LD':
                    $lotes = $this->lote->findLotesLocalizacao($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio']);
                    $width = array('lote' => '40px', 'quadra' => '40px', 'area' => '50px', 'esquerda' => '50px', 'direita' => '50px', 'frente' => '50px', 'fundo' => '50px',
                        'confEsq' => '150px', 'confDir' => '150px', 'confFre' => '150px', 'confFun' => '150px', 'confFun' => '150px', 'dsGeral' => '40px', 'rgi' => '80px');

                    $this->set('tipo', 'MEMORIAL DESCRITIVO');
                    if ($_POST['exibirConf'] == '1') {
                        $colspan = 3; $fix = 11;
                    } else {
                        $colspan = 7; $fix = 4;
                    }
                    $this->set('colspan', $colspan);
                    $this->set('fix', $fix);
                    $this->set('largura', $width);
                    break;
                // VGV
                case 'G':
                    $lotes = $this->lote->findLotesTodos($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio'],true);
                    $width = array('lote' => '45px', 'quadra' => '40px', 'area' => '50px', 'situacao' => '10px', 'contrato' => '50px', 'cliente' => '170px',
                        'const' => '10px', 'valor' => '65px', 'vendido' => '80px');

                    //Caso sejam todos os lotes e no apenas 1 para exibio de resumo no relatorio
                    if ($_POST['lote_relatorio_lote'] == '*') {
                        $this->set('loteTodos', 'true');
                    }
                    $this->set('tipo', 'VGV');
                    $this->set('colspan', 4);
                    $this->set('fix', 5);
                    $this->set('padding-left', '2rem');
                    $this->set('largura', $width);
                    break;
                //Financeiro
                case 'F':
                    $lotes = $this->lote->findLotesVendidos($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio']);
                    $width = array('lote' => '45px', 'quadra' => '40px', 'cliente' => '170px', 'vlTotalContrato' => '80px', 'vlTotalPago' => '80px', 'vlTotalAberto' => '80px', 'saldoDevedor' => '80px', 'situao' => '80px');

                    if ($_POST['lote_relatorio_lote'] == '*') {
                        $this->set('loteTodos', 'true');
                    }

                    $this->set('tipo', 'FINANCEIRO');
                    $this->set('colspan', 3);
                    $this->set('fix', 2);
                    $this->set('padding-left', '2rem');
                    $this->set('largura', $width);
                    break;

                case 'S':
                    $lotes = $this->lote->findLotesVendidos($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio'], true);

                    $loteVerificador = null;
                    for($i = 0; $i< count($lotes); $i++){
                        //Verifica se o contrato está duplicado
                        if($lotes[$i]['contrato'] == $loteVerificador){
                            unset($lotes[$i]);
                            sort($lotes);
                        }
                        $loteVerificador = $lotes[$i]['contrato']; 
                    }

                    $width = array('lote' => '45px', 'quadra' => '40px', 'cliente' => '170px', 'vlTotalContrato' => '80px', 'vlTotalPago' => '80px', 'vlTotalAberto' => '80px', 'saldoDevedor' => '80px', 'parcelaAberta' => '80px', 'parcelaspagas' => '80px','parcelasParaPagar' => '80px');
    
                    if ($_POST['lote_relatorio_lote'] == '*') {
                            $this->set('loteTodos', 'true');
                    }
    
                    $this->set('tipo', 'SALDOS');
                    $this->set('colspan', 3);
                    $this->set('fix', 2);
                    $this->set('padding-left', '2rem');
                    $this->set('largura', $width);
                    break;  
                    
                //Price
                case 'PR':
                    $lotes = $this->lote->findLotesPrice($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio']);
                    $width = array('lote' => '45px', 'quadra' => '40px', 'cliente' => '100px', 'vlTotalContrato' => '80px', 'vlTotalPago' => '80px', 'vlTotalAberto' => '80px', 'saldoDevedor' => '80px', 'vlDivida' => '80px', 'situao' => '80px');

                    if ($_POST['lote_relatorio_lote'] == '*') {
                        $this->set('loteTodos', 'true');
                    }

                    $this->set('tipo', 'PRICE');
                    $this->set('colspan', 3);
                    $this->set('fix', 2);
                    $this->set('padding-left', '2rem');
                    $this->set('largura', $width);
                    break;
                
            }

            $relatorio = $this->carregarDadosTipo($lotes);
        } else {
            $relatorio = false;
        }
        if ($relatorio) {
            $this->display("relatorio");
            if ($_POST['tipoRel'] == 'html') {
                exit(); //No gera em PDF
            }
            if ($_POST['tipo'] == 'LD' && $_POST['exibirConf'] != '1') {
                $this->displayMPDF('relatorio_' . $relatorio[0] . '_' . date('d/m/Y') . '.pdf', true, 'L');
            } else {
                $this->displayMPDF('relatorio_' . $relatorio[0] . '_' . date('d/m/Y') . '.pdf');
            }
        } else {
            $this->carregarDados();
            $this->display('index');
        }
    }
    // carrega dados para exibir relatrio de lotes vendidos
    private function carregarDadosTipo($lotes)
    {
        // Configura o POST de situaes
        if (count($_POST['exibirSitu']) == 1) {
            $_POST['exibirSitu'] = $_POST['exibirSitu'][0];
        } else {
            $_POST['exibirSitu'] = 'T';
        }
        $cliente = $this->tb_cliente->getAdapter()->select()
            ->from(array('c' => TB_CLIENTE), array('cd_cliente', 'cd_municipio', 'nm_razao_social', 'ds_end_logomarca'))
            ->query()->fetch();

        $empreendimento = new Empreendimento();
        $empreendimento = $empreendimento->findEmpreendimento($_POST['empreendimento_relatorio_lote']);
        $this->set('cliente', $cliente);

        if (count($lotes)) {
            // faz os clculos dos totais pra exibir no final
            $totalLotesVendidos = 0;
            $totalLotes = 0;
            $totalLotesAbertos = 0;
            $totalLotesQuitados = 0;
            $valorTotalDisponiveis = 0;
            $valorTotalReservados = 0;
            $valorTotalNegociados = 0;
            $valorTotalQuitados = 0;
            $valorTotalLotesVendidos = 0;
            $totalLotesNegociacao = 0;
            $totalLotesRT = 0;
            $totalLotesReservado = 0;
            $valorVendaTotal = 0;
            $totalLotesFinanceiro = 0;

            foreach ($lotes as $key => &$lote) {

                //varivel responsvel por armazenar a quantidade de parcelas atrasadas.
                $qtdParcelasAtrasadas = 0;
                //conta a quantidade de parcelas em aberto para serem exibidas no campo "Situao".
                $qtdParcelaEmAberto = 0;
                // calcula o valor total do lote
                $totalParcial = 0;

                //Sinal
                if ($lote['contrato']) {
                    $sinal = Sinal::findByContrato($lote['contrato']);
                    if (count($sinal) > 0)
                        foreach ($sinal as $s) {
                            $totalParcial += $s['valor'];
                        }
                }

                $totalParcial += ($lote['vl_parcela'] > 0) ? $lote['nr_parcela'] * $lote['vl_parcela'] : 0;
                $totalParcial += ($lote['vl_intercalada'] > 0) ? $lote['vl_intercalada'] * $lote['nr_intercalada'] : 0;
                $totalParcial += ($lote['vl_parcela_entrega'] > 0) ? $lote['vl_parcela_entrega'] * $lote['nr_parcela_entrega'] : 0;

                //Verifica se existem itens adicionais do contrato
                if ($lote['contrato'] && $lote['fl_itens_contrato'] == 1) {
                    $itensContrato = ContratoItens::findByContrato($lote['contrato']);

                    if (count($itensContrato) > 0) {
                        foreach ($itensContrato as $item) {
                            $totalParcial += ((float)$item['vl_parcela'] * (int)$item['qt_parcelas']);
                        }
                    }
                }

                $totalLotes++;

                //Valor total do contrato
                $totalParcial = floatval($totalParcial);
                if ($totalParcial == 0) {
                    if (($_POST['tipo'] == 'G' || $_POST['tipo'] == 'D')){
                        if (isset($lote['valorTabela'])) {
                            $lote['valor'] = $lote['valorTabela'];
                        }
                    }
                    $totalParcial = $lote['valor'];
                }
                    
                $lote['total'] = $totalParcial;

                if ($lote['status'] == 'D') {
                    $lote['situacao'] = 'Disponvel';
                    $valorTotalDisponiveis += $totalParcial;
                    $totalLotesAbertos++;
                } elseif ($lote['status'] == 'V' && $lote['fl_aprovar_contrato'] == '1') {
                    $lote['situacao'] = 'Vendido';
                    $valorTotalLotesVendidos += $totalParcial;
                    $totalLotesVendidos++;
                } elseif ($lote['status'] == 'N' && $lote['fl_aprovar_contrato'] == '0') {
                    $lote['situacao'] = 'Negociao';
                    $totalLotesNegociacao++;
                    $valorTotalNegociados += $totalParcial;
                } elseif ($lote['status'] == 'Q') {
                    $dtQuitacao = Parcela::getUltimaPaga($lote['contrato']);
                    $lote['situacao'] = ($dtQuitacao != '') ? 'Quitado em ' . Helper::getDate($dtQuitacao) : 'Quitado';
                    $valorTotalQuitados += $totalParcial;
                    $totalLotesQuitados++;
                } elseif ($lote['status'] == 'RT') {
                    $lote['situacao'] = 'RT';
                    $valorTotalReservados += $totalParcial;
                    $totalLotesRT++;
                } elseif ($lote['status'] == 'RC') {
                    $lote['situacao'] = 'Reservado';
                    $valorTotalReservados += $totalParcial;
                    $totalLotesReservado++;
                }
                
                //caso o tipo do contrato seja FINANCEIRO, executa as operaes dentro do if abaixo.
                if ($_POST['tipo'] == 'F') {
                    //busca as parcelas do contrato em questo
                    $parcelas = $this->tb_parcela->getAdapter()->select()
                        ->from(array('p' => TB_PARCELA), array('*'))
                        ->where('p.id_contrato = "'.$lote['contrato'].'"')
                        ->where('p.tp_parcela NOT IN ("SE", "NE", "IE", "CE", "E")')
                        ->query()->fetchAll();

                        //foreach responsvel por calcular o saldo devedor, vl.total pago, vl.total em aberto e situao, do relatrio tipo FINANCEIRO.
                    foreach ($parcelas as $parcela) {
                        //if para calcular o VALOR TOTAL PAGO.
                        if ($parcela['pago'] == '1') {
                            $lote['vlTotalPago'] += $parcela['vl_parcela'];

                        //elseif para calcular o VALOR TOTAL EM ABERTO.
                        } elseif ($parcela['pago'] == '0' && $parcela['dt_parcela'] < date('Y-m-d')) {
                            $lote['vlTotalAberto'] += $parcela['vl_parcela'];
                            $lote['qtdParcelasEmAberto'] = ++$qtdParcelaEmAberto;
                            $lote['vlSaldoDevedor'] += $parcela['vl_parcela'];
                            $qtdParcelasAtrasadas++;

                        //if para somar o valor total do saldo devedor do cliente e contar a quantidade de parcelas atrasadas.
                        } elseif ($parcela['pago'] == '0') {
                            $lote['vlSaldoDevedor'] += $parcela['vl_parcela'];
                        }
                    }

                    if ($_POST['exibirSitu'] == 'T') {
                        //adiciona a quantidade de parcelas atrasadas ao compo em abaixo, do lote que est sendo analisado.
                        $lote['qtdParcelasAtrasadas'] = $qtdParcelasAtrasadas;
                        //conta a quantidade total de lotes do empreendimento.
                        $totalLotesFinanceiro++;
                        $valorVendaTotal += $totalParcial;
                    }
                    elseif ($_POST['exibirSitu'] == 'A'){
                        if ($lote['vlTotalAberto'] != '') {
                            unset($lotes[$key]);
                        } else {
                            //adiciona a quantidade de parcelas atrasadas ao compo em abaixo, do lote que est sendo analisado.
                            $lote['qtdParcelasAtrasadas'] = $qtdParcelasAtrasadas;
                            //conta a quantidade total de lotes do empreendimento.
                            $totalLotesFinanceiro++;
                            $valorVendaTotal += $totalParcial;
                        }
                    }
                    elseif ($_POST['exibirSitu'] == 'I'){
                        if ($lote['vlTotalAberto'] == '') {
                            unset($lotes[$key]);
                        } else {
                            //adiciona a quantidade de parcelas atrasadas ao compo em abaixo, do lote que est sendo analisado.
                            $lote['qtdParcelasAtrasadas'] = $qtdParcelasAtrasadas;
                            //conta a quantidade total de lotes do empreendimento.
                            $totalLotesFinanceiro++;
                            $valorVendaTotal += $totalParcial;
                        }
                    }
                } else if ($_POST['tipo'] == 'S') {
                    //busca as parcelas do contrato em questo
                    $parcelas = $this->tb_parcela->getAdapter()->select()
                        ->from(array('p' => TB_PARCELA), array('*'))
                        ->where('p.id_contrato = "'.$lote['contrato'].'"')
                        ->where('p.tp_parcela NOT IN ("SE", "NE", "IE", "CE", "E")')
                        ->query()->fetchAll();

                        //foreach responsvel por calcular o saldo devedor, vl.total pago, vl.total em aberto e situao, do relatrio tipo FINANCEIRO.
                    $lote['parcelasPagas'] = 0;
                    $lote['totalPacelas'] = count($parcelas);
                    foreach ($parcelas as $parcela) {
                        if ($parcela['pago'] == '1') {
                            $lote['parcelasPagas']++;
                        }
                        //if para calcular o VALOR TOTAL PAGO.
                        if ($parcela['pago'] == '1') {
                            $lote['vlTotalPago'] += $parcela['vl_parcela'];

                        //elseif para calcular o VALOR TOTAL EM ABERTO.
                        } elseif ($parcela['pago'] == '0' && $parcela['dt_parcela'] < date('Y-m-d')) {
                            $lote['vlTotalAberto'] += $parcela['vl_parcela'];
                            $lote['qtdParcelasEmAberto'] = ++$qtdParcelaEmAberto;
                            $qtdParcelasAtrasadas++;

                        //if para somar o valor total do saldo devedor do cliente e contar a quantidade de parcelas atrasadas.
                        } elseif ($parcela['pago'] == '0') {
                            $lote['vlSaldoDevedor'] += $parcela['vl_parcela'];
                        }
                    }

                    if ($_POST['exibirSitu'] == 'T') {
                        //adiciona a quantidade de parcelas atrasadas ao compo em abaixo, do lote que est sendo analisado.
                        $lote['qtdParcelasAtrasadas'] = $qtdParcelasAtrasadas;
                        //conta a quantidade total de lotes do empreendimento.
                        $totalLotesFinanceiro++;
                        $valorVendaTotal += $totalParcial;
                    }
                    elseif ($_POST['exibirSitu'] == 'A'){
                        if ($lote['vlTotalAberto'] != '') {
                            unset($lotes[$key]);
                        } else {
                            //adiciona a quantidade de parcelas atrasadas ao compo em abaixo, do lote que est sendo analisado.
                            $lote['qtdParcelasAtrasadas'] = $qtdParcelasAtrasadas;
                            //conta a quantidade total de lotes do empreendimento.
                            $totalLotesFinanceiro++;
                            $valorVendaTotal += $totalParcial;
                        }
                    }
                    elseif ($_POST['exibirSitu'] == 'I'){
                        if ($lote['vlTotalAberto'] == '') {
                            unset($lotes[$key]);
                        } else {
                            //adiciona a quantidade de parcelas atrasadas ao compo em abaixo, do lote que est sendo analisado.
                            $lote['qtdParcelasAtrasadas'] = $qtdParcelasAtrasadas;
                            //conta a quantidade total de lotes do empreendimento.
                            $totalLotesFinanceiro++;
                            $valorVendaTotal += $totalParcial;
                        }
                    }
                }elseif ($_POST['tipo'] == 'Q') {
                    //busca as parcelas do contrato em questo
                    $parcelas = $this->tb_parcela->getAdapter()->select()
                    ->from(array('p' => TB_PARCELA), array('*'))
                    ->where('p.id_contrato = "'.$lote['contrato'].'"')
                    ->where('p.tp_parcela NOT IN ("SE", "NE", "IE", "CE", "E")')
                    ->query()->fetchAll();

                    $lote['parcelasPagas'] = 0;
                    $lote['totalPacelas'] = count($parcelas);
                    foreach ($parcelas as $parcela) {
                        if ($parcela['pago'] == '1') {
                            $lote['parcelasPagas']++;
                        }
                        //if para calcular o VALOR TOTAL PAGO.
                        if ($parcela['pago'] == '1') {
                            $lote['vlTotalPago'] += $parcela['vl_parcela'];
                        }
                    }
                }
                
                //caso o tipo do contrato seja Price, executa as operaes dentro do if abaixo
                if ($_POST['tipo'] == 'PR') {
                    //busca as parcelas do contrato em questo
                    $parcelas = $this->tb_parcela->getAdapter()->select()
                        ->from(array('p' => TB_PARCELA), array('*'))
                        ->where('p.id_contrato = "'.$lote['contrato'].'"')
                        ->where('p.tp_parcela NOT IN ("SE", "NE", "IE", "CE", "E")')
                        ->query()->fetchAll();

                        //foreach responsvel por calcular o saldo devedor, vl.total pago, vl.total em aberto e situao, do relatrio tipo PRICE.
                    foreach ($parcelas as $parcela) {
                        //if para calcular o VALOR TOTAL PAGO.
                        if ($parcela['pago'] == '1') {
                            $lote['vlTotalPago'] += $parcela['vl_parcela'];

                        //elseif para calcular o VALOR TOTAL EM ABERTO.
                        } elseif ($parcela['pago'] == '0' && $parcela['dt_parcela'] < date('Y-m-d')) {
                            $lote['vlTotalAberto'] += $parcela['vl_parcela'];
                            $lote['qtdParcelasEmAberto'] = ++$qtdParcelaEmAberto;
                            $lote['vlSaldoDevedor'] += $parcela['vl_parcela'];
                            $qtdParcelasAtrasadas++;

                        //if para somar o valor total do saldo devedor do cliente e contar a quantidade de parcelas atrasadas.
                        } elseif ($parcela['pago'] == '0') {
                            $lote['vlSaldoDevedor'] += $parcela['vl_parcela'];
                        }
                    }

                    if ($_POST['exibirSitu'] == 'T') {
                        //adiciona a quantidade de parcelas atrasadas ao compo em abaixo, do lote que est sendo analisado.
                        $lote['qtdParcelasAtrasadas'] = $qtdParcelasAtrasadas;
                        //conta a quantidade total de lotes do empreendimento.
                        $totalLotesFinanceiro++;
                        $valorVendaTotal += $totalParcial;
                    }
                    elseif ($_POST['exibirSitu'] == 'A'){
                        if ($lote['vlTotalAberto'] != '') {
                            unset($lotes[$key]);
                        } else {
                            //adiciona a quantidade de parcelas atrasadas ao compo em abaixo, do lote que est sendo analisado.
                            $lote['qtdParcelasAtrasadas'] = $qtdParcelasAtrasadas;
                            //conta a quantidade total de lotes do empreendimento.
                            $totalLotesFinanceiro++;
                            $valorVendaTotal += $totalParcial;
                        }
                    }
                    elseif ($_POST['exibirSitu'] == 'I'){
                        if ($lote['vlTotalAberto'] == '') {
                            unset($lotes[$key]);
                        } else {
                            //adiciona a quantidade de parcelas atrasadas ao compo em abaixo, do lote que est sendo analisado.
                            $lote['qtdParcelasAtrasadas'] = $qtdParcelasAtrasadas;
                            //conta a quantidade total de lotes do empreendimento.
                            $totalLotesFinanceiro++;
                            $valorVendaTotal += $totalParcial;
                        }
                    }
                
                }  else {
                    $valorVendaTotal += $totalParcial;
                }

                $contato = $this->contato->getDefaultAdapter()->select()->from(array('c' => TB_RELACIONAMENTO), array('c.idContrato', 'c.agr_idStatus'))
                    ->join(array('cr' => TB_CONTRATO), 'c.idContrato = cr.id', array())
                    ->where('c.idContrato = "'.$lote['contrato'].'"')
                    ->where("c.agr_idStatus = '13'")
                    ->query()->fetch();
                
                $lote['impresso'] = ($contato != null) ? '1' : '0';
            }

            $total['totalLotesFinanceiro'] = $totalLotesFinanceiro;
            $total['totalLotesReservado'] = $totalLotesReservado;
            $total['totalLotesRT'] = $totalLotesRT;
            $total['totalLotesNegociacao'] = $totalLotesNegociacao;
            $total['qtdLotesVendidos'] = $totalLotesVendidos;
            $total['qtdLotes'] = $totalLotes;
            $total['qtdLotesAbertos'] = $totalLotesAbertos;
            $total['valorLotesVendidos'] = $valorTotalLotesVendidos;
            $total['valorLotesNegociados'] = $valorTotalNegociados;
            $total['valorLotesDisponiveis'] = $valorTotalDisponiveis;
            $total['valorLotesReservados'] = $valorTotalReservados;
            $total['valorVendaTotal'] = $valorVendaTotal;
            $total['valorTotalQuitados'] = $valorTotalQuitados;
            $total['qtdLotesQuitados'] = $totalLotesQuitados;

            $cabecalho = array(
                'impresso' => 'Impresso por ' . Login::getUsuario()->getLogin() . ' em ' . date('d/m/Y') . ' s ' . date('H:i'),
                'empreendimento' => $empreendimento->nm_empreendimento);
            
            //Transforma o array em uma nica varivel
            if (count($_POST['construcao']) == 1) {
                $_POST['construcao'] = $_POST['construcao'][0];
            } else {
                $_POST['construcao'] = '';
            }
            //funo que permite voc escolher selecionar a opo em construo SIM, NO ou AMBOS.
            if ($_POST['construcao'] == '1'){
                $cabecalho['construcao'] = '(X) SIM ( ) NO';
            } elseif ($_POST['construcao'] == '0') {
                $cabecalho['construcao'] = '( ) SIM (X) NO';
            } else {
                $cabecalho['construcao'] = '(X) SIM (X) NO';
            }
            

            if (count($_POST['fl_caucionado']) == 1) {
                $_POST['fl_caucionado'] = $_POST['fl_caucionado'][0];
            } else {
                $_POST['fl_caucionado'] = '';
            }
            //funo que permite voc escolher selecionar a opo em construo SIM, NO ou AMBOS.
            if ($_POST['fl_caucionado'] == '1'){
                $cabecalho['fl_caucionado'] = '(X) SIM ( ) NO';
            } elseif ($_POST['fl_caucionado'] == '0') {
                $cabecalho['fl_caucionado'] = '( ) SIM (X) NO';
            } else {
                $cabecalho['fl_caucionado'] = '(X) SIM (X) NO';
            }

            //Exell
            if ($_POST['tipoRel'] == 'excel'){
                if($_POST['tipo'] == 'T'){
                    $colunas = ($_POST['exibirObs'] != 'S') ? ['Quadra','Lote', 'rea(M)','Contrato','Cliente','Situao', 'Constr.', 'Vl Vendido']
                        : ['Quadra','Lote', 'rea(M)','Contrato','Cliente', 'Obs. Lote','Situao', 'Constr.', 'Vl Vendido'];
                    
                    for ($i=0; $i < count($lotes); $i++) {
                        if($lotes[$i]['fl_construcao'] == 1){
                            $flConstrucao = 'Sim';
                        }else{
                            $flConstrucao = '';
                        }
                        $linhas[] = ($_POST['exibirObs'] != 'S') ? [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'],
                            $lotes[$i]['contrato'],$lotes[$i]['nm_pessoa'],$lotes[$i]['situacao'],
                            $flConstrucao,$lotes[$i]['total']]
                            : [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'],
                                $lotes[$i]['contrato'],$lotes[$i]['nm_pessoa'], $lotes[$i]['obs_lote'],$lotes[$i]['situacao'],
                                $flConstrucao,$lotes[$i]['total']];
                    }
                }elseif ($_POST['tipo'] == 'D'){
                    $colunas = ($_POST['exibirObs'] != 'S') ? ['Quadra','Lote','rea(M)','Constr.', 'Vl Lote']
                        : ['Quadra','Lote','rea(M)', 'Obs. Lote','Constr.', 'Vl Lote'];
                   
                    for ($i=0; $i < count($lotes); $i++) {
                        if($lotes[$i]['fl_construcao'] == 1){
                            $flConstrucao = 'Sim';
                        }else{
                            $flConstrucao = '';
                        }
                        $linhas[] = ($_POST['exibirObs'] != 'S') ? [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'],
                            $flConstrucao,$lotes[$i]['valor']]
                            : [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'],
                                $lotes[$i]['obs_lote'], $flConstrucao,$lotes[$i]['valor']];
            
                    }
                }elseif ($_POST['tipo'] == 'V'){
                    $colunas = ($_POST['exibirObs'] != 'S') ? ['Quadra','Lote','rea(M)','Contrato','Cliente','Constr.', 'Vl Vendido']
                        : ['Quadra','Lote','rea(M)','Contrato','Cliente', 'Obs. Lote','Constr.', 'Vl Vendido'];

                    for ($i=0; $i < count($lotes); $i++) {
                        if($lotes[$i]['fl_construcao'] == 1){
                            $flConstrucao = 'Sim';
                        }else{
                            $flConstrucao = '';
                        }
                        $linhas[] = ($_POST['exibirObs'] != 'S') ? [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'],$lotes[$i]['contrato'],
                            $lotes[$i]['nm_pessoa'],$flConstrucao,$lotes[$i]['total']]
                            : [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'],$lotes[$i]['contrato'],
                                $lotes[$i]['nm_pessoa'], $lotes[$i]['obs_lote'], $flConstrucao,$lotes[$i]['total']];
                    }
                    
                }elseif ($_POST['tipo'] == 'Q'){
                    $colunas = ($_POST['exibirObs'] != 'S') ? ['Quadra','Lote','rea(M)','Contrato','Cliente','Constr.','Vl Quitado','Vl Vendido']
                        : ['Quadra','Lote','rea(M)','Contrato','Cliente', 'Obs. Lote','Constr.','Vl Quitado','Vl Vendido'];

                    for ($i=0; $i < count($lotes); $i++) {
                        if($lotes[$i]['fl_construcao'] == 1){
                            $flConstrucao = 'Sim';
                        }else{
                            $flConstrucao = '';
                        }
                        $linhas[] = ($_POST['exibirObs'] != 'S') ? [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'],$lotes[$i]['contrato'],
                            $lotes[$i]['nm_pessoa'],$flConstrucao,$lotes[$i]['vlTotalPago'],$lotes[$i]['total']]
                            : [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'],$lotes[$i]['contrato'],
                                $lotes[$i]['nm_pessoa'], $lotes[$i]['obs_lote'],$flConstrucao,$lotes[$i]['vlTutalPago'],$lotes[$i]['total']];
                    }
                }elseif ($_POST['tipo'] == 'QS') {
                    $colunas = ($_POST['exibirObs'] != 'S') ? ['Quadra','Lote','rea(M)','Contrato','Cliente','Contrato Impresso','Vl Vendido']
                        : $colunas = ['Quadra','Lote','rea(M)','Contrato','Cliente', 'Obs. Lote','Contrato Impresso','Vl Vendido'];

                    for ($i=0; $i < count($lotes); $i++) {
                        $linhas[] = ($_POST['exibirObs'] != 'S') ? [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'],$lotes[$i]['contrato'],
                            $lotes[$i]['nm_pessoa'],($lotes[$i]['impresso'] == 1 ? 'Sim' : ''),$lotes[$i]['total']]
                            : [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'],$lotes[$i]['contrato'],
                                $lotes[$i]['nm_pessoa'], $lotes[$i]['obs_lote'],($lotes[$i]['impresso'] == 1 ? 'Sim' : ''),$lotes[$i]['total']];
                    }
                }elseif ($_POST['tipo'] == 'EN'){
                    $colunas = ($_POST['exibirObs'] != 'S') ? $colunas = ['Quadra','Lote','rea(M)','Contrato','Cliente','Constr.','Vl Vendido']
                        : $colunas = ['Quadra','Lote','rea(M)','Contrato','Cliente', 'Obs. Lote','Constr.','Vl Vendido'];

                    for ($i=0; $i < count($lotes); $i++) {

                        if($lote['fl_construcao'] == 1){
                            $flConstrucao = 'Sim';
                        }else{
                            $flConstrucao = '';
                        }

                        $linhas[] = ($_POST['exibirObs'] != 'S') ? [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'],$lotes[$i]['contrato'],
                            $lotes[$i]['nm_pessoa'],$flConstrucao,$lotes[$i]['valor']]
                            : [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'],$lotes[$i]['contrato'],
                                $lotes[$i]['nm_pessoa'], $lotes[$i]['obs_lote'],$flConstrucao,$lotes[$i]['valor']];
                    }
                }
                elseif ($_POST['tipo'] == 'RC'){
                    $colunas = ($_POST['exibirObs'] != 'S') ? $colunas = ['Quadra','Lote','rea(M)','Cliente','Corretor','Data Reserva','Data Expirao Reserva']
                        : $colunas = ['Quadra','Lote','rea(M)','Cliente', 'Obs. Lote','Corretor','Data Reserva','Data Expirao Reserva'];

                    for ($i=0; $i < count($lotes); $i++) {
                        //Data da reserva somado  quantidade de dias de reserva
                        $dataExpiracao = date('d/m/Y', strtotime("+" . $lotes[$i]['temp_reserva'] . " days", strtotime($lotes[$i]['data_reserva'])));
                        
                        //Data da Reserva 
                        $dataReserva = explode("-", $lotes[$i]['data_reserva']);
                        $dataReservaParaBrasil = $dataReserva[2].'/'.$dataReserva[1].'/'.$dataReserva[0];

                        $linhas[] = ($_POST['exibirObs'] != 'S') ? [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'],$lotes[$i]['nome_pessoa'],
                            $lotes[$i]['nm_pessoa'],$dataReservaParaBrasil,$dataExpiracao]
                            : [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'],$lotes[$i]['nome_pessoa'],
                                $lotes[$i]['nm_pessoa'], $lotes[$i]['obs_lote'],$dataReservaParaBrasil,$dataExpiracao];
                    }
                }
                elseif ($_POST['tipo'] == 'RT'){
                    $colunas = ($_POST['exibirObs'] != 'S') ? $colunas = ['Quadra','Lote','rea(M)','Observao','Constr.','Vl Vendido']
                        : $colunas = ['Quadra','Lote','rea(M)','Observao', 'Obs. Lote','Constr.','Vl Vendido'];
                    
                    for ($i=0; $i < count($lotes); $i++) {
                        //Data da Reserva
                        $dataReserva = explode("-", $lotes[$i]['data_reserva']);
                        if($lotes[$i]['data_reserva']){
                            $dataReservaParaBrasil = $dataReserva[2].'/'.$dataReserva[1].'/'.$dataReserva[0];
                        } else{
                            $dataReservaParaBrasil = $lotes[$i]['data_reserva'];
                        }
                        if($lotes[$i]['fl_construcao'] == 1){
                            $flConstrucao = 'Sim';
                        }else{
                            $flConstrucao = '';
                        }
                        $linhas[] = ($_POST['exibirObs'] != 'S') ? [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'],
                            $lotes[$i]['obs_reserva'], $dataReservaParaBrasil,$flConstrucao,$lotes[$i]['total']]
                            : [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'],
                                $lotes[$i]['obs_reserva'], $dataReservaParaBrasil, $lotes[$i]['obs_lote'],$flConstrucao,$lotes[$i]['total']];
                    }
                }elseif ($_POST['tipo'] == 'LD'){
                    if($_POST['exibirConf'] != '1') {
                        $colunas = ($_POST['exibirObs'] != 'S') ? ['Quadra', 'Lote', 'rea(M)','frente', 'fundo', 'esquerda', 'direita',
                            'conf_frente', 'conf_fundo', 'conf_esquerda', 'conf_direita','rgi']
                            : ['Quadra', 'Lote', 'rea(M)', 'Obs. Lote','frente', 'fundo', 'esquerda', 'direita', 'conf_frente', 'conf_fundo', 'conf_esquerda', 'conf_direita','rgi'];
                        
                        for ($i=0; $i < count($lotes); $i++) {
                            $linhas[] = ($_POST['exibirObs'] != 'S') ? [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'],
                                $lotes[$i]['frente'],$lotes[$i]['fundo'],$lotes[$i]['esquerda'],
                                $lotes[$i]['direita'],$lotes[$i]['conf_frente'],$lotes[$i]['conf_fundo'],
                                $lotes[$i]['conf_esquerda'],$lotes[$i]['conf_direita'],$lotes[$i]['rgi']]
                                : [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'], $lotes[$i]['obs_lote'],
                                    $lotes[$i]['frente'],$lotes[$i]['fundo'],$lotes[$i]['esquerda'],
                                    $lotes[$i]['direita'],$lotes[$i]['conf_frente'],$lotes[$i]['conf_fundo'],
                                    $lotes[$i]['conf_esquerda'],$lotes[$i]['conf_direita'],$lotes[$i]['rgi']];
                        }
                    } else {
                        $colunas = ($_POST['exibirObs'] != 'S') ? ['Quadra', 'lote', 'rea(M)', 'Descrio Geral', 'rgi']
                            : ['Quadra', 'lote', 'rea(M)', 'Obs. Lote', 'Descrio Geral', 'rgi'];

                        for ($i=0; $i < count($lotes); $i++) {
                            $linhas[] = ($_POST['exibirObs'] != 'S') ? [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'], 
                                $lotes[$i]['ds_geral'],$lotes[$i]['rgi']]
                                : [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'], $lotes[$i]['obs_lote'], $lotes[$i]['ds_geral'],$lotes[$i]['rgi']];
                        }
                    }
                }elseif ($_POST['tipo'] == 'G'){
                    $colunas = ($_POST['exibirObs'] != 'S') ? ['Quadra','Lote', 'rea(M)','Contrato','Cliente','Situao', 'Constr.', 'Vl Vendido']
                        : $colunas = ['Quadra','Lote', 'rea(M)','Contrato','Cliente', 'Obs. Lote','Situao', 'Constr.', 'Vl Vendido'];
                    
                    for ($i=0; $i < count($lotes); $i++) {
                        if($lotes[$i]['fl_construcao'] == 1){
                            $flConstrucao = 'Sim';
                        }else{
                            $flConstrucao = '';
                        }
                        $linhas[] = ($_POST['exibirObs'] != 'S') ? [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'],
                            $lotes[$i]['contrato'],$lotes[$i]['nm_pessoa'],$lotes[$i]['situacao'],
                            $flConstrucao,$lotes[$i]['total']]
                            : [$lotes[$i]['quadra'], $lotes[$i]['lote'],$lotes[$i]['area'],
                                $lotes[$i]['contrato'],$lotes[$i]['nm_pessoa'], $lotes[$i]['obs_lote'],$lotes[$i]['situacao'],
                                $flConstrucao,$lotes[$i]['total']];
                    }
                } else if ($_POST['tipo'] == 'S') {
                    $colunas = ($_POST['exibirObs'] != 'S') ? ['Quadra','Lote','Contrato','Cliente','Telefone','Tel. Celular','Tel. Recado', 'Email','Vl contrato', 'Parcelas Pagas', 'Vl pago', 'Parcelas em Aberto',
                        'Vl em aberto', 'Parcelas a Pagar', 'Saldo devedor','Em construo', 'Jurdico']
                        : ['Quadra','Lote','Contrato','Cliente','Telefone','Tel. Celular','Tel. Recado', 'Email', 'Obs. Lote','Vl contrato','Parcelas Pagas', 'Vl pago',
                            'parcela em aberto',  'Vl em aberto', 'Parcelas a Pagar', 'Saldo devedor','Em construo', 'Jurdico'];
                    sort($lotes);
                    //No excel, deve ser utilizado o for ao invs do foreach (ACL-3015)
                    for($i = 0; $i< count($lotes); $i++){

                        $lotes[$i]['totalParcelasParaPagar'] = $lotes[$i]['nr_parcela'] - $lotes[$i]['parcelasPagas'];
    
                        if ($lotes[$i]['qtdParcelasEmAberto'] == '') {
                            $lotes[$i]['qtdParcelasEmAberto'] = 0;    
                        }
    
                        if($lotes[$i]['fl_construcao'] == 1){
                            $construcao = 'Sim';
                        }
                        else{
                            $construcao = 'No';
                        }
                        
                        $linhas[] = ($_POST['exibirObs'] != 'S') ? [$lotes[$i]['quadra'], $lotes[$i]['lote'],
                        $lotes[$i]['contrato'], $lotes[$i]['nm_pessoa'], $lotes[$i]['nr_telefone'], $lotes[$i]['nr_celular'], $lotes[$i]['nr_recado'],
                        $lotes[$i]['email'],
                        $lotes[$i]['total'], Helper::apenasNumeros($lotes[$i]['parcelasPagas']), $lotes[$i]['vlTotalPago'], $lotes[$i]['qtdParcelasEmAberto'],
                            $lotes[$i]['vlTotalAberto'], $lotes[$i]['totalParcelasParaPagar'], $lotes[$i]['vlSaldoDevedor'], $construcao, $lotes[$i]['descricao']]
                        
                        : [$lotes[$i]['quadra'], $lotes[$i]['lote'],
                            $lotes[$i]['contrato'], $lotes[$i]['nm_pessoa'], $lotes[$i]['nr_telefone'], $lotes[$i]['nr_celular'], $lotes[$i]['nr_recado'],
                        $lotes[$i]['email'], $lotes[$i]['obs_lote'],
                        $lotes[$i]['total'], Helper::apenasNumeros($lotes[$i]['parcelasPagas']), $lotes[$i]['vlTotalPago'], $lotes[$i]['qtdParcelasEmAberto'],
                            $lotes[$i]['vlTotalAberto'], $lotes[$i]['totalParcelasParaPagar'], $lotes[$i]['vlSaldoDevedor'], $construcao, $lotes[$i]['descricao']];       
                            
                        foreach($linhas as $k => &$line){
                            if($line[0] == null){
                                unset($linhas[$k]);
                                continue;
                            }
                        }
                        sort($linhas);
                    }
  
                } else if ($_POST['tipo'] == 'PR'){
                    $colunas = ($_POST['exibirObs'] != 'S') ? ['Quadra','Lote','Contrato','Cliente', 'Vl divida', 'Vl contrato', 'Vl pago',
                        'vl em aberto', 'saldo devedor', 'situao']
                        : ['Quadra','Lote','Contrato','Cliente', 'Obs. Lote', 'Vl divida', 'Vl contrato', 'Vl pago',
                            'vl em aberto', 'saldo devedor', 'situao'];
                    sort($lotes);
                    for($i = 0; $i< count($lotes); $i++){
                        if ($lotes[$i]['vlTotalAberto'] != '') {
                            $situacao = $lotes[$i]['qtdParcelasEmAberto'] . ' aberta(s)';
                        } elseif ($lotes[$i]['vlSaldoDevedor'] != '') {
                            $situacao = 'Adimplente';
                        } else {
                            $situacao = 'Adimplente';
                        }
                        $linhas[] = ($_POST['exibirObs'] != 'S') ? [$lotes[$i]['quadra'], $lotes[$i]['lote'],
                            $lotes[$i]['contrato'], $lotes[$i]['nm_pessoa'],
                            $lotes[$i]['vl_divida'], $lotes[$i]['total'], $lotes[$i]['vlTotalPago'],
                            $lotes[$i]['vlTotalAberto'], $lotes[$i]['vlSaldoDevedor'],
                            $situacao] 
                            : [$lotes[$i]['quadra'], $lotes[$i]['lote'],
                            $lotes[$i]['contrato'], $lotes[$i]['nm_pessoa'], $lotes[$i]['obs_lote'],
                            $lotes[$i]['vl_divida'], $lotes[$i]['total'], $lotes[$i]['vlTotalPago'],
                            $lotes[$i]['vlTotalAberto'], $lotes[$i]['vlSaldoDevedor'],
                            $situacao];
                            
                        foreach($linhas as $k => &$line){
                            if($line[0] == null){
                                unset($linhas[$k]);
                                continue;
                            }
                        }
                        sort($linhas);
                    }  
                } else {
                    $colunas = ($_POST['exibirObs'] != 'S') ? ['Quadra','Lote','Contrato','Cliente','Vl contrato', 'Vl pago',
                        'vl em aberto', 'saldo devedor', 'situao']
                        : ['Quadra','Lote','Contrato','Cliente', 'Obs. Lote','Vl contrato', 'Vl pago',
                            'vl em aberto', 'saldo devedor', 'situao'];
                    sort($lotes);
                    for($i = 0; $i< count($lotes); $i++){
                        if ($lotes[$i]['vlTotalAberto'] != '') {
                            $situacao = $lotes[$i]['qtdParcelasEmAberto'] . ' aberta(s)';
                        } elseif ($lotes[$i]['vlSaldoDevedor'] != '') {
                            $situacao = 'Adimplente';
                        } else {
                            $situacao = 'Adimplente';
                        }
                        $linhas[] = ($_POST['exibirObs'] != 'S') ? [$lotes[$i]['quadra'], $lotes[$i]['lote'],
                            $lotes[$i]['contrato'], $lotes[$i]['nm_pessoa'],
                            $lotes[$i]['total'], $lotes[$i]['vlTotalPago'],
                            $lotes[$i]['vlTotalAberto'], $lotes[$i]['vlSaldoDevedor'],
                            $situacao] 
                            : [$lotes[$i]['quadra'], $lotes[$i]['lote'],
                            $lotes[$i]['contrato'], $lotes[$i]['nm_pessoa'], $lotes[$i]['obs_lote'],
                            $lotes[$i]['total'], $lotes[$i]['vlTotalPago'],
                            $lotes[$i]['vlTotalAberto'], $lotes[$i]['vlSaldoDevedor'],
                            $situacao];
                            
                        foreach($linhas as $k => &$line){
                            if($line[0] == null){
                                unset($linhas[$k]);
                                continue;
                            }
                        }
                        sort($linhas);
                    }  
                }
                $this->geraExcel($colunas, $linhas);
                exit();
            }

            $contador = [];
            for ($i=0; $i < count($lotes); $i++) { 
                $contador[$i] = $lotes[$i]['corretor'];
                $contador[$i] = $lotes[$i]['nm_pessoa'];
            }
            $x = array('s'=>'ss', 'a',4 , 'sss' => null);

            $contador = array_replace($x,array_fill_keys(array_keys($x, null),''));

            $vals = array_count_values($contador);

            $this->set('loteamento', $vals);            
            $this->set('tipoFinan', $_POST['exibirSitu']);
            $this->set('lotes', $lotes);
            $this->set('cabecalho', $cabecalho);
            $this->set('totais', $total);
            return $this->get('tipo');
        } else {
            $this->_helper->addMensagem('index', 'No existem lotes com os dados selecionados');
            return false;
        }
    }

    private function carregarDados()
    {
        $empreendimento = $this->empreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('nm_empreendimento', 'id'))
            ->join(array('l' => TB_LOTES), 'e.id = l.id_empreendimento', array('id_lote' => 'id', 'id_empreendimento'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimento = $empreendimento->group('e.id')->order('nm_empreendimento')->query()->fetchAll();
        $this->set('empreendimentos', $empreendimento);
    }

    public function quadraByEmprendimentoAction()
    {
        $lotes = $this->lote->findLotesEmpreendimento($_POST['id_empreendimento'], true, false);
        $this->set('lotes', $lotes);

        $lista = array();
        $lista[] = array('id' => '*', 'text' => utf8_encode('Todos'));
        foreach ($lotes as $lote) {
            $lista[] = array(
                'id' => utf8_encode($lote['quadra']),
                'text' =>  ' Quadra: ' . utf8_encode($lote['quadra']));
        }
        echo json_encode($lista);
    }

    public function loteByEmprendimentoAction()
    {
        $lotes = $this->lote->findLotesEmpreendimento($_POST['id_empreendimento'],false, $_POST['quadra']);
        $this->set('lotes', $lotes);

        $lista = array();
        $lista[] = array('id' => '*', 'text' => utf8_encode('Todos'));
        foreach ($lotes as $lote) {
            $lista[] = array(
                'id' => $lote['id'],
                'text' =>  ' Lote: ' . utf8_encode($lote['lote']));
        }
        echo json_encode($lista);
    }

    public function validarAction()
    {
        $campos = array("empreendimento_relatorio_lote", "lote_relatorio_lote", "tipo", "loteRelatorio", "fl_caucionado");
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "empreendimento_relatorio_lote" :
                        $msg = "O campo Empreendimento  obrigatrio.";
                        break;
                    case "lote_relatorio_lote" :
                        $msg = "O campo Quadra  obrigatrio.";
                        break;
                    case "loteRelatorio" :
                        $msg = "O campo Lote  obrigatrio.";
                        break;
                    case "tipo" :
                        $msg = "O tipo deve ser escolhido.";
                        break;
                    case "fl_caucionado" :
                        $msg = "O tipo deve ser escolhido.";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }
        //Valida se h uma situao marcada na opo financeiro
        if ($_POST['tipo'] == 'F' && $_POST['exibirSitu'] == '')
            $this->_helper->addMensagem('danger', 'Situao deve ser escolhida.');
         
        if ($_POST['tipo'] == 'S' && $_POST['exibirSitu'] == '')
            $this->_helper->addMensagem('danger', 'Situao deve ser escolhida.');    

        if ($this->_isPost) {
            //Transforma o array em uma nica varivel
            if (count($_POST['construcao']) == 1) {
                $_POST['construcao'] = $_POST['construcao'][0];
            } else {
                $_POST['construcao'] = '';
            }

            if (count($_POST['fl_caucionado']) == 1) {
                $_POST['fl_caucionado'] = $_POST['fl_caucionado'][0];
            } else {
                $_POST['fl_caucionado'] = '';
            }
            $this->set('flagTipo', $_POST['tipo']);

            // v qual o tipo de relatrio
            switch ($_POST['tipo']) {
                // todos os lotes
                case 'T':
                    $lotes = $this->lote->findLotesTodos($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio'], false, $_POST['fl_caucionado']);
                    $width = array('lote' => '45px', 'quadra' => '40px', 'area' => '50px', 'situacao' => '10px', 'contrato' => '50px', 'cliente' => '170px', 'const' => '10px', 'valor' => '65px', 'vendido' => '80px');

                    //Caso sejam todos os lotes e no apenas 1 para exibio de resumo no relatorio
                    if ($_POST['lote_relatorio_lote'] == '*') {
                        $this->set('loteTodos', 'true');
                    }

                    $this->set('tipo', 'TODOS');
                    $this->set('largura', $width);
                    break;
                //Lotes vendidos com quitados
                case 'V':
                    $lotes = $this->lote->findLotesVendidos($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio']);
                    $width = array('lote' => '50px', 'quadra' => '50px', 'area' => '70px', 'contrato' => '70px', 'cliente' => '170px', 'const' => '10px',
                        'valor' => '65px', 'vendido' => '80px');

                    $this->set('tipo', 'VENDIDOS COM QUITADOS');
                    $this->set('largura', $width);
                    break;
                // lotes vendidos sem quitados
                case 'SQ':
                    $lotes = $this->lote->findLotesQuitados($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio'], false, false);
                    $width = array('lote' => '30px', 'quadra' => '30px', 'area' => '40px', 'contrato' => '40px', 'cliente' => '195px', 'const' => '10px',
                        'valor' => '65px', 'vendido' => '80px');

                    $this->set('tipo', 'VENDIDOS SEM QUITADOS');
                    $this->set('largura', $width);
                    break;
                // lotes quitados
                case 'Q':
                    $lotes = $this->lote->findLotesQuitados($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio']);
                    $width = array('lote' => '50px', 'quadra' => '50px', 'area' => '70px', 'contrato' => '70px', 'cliente' => '170px', 'const' => '10px',
                    'vl.total pago' => '65px', 'vendido' => '80px');

                    $this->set('tipo', 'QUITADOS');
                    $this->set('largura', $width);
                    break;
                // lotes quitados sinal
                case 'QS':
                    $parcelaSinal = true;
                    $lotes = $this->lote->findLotesQuitados($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio'], $parcelaSinal);
                    $width = array('lote' => '50px', 'quadra' => '50px', 'area' => '70px', 'contrato' => '70px', 'cliente' => '170px', 'const' => '10px',
                        'valor' => '65px', 'vendido' => '80px');

                    $this->set('tipo', 'QUITADOS SINAL');
                    $this->set('largura', $width);
                    break;
                // lotes em negociacao
                case 'EN':
                    $lotes = $this->lote->findLotesEmNegociacao($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio']);
                    $width = array('lote' => '50px', 'quadra' => '50px', 'area' => '70px', 'contrato' => '70px', 'cliente' => '170px', 'const' => '80px',
                        'valor' => '65px', 'vendido' => '80px');

                    $this->set('tipo', 'EM NEGOCIAO');
                    $this->set('largura', $width);
                    break;
                // lotes reservado para cliente
                case 'RC':
                    $lotes = $this->lote->findLotesReservadosCliente($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio']);
                    $width = array('lote' => '50px', 'quadra' => '50px', 'area' => '70px','cliente' => '170px', 'Corretor' => '120px','DataResenva' => '90px','dataExpiracaoReserva'=>'150px');

                    $this->set('tipo', 'RESERVADOS');
                    $this->set('largura', $width);
                    break;
                // lotes em reserva tcnica
                case 'RT':
                    $lotes = $this->lote->findLotesReservaTecnica($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio']);

                    $width = array('lote' => '50px', 'quadra' => '50px', 'area' => '70px', 'contrato' => '70px', 'cliente' => '170px', 'const' => '10px',
                        'valor' => '65px', 'vendido' => '80px');

                    $this->set('tipo', 'EM RESERVA TCNICA');
                    $this->set('largura', $width);
                    break;
                // lotes disponveis
                case 'D':
                    $lotes = $this->lote->findLotesDisponiveis($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], true, $_POST['loteRelatorio']);
                    $width = array('lote' => '80px', 'quadra' => '80px', 'area' => '90px', 'const' => '80px', 'valor' => '120px', 'vendido' => '120px');
                    
                    $this->set('tipo', 'DISPONVEIS');
                    $this->set('largura', $width);
                    break;
                // lotes detalhado
                case 'LD':
                    $lotes = $this->lote->findLotesLocalizacao($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio']);
                    $width = array('lote' => '45px', 'quadra' => '40px', 'area' => '50px', 'esquerda' => '50px', 'direita' => '50px', 'frente' => '50px', 'fundo' => '50px',
                        'confEsq' => '150px', 'confDir' => '150px', 'confFre' => '150px', 'confFun' => '150px', 'rgi' => '150px');

                    $this->set('tipo', 'MEMORIAL DESCRITIVO');
                    $this->set('largura', $width);
                    break;
                // VGV
                case 'G':
                    $lotes = $this->lote->findLotesTodos($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio']);
                    $width = array('lote' => '45px', 'quadra' => '40px', 'area' => '50px', 'situacao' => '10px', 'contrato' => '50px', 'cliente' => '170px',
                        'const' => '10px', 'valor' => '65px', 'vendido' => '80px');

                    //Caso sejam todos os lotes e no apenas 1 para exibio de resumo no relatorio
                    if ($_POST['lote_relatorio_lote'] == '*') {
                        $this->set('loteTodos', 'true');
                    }
                    $this->set('tipo', 'VGV');
                    $this->set('largura', $width);
                    break;
                case 'F':
                    $lotes = $this->lote->findLotesTodos($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio']);
                    $width = array('lote' => '45px', 'quadra' => '40px', 'cliente' => '170px', 'vl.total contrato' => '80px', 'vl.total pago' => '80px', 'vl.total aberto' => '80px', 'saldo devedor' => '80px', 'situao' => '80px');

                    //Caso sejam todos os lotes e no apenas 1 para exibio de resumo no relatorio
                    if ($_POST['lote_relatorio_lote'] == '*') {
                        $this->set('loteTodos', 'true');
                    }

                    $this->set('tipo', 'FINANCEIRO');
                    $this->set('largura', $width);
                    break;

                case 'S':
                    $lotes = $this->lote->findLotesTodos($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio']);
                    $width = array('lote' => '45px', 'quadra' => '40px', 'cliente' => '160px', 'vl.total contrato' => '80px', 'vl.total pago' => '80px', 'vl.total aberto' => '80px', 'saldo devedor' => '80px', 'parcelaAberta' => '80px', 'parcelaspagas' => '80px','parcelasParaPagar' => '80px', 'vlContrato' => '80px');
    
                    //Caso sejam todos os lotes e no apenas 1 para exibio de resumo no relatorio
                    if ($_POST['lote_relatorio_lote'] == '*') {
                            $this->set('loteTodos', 'true');
                    }
    
                    $this->set('tipo', 'SALDOS');
                    $this->set('largura', $width);
                    break;
                 
                //Lotes com venda Price
                case 'PR':
                    $lotes = $this->lote->findLotesPrice($_POST['empreendimento_relatorio_lote'], $_POST['lote_relatorio_lote'], $_POST['construcao'], $_POST['ordem'], $_POST['loteRelatorio']);
                    $width = array('lote' => '45px', 'quadra' => '40px', 'cliente' => '100px', 'vl.total contrato' => '80px', 'vl.total pago' => '80px', 'vl.total aberto' => '80px', 'saldo devedor' => '80px','vlDivida' => '80px', 'situao' => '80px');
    
                    //Caso sejam todos os lotes e no apenas 1 para exibio de resumo no relatorio
                    if ($_POST['lote_relatorio_lote'] == '*') {
                            $this->set('loteTodos', 'true');
                    }
    
                    $this->set('tipo', 'PRICE');
                    $this->set('largura', $width);
                    break;
                 
            }
            if (!$lotes) {
                $this->_helper->addMensagem('danger', "Nenhum resultado foi encontrado.");
            }
        }
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            echo json_encode(true);
        }
    }
}