<?php
set_time_limit(0);
class IptuRelatorioController extends Controller {

    public function __construct($request) {
        parent::__construct($request);

    }

    public function indexAction() {
        $this->set("subtitulo","Relatrio de IPTU");
        $this->carregarDados();
        $this->display("index");
    }

    private function carregarDados() {
        $instanceEmpreendimento = new Empreendimento();

        $empreendimento = $instanceEmpreendimento->getDefaultAdapter()->select()
            ->from(array('e'=>TB_EMPREENDIMENTO), array('nm_empreendimento'))
            ->join(array('l'=>TB_LOTES), 'e.id = l.id_empreendimento', array('id_lote'=>'id', 'id_empreendimento'))
            ->join(array('c'=>TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato'=>'id', 'id_lote'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimento = $empreendimento->group('e.id')->order('nm_empreendimento')->query()->fetchAll();
        $this->set('empreendimentos',$empreendimento);
    }

    public function relatorioAction() {
        ini_set("memory_limit", "128M");
        set_time_limit(0);

        if($this->validar()) {

            $tbClienteAcade = new Db_Cliente();
            $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

            $instanceLote = new Lote();
            $selectLote = $instanceLote->getDefaultAdapter()->select();
            $selectLote = $selectLote->from(array('l'=>TB_LOTES), array('quadra','lote', 'rgi'))
                    ->join(array('c'=>TB_CONTRATO), 'l.id = c.id_lote', array('idContrato'=>'id', 'dt_contrato'))
                    ->join(array('p'=>TB_PESSOA), 'c.id_pessoa = p.id', array('pessoa_id'=>'p.id','pessoa_nome'=>'p.nm_pessoa','email'=>'p.email', 'telefone'=>'p.nr_telefone',
                    'celular'=>'p.nr_celular', 'fax'=>'p.nr_fax', 'recado'=>'p.nr_recado', 'cep'=>'p.nr_cep', 'endereco' =>'p.endereco', 'bairro'=>'p.nm_bairro', 'nr_endereco', 'ds_complemento'))
                    ->joinLeft(array('pf'=>TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', array('cpf'=>'pf.nr_cpf','rg'=>'pf.nr_rg'))
                    ->joinLeft(array('pj'=>TB_PESSOA_JURIDICA), 'p.id = pj.id_pessoa', array('cnpj'=>'pj.nr_cnpj','fantasia'=>'pj.nm_fantasia'))
                    ->join(array('cd'=>Db_Cidade::TABLE_NAME), 'p.cd_cidade = cd.id', array('cidade'=>'cd.nome', 'uf'=>'cd.uf'));
                    
            if($_POST['dataInicio']){
                $selectLote->where('c.dt_contrato >= ?', Helper::dataParaAmericano($_POST['dataInicio']));
            }
            if($_POST['dataFinal']){
                $selectLote->where('c.dt_contrato <= ?', Helper::dataParaAmericano($_POST['dataFinal']));
            }
            $selectLote->where('l.id_empreendimento = ? and c.id not  in (SELECT id_contrato FROM DISTRATO ) ', $_POST['empreendimento_relatorio_empreendimentos'] );
            $selectLote->order('l.quadra');
            $selectLote->order('l.lote');
            $relatorios = $selectLote->order('p.nm_pessoa')->query()->fetchAll();

            $empreendimento = new Empreendimento();
            $empreendimentoInfo = $empreendimento->getAdapter()->select()
                ->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento', 'ds_path_logo'))
                ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
                ->where('id = ' . $_POST['empreendimento_relatorio_empreendimentos'])->query()->fetch();
            $this->set("empreendimentoInfo", $empreendimentoInfo);

            if(count($relatorios)) {
                if ($_POST['tipoRelatorio'] == 'P') {
                    $this->set('relatorios', $relatorios);
                    $this->set('empreendimento', Empreendimento::findEmpreendimento($_POST['empreendimento_relatorio_empreendimentos'])->nm_empreendimento);
                    $this->displayMPDF(rand().'.pdf');
                } else {
                    $colunas = [
                        'Quadra',
                        'Lote',
                        'Contrato',
                        'RGI Indiv',
                        'Dt. Contrato',
                        'Nome',
                        'CPF/CNPJ',
                        'RG',
                        'Endereo',
                        'Numero',
                        'Complemento',
                        'Bairro',
                        'Cep',
                        'Cidade',
                        'Estado',
                        'Email',
                        'Telefone'
                    ];

                    for ($i = 0; $i < count($relatorios); $i++) {
                        $linhas[] = [
                            $relatorios[$i]['quadra'],
                            $relatorios[$i]['lote'],
                            $relatorios[$i]['idContrato'],
                            $relatorios[$i]['rgi'],
                            Helper::getDate($relatorios[$i]['dt_contrato']),
                            $relatorios[$i]['pessoa_nome'],
                            $relatorios[$i]['cpf']? $relatorios[$i]['cpf'] : $relatorios[$i]['cnpj'],
                            $relatorios[$i]['rg'],
                            $relatorios[$i]['endereco'],
                            $relatorios[$i]['nr_endereco'],
                            $relatorios[$i]['ds_complemento'],
                            $relatorios[$i]['bairro'],
                            $relatorios[$i]['cep'],
                            $relatorios[$i]['cidade'],
                            $relatorios[$i]['uf'],
                            $relatorios[$i]['email'],
                            $relatorios[$i]['telefone']
                        ];
                    }
                    $this->geraExcel($colunas, $linhas);
                }

            } else {
                $this->_helper->addMensagem ( 'index', 'Este empreendimento no possue clientes.');
                $this->carregarDados();
                $this->display("index");
            }

        } else {
            $this->carregarDados();
            $this->display("index");
        }
    }

    private function validar() {
        //validao vazio
        $campos = array ("empreendimento_relatorio_empreendimentos");
       
        foreach ( $campos as $cp ) {
            if ($_POST [$cp] == "") {
                $msg = "O campo Empreendimento  obrigatrio.";
                $this->_helper->addMensagem ( $cp, $msg );
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }
}