<?php

/**
 * Created by PhpStorm.
 * User: programacao-03
 * Date: 28/12/15
 * Time: 11:52
 */
class InadimplentesController extends Controller
{

    public function indexAction()
    {
        $this->carregarDados();
        $this->display("index");
    }

    private function carregarDados()
    {
        $instanceEmpreendimento = new Empreendimento();
        $empreendimento = $instanceEmpreendimento->getDefaultAdapter();

        $empreendimento = $empreendimento->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('id_empreendimento' => 'id', 'nm_empreendimento'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {

            }
        }
        $empreendimento = $empreendimento->group('e.id')->order('nm_empreendimento')->query()->fetchAll();
        
        $this->set('empreendimentos', $empreendimento);
    }

    public function relatorioAction()
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        ini_set('memory_limit', '3000M');
        set_time_limit(0);

        if ($this->validar()) {
            /*
             * Executa o relatorio de nao pagas apos setar os parametros de execucao
             * Passa como parametro o tipo de relatorio (analitico ou sintetico)
             */
            $this->relatorio($_POST['tipo']);
        } else {
            $this->indexAction();
        }
    }

    public function relatorio($tipoRelatorio = 'N')
    {
        $tpParcelas = array();
        if (count($_POST['tp_parcela'])) {
            foreach ($_POST['tp_parcela'] as $tipo) {
                if ($tipo == 'G' || $tipo == 'Q') {
                    $tpParcelas[] = '"' . $tipo . '"';
                } else {
                    $tpParcelas[] = '"' . $tipo . '"';
                }
            }
            $tpParcelas = '(' . implode(',', $tpParcelas) . ')';
        }

        $instanceEmpreendimento = new Empreendimento();
        $instanceEmpreendimento = $instanceEmpreendimento->getDefaultAdapter();

        $relatorio['empreendimento'] = $instanceEmpreendimento->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.rgi', 'e.id', 'e.porcAdmin', 'e.ds_path_logo'))
            ->join(array('c' => Db_Cidade::TABLE_NAME), 'e.cd_cidade = c.id', array('cidade_nome' => 'c.nome', 'cidade_uf' => 'c.uf'))
            ->joinLeft(array('t' => TB_TIPO_LOTEAMENTO), 'e.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
            ->where('e.id = ?', $_POST['empreendimento_relatorio_parcela_paga'])->query()->fetch();

        $instanceContrato = new Contrato();
        $instanceContrato = $instanceContrato->getDefaultAdapter();
        $instanceContrato = $instanceContrato->select()
            ->from(array('c' => TB_CONTRATO), array('id_contrato' => 'c.id', 'id_lote' => 'c.id_lote', 'nr_parcela', 'nr_parcela_sinal', 'nr_intercalada', 'nr_parcela_entrega'))
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('l.quadra', 'l.lote', 'fl_construcao'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('p.nm_pessoa', 'p.endereco', 'p.nm_bairro', 'id_pessoa' => 'p.id'))
            ->joinLeft(array('co' => TB_PESSOA), 'c.id_corretor = co.id', array('nm_corretor' => 'nm_pessoa'));

        //testa se foi selecionado algum contrato ou se estao sendo selecionado "todos"
        if ($_POST['cliente_relatorio_parcela_paga'] != '*') {
            $instanceContrato->where('p.id = ?', $_POST['cliente_relatorio_parcela_paga']);
        }

        $relatorio['contrato'] = $instanceContrato->where('l.id_empreendimento = ?', $relatorio['empreendimento']['id'])
            ->order(array('p.nm_pessoa', 'l.lote', 'l.quadra'))
            ->query()->fetchAll();

        $parcela_quantidade = 0;
        $parcela_normal_quantidade = 0;
        $parcela_sinal_quantidade = 0;
        $parcela_intercalada_quantidade = 0;
        $parcela_negociada_quantidade = 0;
        $parcela_quitacao_quantidade = 0;
        $parcela_entrega_quantidade = 0;
        $parcela_total = 0;
        $parcela_valor = 0;
        $resumoAtraso = array();
        $count = count($relatorio['contrato']);

        if ($count) {
            $pessoas = array();
            //percorre todos os contratos selecionados
            foreach ($relatorio['contrato'] as &$contrato) {
                $parcela_quitacao_quantidade_contrato = 0;

                $tb_juridico = new Juridico();
                $listaJuridico = $tb_juridico->getDefaultAdapter()->select()
                    ->from(array('j' => TB_JURIDICO), array('*'))
                    ->join(array('ag' => TB_AGRUPADA), 'ag.idTabela = 18 AND ag.idCampo = j.id_tipo_audiencia', array('descricao'))
                    ->where('j.id_contrato = ' . $contrato['id_contrato'])
                    ->order('id_juridico DESC')
                    ->limit('1')->query()->fetchAll();

                $contrato['tpJuridico'] = '';
                foreach ($listaJuridico as $juridico) {
                    $contrato['tpJuridico'] .= $juridico['descricao'] . ' ';
                }

                if(count($_POST['juridico']) < 2){
                    if($_POST['juridico'][0] == 'juridicoS'){
                        if(!$listaJuridico){
                            unset($contrato);
                        }
                    }elseif($_POST['juridico'][0] == 'juridicoN'){
                        if($listaJuridico){
                            unset($contrato);
                        }
                    }
                }
                if (count($contrato) == 0) {
                    continue;
                }

                $fPagamento = new Contrato();
                $listaFPagamento = $fPagamento->getDefaultAdapter()->select()
                    ->from(array('c' => TB_CONTRATO), array('id' => 'c.id', 'fl_fm_pagamento'))
                    ->where('c.id = ' . $contrato['id_contrato'])
                    ->query()->fetchAll();
                    //var_dump($listaFPagamento[0]['fl_fm_pagamento']); exit;

                $contrato['fPagamento'] = '';
                foreach ($listaFPagamento as $pagamento) {
                    $contrato['fPagamento'] .= $pagamento['fl_fm_pagamento'] . ' ';
                }

                if(count($_POST['pagamento']) < 2){
                    if($_POST['pagamento'][0] == 'parcelado/avista'){
                        //if(!$listaFPagamento){
                        if($listaFPagamento[0]['fl_fm_pagamento'] == 'PM'){
                            unset($contrato);
                        }
                    }elseif($_POST['pagamento'][0] == 'permuta'){
                        //if($listaFPagamento){
                        if($listaFPagamento[0]['fl_fm_pagamento'] != 'PM'){
                            unset($contrato);
                        }
                    }
                }
                if (count($contrato) == 0) {
                    continue;
                }

                $valorMinimo = 0;
                $valorMaximo = 0;

                foreach($_POST['opcao'] as $opcao){
                    switch ($opcao)
                    {
                        case 'opcaoA': //At 30 dias de atraso
                            $valorMinimo = 1;
                            $valorMaximo = 30;
                            break;

                        case 'opcaoB': //Entre 31 e 60 dias de atraso
                            $valorMinimo = ($valorMinimo == 0) ? $valorMinimo = 31 : $valorMinimo = $valorMinimo;
                            $valorMaximo = ($valorMaximo >= 0) ? $valorMaximo = 60 : $valorMaximo = $valorMaximo;
                            break;
                        
                        case 'opcaoC': //Entre 61 e 90 dias de atraso
                            $valorMinimo = ($valorMinimo == 0) ? $valorMinimo = 61 : $valorMinimo = $valorMinimo;
                            $valorMaximo = ($valorMaximo >= 0) ? $valorMaximo = 90 : $valorMaximo = $valorMaximo;
                            break;

                        case 'opcaoD': //Entre 91 e 120 dias de atraso
                            $valorMinimo = ($valorMinimo == 0) ? $valorMinimo = 91 : $valorMinimo = $valorMinimo;
                            $valorMaximo = ($valorMaximo >= 0) ? $valorMaximo = 120 : $valorMaximo = $valorMaximo;
                            break;
                        
                        case 'opcaoE': //Entre 121 e 150 dias de atraso
                            $valorMinimo = ($valorMinimo == 0) ? $valorMinimo = 121 : $valorMinimo = $valorMinimo;
                            $valorMaximo = ($valorMaximo >= 0) ? $valorMaximo = 150 : $valorMaximo = $valorMaximo;
                            break;
                        case 'opcaoF': //Acima de 150 dias de atraso
                            $valorMinimo = ($valorMinimo == 0) ? $valorMinimo = 151 : $valorMinimo = $valorMinimo;
                            $valorMaximo = ($valorMaximo >= 0) ? $valorMaximo = 151 : $valorMaximo = $valorMaximo;
                            break;
                    }
                }
                //testa o tipo de relatorio para a busca completa ou simples dos dados das parcelas.
                if ($tipoRelatorio == 'PNC') {
                    if ($_POST['opcoes'] == 'html') {
                        $contrato['parcelas'] = Parcela::parcelasAtrasadasCompletaByContrato($contrato['id_contrato'], $_POST['ate'], $tpParcelas, 0, $_POST['fl_profissao']);
                    } else {
                        $contrato['parcelas'] = Parcela::parcelaCompletaByContrato($contrato['id_contrato'], $_POST['de'], $_POST['ate'], $tpParcelas, 0, $_POST['fl_profissao']);
                    }
                } else {
                    if ($_POST['opcoes'] == 'html') {
                        $contrato['parcelas'] = Parcela::parcelasAtrasadasByContrato($contrato['id_contrato'], $_POST['ate'], $tpParcelas);
                    } else {
                        $contrato['parcelas'] = Parcela::parcelaByContrato($contrato['id_contrato'], $_POST['de'], $_POST['ate'], $tpParcelas);
                    }
                }

                foreach($contrato['parcelas'] as $k => $parcela){
                    $diferencaDatas = Helper::date_diff(Helper::dataParaAmericano($parcela['dt_parcela']), Helper::dataParaAmericano(date('Y-m-d')));
                                        
                    if ($valorMinimo < 151 && $valorMaximo < 151)
                    {
                        if ($diferencaDatas > $valorMaximo || $diferencaDatas < $valorMinimo)
                        {
                            unset($contrato['parcelas'][$k]);
                        }
                    } else {
                        if ($diferencaDatas < $valorMinimo)
                        {
                            unset($contrato['parcelas'][$k]);
                        }
                    } 
                }

                if (count($contrato['parcelas']) == 0) {
                    continue;
                }

                //Tras o total das parcelas do contrato itens
                $contrato['nrParcelaItens'] = ContratoItens::getQtdeParcelasItens($contrato['id_contrato']);
                foreach ($contrato['parcelas'] as &$parc) {
                    $parcela_valor += $parc['vl_parcela'];
                    $parcela_quantidade++;
                    switch ($parc['tp_parcela']) {
                        case 'N' :
                            $parcela_normal_quantidade++;
                            break;
                        case 'S' :
                            $parcela_sinal_quantidade++;
                            break;
                        case 'C' :
                            $parcela_entrega_quantidade++;
                            break;
                        case 'I' :
                            $parcela_intercalada_quantidade++;
                            break;
                        case 'G' :
                            $parcela_negociada_quantidade++;
                            $parc['nr_negociacao'] = Negociacao::getNumeroParcelasById($parc['id_negociacao']);
                            break;
                        case 'Q' :
                            $parcela_quitacao_quantidade++;
                            $parcela_quitacao_quantidade_contrato++;
                            break;
                    }

                    //+1 por que a funcao do php nao retorna o numero correto, ele conta assim que vence, o certo  e a partir do dia seguinte
                    $atraso = Helper::date_diff(Helper::dataParaAmericano($parc["dt_parcela"]), Helper::dataParaAmericano($_POST['dataBase']));
                    $parc["atraso"] = ($atraso >= 0) ? number_format($atraso, 0) : "0";

                    if ($atraso <= 30) {
                        $resumoAtraso['30']['qtd']++;
                        $resumoAtraso['30']['vl'] += $parc['vl_parcela'];

                    } elseif($atraso <= 60) {
                        $resumoAtraso['60']['qtd']++;
                        $resumoAtraso['60']['vl'] += $parc['vl_parcela'];

                    } elseif ($atraso <= 90) {
                        $resumoAtraso['90']['qtd']++;
                        $resumoAtraso['90']['vl'] += $parc['vl_parcela'];

                    } elseif ($atraso <= 120) {
                        $resumoAtraso['120']['qtd']++;
                        $resumoAtraso['120']['vl'] += $parc['vl_parcela'];

                    } elseif ($atraso <= 150) {
                        $resumoAtraso['150']['qtd']++;
                        $resumoAtraso['150']['vl'] += $parc['vl_parcela'];

                    } elseif ($atraso <= 180) {
                        $resumoAtraso['180']['qtd']++;
                        $resumoAtraso['180']['vl'] += $parc['vl_parcela'];

                    } elseif ($atraso <= 240) {
                        $resumoAtraso['240']['qtd']++;
                        $resumoAtraso['240']['vl'] += $parc['vl_parcela'];

                    }  elseif ($atraso <= 300) {
                        $resumoAtraso['300']['qtd']++;
                        $resumoAtraso['300']['vl'] += $parc['vl_parcela'];

                    } else {
                        $resumoAtraso['mais']['qtd']++;
                        $resumoAtraso['mais']['vl'] += $parc['vl_parcela'];
                    }

                    /*
                     * Realiza ajustes no caso do relatorio ser analitico
                     * Primeito calcula dias de atraso das parcelas
                     * Depois calcula multa e juros baseado nos dias da data base
                     * Finalmente calcula valor total com adicoes e inclui no valor total do contrato
                     */
                    if ($tipoRelatorio == 'PNC') {
                        if ($parc["atraso"] > 0) {
                            if ($parc['tp_multa'] != 'S') {
                                // $multa = ($parc['tp_multa'] == 'P') ? (($parc["vl_parcela"] + $parc['acrescimo']) - $parc['desconto']) * ($parc["multa"] / 100) : $parc['multa'];
                                $multa = ($parc['tp_multa'] == 'P') ? $parc["vl_parcela"] * ($parc["multa"] / 100) : $parc['multa'];
                                $multa = number_format($multa, 2, '.', '');
                            } else {
                                $multa = '0';
                            }
                            if ($parc['tp_juros'] != 'S') {
                                // $juros = ($parc['tp_juros'] == 'P') ? (($parc["vl_parcela"] + $parc['acrescimo']) - $parc['desconto']) * ($parc["juros"] / 100) : $parc['juros'];
                                $juros = ($parc['tp_juros'] == 'P') ? $parc["vl_parcela"] * ($parc["juros"] / 100)  : $parc['juros'];
                                $juros *= $atraso;
                            } else {
                                $juros = '0';
                            }
                        } else {
                            $multa = "0";
                            $juros = "0";
                        }
                        $juros = number_format($juros, 2, '.', '');
                        $multa = number_format($multa, 2, '.', '');
                        $parc['juros'] = $juros;
                        $parc['multa'] = $multa;
                        $parc['total'] = number_format(((($parc['vl_parcela'] + $parc['acrescimo']) - $parc['desconto']) + $juros + $multa), 2, '.', '');

                        //adiciona valores de subtotal do contrato
                        $contrato['total']['vl_parcela'] += $parc['vl_parcela'];
                        $contrato['total']['juros'] += $juros;
                        $contrato['total']['multa'] += $multa;
                        $contrato['total']['vl_total'] += $parc['total'];
                        $contrato['nr_telefone'] = $parc['nr_telefone'];
                        $contrato['nr_celular'] = $parc['nr_celular'];
                        $contrato['nr_recado'] = $parc['nr_recado'];
                        $contrato['email'] = $parc['email'];
                        $contrato['profissao'] = ($parc['nm_profissao'])?$parc['nm_profissao']:'';
                    }
                }
                // Quantidade total de parcelas do contrato
                $contrato['total']['quitacao'] = $parcela_quitacao_quantidade_contrato;

                /*
                 * Ajusta os arrays para agrupar as informacoes por pessoa e nao por contrato
                 * no caso do relatorio ser do tipo completo.
                 */

                if ($tipoRelatorio == 'PNC') {
                    $id = $contrato['id_pessoa'];
                    if (is_array($pessoas[$id][$contrato['id_contrato']])) {
                        $pessoas[$id][$contrato['id_contrato']] = array_merge($pessoas[$id][$contrato['id_contrato']], $contrato);
                    } else {
                        $pessoas[$id][$contrato['id_contrato']] = array();
                        $pessoas[$id][$contrato['id_contrato']] = $contrato;
                    }
                    //Adiciona os totais de valores de cada contrato para o total do relatorio completo
                    $relatorio['total']['vl_total'] += $contrato['total']['vl_total'];
                    $relatorio['total']['juros'] += $contrato['total']['juros'];
                    $relatorio['total']['multa'] += $contrato['total']['multa'];
                }
            }
        }

        //verifica se existem parcelas para nao exibir o relatorio em branco
        if ($parcela_quantidade == 0) {
            $this->_helper->addMensagem('index', 'No existem parcelas a serem exibidas!');
            $this->indexAction();
            exit;
        }

        $relatorio['total']['parcela'] = $parcela_quantidade;
        $relatorio['total']['parcela_normal'] = $parcela_normal_quantidade;
        $relatorio['total']['parcela_sinal'] = $parcela_sinal_quantidade;
        $relatorio['total']['parcela_intercalada'] = $parcela_intercalada_quantidade;
        $relatorio['total']['parcela_negociada'] = $parcela_negociada_quantidade;
        $relatorio['total']['valor'] = $parcela_valor;
        $relatorio['total']['total'] = $parcela_total;
        $relatorio['resumo'] = $resumoAtraso;

        if ($relatorio['empreendimento']['porcAdmin'] > 0) {
            $valor = (float)$relatorio['empreendimento']['porcAdmin'];
            $relatorio['total']['porcAdmin'] = $parcela_valor * ($valor / 100);
        }

        $relatorio['todos'] = $_POST['cliente_relatorio_parcela_paga'] == '*' ? true : false;
        $relatorio['tipo'] = $_POST['tipo'] == 'PNC' ? true : false;

        if ($tipoRelatorio == 'PNC') {
            $relatorio['contrato'] = $pessoas;
        }
        $relatorio['periodo'] = $_POST['de'] . " at&eacute; " . $_POST['ate'];
        $this->set('relatorio', $relatorio);

        if ($_POST['tipoRelatorio'] == 'pdf') {
            $this->displayMPDF('Relatorio_' . time() . '.pdf');
        } elseif ($_POST['tipoRelatorio'] == 'xls') {
            $i = 0;
            foreach ($relatorio['contrato'] AS $idContrato => $contrato) {
                if ($relatorio['tipo']) {
                    foreach ($relatorio['contrato'][$idContrato] as $idP => $p) {
                        // var_dump($relatorio['contrato'][$idContrato][$idP]['parcelas']);exit;
                        foreach ($relatorio['contrato'][$idContrato][$idP]['parcelas'] as $parcela) {
                            $nrParcelaItens = $relatorio['contrato'][$idContrato][$idP]['nrParcelaItens'];
                            switch ($parcela['tp_parcela']) {
                                case 'S':
                                    $qtdeParcelas = $parcela['id_parcela'] . '/' . ($nrParcelaItens['QtdeSinal'] + $relatorio['contrato'][$idContrato][$idP]['nr_parcela_sinal']) . '-' . $parcela['tp_parcela'];
                                    break;
                                case 'I':
                                    $qtdeParcelas = $parcela['id_parcela'] . '/' . ($nrParcelaItens['QtdeIntercalada'] + $relatorio['contrato'][$idContrato][$idP]['nr_intercalada']) . '-' . $parcela['tp_parcela'];
                                    break;
                                case 'G':
                                    $qtdeParcelas = $parcela['id_parcela'] . '/' . $parcela['nr_negociacao'] . '-' . $parcela['tp_parcela'];
                                    break;
                                case 'C':
                                    $qtdeParcelas = $parcela['id_parcela'] . '/' . ($nrParcelaItens['QtdeChave'] + $relatorio['contrato'][$idContrato][$idP]['nr_parcela_entrega']) . '-' . $parcela['tp_parcela'];
                                    break;
                                case 'Q':
                                    $qtdeParcelas = $parcela['id_parcela'] . '/' . $relatorio['contrato'][$idContrato][$idP]['total']['quitacao'] . '-' . $parcela['tp_parcela'];
                                    break;
                                default:
                                    $qtdeParcelas = $parcela['id_parcela'] . '/' . ($nrParcelaItens['QtdeNormal'] + $relatorio['contrato'][$idContrato][$idP]['nr_parcela']) . '-' . $parcela['tp_parcela'];
                                    break;
                            }

                            $colunas = [
                                'Nome',
                                'Telefone',
                                'Email',
                                Helper::exibeAbreviacao(($relatorio['empreendimento']['ds_grupo'] != '') ? $relatorio['empreendimento']['ds_grupo'] : ''),
                                Helper::exibeAbreviacao(($relatorio['empreendimento']['ds_subgrupo'] != '') ? $relatorio['empreendimento']['ds_subgrupo'] : ''),
                                'Contrato',
                                'Baixa',
                                'Parcela',
                                'Vencto',
                                'Atraso',
                                '2 Via',
                                'Valor',
                                'Multa',
                                'Juros',
                                'Corretor/Vendedor',
                                'Total',
                                'Situao',
                                'Construo',
                            ];

                            if ($_POST['fl_profissao'] == '1') {
                                array_splice($colunas, 3,0, 'Profisso');
                            }

                            $linhas[$i] = [
                                $relatorio['contrato'][$idContrato][$idP]['nm_pessoa'],
                                current($relatorio['contrato'][$idContrato])["nr_telefone"] . ' ' . current($relatorio['contrato'][$idContrato])["nr_celular"] . ' ' . current($relatorio['contrato'][$idContrato])["nr_recado"],
                                current($relatorio['contrato'][$idContrato])['email'],
                                $relatorio['contrato'][$idContrato][$idP]['quadra'],
                                $relatorio['contrato'][$idContrato][$idP]['lote'],
                                $parcela['idDoContrato'],
                                $parcela['id_parcela_contrato'],
                                $qtdeParcelas,
                                $parcela['dt_parcela'],
                                $parcela['atraso'],
                                $parcela['dt_parcela_2avia'] ? Helper::dataParaBrasil($parcela['dt_parcela_2avia']) :'',
                                Helper::getMoney($parcela['vl_parcela']) == '0,00' ? '' : Helper::getMoney($parcela['vl_parcela']),
                                Helper::getMoney($parcela['multa']) == '0,00' ? '' : Helper::getMoney($parcela['multa']),
                                Helper::getMoney($parcela['juros']) == '0,00' ? '' : Helper::getMoney($parcela['juros']),
                                $contrato[$idP]['nm_corretor'],
                                Helper::getMoney($parcela['vl_parcela']) == '0,00' ? '' : Helper::getMoney($parcela['total']),
                                $relatorio['contrato'][$idContrato][$idP]['tpJuridico'],
                                $relatorio['contrato'][$idContrato][$idP]['fl_construcao'] == '1'? "Lote com construo":"Lote sem construo",
                            ];

                            if ($_POST['fl_profissao'] == '1') {
                                array_splice($linhas[$i], 3,0, current($relatorio['contrato'][$idContrato])['profissao']);
                            }

                            $i++;
                        }
                    }
                } else {
                    foreach ($contrato['parcelas'] as $parcela) {
                        $nrParcelaItens = $relatorio['contrato'][$idContrato]['nrParcelaItens'];
                        switch ($parcela['tp_parcela']) {
                            case 'S':
                                $qtdeParcelas = $parcela['id_parcela'] . '/' . ($nrParcelaItens['QtdeSinal'] + $relatorio['contrato'][$idContrato]['nr_parcela_sinal']) . '-' . $parcela['tp_parcela'];
                                break;
                            case 'I':
                                $qtdeParcelas = $parcela['id_parcela'] . '/' . ($nrParcelaItens['QtdeIntercalada'] + $relatorio['contrato'][$idContrato]['nr_intercalada']) . '-' . $parcela['tp_parcela'];
                                break;
                            case 'G':
                                $qtdeParcelas = $parcela['id_parcela'] . '/' . $parcela['nr_negociacao'] . '-' . $parcela['tp_parcela'];
                                break;
                            case 'C':
                                $qtdeParcelas = $parcela['id_parcela'] . '/' . ($nrParcelaItens['QtdeChave'] + $relatorio['contrato'][$idContrato]['nr_parcela_entrega']) . '-' . $parcela['tp_parcela'];
                                break;
                            case 'Q':
                                $qtdeParcelas = $parcela['id_parcela'] . '/' . $contrato['total']['quitacao'] . '-' . $parcela['tp_parcela'];
                                break;
                            default:
                                $qtdeParcelas = $parcela['id_parcela'] . '/' . ($nrParcelaItens['QtdeNormal'] + $relatorio['contrato'][$idContrato]['nr_parcela']) . '-' . $parcela['tp_parcela'];
                                break;
                        }
                        $colunas = [
                            'Nome',
                            Helper::exibeAbreviacao(($relatorio['empreendimento']['ds_grupo'] != '') ? $relatorio['empreendimento']['ds_grupo']:''),
                            Helper::exibeAbreviacao(($relatorio['empreendimento']['ds_subgrupo'] != '') ? $relatorio['empreendimento']['ds_subgrupo']:''),
                            'Parcela',
                            'Vencto',
                            'Acres',
                            'Desc',
                            'Valor',
                            'Situao',
                            'Construo',
                        ];
                        $linhas[] = [
                            $contrato['nm_pessoa'],
                            $contrato['quadra'],
                            $contrato['lote'],
                            $qtdeParcelas,
                            Helper::getDate($parcela['dt_parcela']),
                            Helper::getMoney($parcela['acrescimo']) == '0,00' ? '' : Helper::getMoney($parcela['acrescimo']),
                            Helper::getMoney($parcela['desconto']) == '0,00' ? '' : Helper::getMoney($parcela['desconto']),
                            Helper::getMoney($parcela['vl_parcela']) == '0,00' ? '' : Helper::getMoney($parcela['vl_parcela']),
                            $relatorio['contrato'][$idContrato][$idP]['tpJuridico'],
                            $relatorio['contrato'][$idContrato][$idP]['fl_construcao'] == '1'? "Lote com construo":"Lote sem construo",
                        ];
                    }
                }
            }

            $this->geraExcel($colunas, $linhas);

        } else {
            $this->display("relatorio");
        }
    }

    public function clienteParcelasPagasAction()
    {
        $id_empreendimento = $_POST['id_empreendimento'];
        $instanceLote = new Lote();
        $selectLotes = $instanceLote->getDefaultAdapter()->select();
        $clientes = $selectLotes
            ->from(array('l' => TB_LOTES), array('id_lote' => 'id', 'id_empreendimento','quadra','lote'))
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'id_pessoa','fl_distrato'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa', 'id'))
            ->where('l.id_empreendimento = ?', $id_empreendimento)
            ->where('c.fl_distrato = "0"')
            ->order('p.nm_pessoa')
            ->query()->fetchAll();
        $this->set('clientes', $clientes);

        $lista = array();
        $lista[] = array( 'id' => '*', 'text' => utf8_encode('Todos'));
        foreach ($clientes as $cliente) {
            $lista[] = array(
                'id' => $cliente['id'],
                'text' => utf8_encode($cliente['nm_pessoa']) .
                    ' Quadra: ' . utf8_encode($cliente['quadra']) .
                    ' - Lote: ' . utf8_encode($cliente['lote']) .
                    ' - Contrato: ' . utf8_encode($cliente['id_contrato'])
            );
        }

        echo json_encode($lista);
    }

    private function validar()
    {
        //validacao para evitar campos vazios
        $campos = array("empreendimento_relatorio_parcela_paga", "cliente_relatorio_parcela_paga");
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "empreendimento_relatorio_parcela_paga" :
                        $msg = "O campo Empreendimento  obrigatrio.";
                        break;
                    case "cliente_relatorio_parcela_paga" :
                        $msg = "O campo Clientes  obrigatrio.";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }
        if (count($_POST['tp_parcela']) == 0)
            $this->_helper->addMensagem('tp_parcela', 'Selecione pelo menos um tipo de parcela.');

        if ($_POST['de'] == '' || $_POST['ate'] == '') {
            $msg = 'O perodo  obrigatrio.';
            $this->_helper->addMensagem('data', $msg);
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }
}
