<?php

/**
 * Classe que representa o controller do extrato
 */
class ExtratoHistoricoController extends Controller
{

    public function __construct($request)
    {

        parent::__construct($request);
        $this->empreendimento = new Empreendimento();

        $this->set('subtitulo', "Extrato Histrico");

    }

    /**
     * Action index do controller
     */
    public function indexAction()
    {
        $this->redir(array("modulo" => "rl", "controller" => "extratoHistorico", "action" => "gerar"));
    }


    /**
     * Action responsvel por gerar o pdf com as informaes das parcelas
     */
    public function gerarAction()
    {
        $tbClienteAcade = (new Db_Cliente())->fetchRow()->toArray();
        $cidade = new Cidade();
        $this->set('clienteAcade', $tbClienteAcade);

        //instncia das tabelas
        $adapter = Pessoa::getDefaultAdapter();

        $empreendimento = $this->empreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('nm_empreendimento', 'id', 'ds_path_logo'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimento = $empreendimento->order('nm_empreendimento')->query()->fetchAll();

        $this->set('empreendimentos', $empreendimento);

        if ($this->_isPost) {

            $parcelaAvulsa = ($_POST['parcelaAvulsa'] == '0')?' AND tp_parcela != "A"':'';

            $rsItens = $adapter->select()->from(array("p" => TB_PARCELA_HISTORICO))
                ->where('p.id_contrato = '.$_POST['idContrato'].$parcelaAvulsa)
                ->order("dt_parcela")
                ->query()->fetchAll();

            $contrato = $adapter->select()->from(array("c" => TB_CONTRATO_HISTORICO))
                ->join(array("p" => TB_PESSOA), "c.id_pessoa = p.id", 'nm_pessoa')
                ->join(array("l" => TB_LOTES), "c.id_lote = l.id", array('lote', 'quadra'))
                ->joinLeft(array("ie" => TB_INDICE_EMPREENDIMENTO), "ie.id_indice_empreendimento = c.id_indice", ['fl_periodo','fl_residuo', 'indice_adicional', 'fl_periodo_adc', 'id_indice as idIndice'])
                ->joinLeft(array("d" => TB_DISTRATO),"c.id = d.id_contrato",'dt_distrato')
                ->where("c.id = {$_POST['idContrato']}")->query()->fetch();
            $tbAgrupada = AgrupadaGeral::buscar('12', $contrato['idIndice']);
            $contrato['indice'] = $tbAgrupada['descricao'];
            //valores a serem imcrementados
            $total_pago = 0;
            $total_a_pagar = 0;

            //tipos de parcelas
            //sinal
            $total_sinal = $adapter->select()->from(TB_PARCELA_HISTORICO, array('total' => 'count(*)'))->where("tp_parcela = 'S'")->where("id_contrato = {$_POST['idContrato']}")->query()->fetch();
            //intercalada
            $total_intercalada = $adapter->select()->from(TB_PARCELA_HISTORICO, array('total' => 'count(*)'))->where("tp_parcela = 'I'")->where("id_contrato = {$_POST['idContrato']}")->query()->fetch();
            //chaves
            $total_chave = $adapter->select()->from(TB_PARCELA_HISTORICO, array('total' => 'count(*)'))->where("tp_parcela = 'C'")->where("id_contrato = {$_POST['idContrato']}")->query()->fetch();
            //chaves
            $total_negociada["total"] = 0;

            $itens = array();

            $saldo = 0;
            foreach ($rsItens as $item) {

                if ($item['tp_parcela'] == 'S' && $contrato['inclui_sinal_contrato'] == 0) {
                    continue;
                }

                if (!$item["vl_parcela"])
                    $item["vl_parcela"] = 0.00;
                if (!$item["acrescimo"])
                    $item["acrescimo"] = 0.00;
                if (!$item["vl_juros"])
                    $item["vl_juros"] = 0.00;
                if (!$item["vl_multa"])
                    $item["vl_multa"] = 0.00;
                if (!$item["desconto"])
                    $item["desconto"] = 0.00;

                $tipoParcela = array('E', 'NE', 'SE', 'CE', 'IE');
                if ($item['pago'] == 1) {
                    $total_pago += $item['vl_parcela'] + $item['vl_multa'] + $item['vl_juros'] - $item['desconto'];
                } else if (!in_array($item['tp_parcela'], $tipoParcela)) {
                    $total_a_pagar += $item['vl_parcela'];
                }

                if ($item['vl_total_pago']) {
                    $tt = (float)number_format($item['vl_parcela'] + $item['vl_juros'] + $item['vl_multa'], 2);
                    $pago = (float)number_format($item['vl_total_pago'], 2);
                    $saldo += $tt - $pago;
                }

                $item['saldo'] = $saldo;
                $item['dt_parcela'] = $this->_helper->getDate($item['dt_parcela']);
                $item['dt_pagamento'] = $this->_helper->getDate($item['dt_pagamento']);
                $itens[] = $item;
            }

            // testa se o valor  nulo para no ter problemas com as operaes
            if ($contrato['nr_parcela'] == null) {
                $contrato['nr_parcela'] = 0.00;
            }
            if ($contrato['nr_parcela_sinal'] == null) {
                $contrato['nr_parcela_sinal'] = 0.00;
            }
            if ($contrato['nr_parcela_entrega'] == null) {
                $contrato['nr_parcela_entrega'] = 0.00;
            }
            if ($contrato['nr_intercalada'] == null) {
                $contrato['nr_intercalada'] = 0.00;
            }
            if ($contrato['vl_parcela'] == null) {
                $contrato['vl_parcela'] = 0.00;
            }
            if ($contrato['vl_parcela_sinal'] == null) {
                $contrato['vl_parcela_sinal'] = 0.00;
            }
            if ($contrato['vl_parcela_entrega'] == null) {
                $contrato['vl_parcela_entrega'] = 0.00;
            }
            if ($contrato['vl_intercalada'] == null) {
                $contrato['vl_intercalada'] = 0.00;
            }

            $valor_inicial = $contrato['nr_parcela'] * $contrato['vl_parcela']
                + $contrato['nr_intercalada'] * $contrato['vl_intercalada']
                + $contrato['nr_parcela_entrega'] * $contrato['vl_parcela_entrega'];
            if ($contrato['inclui_sinal_contrato'] == 1) {
                $valor_inicial += +$contrato['vl_sinal'];
            }

            //Busca se o contrato possui itens adicionais e os calcula para o total do valor do contrato
            $itensContrato = new ContratoItens();
            $itensContrato = $itensContrato->fetchAll('id_contrato = ' . $contrato['id']);

            if (count($itensContrato) > 0) {
                foreach ($itensContrato as $item) {
                    $valor_inicial += ((float)$item['vl_parcela'] * (int)$item['qt_parcelas']);
                }
            }

            //dados para o cabecalho do relatrio
            $tb_empreendimento = new Empreendimento();

            //dados da empresa
            $tabAgrup = Db_TabelaAgrupada::findByField("idTabela", Db_TabelaAgrupada::TABLE_CLIENTE, "descricao");

            foreach ($tabAgrup as $tab) {
                $header[$tab->getIdCampo()] = $tab->getDescricao();
            }

            $empreendimento = $tb_empreendimento->fetchRow("id = {$_POST['idEmpreendimento']}");

            $empreendimentoInfo = $tb_empreendimento->getAdapter()->select()->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento', 'cd_cidade'))
                ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
                ->where('id = '. $_POST['idEmpreendimento'])->query()->fetch();
            $this->set("empreendimentoInfo", $empreendimentoInfo);

            $header['dt_distrato'] = $this->_helper->getDate($contrato['dt_distrato']);
            $header['empreendimentologo'] = $empreendimento->ds_path_logo;
            $header['empreendimento'] = $empreendimento['nm_empreendimento'];
            $header['contrato'] = $_POST['idContrato'];
            $header['lote'] = $contrato['lote'];
            $header['quadra'] = $contrato['quadra'];
            $header['dt_contrato'] = $this->_helper->getDate($contrato['dt_contrato']);
            $header['cliente'] = $contrato["nm_pessoa"];
            $header['vl_inicial'] = number_format($valor_inicial, 2, ',', '.');
            $header['vl_a_pagar'] = number_format($total_a_pagar, 2, ',', '.');
            $header['vl_pago'] = number_format($total_pago, 2, ',', '.');
            $comSemResiduo = ($contrato['fl_residuo'] == '1')?' - Com':' - Sem';
            $caracterSoma = Helper::getNomePeriodo($contrato['fl_periodo']) != ''?' +':'';
            $indiceAdicional = ($contrato['indice_adicional'] != '0')?$caracterSoma.str_replace('.',',',number_format($contrato['indice_adicional'], 2)).'%':'';
            $header['indice'] = $contrato['indice'] . ' ' . Helper::getNomePeriodo($contrato['fl_periodo']) . ' ' . $indiceAdicional . ' ' . Helper::getNomePeriodo($contrato['fl_periodo_adc']).$comSemResiduo.' Resduo';
            //Puxa os dados do cabealho e coloca em um array
            $dadosCabecalho['DC'] = $_POST['dataContrato'];
            $dadosCabecalho['VC'] = $_POST['ValorContrato'];
            $dadosCabecalho['VP'] = $_POST['valorPago'];
            $dadosCabecalho['VR'] = $_POST['valorRestante'];
            $dadosCabecalho['IR'] = $_POST['indiceReajuste'];

            $this->set("dadosCabecalho", $dadosCabecalho);
            $this->set("valores", $itens);
            $this->set("cabecalho", $header);
            // Cidade empreendimento
            $cidade = $cidade->byId($empreendimentoInfo['cd_cidade']);
            $this->set('clienteCidade', $cidade);
            
            $this->display();

            $this->displayMPDF('Extrato_de_cliente' . time() . '.pdf', true, 'P');
        } else{
            $this->display('form');
        }
    }

    public function validarAction()
    {
        $campos = array(
            'idContrato' => 'Selecione o Contrato.','idEmpreendimento' => 'Selecione o Empreendimento.'
        );
        foreach ($campos as $campo => $msg) {
            if ($_POST[$campo] == '') {
                $this->_helper->addMensagem($campo, $msg);
            }
        }

        //Mensagem de Erros
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            echo json_encode(true);
        }
    }

    public function contratoByEmpreendimentoAction()
    {
        $empreedimento = $_POST['id_empreendimento'];
        $contratos = Contrato::byEmpreendimentoextrato($empreedimento, Contrato::CONTRATO_GERADO, false, array("nm_pessoa", "lote", "quadra", "id"));

        $lista[] = array('id'=>'','text'=>'');
        if (count($contratos) > 0) {
            foreach ($contratos as $contrato) {
                $lista[] = array(
                    'id' => $contrato['id'],
                    'text' => utf8_encode($contrato['nm_pessoa']) . ' Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . $contrato['id'],
                );
            }
        }
        echo json_encode($lista);
    }
}

