<?php

/**
 * Classe que representa o controller do extrato
 */
class ExtratoController extends Controller
{
    public function __construct($request)
    {

        parent::__construct($request);
        $this->empreendimento = new Empreendimento();
        $this->set("subtitulo", "Relatrio de Extrato de Pagamentos");

    }

    /**
     * Action index do controller
     */
    public function indexAction()
    {
        $this->redir(array("modulo" => "rl", "controller" => "extrato", "action" => "gerar"));

    }

    /**
     * Action responsvel por gerar o pdf com as informaes das parcelas
     */
    public function gerarAction()
    {
        //Pesquisa dados do cliente e da cidade;
        $tbClienteAcade = (new Db_Cliente())->fetchRow()->toArray();
        $cidade = new Cidade();
        $this->set('clienteAcade', $tbClienteAcade);

        $empreendimento = $this->empreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('nm_empreendimento', 'id', 'ds_path_logo'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimento = $empreendimento->order('nm_empreendimento')->query()->fetchAll();

        $this->set('empreendimentos', $empreendimento);


        if ($this->_isPost) {

            if ($this->validar()) {

                //dados das parcelas
                $tb_parcela = new Parcela();
                $tb_contrato = new Contrato();
                $tb_emp = new Empreendimento();
                $parcelaAvulsa = ($_POST['parcelaAvulsa'] == '0')?' AND tp_parcela != "A"':'';
                //busca s os dados ("S", "N", "I", "C", "G") no campo tp_parcela.
                $parcelaNegociada = ($_POST['parcelaNegociadas'] == '0')?' AND tp_parcela IN ("S", "N", "I", "C", "G")':'';
                $exibeResumoFinanceiro = $_POST['resumoFinanceiro'];

                //busca todos as PARCELAS que possuem o id_contrato igual ao informado no formulario. Query principal.
                $rsItens = $tb_parcela->fetchAll('id_contrato = '.$_POST['idContrato'].$parcelaNegociada.$parcelaAvulsa, 'dt_parcela')->toArray();

                //busca os nomes das pessoas e lotes relativo ao contrato selecionado
                $contrato = $tb_contrato->getAdapter()->select()->from(array("c" => TB_CONTRATO))
                    ->join(array("p" => TB_PESSOA), "c.id_pessoa = p.id", 'nm_pessoa')
                    ->join(array("l" => TB_LOTES), "c.id_lote = l.id", array('lote', 'quadra'))
                    ->join(array("ie" => TB_INDICE_EMPREENDIMENTO), "ie.id_indice_empreendimento = c.id_indice", ['fl_periodo', 'fl_residuo', 'indice_adicional', 'fl_periodo_adc', 'id_indice as idIndice'])
                    ->where("c.id = {$_POST['idContrato']}")->query()->fetch();
                $tbAgrupada = AgrupadaGeral::buscar('12', $contrato['idIndice']);
                $contrato['indice'] = $tbAgrupada['descricao'];
                //valores a serem imcrementados
                $total_pago = 0;
                $total_a_pagar = 0;
                $total_desconto = 0;
                $total_multa = 0;
                $total_juros = 0;
                $total_acrescimo = 0;
                $totalPagoHeader = 0;
                $total_a_pagar_header = 0;
                $total_qtd_parcela_paga = 0;
                $total_qtd_parcela_atraso = 0;
                $total_qtd_parcela_a_vencer = 0;
                $total_vl_parcela_atraso = 0;
                $total_vl_parcela_a_vencer = 0;

                $itens = array();
                $tipoParcela = array('E', 'NE', 'SE', 'CE', 'IE');

                foreach ($rsItens as $item) {

                    if ($item['tp_parcela'] == 'S' && $contrato['inclui_sinal_contrato'] == 0) {
                        continue;
                    }
                    if (!$item["vl_parcela"])
                        $item["vl_parcela"] = 0.00;
                    if (!$item["acrescimo"])
                        $item["acrescimo"] = 0.00;
                    if (!$item["vl_juros"])
                        $item["vl_juros"] = 0.00;
                    if (!$item["vl_multa"])
                        $item["vl_multa"] = 0.00;
                    if (!$item["desconto"])
                        $item["desconto"] = 0.00;

                    //calcula o valor do juros
                    $juros = (float)$item['vl_total_pago'] - (float)$item['vl_parcela'];
                    $juros = $juros - (float)$item['vl_multa'] + (float)$item['desconto']-(float)$item['acrescimo'];

                    $juros = round($juros, 2);
                    //caso o juros sej maior que 0 o mesmo recebe o novo valor calculado.
                    if ($item['vl_juros'] > 0 && $juros > 0) {
                        $item['vl_juros'] = $juros;
                    }

                    if ($item['pago'] == 1) {
                        //valor do header que no possui acrescimo
                        $totalPagoHeader += $item['vl_total_pago'];
                        $total_pago += $item['vl_parcela'] + $item['vl_multa'] + $item['vl_juros'] - $item['desconto'] + $item['acrescimo'];
                        $total_acrescimo += $item['acrescimo'];
                        $total_desconto += $item['desconto'];
                        $total_juros += $item['vl_juros'];
                        $total_multa += $item['vl_multa'];
                        $total_a_pagar += $item['vl_parcela'];
                        $total_qtd_parcela_paga++;
                    } else if (!in_array($item['tp_parcela'], $tipoParcela)) {
                        $total_acrescimo += $item['acrescimo'];
                        $total_desconto += $item['desconto'];
                        $total_juros += $item['vl_juros'];
                        $total_multa += $item['vl_multa'];
                        $total_a_pagar_header += $item['vl_parcela'] + $item['acrescimo'] - $item['desconto'];
                        $total_a_pagar += $item['vl_parcela'];
                    }

                    //Clculo resumo financeiro
                    if (!in_array($item['tp_parcela'], $tipoParcela)
                      && $exibeResumoFinanceiro == '1'
                      && $item['pago'] == '0')
                    {
                        if (strtotime($item['dt_parcela']) < strtotime(date('Y-m-d'))) {
                            $total_qtd_parcela_atraso++;
                            $total_vl_parcela_atraso += $item['vl_parcela'];
                        } else {
                            $total_qtd_parcela_a_vencer++;
                            $total_vl_parcela_a_vencer += $item['vl_parcela'];
                        }
                    }

                    //caso a parcelas seja do tipo E, NE IE, SE, CE, os valores do saldo, multa e juros so zerados
                    if (!in_array($item['tp_parcela'], $tipoParcela)) {
     //WS                   var_dump($item);
                        $saldoSemValorPago = $item['vl_parcela'] + $item['vl_juros'] + $item['vl_multa'] + $item['acrescimo'] - $item['desconto'];
                        $saldo = $saldoSemValorPago - $item['vl_total_pago'];
                        //Essa verificao serve para evitar zeros negativos (-0,00)
                        if ((string)$saldoSemValorPago == (string)$item['vl_total_pago']) {
                            $saldo = abs($saldo);
                        }
                    }
                    else {
                        $saldo = 0;
                        $item['vl_juros'] = 0;
                        $item['vl_multa'] = 0;
                    }

                    $item['saldo'] = $saldo;
                    $item['dt_parcela'] = $this->_helper->getDate($item['dt_parcela']);
                    $item['dt_pagamento'] = $this->_helper->getDate($item['dt_pagamento']);
                    $itens[] = $item;
                }
                // testa se o valor  nulo para no ter problemas com as operaes
                if ($contrato['nr_parcela'] == null) {
                    $contrato['nr_parcela'] = 0.00;
                }
                if ($contrato['nr_parcela_sinal'] == null) {
                    $contrato['nr_parcela_sinal'] = 0.00;
                }
                if ($contrato['nr_parcela_entrega'] == null) {
                    $contrato['nr_parcela_entrega'] = 0.00;
                }
                if ($contrato['nr_intercalada'] == null) {
                    $contrato['nr_intercalada'] = 0.00;
                }
                if ($contrato['vl_parcela'] == null) {
                    $contrato['vl_parcela'] = 0.00;
                }
                if ($contrato['vl_parcela_sinal'] == null) {
                    $contrato['vl_parcela_sinal'] = 0.00;
                }
                if ($contrato['vl_parcela_entrega'] == null) {
                    $contrato['vl_parcela_entrega'] = 0.00;
                }
                if ($contrato['vl_intercalada'] == null) {
                    $contrato['vl_intercalada'] = 0.00;
                }

                $valor_inicial = $contrato['nr_parcela'] * $contrato['vl_parcela']
                    + $contrato['nr_intercalada'] * $contrato['vl_intercalada']
                    + $contrato['nr_parcela_entrega'] * $contrato['vl_parcela_entrega'];
                if ($contrato['inclui_sinal_contrato'] == 1) {
                    $valor_inicial += $contrato['vl_sinal'];
                }

                //Busca se o contrato possui itens adicionais e os calcula para o total do valor do contrato
                $itensContrato = new ContratoItens();
                $itensContrato = $itensContrato->fetchAll('id_contrato = ' . $contrato['id']);

                if (count($itensContrato) > 0) {
                    foreach ($itensContrato as $item) {
                        $valor_inicial += ((float)$item['vl_parcela'] * (int)$item['qt_parcelas']);
                    }
                }

                //dados para o cabecalho do relatrio
                $tb_empreendimento = new Empreendimento();

                //busca o objeto empreendimento instanciado
                $empreendimento = $tb_empreendimento->findEmpreendimento($_POST['idEmpreendimento']);

                $empreendimentoInfo = $tb_empreendimento->getAdapter()->select()->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento', 'cd_cidade'))
                    ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
                    ->where('id = '. $_POST['idEmpreendimento'])->query()->fetch();
                $this->set("empreendimentoInfo", $empreendimentoInfo);

                $header['empreendimentologo'] = $empreendimento->ds_path_logo;
                $header['empreendimento'] = $empreendimento->nm_empreendimento;
                $header['contrato'] = $_POST['idContrato'];
                $header['lote'] = $contrato['lote'];
                $header['quadra'] = $contrato['quadra'];
                $header['dt_contrato'] = $this->_helper->getDate($contrato['dt_contrato']);
                $header['cliente'] = $contrato["nm_pessoa"];
                $header['vl_inicial'] = number_format($valor_inicial, 2, ',', '.');
                $header['vl_a_pagar'] = number_format($total_a_pagar_header, 2, ',', '.');
                $header['vl_pago'] = number_format($totalPagoHeader, 2, ',', '.');
                $comSemResiduo = ($contrato['fl_residuo'] == '1')?' - Com':' - Sem';
                $caracterSoma = Helper::getNomePeriodo($contrato['fl_periodo']) != ''?' +':'';
                $indiceAdicional = ($contrato['indice_adicional'] != '0') ? $caracterSoma . str_replace('.',',',number_format($contrato['indice_adicional'], 2)) . '%' : '';
                $header['indice'] = $contrato['indice'] . ' ' . Helper::getNomePeriodo($contrato['fl_periodo']) . ' ' . $indiceAdicional . ' ' . Helper::getNomePeriodo($contrato['fl_periodo_adc']).$comSemResiduo.' Resduo';

                $totais['total_pago'] = number_format($total_pago, 2, ',', '.');
                $totais['total_pagar'] = number_format($total_a_pagar, 2, ',', '.');
                $totais['total_desconto'] = number_format($total_desconto, 2, ',', '.');
                $totais['total_multa'] = number_format($total_multa, 2, ',', '.');
                $totais['total_juros'] = number_format($total_juros, 2, ',', '.');
                $totais['total_acrescimo'] = number_format($total_acrescimo, 2, ',', '.');
                $totais['total_vl_parcela_atraso'] = number_format($total_vl_parcela_atraso, 2, ',', '.');
                $totais['total_vl_parcela_a_vencer'] = number_format($total_vl_parcela_a_vencer, 2, ',', '.');
                $totais['total_qtd_parcela_paga'] = $total_qtd_parcela_paga;
                $totais['total_qtd_parcela_atraso'] = $total_qtd_parcela_atraso;
                $totais['total_qtd_parcela_a_vencer'] = $total_qtd_parcela_a_vencer;
                //Puxa os dados do cabealho e coloca em um array
                $dadosCabecalho['DC'] = $_POST['dataContrato'];
                $dadosCabecalho['VC'] = $_POST['ValorContrato'];
                $dadosCabecalho['VP'] = $_POST['valorPago'];
                $dadosCabecalho['VR'] = $_POST['valorRestante'];
                $dadosCabecalho['IR'] = $_POST['indiceReajuste'];
                
                $this->set("dadosCabecalho", $dadosCabecalho);
                $this->set("totais", $totais);
                $this->set("valores", $itens);
                $this->set("cabecalho", $header);

                //Cidade
                $cidade = $cidade->byId($empreendimentoInfo['cd_cidade']);
                $this->set('clienteCidade', $cidade);

                //Resumo Financeiro
                $this->set('resumoFinanceiro', $exibeResumoFinanceiro);

                //gerao do display e converso para PDF do documento usando o MPDF
                $this->display();
                $this->displayMPDF('Extrato_de_cliente' . time() . '.pdf');

                exit;
            }
        }

        $this->display('form');
    }

    public function validar()
    {
        $campos = array(
            'idContrato' => 'Selecione o Contrato.', 'idEmpreendimento' => 'Selecione o Empreendimento.'
        );
        foreach ($campos as $campo => $msg) {
            if ($_POST[$campo] == '') {
                $this->_helper->addMensagem($campo, $msg);
            }
        }
        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function contratoByEmpreendimentoAction()
    {
        $contratos = Contrato::byEmpreendimentoextrato($_POST['id_empreendimento'], Contrato::CONTRATO_GERADO, true, array("nm_pessoa", "lote", "quadra", "id"));

        $lista = array();
        foreach ($contratos as $contrato) {
            $lista[] = array('id' => $contrato['id'],
                'text' => utf8_encode($contrato['nm_pessoa']) . ' - Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . utf8_encode($contrato['id']));
        }
        echo json_encode($lista);
    }
}

