<?php

class EtiquetaController extends Controller
{

    private function validar()
    {
        //validao vazio
        $campos = array("etiquetas_empreendimento", "listaClientes");
        foreach ($campos as $cp) {
            if ($_POST[$cp] == "") {
                switch ($cp) {
                    case "etiquetas_empreendimento":
                        $msg = "O campo Empreendimento  obrigatrio.";
                        break;
                    case "listaClientes":
                        $msg = "Pelo menos um cliente deve ser escolhido.";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function indexAction()
    {
        $this->set("subtitulo", "Gerao de Etiquetas");

        $instanceEmpreendimento = new Empreendimento();

        $empreendimento = $instanceEmpreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('nm_empreendimento', 'id'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimento = $empreendimento->order('nm_empreendimento')->query()->fetchAll();

        $options = array();
        foreach ($empreendimento as $emp) {
            $options[$emp["id"]] = $emp["nm_empreendimento"];
        }
        $this->set("empOptions", $options);
        $this->display("form");
    }

    public function etiquetasClientesAction()
    {

        $clientes = Contrato::byEmpreendimento($_POST['etiquetas_empreendimento'], Contrato::CONTRATO_TODOS, 2, array("nm_pessoa", "lote", "quadra", "id"), true);
        $lista[] = array('id' => '*', 'text' => utf8_encode('Todos'));
        foreach ($clientes AS $cliente) {
            $lista[] = array(
                'id' => $cliente['id'],
                'text' => utf8_encode($cliente['nm_pessoa']) . ' - Quadra.: ' . utf8_encode($cliente['quadra'])  . ' - Lote: ' . utf8_encode($cliente['lote']) . ' - Contrato: ' . $cliente['id']
            );
        }
        echo json_encode($lista);
    }

    public function gerarAction()
    {
        if ($this-> _isPost && $this->validar()) {
            // no deixa que a ordem das etiquetas ultrapasse uma folha
            $ordem = ($_POST["ordem"] < 1 || $_POST["ordem"] > 30) ? 1 : $_POST["ordem"];
            $tb_cliente = new Pessoa();
            $clientes = Array();
            if ($_POST["listaClientes"][0] == "*") {
                $clientes = $tb_cliente->getAdapter()->select()->distinct()
                    ->from(array("p" => TB_PESSOA), array("nm_pessoa", "endereco", "nm_bairro", "nr_cep", "nr_telefone", "nr_celular", "nr_endereco", "ds_complemento"))
                    ->joinLeft(array("ci" => TB_CIDADE), "p.cd_cidade = ci.id", array("cidade" => "nome", "uf"))
                    ->join(array("c" => TB_CONTRATO), "c.id_pessoa = p.id", array("c.id" , "c.fl_distrato"))
                    ->join(array("l" => TB_LOTES), "c.id_lote = l.id", array("quadra", "lote"))
                    ->join(array("e" => TB_EMPREENDIMENTO), "l.id_empreendimento = e.id", "nm_empreendimento")
                    ->where("e.id = '" . $_POST["etiquetas_empreendimento"] . "'")
                    ->order("nm_pessoa");

                if($_POST['contratoAtivo'] == 'S') {
                    $clientes = $clientes->where('c.fl_distrato != "1"');
                }
                $clientes = $clientes->query()->fetchAll();

            } else {
                foreach ($_POST["listaClientes"] as $cdContrato) {
                    $contrato = $tb_cliente->getAdapter()->select()->distinct()
                        ->from(array("p" => TB_PESSOA), array("nm_pessoa", "endereco", "nm_bairro", "nr_cep", "nr_telefone", "nr_celular", "nr_endereco", "ds_complemento"))
                        ->joinLeft(array("ci" => TB_CIDADE), "p.cd_cidade = ci.id", array("cidade" => "nome", "uf"))
                        ->join(array("c" => TB_CONTRATO), "c.id_pessoa = p.id", array("c.id" , "c.fl_distrato"))
                        ->join(array("l" => TB_LOTES), "c.id_lote = l.id", array("quadra", "lote"))
                        ->join(array("e" => TB_EMPREENDIMENTO), "l.id_empreendimento = e.id", "nm_empreendimento")
                        ->where("c.id = '" . $cdContrato . "'")
                        ->where("e.id = '" . $_POST["etiquetas_empreendimento"] . "'")
                        ->order("nm_pessoa")
                        ->query()->fetch();
                    $clientes[] = $contrato;
                }
            }

            $empreendimento = (new Empreendimento())->fetchRow('id = '.$_POST['etiquetas_empreendimento'])->toArray();

            $tipoLoteamento = (new TipoLoteamento())->fetchRow('id_tipo_loteamento = '.$empreendimento['id_tipo_loteamento']);
            $empreendimento['dsGrupo'] = ($tipoLoteamento['ds_grupo'])?$tipoLoteamento['ds_grupo']:'';
            $empreendimento['dsSubgrupo'] = ($tipoLoteamento['ds_subgrupo'])?$tipoLoteamento['ds_subgrupo']:'';

            $this->set("empreendimento", $empreendimento);
            $this->set("ordem", $ordem);
            $this->set("clientes", $clientes);
            $this->display('gerar');
            $this->displayPDF(null, true, "P", "Letter", array(0, 7, 0, -4));
        } else {
            $this->indexAction();
        }
    }

}

?>
