<?php

class DistratoRelatorioController extends Controller
{

    public function __construct($request)
    {

        parent::__construct($request);

    }

    public function indexAction()
    {

        $this->set("subtitulo", "Relatrio de Distrato");
        if ($this->_isPost) {

            $tbClienteAcade = new Db_Cliente();
            $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

            if ($this->validar()) {

                $tiposDistrato = [
                    'I' => 'Inadimplncia',
                    'V' => 'Voluntrio',
                    'J' => 'Judicial',
                    'T'=> 'Tecnica',
                    'O' => 'Outros'
                ];

                $tb_emp = new Empreendimento();
                $adapter = $tb_emp->getAdapter();

                $where = " l.id_empreendimento = {$_POST['id_empreendimento']} and
						c.fl_distrato = '1' ";

                //Testa o tipo de distrato
                $tipoDistrato = '';
                $tpDistratoSelecionado = [];
                foreach ($_POST['tp_distrato'] as $tipo) {
                    if ($tipoDistrato != '')
                        $tipoDistrato .= '", "';
                    $tipoDistrato .= $tipo;
                    $tpDistratoSelecionado[] = $tiposDistrato[$tipo];
                }
                $tpDistratoSelecionado = implode(' - ',$tpDistratoSelecionado);
                $where .= 'AND d.tp_distrato IN ("' . $tipoDistrato . '") ';

                //Status
                if($_POST['status'] == 'C'){
                    $where .= 'AND d.dt_recebimento_termo IS NOT NULL ';
                }elseif($_POST['status'] == 'P'){
                    $where .= ' AND d.dt_recebimento_termo IS NULL ';
                }

                //Ordenao
                if ($_POST['ordem'] == 'Q') {
                    $ordem = array('d.tp_distrato', 'd.id_motivo','quadra', 'lote');
                } elseif ($_POST['ordem'] == 'D') {
                    $ordem = array('d.tp_distrato','d.id_motivo','d.dt_distrato');
                } elseif ($_POST['ordem'] == 'DR') {
                    $ordem = array('d.tp_distrato','d.id_motivo','d.dt_recebimento_termo');
                } else {
                    $ordem = array('d.tp_distrato', 'd.id_motivo', 'd.dt_distrato');
                }

                $listaDistratos = $adapter->select()
                    ->from(array('c' => TB_CONTRATO), array("dt_contrato" => "c.dt_contrato", "idContr" => "c.id", "nr_parcela", "nr_parcela_sinal", "nr_intercalada", "nr_parcela_entrega", "vl_sinal", "vl_parcela", "vl_intercalada", "vl_parcela_entrega"))
                    ->joinRight(array('d' => TB_DISTRATO), 'd.id_contrato = c.id', '*')
                    ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', 'p.nm_pessoa')
                    ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', 'pf.nr_cpf')
                    ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('lote', 'quadra'))
                    ->where($where);
                
                if ($_POST['de'] && $_POST['ate']) {
                    $listaDistratos = $listaDistratos->where('d.dt_distrato BETWEEN "' . Helper::getInputDate($_POST['de']) . '" AND "' . Helper::getInputDate($_POST['ate']) . '"');
                } elseif($_POST['dtInicioR'] && $_POST['dtFinalR']) {
                    $listaDistratos = $listaDistratos->where('d.dt_recebimento_termo BETWEEN "' . Helper::getInputDate($_POST['dtInicioR']) . '" AND "' . Helper::getInputDate($_POST['dtFinalR']) . '"');
                } elseif($_POST['de'] && $_POST['ate'] && $_POST['dtInicioR'] && $_POST['dtFinalR']) {
                    $listaDistratos = $listaDistratos->where('d.dt_distrato BETWEEN "' . Helper::getInputDate($_POST['de']) . '" AND "' . Helper::getInputDate($_POST['ate']) . '" AND d.dt_recebimento_termo BETWEEN "' . Helper::getInputDate($_POST['dtInicioR']) . '" AND "' . Helper::getInputDate($_POST['dtFinalR']) . '"');
                }

                $listaDistratos = $listaDistratos->order($ordem)->query()->fetchAll();

                if (count($listaDistratos) == 0) {
                    $this->_helper->addMensagem('erro', 'No foram encontrados registros no perodo.');
                    $this->display("index");
                    exit;
                }
                $distratos = [];

                foreach ($listaDistratos as &$distrato) {
                    $parcelas = new ParcelaDistrato();
                    $parcelas = $parcelas->getAdapter()->select()
                        ->from(array("pd" => TB_PARCELA_DISTRATO), array('id_parcela_contrato', 'dt_parcela', 'vl_parcela', 'vlDevolver' => 'SUM(vl_parcela)', 'qtParcelas' => 'COUNT(id_parcela_contrato)'))
                        ->where('id_contrato = ?', $distrato['id_contrato'])
                        ->where('tp_parcela = ?', 'D')->query()->fetchAll();
                    $distrato['qtParcelas'] = $parcelas[0]['qtParcelas'];
                    $distrato['vlDevolver'] = $parcelas[0]['vlDevolver'];
                    if ($distrato['tp_distrato'] == 'V') {
                        $distratos[$distrato['tp_distrato']][$distrato['id_motivo']][] = $distrato;
                    } else {
                        $distratos[$distrato['tp_distrato']][] = $distrato;
                    }
                }

                $empreendimento = $tb_emp->fetchRow('id = ' . $_POST['id_empreendimento'])->toArray();

                //Trs as informaes do Tipo de Loteamento
                $empreendimentoInfo = $tb_emp->getAdapter()->select()
                    ->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento', 'ds_path_logo'))
                    ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
                    ->where('id = ' . $_POST['id_empreendimento'])
                    ->query()->fetch();
                $this->set("empreendimentoInfo", $empreendimentoInfo);

                $motivos = Db_TabelaAgrupada::findByTabelaId(20);
                foreach ($motivos as $motivo) {
                    $auxMotivos[$motivo['idCampo']] = $motivo['descricao'];
                }

                $this->set('emp', $empreendimento);
                $this->set('motivos', $auxMotivos);
                $this->set('distratos', $distratos);

                $this->set('tpDistratoSelecionado', $tpDistratoSelecionado);
                
                if ($_POST['tipoRelatorio'] == 'pdf') {
                    $this->display('relatorio');
                    $this->displayMPDF(rand() . date("d/m/Y") . ".pdf", true, "L", "A4", array(1, 1, 1, 1));
                } elseif ($_POST['tipoRelatorio'] == 'xls') {
                    //Transformando Relatrio para Excel
                    for ($i = 0 ; $i < count($listaDistratos); $i ++){
                        $valorParcela = Helper::getMoney($listaDistratos[$i]["vlDevolver"] / $listaDistratos[$i]['qtParcelas']);

                        $colunas = [
                            'Data',
                            'Rec. Termo	',
                            'Data Contrato',
                            'Contrato',
                            'Qdr',
                            'Lt',
                            'Cliente',
                            'Dados Bancrios',
                            'Total Contrato',
                            'Valor Pago	',
                            'A Devolver',
                            'Valor Parcela',
                            'Documento',
                        ];

                        $linhas[] = [
                            Helper::getDate($listaDistratos[$i]['dt_distrato']),
                            Helper::getDate($listaDistratos[$i]['dt_recebimento_termo']),
                            Helper::getDate($listaDistratos[$i]['dt_contrato']),
                            $listaDistratos[$i]['id_contrato'],
                            $listaDistratos[$i]['quadra'],
                            $listaDistratos[$i]['lote'],
                            $listaDistratos[$i]['nm_pessoa'],
                            $listaDistratos[$i]['id_banco'] ? Banco::findBancoNome($listaDistratos[$i]['id_banco']) : '',
                            Helper::getMoney(($listaDistratos[$i]['nr_parcela']*$listaDistratos[$i]['vl_parcela']) + ($listaDistratos[$i]['nr_parcela_sinal']*$listaDistratos[$i]['vl_sinal']) + ($listaDistratos[$i]['nr_intercalada']*$listaDistratos[$i]['vl_intercalada']) + ($listaDistratos[$i]['nr_parcela_entrega']*$listaDistratos[$i]['vl_parcela_entrega'])),
                            Helper::getMoney($listaDistratos[$i]['vl_distrato']),
                            Helper::getMoney($listaDistratos[$i]['vlDevolver']),
                            '('. $listaDistratos[$i]['qtParcelas'] .'x) '.$valorParcela,
                            $listaDistratos[$i]['dt_recebimento_termo']?'RECEBIDO':'PENDENTE',
                        ];

                    }
                        $this->geraExcel($colunas, $linhas);          
                    }
                }else{
                    $this->display("relatorio");
                }
            }
        $this->carregarDados();
        $this->display("index");
    }


    private function carregarDados()
    {
        $instanceEmpreendimento = new Empreendimento();

        $empreendimentos = $instanceEmpreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('nm_empreendimento'))
            ->join(array('l' => TB_LOTES), 'e.id = l.id_empreendimento', array('id_lote' => 'id', 'id_empreendimento'))
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'id_lote', 'dt_contrato'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimentos = $empreendimentos->group('e.id')->order('nm_empreendimento')->query()->fetchAll();
        $this->set('empreendimentos', $empreendimentos);
    }

    private function validar()
    {
        //validao vazio
        $campos = array(
            "id_empreendimento" => "Selecione o empreendimento",
        );

        foreach ($campos as $k => $v) {
            if ($_POST[$k] == "") {
                $this->_helper->addMensagem($k, $v);
            }
        }

        if ($_POST['de'] == '' || $_POST['ate'] == '') {
            if ($_POST['dtInicioR'] == '' || $_POST['dtFinalR'] == '') {
                $this->_helper->addMensagem('tp_distrato', 'Selecione ao menos um perodo.');
            }
        }
        if (!isset($_POST['tp_distrato']))
            $this->_helper->addMensagem('tp_distrato', 'Selecione ao menos um tipo de distrato.');

        return !(count($this->_helper->getMensagens()) > 0);
    }
}