<?php

/**
 * Description of CartasEnviadasController
 *
 * @author acade
 */
class DimobController extends Controller
{

    protected $tb_empreendimento;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_empreendimento = new Empreendimento();
    }

    public function indexAction()
    {
        $this->redir(array('modulo' => 'rl', 'controller' => 'dimob', 'action' => 'relatorio'));
    }

    public function relatorioAction()
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        ini_set('max_execution_time', 800);
        if ($this->_isPost && $this->validar()) {

            //Verifica o checkbox de outros para excluir ou no o tipo de baixa
            $tipoExcluido = "O";
            if ($_POST['outros'] == '1') {
                $tipoExcluido = null;
            }

            $data = ($_POST['data'] == 'dp')?'dt_pagamento':'dt_credito';

            $contratos = $this->tb_empreendimento->getAdapter()->select()->from(array('l' => TB_LOTES), array('lote', 'quadra'))
                ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'nr_parcela', 'vl_parcela', 'nr_parcela_sinal', 'vl_sinal', 'nr_intercalada', 'vl_intercalada', 'nr_parcela_entrega', 'vl_parcela_entrega', 'dt_contrato', 'inclui_sinal_contrato', 'fl_distrato', 'fl_itens_contrato'))
                ->join(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('nm_pessoa'))
                ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pe.id = pf.id_pessoa', array('nr_cpf'))
                ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pe.id = pj.id_pessoa', array('nr_cnpj'))
                ->join(array('p' => TB_PARCELA), 'p.id_contrato = c.id', array('tp_baixa','vl_total_pago','tp_parcela', 'pago', 'dt_pagamento', 'dt_credito'))
                ->where('id_empreendimento = ' . $_POST['empreendimento'])
                ->where("p.tp_parcela != 'A'");

            //ESTE CDIGO EST COMENTADO POIS  UMA CODIGO ANTIGO. FOI SUBSTITUDO PELAS LINHAS DE CDIGO 85 AT 101
//            if ($_POST['anoContrato'] && !$_POST['anoRecebimento']) {
//                //exibe somente o contrato com parcela paga
//                if ($_POST['pagamento'] == 'nao') {
//                    $contratos->where("p.pago = '1'")
//                        ->where("YEAR(c.dt_contrato) = '{$_POST['anoContrato']}'");
//                }
//                //exibe o contrato com parcelas pagas e no pagas
//                else {
//                    $contratos->where("YEAR(c.dt_contrato) = '{$_POST['anoContrato']}'");
//                }
//
//            } elseif (!$_POST['anoContrato'] && $_POST['anoRecebimento']) {
//                if ($_POST['pagamento'] == 'nao') {
//                    $contratos->where("p.pago = '1'")
//                    ->where("YEAR(p.".$data.") = '{$_POST['anoRecebimento']}'");
//                }
//                else {
//                    $contratos->where("YEAR(p.".$data.") = '{$_POST['anoRecebimento']}'");
//                }
//
//            } elseif ($_POST['anoContrato'] && $_POST['anoRecebimento']) {
//                if ($_POST['pagamento'] == 'nao') {
//                    $contratos->where("p.pago = '1'")
//                        ->where("YEAR(c.dt_contrato) = '{$_POST['anoContrato']}'")
//                        ->where("YEAR(p.".$data.") = {$_POST['anoRecebimento']}");
//                }
//                else {
//                    $contratos->where("YEAR(c.dt_contrato) = '{$_POST['anoContrato']}'")
//                        ->where("YEAR(p.".$data.") = '{$_POST['anoRecebimento']}' or p.dt_pagamento is null");
//                }
//            }

//            $contratos->where('p.tp_baixa != "' . $tipoExcluido . '"')
//                ->group('c.id');

            if ($_POST['pagamento'] == 'nao') {

                if ($_POST['anoContrato']) {
                    $contratos->where("p.pago = '1'")
                        ->where("YEAR(c.dt_contrato) = '{$_POST['anoContrato']}'")
                        ->where("YEAR(p.".$data.") = {$_POST['anoRecebimento']}");
                } else {
                    $contratos->where("p.pago = '1'")
                        ->where("YEAR(p.".$data.") = {$_POST['anoRecebimento']}");
                }
            } else {

                if ($_POST['anoContrato']) {
                    $contratos->where("YEAR(c.dt_contrato) = '{$_POST['anoContrato']}'")
                        ->where("YEAR(p.".$data.") = '{$_POST['anoRecebimento']}' or p.dt_pagamento is null or p.dt_credito is null");
                } else {
                    $contratos->where("YEAR(p.".$data.") = '{$_POST['anoRecebimento']}' or p.dt_pagamento is null or p.dt_credito is null");
                }
            }

            if ($_POST['outros'] == '0') {
                $contratos->where("p.tp_baixa = 'T' or p.tp_baixa = 'B' or p.tp_baixa is null")
                    ->group('c.id');
            } else {
                $contratos->where("p.tp_baixa = 'T' or p.tp_baixa = 'B' or p.tp_baixa = 'O' or p.tp_baixa is null")
                    ->group('c.id');
            }

            $contratos = $contratos->query()->fetchAll();

            //Busca os contratos distratados para incluir no relatorio
            $contratoHistorico = $this->tb_empreendimento->getAdapter()->select()
                ->from(array('l' => TB_LOTES), array('lote', 'quadra'))
                ->join(array('ch' => TB_CONTRATO_HISTORICO), 'l.id = ch.id_lote', array('id_contrato' => 'id', 'nr_parcela', 'vl_parcela', 'nr_parcela_sinal', 'vl_sinal', 'nr_intercalada', 'vl_intercalada', 'nr_parcela_entrega', 'vl_parcela_entrega', 'dt_contrato', 'inclui_sinal_contrato', 'fl_distrato', 'fl_itens_contrato'))
                ->join(array('pe' => TB_PESSOA), 'pe.id = ch.id_pessoa', array('nm_pessoa'))
                ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pe.id = pf.id_pessoa', array('nr_cpf'))
                ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pe.id = pj.id_pessoa', array('nr_cnpj'))
                ->join(array('ph' => TB_PARCELA_HISTORICO), 'ph.id_contrato = ch.id', array('tp_baixa','vl_total_pago','tp_parcela', 'pago', 'dt_pagamento', 'dt_credito'))
                ->where('id_empreendimento = ' . $_POST['empreendimento'])
                ->where("ph.tp_parcela != 'A'");

            //ESTE CDIGO EST COMENTADO POIS  UMA CODIGO ANTIGO. FOI SUBSTITUDO PELAS LINHAS DE CDIGO 156 AT 163
//            if ($_POST['anoContrato'] && !$_POST['anoRecebimento']) {
//
//                //exibe somente o contrato com parcela paga
//                if ($_POST['pagamento'] == 'nao') {
//                    $contratoHistorico->where("ph.pago = '1'")
//                        ->where("YEAR(ch.dt_contrato) = '{$_POST['anoContrato']}'");
//                }
//                //exibe o contrato com parcelas pagas e no pagas
//                else {
//                    $contratoHistorico->where("YEAR(ch.dt_contrato) = '{$_POST['anoContrato']}'");
//                }
//
//            } elseif (!$_POST['anoContrato'] && $_POST['anoRecebimento']) {
//
//                if ($_POST['pagamento'] == 'nao') {
//                    $contratoHistorico->where("ph.pago = '1'")
//                        ->where("YEAR(ph.".$data.") = '{$_POST['anoRecebimento']}'");
//                }
//                else {
//                    $contratoHistorico->where("YEAR(ph.".$data.") = '{$_POST['anoRecebimento']}'");
//                }
//
//            }
//            elseif ($_POST['anoContrato'] && $_POST['anoRecebimento']) {
//
//                if ($_POST['pagamento'] == 'nao') {
//                    $contratoHistorico->where("ph.pago = '1'")
//                        ->where("YEAR(ch.dt_contrato) = '{$_POST['anoContrato']}'")
//                        ->where("YEAR(ph.".$data.") = {$_POST['anoRecebimento']}");
//                }
//                else {
//                    $contratoHistorico->where("YEAR(ch.dt_contrato) = '{$_POST['anoContrato']}'")
//                        ->where("YEAR(ph.".$data.") = '{$_POST['anoRecebimento']}' or ph.dt_pagamento is null");
//                }
//            }

//            $contratoHistorico->where('ph.tp_baixa != "' . $tipoExcluido . '"')
//                ->group('ch.id');

            if ($_POST['pagamento'] == 'nao') {

                if ($_POST['anoContrato']) {
                    $contratoHistorico->where("ph.pago = '1'")
                        ->where("YEAR(ch.dt_contrato) = '{$_POST['anoContrato']}'")
                        ->where("YEAR(ph.".$data.") = {$_POST['anoRecebimento']}");
                } else {
                    $contratoHistorico->where("ph.pago = '1'")
                        ->where("YEAR(ph.".$data.") = {$_POST['anoRecebimento']}");
                }
            } else {

                if ($_POST['anoContrato']) {
                    $contratoHistorico->where("YEAR(ch.dt_contrato) = '{$_POST['anoContrato']}'")
                        ->where("YEAR(ph.".$data.") = '{$_POST['anoRecebimento']}' or ph.dt_pagamento is null or ph.dt_credito is null");
                } else {
                    $contratoHistorico->where("YEAR(ph.".$data.") = '{$_POST['anoRecebimento']}' or ph.dt_pagamento is null or ph.dt_credito is null");
                }
            }

            if ($_POST['outros'] == '0') {
                $contratoHistorico->where("ph.tp_baixa = 'T' or ph.tp_baixa = 'B' or ph.tp_baixa is null")
                    ->group('ch.id');
            } else {
                $contratoHistorico->where("ph.tp_baixa = 'T' or ph.tp_baixa = 'B' or ph.tp_baixa = 'O' or ph.tp_baixa is null")
                    ->group('ch.id');
            }

            $contratoHistorico = $contratoHistorico->query()->fetchAll();

            $contratos = array_merge($contratos, $contratoHistorico);

            $aux = array();
            $i = 0;
            $adapter = $this->tb_empreendimento->getAdapter();
            foreach ($contratos as $key => $contrato) {
                $aux[$i]['lote'] = $contrato['lote'];
                $aux[$i]['quadra'] = $contrato['quadra'];
                $aux[$i]['cliente'] = $contrato['nm_pessoa'];
                $aux[$i]['contrato'] = $contrato['id_contrato'];

                $dt = explode('-', $contrato['dt_contrato']);
                $dataContrato = $dt[2] . '/' . $dt[1] . '/' . $dt[0];

                $aux[$i]['dt_contrato'] = $dataContrato;
                $aux[$i]['cpf'] = $contrato['nr_cpf'];
                $aux[$i]['cnpj'] = $contrato['nr_cnpj'];
                $aux[$i]['vlVenda'] = ($contrato['vl_parcela'] * $contrato['nr_parcela']) +
                    ($contrato['vl_intercalada'] * $contrato['nr_intercalada']) +
                    ($contrato['vl_parcela_entrega'] * $contrato['nr_parcela_entrega']);
                if ($contrato['inclui_sinal_contrato'] == 1) {
                    $aux[$i]['vlVenda'] += $contrato['vl_sinal'];
                }

                //Busca os valores dos itens adicionais se existirem
                if ($contrato['fl_itens_contrato'] == '1') {
                    $itensContrato = ContratoItens::findByContrato($contrato['id_contrato']);

                    if (count($itensContrato) > 0)
                        foreach ($itensContrato as $item) {
                            $aux[$i]['vlVenda'] += $item['vl_parcela'] * $item['qt_parcelas'];
                        }
                }

                //Teste para verificar se o contrato  distratado ou no
                if ($contrato['fl_distrato'] == '1') {
                    $total_parcelas = $adapter->select()
                        ->from(TB_PARCELA_HISTORICO, array(
                            'totalParcela' => 'SUM(vl_parcela)',
                            'totalJuros' => 'SUM(vl_juros)',
                            'totalMulta' => 'SUM(vl_multa)',
                            'totalValorPago' => 'SUM(vl_total_pago)',
                            'totalDesconto' => 'SUM(desconto)',
                            'totalAcrescimo' => 'SUM(acrescimo)'
                        ))
                        ->where("id_contrato = '{$contrato['id_contrato']}'")
                        ->where('tp_baixa != "'.$tipoExcluido.'"')
                        ->where("tp_parcela != 'A'");

                    if ($_POST['pagamento'] == 'nao') {
                        $total_parcelas->where("pago = '1'")
                            ->where("YEAR(".$data.") = '{$_POST['anoRecebimento']}' or dt_pagamento is null or dt_credito is null");
                    } else {
                        $total_parcelas->where("YEAR(".$data.") = '{$_POST['anoRecebimento']}' or dt_pagamento is null or dt_credito is null");
                    }

                    //ESTE CDIGO EST COMENTADO POIS  UMA CODIGO ANTIGO. FOI SUBSTITUDO PELAS LINHAS DE CDIGO 225 AT 230
//                    if ($_POST['anoContrato'] && !$_POST['anoRecebimento']) {
//                        $total_parcelas->where("YEAR(".$data.") = '{$_POST['anoContrato']}'");
//
//                    } elseif ($_POST['anoRecebimento']) {
//                        $total_parcelas->where("YEAR(".$data.") = '{$_POST['anoRecebimento']}'")
//                            ->where("pago = '1'");
//                    }

                    $total_parcelas = $total_parcelas->query()->fetch();

                } else {
                    //consultas para valores das parcelas pagas (todos os tipos)
                    $total_parcelas = $adapter->select()
                        ->from(TB_PARCELA, array(
                            'totalParcela' => 'SUM(vl_parcela)',
                            'totalJuros' => 'SUM(vl_juros)',
                            'totalMulta' => 'SUM(vl_multa)',
                            'totalValorPago' => 'SUM(vl_total_pago)',
                            'totalDesconto' => 'SUM(desconto)',
                            'totalAcrescimo' => 'SUM(acrescimo)'
                        ))
                        ->where("id_contrato = '{$contrato['id_contrato']}'")
                        ->where('tp_baixa != "'.$tipoExcluido.'"')
                        ->where("tp_parcela != 'A'");

                    if ($_POST['pagamento'] == 'nao') {
                        $total_parcelas->where("pago = '1'")
                            ->where("YEAR(".$data.") = '{$_POST['anoRecebimento']}' or dt_pagamento is null or dt_credito is null");
                    } else {
                        $total_parcelas->where("YEAR(".$data.") = '{$_POST['anoRecebimento']}' or dt_pagamento is null or dt_credito is null");
                    }

                    //ESTE CDIGO EST COMENTADO POIS  UMA CODIGO ANTIGO. FOI SUBSTITUDO PELAS LINHAS DE CDIGO 257 AT 262
//                    if ($_POST['anoContrato'] && !$_POST['anoRecebimento']) {
//                        $total_parcelas->where("YEAR(".$data.") = '{$_POST['anoContrato']}'");
//
//                    } elseif ($_POST['anoRecebimento'] && !$_POST['anoContrato']) {
//                        $total_parcelas->where("YEAR(".$data.") = '{$_POST['anoRecebimento']}' or dt_pagamento is null")
//                            ->where("pago = '1'");
//                    } elseif ($_POST['anoContrato'] && $_POST['anoRecebimento']) {
//                        $total_parcelas->where("YEAR(".$data.") = '{$_POST['anoContrato']}' or dt_pagamento is null");
//                    }
                    $total_parcelas = $total_parcelas->query()->fetch();
                }

                $total_parcelas['totalParcela'] = ($total_parcelas['totalParcela'] != null) ? $total_parcelas['totalParcela'] : 0;
                $total_parcelas['totalJuros'] = ($total_parcelas['totalJuros'] != null) ? $total_parcelas['totalJuros'] : 0;
                $total_parcelas['totalMulta'] = ($total_parcelas['totalMulta'] != null) ? $total_parcelas['totalMulta'] : 0;
                $total_parcelas['totalValorPago'] = ($total_parcelas['totalValorPago'] != null) ? $total_parcelas['totalValorPago'] : 0;
                $total_parcelas['totalDesconto'] = ($total_parcelas['totalDesconto'] != null) ? $total_parcelas['totalDesconto'] : 0;
                $total_parcelas['totalAcrescimo'] = ($total_parcelas['totalAcrescimo'] != null) ? $total_parcelas['totalAcrescimo'] : 0;

                $aux[$i]['vlParcelas'] = $total_parcelas['totalParcela'] - $total_parcelas['totalDesconto'] + $total_parcelas['totalAcrescimo'];
                $aux[$i]['vlJuros'] = $total_parcelas['totalJuros'];
                $aux[$i]['vlMulta'] = $total_parcelas['totalMulta'];
                $aux[$i]['vlPago'] = $total_parcelas['totalValorPago'];

                //caso o contrato seja distrato e o valor total pago seja zera, o mesmo  removido da lista de contratos,
                //pois um contrato distratado e com valor total pago = 0, no deve aparecer no relatrio.
                if ($aux[$i]['vlPago'] == 0 && $contrato['fl_distrato'] == '1')
                    unset($aux[$key]);

                $i++;
            }

            //remove as parcelas zeradas da lista caso o usurio selecione opo de no exibir as parcelas zeradas.
            if ($_POST['pagamento'] == 'nao') {
                foreach ($aux as $key => $value) {
                    if ($value['vlPago'] == 0)
                        unset($aux[$key]);
                }
            }

            //ordena o documento de acordo com o filtro informado
            if ($_POST['ordena'] == 'C') {
                function cmp($a, $b)
                {
                    return strcmp(Helper::getInputDate($a["dt_contrato"]), Helper::getInputDate($b["dt_contrato"]));
                }
            } elseif ($_POST['ordena'] == 'Q') {
                function cmp($a, $b)
                {
                    return strcmp($a["quadra"].$a["lote"], $b["quadra"].$b["lote"]);
                }
            } elseif ($_POST['ordena'] == 'CL') {
                function cmp($a, $b)
                {
                    return strcmp($a["cliente"], $b["cliente"]);
                }
            }

            usort($aux, 'cmp');

            $empreendimento = $this->tb_empreendimento->fetchRow("id = {$_POST['empreendimento']}");

            //Trs as informaes do Tipo de Loteamento
            $empreendimentoInfo = $this->tb_empreendimento->getAdapter()->select()
                ->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento','ds_path_logo'))
                ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
                ->where('id = ' . $_POST['empreendimento'])
                ->query()->fetch();
            $this->set("empreendimentoInfo", $empreendimentoInfo);

            $this->set('clientes', $aux);
            $this->set('empreendimento', $empreendimento);
            $this->display('gerar');
            $this->displayMPDF('Dimob-RECEITA_FEDERAL.pdf', true, 'L');
        }

        $empreendimentos = new Empreendimento();

        $empreendimentos = $empreendimentos->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('nm_empreendimento', 'id'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        // verifica se no  empreendedor pra adicionar a opo de todos os empreendimentos
        $this->set("empreendimentos", $empreendimentos);
        $this->display("form");

    }

    private function validar() {
        if (!$_POST['empreendimento']) {
            $this->_helper->addMensagem ('danger', 'O campo <b>Empreendimento</b>  obrigatrio' );
        }
        if (!$_POST['anoContrato'] && !$_POST['anoRecebimento']) {
            $this->_helper->addMensagem ('danger', 'Ao menos um dos campos <b>Ano Contrato</b> ou <b>Ano Recebimento</b> devem ser preenchidos.' );
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

}