<?php


class DeclaracoesController extends Controller {

    protected $tb_cliente;

    public function __construct($request) {
        parent::__construct($request);
        $this->empreendimentos = new Empreendimento();
        $this->tb_cliente = new Db_Cliente();
        $this->set("subtitulo", "Relatrio de Declaraes");

    }

    public function relatorioDeContratosAction()
    {
        $id_empreendimento = $_POST['id_empreendimento'];
        $instanceLote = new Lote();
        $selectLotes = $instanceLote->getDefaultAdapter()->select();
        $clientes = $selectLotes->from(array('l' => TB_LOTES), array('id', "lote", "quadra", 'id_empreendimento'))
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('idContrato' => 'id', 'id', 'id_pessoa', 'fl_distrato'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa', 'id'))
            ->where('l.id_empreendimento = ?', $id_empreendimento)->order('p.nm_pessoa')->group('c.id')->query()->fetchAll();
        $this->set('clientes', $clientes);

        $lista[] = array('id' => '*', 'text' => utf8_encode('Todos'));
        foreach ($clientes as $cliente) {
            $lista[] = array(
                'id' => $cliente['idContrato'],
                'text' => utf8_encode($cliente['nm_pessoa']) . ' - Quadra: ' . utf8_encode($cliente['quadra']) . ' - Lote: ' . utf8_encode($cliente['lote']). ' Contrato: '.$cliente['idContrato'],
            );
        }
        echo json_encode($lista);
    }

    public function relatorioDeContratosAtivosAction()
    {
        $id_empreendimento = $_POST['id_empreendimento'];
        $instanceLote = new Lote();
        $selectLotes = $instanceLote->getDefaultAdapter()->select();
        $clientes = $selectLotes->from(array('l' => TB_LOTES), array('id', "lote", "quadra", 'id_empreendimento'))
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('idContrato' => 'id', 'id', 'id_pessoa', 'fl_distrato'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa', 'id'))
            ->where('c.fl_distrato = "0"')
            ->where('l.id_empreendimento = ?', $id_empreendimento)->order('p.nm_pessoa')->group('c.id')->query()->fetchAll();
        $this->set('clientes', $clientes);

        $lista[] = array('id' => '*', 'text' => utf8_encode('Todos'));
        foreach ($clientes as $cliente) {
            $lista[] = array(
                'id' => $cliente['idContrato'],
                'text' => utf8_encode($cliente['nm_pessoa']) . ' - Quadra: ' . utf8_encode($cliente['quadra']) . ' - Lote: ' . utf8_encode($cliente['lote']). ' Contrato: '.$cliente['idContrato'],
            );
        }
        echo json_encode($lista);
    }

    public function relatorioDeContratosInativosAction()
    {
        $id_empreendimento = $_POST['id_empreendimento'];
        $instanceLote = new Lote();
        $selectLotes = $instanceLote->getDefaultAdapter()->select();
        $clientes = $selectLotes->from(array('l' => TB_LOTES), array('id', "lote", "quadra", 'id_empreendimento'))
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('idContrato' => 'id', 'id', 'id_pessoa', 'fl_distrato'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa', 'id'))
            ->where('c.fl_distrato = "1"')
            ->where('l.id_empreendimento = ?', $id_empreendimento)->order('p.nm_pessoa')->group('c.id')->query()->fetchAll();
        $this->set('clientes', $clientes);

        $lista[] = array('id' => '*', 'text' => utf8_encode('Todos'));
        foreach ($clientes as $cliente) {
            $lista[] = array(
                'id' => $cliente['idContrato'],
                'text' => utf8_encode($cliente['nm_pessoa']) . ' - Quadra: ' . utf8_encode($cliente['quadra']) . ' - Lote: ' . utf8_encode($cliente['lote']). ' Contrato: '.$cliente['idContrato'],
            );
        }
        echo json_encode($lista);
    }

    private function validar() {
        //validao vazio
        $campos = array("declaracoes_empreendimento", "declaracoes");
        foreach ($campos as $cp) {

            if ($_POST[$cp] == "") {
                switch ($cp) {
                    case "declaracoes_empreendimento":
                        $msg = "O campo Empreendimento  obrigatrio.";
                        break;
                    case "declaracoes":
                        $msg = "O campo Declarao  obrigatrio.";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);
            }
            //teste de validao do campo ListaClientes novo
            if(count($_POST['listaClientes']) == 0){
                $msg = "Ao menos um cliente deve ser escolhido.";
                $this->_helper->addMensagem('listaClientes',$msg);
            }
        }
        return!(count($this->_helper->getMensagens()) > 0);
    }

    public function indexAction() {
        $this->set("subtitulo", "Relatrio de Declaraes");
        $empreendimento = new Empreendimento();

        $empreendimento = $empreendimento->getDefaultAdapter()->select()
            ->from(array('e'=>TB_EMPREENDIMENTO), array('nm_empreendimento', 'id'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {

            }
        }
        $empreendimento = $empreendimento->order('nm_empreendimento')->query()->fetchAll();

        $options = array();
        foreach ($empreendimento as $emp) {
            $options[$emp["id"]] = $emp["nm_empreendimento"];
        }
        $this->set("empOptions", $options);

        $declaracao = new Modelo();
        $listaModelo = $declaracao->getAdapter()->select()
            ->from(array('co' => TB_MODELO), ['nm_titulo', 'cd_modelo'])
            ->where('co.tp_modelo = "DE"')->order('nm_titulo')->query()->fetchAll();

        $listaModeloWord = $declaracao->getAdapter()->select()
            ->from(array('co' => TB_MODELO_ARQUIVO), ['nm_titulo', 'cd_modelo as cd_modelo_word'])
            ->where('co.tp_modelo = "DE"')->order('nm_titulo')->query()->fetchAll();

        $listaDeclaracoes = array_merge($listaModelo, $listaModeloWord);
        sort($listaDeclaracoes);

        foreach ($listaDeclaracoes as $declaracao) {
            if ($declaracao['cd_modelo']) {
                $declaracoes[] = [
                    "nm_titulo" => $declaracao['nm_titulo'],
                    "cd_modelo" => $declaracao['cd_modelo']
                ]; 
            } else if ($declaracao['cd_modelo_word']) {
                $declaracoes[] = [
                    "nm_titulo" => $declaracao['nm_titulo'] . ' [Word]',
                    "cd_modelo" => 'w_' . $declaracao['cd_modelo_word']
                ]; 
            }
            
        }
        $this->set('declaracoes',$declaracoes);
        $this->display("form");
    }

    public function gerarAction()
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        if ($this->_isPost && $this->validar() && substr($_POST['declaracoes'], 0, 1) != 'w') {
            $tb_cliente = new Pessoa();
            $clientes = array();
            $declaracoes = new Modelo();
            $assinaturas = new Assinatura();      
            $parcerias = new Parceria();

            $assinatura = $assinaturas->fetchAll('id_empreendimento = '. $this->_helper->filters($_POST["declaracoes_empreendimento"]))->toArray();   
            $parceria = $parcerias->fetchAll('id_empreendimento = '. $this->_helper->filters($_POST['declaracoes_empreendimento']))->toArray();
            $empreendimento = (new Empreendimento())->fetchRow('id =' . $_POST["declaracoes_empreendimento"])->toArray();
            $tipoLoteamento = (new TipoLoteamento())->fetchRow('id_tipo_loteamento = '.$empreendimento['id_tipo_loteamento']);
            $empreendimento['dsGrupo'] = ($tipoLoteamento['ds_grupo'])?$tipoLoteamento['ds_grupo']:'';
            $empreendimento['dsSubgrupo'] = ($tipoLoteamento['ds_subgrupo'])?$tipoLoteamento['ds_subgrupo']:'';

            if ($_POST["listaClientes"][0] == "*") {
                $where = ' c.fl_distrato = "0" ';
            } else {
                foreach ($_POST["listaClientes"] as $c) {
                    $clientes[] = "'" . $c . "'";
                }
                $clientes = implode(",", $clientes);
                $where = "c.id IN (" . $clientes . ")";
            }
            $clientes = $tb_cliente->getAdapter()->select()
                ->from(array("p" => TB_PESSOA), array("nm_pessoa", "endereco", "nm_bairro", "nr_cep", "nr_telefone", "nr_celular", "nr_endereco", "ds_complemento"))
                ->joinLeft(array("ci" => TB_CIDADE), "p.cd_cidade = ci.id", array("cidade" => "nome", "uf"))
                ->join(array("c" => TB_CONTRATO), "c.id_pessoa = p.id", "c.id")
                ->join(array("l" => TB_LOTES), "c.id_lote = l.id", array("quadra", "lote"))
                ->join(array("e" => TB_EMPREENDIMENTO), "l.id_empreendimento = e.id", array("nm_empreendimento", "cd_cidade"))
                ->joinLeft(array("cid" => TB_CIDADE), "e.cd_cidade = cid.id", array("cidade_emp" => "nome"))
                ->where($where)
                ->where("e.id = '" . $_POST["declaracoes_empreendimento"] . "'")
                ->order("nm_pessoa")
                ->query()->fetchAll();
            $this->set('clientes', $clientes);
            $this->set('empreendimento', $empreendimento);
            
            $cliente = $this->tb_cliente->getAdapter()->select()
                ->from(array('c' => TB_CLIENTE), array('cd_cliente','cd_municipio','nm_razao_social','ds_end_logomarca', 'nm_bairro', 'ds_endereco', 'nr_cep'))
                ->query()->fetch();
            $this->set('cliente', $cliente);
            
            $declaracoes = $declaracoes->fetchRow('cd_modelo = ' . $_POST['declaracoes'])->toArray();
            $this->set('declaracao', $declaracoes);
            $this->set('assinatura', $assinatura);
            $this->set('parceria', $parceria);
            $this->set('tipoAssinatura', $_POST['campoAssinatura']);
            $this->set('data', $_POST['data']);
            $this->display('gerar');            
            $this->displayPDF("declaracao.pdf");

        } else if (substr($_POST['declaracoes'], 0, 1) == 'w') {
            $this->geraWord(substr($_POST['declaracoes'], 2), $_POST['listaClientes']);
        }
        else {
            $this->indexAction();
        }
    }

    private function geraWord($cd_modelo, $listaClientes) {
        $modeloArquivo = new ModeloArquivo();
        $modeloArquivo = $modeloArquivo->getAdapter()->select()
            ->from(['m' => TB_MODELO_ARQUIVO], ['cd_modelo', 'ds_path_modelo'])
            ->where('cd_modelo = ?', $cd_modelo)->query()->fetch();
        
        $filenameAr = [];

        if ($listaClientes[0] != '*') {
            foreach ($listaClientes as $contrato) {
                $templateProcessor = new \PhpOffice\PhpWord\TemplateProcessor(__ROOT__ . '/' . $modeloArquivo['ds_path_modelo']);

                $variaveis = $this->adicionarValoresTemplate($contrato, $templateProcessor);
        
                $filename = 'declaracao' . $contrato . '.docx';
                $filenameAr[] = $filename;
        
                $variaveis['templateProcessor']->saveAs($filename);      
                
            }
            if (sizeof($listaClientes) < 2) {
                //gera o download automatico
                header('Content-Description: File Transfer');
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename='.$filename);
                header('Content-Transfer-Encoding: binary');
                header('Expires: 0');
                header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
                header('Pragma: public');
                header('Content-Length: ' . filesize($filename));
                flush();
                //remove os arquivos temporarios
                readfile($filename);
                unlink($filename);
            } else {
                $files = $filenameAr;
                $zipname = 'declaracoes.zip';
                $zip = new ZipArchive;
                $zip->open($zipname, ZipArchive::CREATE);
                foreach ($files as $file) {
                    $zip->addFile($file);
                }
                $zip->close();
                foreach ($files as $file) {
                    unlink($file);
                }
                header('Content-Type: application/zip');
                header('Content-disposition: attachment; filename='.$zipname);
                header('Content-Length: ' . filesize($zipname));
                readfile($zipname);
                unlink($zipname);
            }
        } else {
            $msg = "A opo Todos no est disponvel para declarao em Word.";
            $this->_helper->addMensagem('listaClientes',$msg);
            $this->indexAction();
        }
    }
}

