<?php

class ConfissaoRelatorioController extends Controller {

    public function __construct($request) {
        parent::__construct($request);

    }

    public function indexAction() {

        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        $this->set("subtitulo", "Relatrio de Confisses de Dvidas");
        if ($this->_isPost) {
            if ($this->validar()) {
                $tb_confissao = new Confissao();
                $tb_emp = new Empreendimento();
                $empreendimento = $tb_emp->fetchRow('id = ' . $_POST['id_empreendimento'])->toArray();

                $where = "1";
                if ($_POST['situacao'] == 'P') {
                    $where = "dtPagamento is not null";
                }elseif($_POST['situacao'] == 'N'){
                    $where = "dtPagamento is null";
                }

                $tipoLoteamento = (new TipoLoteamento())->fetchRow('id_tipo_loteamento = '.$empreendimento['id_tipo_loteamento']);
                $empreendimento['dsGrupo'] = ($tipoLoteamento['ds_grupo'])?$tipoLoteamento['ds_grupo']:'';
                $empreendimento['dsSubgrupo'] = ($tipoLoteamento['ds_subgrupo'])?$tipoLoteamento['ds_subgrupo']:'';

                $confissoes = $tb_confissao->getAdapter()->select()->from(array('c' => TB_CONFISSAO), array('*'))
                    ->join(array('cl' => TB_CONFISSAO_LOTE), 'cl.idConfissao = c.id', null)
                    ->join(array('l' => TB_LOTES), 'cl.idLote = l.id', array('lote', 'quadra'))
                    ->join(array('cont' => TB_CONTRATO), 'cont.id_lote = l.id', null)
                    ->join(array('p' => TB_PESSOA), 'p.id = cont.id_pessoa', 'nm_pessoa')
                    ->where('id_empreendimento = ' . $_POST['id_empreendimento'])
                    ->where($where)
                    ->where("fl_distrato != '1'")
                    ->order(array('c.dtVencimento'))
                    ->query()->fetchAll();

                if (count($confissoes) > 0) {

                    $aux = array();
                    foreach ($confissoes as $confissao) {
                        $aux[$confissao['id']]['cliente'] = $confissao['nm_pessoa'];
                        $aux[$confissao['id']]['valor'] = Helper::getMoney($confissao['valor']);
                        $aux[$confissao['id']]['garantia'] = $confissao['garantia'];
                        $aux[$confissao['id']]['vencimento'] = Helper::getDate($confissao['dtVencimento']);
                        $aux[$confissao['id']]['pagamento'] = Helper::getDate($confissao['dtPagamento']);
                        $aux[$confissao['id']]['obs'] = $confissao['obs'];
                        $aux[$confissao['id']]['lotes'][] = array('lote' => $confissao['lote'], 'quadra' => $confissao['quadra']);
                    }

                    $this->set("emp", $empreendimento);
                    $this->set("confissoes", $aux);

                    $this->_lastView = 'relatorio';

                    $this->display('relatorio');
                    $this->displayMPDF(rand() . '.pdf');
                }else{
                    $tipo = ($_POST['situacao']=='P')?'pagas':'no pagas';
                    $this->_helper->addMensagem('erro',"No existem confisses $tipo para esse empreendimento.");
                }
            }
        }
        $this->carregarDados();
        $this->display("index");
    }

    private function carregarDados() {
        $instanceEmpreendimento = new Empreendimento();

        $empreendimento = $instanceEmpreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('nm_empreendimento'))
            ->join(array('l' => TB_LOTES), 'e.id = l.id_empreendimento', array('id_lote' => 'id', 'id_empreendimento'))
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'id_lote'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimento = $empreendimento->group('e.id')->order('nm_empreendimento')->query()->fetchAll();
        $this->set('empreendimentos', $empreendimento);
    }

    private function validar() {
        //validao vazio
        $campos = array("id_empreendimento" => "Selecione o empreendimento");
        foreach ($campos as $k => $v) {
            if ($_POST[$k] == "") {
                $this->_helper->addMensagem($k, $v);
            }
        }

        return!(count($this->_helper->getMensagens()) > 0);
    }

}