<?php

/**
 * Created by PhpStorm.
 * User: programacao-03
 * Date: 28/12/15
 * Time: 11:52
 */
class ComunicacaoController extends Controller
{
    private $tb_comunicacao;

    public function __construct($request)
    {
        parent::__construct($request);
    }
    public function indexAction()
    {$instanceEmpreendimento = new Empreendimento();
        $empreendimento = $instanceEmpreendimento->getDefaultAdapter();

        $empreendimento = $empreendimento->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('id_empreendimento' => 'id', 'nm_empreendimento'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {

            }
        }
        $empreendimento = $empreendimento->group('e.id')->order('nm_empreendimento')->query();
        $this->set('empreendimentos', $empreendimento);
        $this->display("index");
    }


    public function relatorioAction()
    {
        $tbClienteAcade = new Db_Cliente();
        $clienteAcade = $tbClienteAcade->fetchRow()->toArray();
        $this->set('clienteAcade', $clienteAcade);
        ini_set('memory_limit', '3000M');
        set_time_limit(0);
       
        
        $this->tb_comunicacao = new Comunicacao();
        $result = $this->tb_comunicacao->getRelatorio(implode("-",array_reverse(explode("/",$_POST['de']))),implode("-",array_reverse(explode("/",$_POST['ate']))),$_POST['idEmpreendimento'],"1",$_POST['tipoEnvio']);
        
        $retorno = [];
        $total = [];
        $totalAgendado = [];
        $totalEnviado = [];

        $totalGeral = 0;
        $totalAgendadoGeral = 0;
        $totalEnviadoGeral = 0;
        foreach($result as $agendamento){
            $posicao=$agendamento['nm_empreendimento'];
            if(!$total[$posicao]){
                $total[$posicao] = 0;
                $totalEnviado[$posicao] = 0;
                $totalAgendado[$posicao] = 0;
            }
            if($agendamento['enviado']){
                if(!$retorno[$posicao][$agendamento['enviado']]){
                    $retorno[$posicao][$agendamento['enviado']]['agendado']=0;
                    $retorno[$posicao][$agendamento['enviado']]['data']=$agendamento['enviado'];
                }
                $retorno[$posicao][$agendamento['enviado']]['enviado']=(Int) $agendamento['contador'];
                $total[$posicao] += (Int) $agendamento['contador'];
                $totalEnviado[$posicao] += (Int) $agendamento['contador'];
                $totalGeral += (Int) $agendamento['contador'];
                $totalEnviadoGeral += (Int) $agendamento['contador'];
            }
            elseif($agendamento['agendado']&&$agendamento['statusAgendamento']==0){
                if(!$retorno[$posicao][$agendamento['agendado']]){
                    $retorno[$posicao][$agendamento['agendado']]['enviado']=0;
                    $retorno[$posicao][$agendamento['agendado']]['data']=$agendamento['agendado'];
                }
                $retorno[$posicao][$agendamento['agendado']]['agendado']=(Int) $agendamento['contador'];
                $total[$posicao] += (Int) $agendamento['contador'];
                $totalAgendado[$posicao] += (Int) $agendamento['contador'];
                $totalGeral += (Int) $agendamento['contador'];
                $totalAgendadoGeral += (Int) $agendamento['contador'];
            }
        }
        foreach($retorno as $key=>$emp){
            ksort($retorno[$key]) ;
        }
        $this->set('agendamentos', $retorno);
        $this->set('total', $total);
        $this->set('totalAgendado', $totalAgendado);
        $this->set('totalEnviado', $totalEnviado);
        $this->set('totalGeral', $totalGeral);
        $this->set('totalAgendadoGeral', $totalAgendadoGeral);
        $this->set('totalEnviadoGeral', $totalEnviadoGeral);
        if ($_POST['tipoRelatorio'] == 'pdf') {
            $this->displayMPDF('Relatorio_' . time() . '.pdf');
        } elseif ($_POST['tipoRelatorio'] == 'xls') {
            $colunas = [
                '',
                '',
                '',
                ''
            ];
            foreach($retorno as $key1=>$agendamentos){        
                $linhas[]=["Empreendimento: ".$key1,"","",""];
                $linhas[]=["","","",""];
                $linhas[]=["Data","Quantidade Agendado","Quantidade Enviado","Saldo"];
                foreach($agendamentos as $key=>$agendamento){
                    $linhas[]=[ 
                        implode("/",array_reverse(explode("-",$agendamento['data']))),
                        $agendamento['agendado'],
                        $agendamento['enviado'],
                        ($agendamento['agendado']+$agendamento['enviado'])
                    ];
                                           
                }
            }

            $linhas[]=["","","",""];
            $linhas[]=["Quantidade Total de e-mails:","","",  $totalGeral];

            $linhas[]=["Quantidade total agendado:","","",  $totalAgendadoGeral];

            $linhas[]=["Quantidade total enviado:","","",  $totalEnviadoGeral];

            $linhas[]=["","","",""];

            $linhas[]=["Limite atual dirio de envio de e-mails:","","",$clienteAcade['qtd_envio_email'] ];
            
            $linhas[]=["","","",""];
                  
                
            $this->geraExcel($colunas, $linhas);

        } else {
            $this->display("relatorio");
        }
    }

    
}
