<?php

class ComissaoController extends Controller
{
    public function indexAction()
    {
        $this->set("subtitulo", "Relatrio de Comisses ");
        $this->set('nomeTela', "Relatrio de Comisses ");

        $instanceEmpreendimento = new Empreendimento();
        $empreendimento = $instanceEmpreendimento->getDefaultAdapter();

        $empreendimento = $empreendimento->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('id_empreendimento' => 'id', 'nm_empreendimento'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {

            }
        }
        $empreendimento = $empreendimento->group('e.id')->order('nm_empreendimento')->query()->fetchAll();
        $this->set('empreendimentos', $empreendimento);

        $this->display("index");
    }

    public function relatorioAction()
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        ini_set('memory_limit', '3000M');
        set_time_limit(0);

        if ($this->validar()) {

            if ($_POST['corretor_relatorio_comissoes']) {
                if ($_POST['corretor_relatorio_comissoes'] == '*') {
                    $tipo_comissao = '*';
                } else {
                    $tb_corretorEmpreendimento = new Corretor_Empreendimento();
                    $corretorParceiro = $tb_corretorEmpreendimento->fetchRow('id_corretor = ' . $_POST['corretor_relatorio_comissoes'] . ' AND id_empreendimento = ' . $_POST['empreendimento_relatorio_comissoes']);
                    $tipo_comissao = $corretorParceiro['tp_comissao'];
                }                
            } else {
                $tb_parceriaComissao = new ParceriaComissao();
                $corretorParceiro = $tb_parceriaComissao->fetchRow('id_pessoa = ' . $_POST['idParceiro'] . ' AND id_empreendimento = ' . $_POST['empreendimento_relatorio_comissoes']);
                $tipo_comissao = $corretorParceiro['tp_comissao'];
            }

            if ($tipo_comissao != 'P' && $tipo_comissao != '*') {
                $_POST['tp_relatorio'] = 'F';
                //Valor Fixo, Porc. Total da Venda e Porc. Total da Tabela Pre�o
                $this->relatorioF();
            } else if ($tipo_comissao == 'P') {
                $_POST['tp_relatorio'] = 'P';
                //Porc. Parcela
                $this->relatorioP();
            }  else {
                $_POST['tp_relatorio'] = '*';
                $this->relatorioTodos();
            }
        } else {
            $this->indexAction();
        }
    }

    //Relat�rio de todos os contratos de todos os corretores de um determinado empreendimento
    public function relatorioTodos() {
        $tpParcelas = array();

        if (count($_POST['tp_parcela'])) {
            foreach ($_POST['tp_parcela'] as $tipo) {
                if ($tipo == 'G' || $tipo == 'Q') {
                    $tpParcelas[] = '"' . $tipo . '"';
                } else {
                    $tpParcelas[] = '"' . $tipo . '", "' . $tipo . 'E"';
                }
            }
            $tpParcelas = '(' . implode(',', $tpParcelas) . ')';
        }
        $instanceEmpreendimento = new Empreendimento();

        $relatorio['empreendimento'] = $instanceEmpreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.rgi', 'e.id', 'e.porcAdmin', 'e.id_tipo_loteamento','ds_path_logo'))
            ->join(array('c' => Db_Cidade::TABLE_NAME), 'e.cd_cidade = c.id', array('cidade_nome' => 'c.nome', 'cidade_uf' => 'c.uf'))
            ->joinLeft(array('t' => TB_TIPO_LOTEAMENTO), 'e.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
            ->where('e.id = ?', $_POST['empreendimento_relatorio_comissoes'])->query()->fetch();

        //Busca o corretor ou parceiro do empreendimento
        if ($_POST['corretor_relatorio_comissoes'] == '*') {
            $instanceCorretor = new Corretor_Empreendimento();
            $corretorParceiro = $instanceCorretor->getAdapter()->select()
                ->from(array('ce' => TB_CORRETOR_EMPREENDIMENTO), array('*'))                    
                ->join(array('p' => TB_PESSOA), 'ce.id_corretor = p.id', array('p.nm_pessoa'))
                ->joinLeft(array('i' => TB_PESSOA_JURIDICA), 'ce.id_imobiliaria = i.id_pessoa', array('i.nm_fantasia'))
                ->where('ce.id_empreendimento = ?', $_POST['empreendimento_relatorio_comissoes'])                                       
                ->query()->fetchAll();
        } else {
            $instancia = new InstanciaZend();
            $corretorParceiro = $instancia->getAdapter()->select()
                ->from(array('pc' => TB_PARCERIA_COMISSAO), array('*'))
                ->join(array('p' => TB_PESSOA), 'pc.id_pessoa = p.id', array('p.nm_pessoa'))
                ->where('pc.id_empreendimento = ?', $_POST['empreendimento_relatorio_comissoes'])
                ->where('p.id = ?', $_POST['idParceiro'])
                ->query()->fetch();
        }

        $relatorio['corretorParceiro'] = $corretorParceiro;

        for ($i=0; $i < count($relatorio['corretorParceiro']); $i++) {
            switch ($relatorio['corretorParceiro'][$i]['tp_comissao']) {
                case 'P':                    
                    $relatorio['corretorParceiro'][$i]['tipoComissao'] = 'Porc. Parcela';                    
                    break;
                case 'PL':                    
                    $relatorio['corretorParceiro'][$i]['tipoComissao'] = 'Porc. Total';                    
                    break;
                case 'F':                    
                    $relatorio['corretorParceiro'][$i]['tipoComissao'] = 'Fixo';                    
                    break;
                case 'PT':                    
                    $relatorio['corretorParceiro'][$i]['tipoComissao'] = 'Porc. Valor Total Tabela';
                    break;
            }                        
        }         
        
        $instanceContrato = new Contrato();
        $contratos = $instanceContrato->getDefaultAdapter()->select()
            ->from(array('c' => TB_CONTRATO), array('id_contrato' => 'c.id', 'id_lote' => 'c.id_lote', 'id_corretor', 'nr_parcela', 'dt_contrato', 'fl_distrato',
                'nr_parcela_sinal', 'nr_intercalada', 'nr_parcela_entrega', 'vl_parcela', 'vl_sinal', 'vl_intercalada', 'vl_parcela_entrega', 'fl_aprovar_contrato'))
            ->join(array('ce' => TB_CORRETOR_EMPREENDIMENTO), 'c.id_corretor = ce.id_corretor', array('tp_comissao', 'pc_comissao'))
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('l.quadra', 'l.lote'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('p.nm_pessoa', 'p.endereco', 'p.nm_bairro', 'id_pessoa' => 'p.id'))
            ->where('l.id_empreendimento = ?', $relatorio['empreendimento']['id'])
            ->where('c.fl_aprovar_contrato = "1"')
            ->group('id_contrato');

        if ($_POST['distratado'] != '1') {
            $contratos = $contratos->where('c.fl_distrato = "0"');            
        }

        if ($_POST['deContrato']) {
            $contratos = $contratos->where('c.dt_contrato BETWEEN "' . Helper::getInputDate($_POST['deContrato']) . '" AND "' . Helper::getInputDate($_POST['ateContrato']) . '"');
        }

        $contratos = $contratos->order(array('c.dt_contrato'))->query()->fetchAll();
        
        $parcela_quantidade = 0;
        $parcela_valor = 0;

            for ($i=0; $i<count($relatorio['corretorParceiro']); $i++) {
                //percorre todos os contratos selecionados
                $totalValor = 0; $totalComissao = 0; $parcela_quantidade = 0; $parcela_valor = 0;
                foreach ($contratos as $key => &$contrato) {
                    if (($relatorio['corretorParceiro'][$i]['tp_comissao'] == 'P') && (($contrato['id_corretor'] == $relatorio['corretorParceiro'][$i]['id_corretor']))) {
                        $tpParcelasCorretorParceiro = Corretor_Empreendimento::getArrayTiposParcela(false,$_POST['empreendimento_relatorio_comissoes'], $contrato['id_corretor']);
                        //percorre todos os contratos selecionados
                        
                            $hasSinal = ($contrato['nr_parcela_sinal'] > 0);


                            if ($_POST['deContrato'] && $_POST['ateContrato']) {
                                $parcelas = Parcela::parcelaByContrato($contrato['id_contrato'], $_POST['deContrato'], $_POST['ateContrato'], $tpParcelas, 1, false);
                                $parcelasHistorico = Parcela::parcelaHistoricoByContrato($contrato['id_contrato'], $_POST['deContrato'], $_POST['ateContrato'], $tpParcelas, 1, false);
                            }

                            $contrato['parcelas'] = array_merge($parcelasHistorico, $parcelas);
            
                            if (count($contrato['parcelas']) == 0) {
                                unset($contratos[$key]);
                                continue;
                            }                            
                            foreach ($contrato['parcelas'] as $kp => &$parc) {
                                //Teste para calculo das comissoes referentes a cada tipo
                                switch ($relatorio['corretorParceiro'][$i]['tp_comissao']) {
                                    case 'PL' :
                                        if ($parc['tp_parcela'] == 'S')
                                            $parc['vl_comissao'] = (Contrato::getVlContrato($contrato['id_contrato']) * $relatorio['corretorParceiro'][$i]['pc_comissao'] * 0.01) / (int)$contrato['nr_parcela_sinal'];
                                        break;
                                    case 'P' :
                                        if (in_array($parc['tp_parcela'], $tpParcelasCorretorParceiro))
                                            $parc['vl_comissao'] = $parc['vl_total_pago'] * ($relatorio['corretorParceiro'][$i]['pc_comissao'] * 0.01);
                                        break;
                                    case 'F' :
                                        if ($hasSinal) {
                                            if ($parc['tp_parcela'] == 'S' && $parc['id_parcela'] == '1')
                                                $parc['vl_comissao'] = $$relatorio['corretorParceiro'][$i]['pc_comissao'];
                                        } else
                                            if ($parc['tp_parcela'] == 'N' && $parc['id_parcela'] == '1')
                                                $parc['vl_comissao'] = $$relatorio['corretorParceiro'][$i]['pc_comissao'];
                                        break;
                                }
                                if (isset($parc['vl_comissao'])) {
                                    $totalComissao += $parc['vl_comissao'];
                                    $parcela_valor += $parc['vl_parcela'];
                                    $parcela_quantidade++;
                                } else
                                    unset($contrato['parcelas'][$kp]);                                
                            }                            
                            if (count($contrato['parcelas']) == 0) {
                                unset($contratos[$key]);
                            }
                            $relatorio['contratos'][$key] = $contrato;
                            $relatorio['corretorParceiro'][$i]['totalParcela'] = $parcela_quantidade;
                            $relatorio['corretorParceiro'][$i]['totalValor'] = $parcela_valor;

                    } else if (($relatorio['corretorParceiro'][$i]['tp_comissao'] != 'P') && (($contrato['id_corretor'] == $relatorio['corretorParceiro'][$i]['id_corretor']))) {
                        //Variavel para acumulativa, para totalValor 
                        $valorLote = 0;
                        //condi��o para verificar valor tabela pre�o, caso n�o tenha segue normal
                        if ($relatorio['corretorParceiro'][$i]['tp_comissao'] == 'PT' && $_POST['corretor_relatorio_comissoes']) {
                            $tabelaPrecoLote = new TabelaPrecoLote();
                            $tabelaPrecoLote = $tabelaPrecoLote->fetchRow('id_tabela_preco = ' . $relatorio['corretorParceiro'][$i]['id_tabela_preco'] . ' AND id_lote = ' . $contrato['id_lote']);
                            if ($tabelaPrecoLote)
                                $valorLote += $tabelaPrecoLote['vl_total'];
                        } else {
                            $valorLote = $contrato['nr_parcela'] * $contrato['vl_parcela'];
                            $valorLote += $contrato['vl_sinal'];
                            $valorLote += $contrato['nr_parcela_entrega'] * $contrato['vl_parcela_entrega'];
                            $valorLote += $contrato['nr_intercalada'] * $contrato['vl_intercalada'];

                            //Busca se o contrato possui itens adicionais e os calcula para o total do valor do contrato
                            $itensContrato = new ContratoItens();
                            $itensContrato = $itensContrato->fetchAll('id_contrato = ' . $contrato['id_contrato']);
                            if (count($itensContrato) > 0)
                                foreach ($itensContrato as $item)
                                    $valorLote += ((float)$item['vl_parcela'] * (int)$item['qt_parcelas']);
                        }                    

                        if ($relatorio['corretorParceiro'][$i]['tp_comissao'] == 'F') {
                            $contrato['comissao'] = $relatorio['corretorParceiro'][$i]['pc_comissao'];                        
                        } else {
                            $contrato['comissao'] = $valorLote * ($relatorio['corretorParceiro'][$i]['pc_comissao'] / 100);                        
                        }
                        $totalComissao += $contrato['comissao'];                    
                        $contrato['valor'] += $valorLote;
                        $totalValor += $valorLote;

                        $relatorio['contratos'][$key] = $contrato;
                        $relatorio['corretorParceiro'][$i]['totalValor'] = $totalValor;
                    }                                    
                    
                }
                $relatorio['corretorParceiro'][$i]['totalComissao'] = $totalComissao;
            }
        $relatorio['todos'] = ($_POST['corretor_relatorio_comissoes'] == '*') ? true : false;
        $relatorio['tipo'] = $_POST['tipo'] == 'PC' ? true : false;

        $relatorio['periodoContrato'] = $_POST['deContrato'] . " at " . $_POST['ateContrato'];
        $relatorio['periodoPagamento'] = $_POST['dePagamento'] . " at " . $_POST['atePagamento'];
        $relatorio['periodoCredito'] = $_POST['deCredito'] . " at " . $_POST['ateCredito']; 

        if (count($relatorio['contratos']) > 0) {
            $this->set('relatorio', $relatorio);
            $this->display("relatorio");

            if ($_POST['tipoRelatorio'] == 'pdf') {
                $this->displayMPDF('Relatorio_' . time() . '.pdf');
            }
        } else {

            //verifica se existem parcelas para no exibir o relatrio em branco 
            $this->_helper->addMensagem('index', 'No exitem dados a serem exibidos!');

            $this->indexAction();
            exit;
        }
    }

    public function relatorioP()
    {
        $tpParcelas = array();

        if (count($_POST['tp_parcela'])) {
            foreach ($_POST['tp_parcela'] as $tipo) {
                if ($tipo == 'G' || $tipo == 'Q') {
                    $tpParcelas[] = '"' . $tipo . '"';
                } else {
                    $tpParcelas[] = '"' . $tipo . '", "' . $tipo . 'E"';
                }
            }
            $tpParcelas = '(' . implode(',', $tpParcelas) . ')';
        }
        $instanceEmpreendimento = new Empreendimento();

        $relatorio['empreendimento'] = $instanceEmpreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.rgi', 'e.id', 'e.porcAdmin', 'e.id_tipo_loteamento','ds_path_logo'))
            ->join(array('c' => Db_Cidade::TABLE_NAME), 'e.cd_cidade = c.id', array('cidade_nome' => 'c.nome', 'cidade_uf' => 'c.uf'))
            ->joinLeft(array('t' => TB_TIPO_LOTEAMENTO), 'e.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
            ->where('e.id = ?', $_POST['empreendimento_relatorio_comissoes'])->query()->fetch();

        //Busca o corretor ou parceiro do empreendimento
        if ($_POST['corretor_relatorio_comissoes']) {
            $instanceCorretor = new Corretor_Empreendimento();
            $corretorParceiro = $instanceCorretor->getAdapter()->select()
                ->from(array('ce' => TB_CORRETOR_EMPREENDIMENTO), array('*'))
                ->join(array('p' => TB_PESSOA), 'ce.id_corretor = p.id', array('p.nm_pessoa'))
                ->joinLeft(array('i' => TB_PESSOA_JURIDICA), 'ce.id_imobiliaria = i.id_pessoa', array('i.nm_fantasia'))
                ->where('ce.id_empreendimento = ?', $_POST['empreendimento_relatorio_comissoes'])
                ->where('p.id = ?', $_POST['corretor_relatorio_comissoes'])
                ->query()->fetchAll();
        } else {
            $instancia = new InstanciaZend();
            $corretorParceiro = $instancia->getAdapter()->select()
                ->from(array('pc' => TB_PARCERIA_COMISSAO), array('*'))
                ->join(array('p' => TB_PESSOA), 'pc.id_pessoa = p.id', array('p.nm_pessoa'))
                ->where('pc.id_empreendimento = ?', $_POST['empreendimento_relatorio_comissoes'])
                ->where('p.id = ?', $_POST['idParceiro'])
                ->query()->fetchAll();
        }
        $relatorio['corretorParceiro'] = $corretorParceiro;

        $relatorio['corretorParceiro'][0]['tipoComissao'] = 'Porc. Parcela';

        //Seta os valores do quadro resumo ao final do relat�rio para acrescimos
        $totalComissao = 0;
        $parcela_quantidade = 0;
        $parcela_valor = 0;

        $instanceContrato = new Contrato();
        $contratos = $instanceContrato->getDefaultAdapter()->select()
            ->from(array('c' => TB_CONTRATO), array('id_contrato' => 'c.id', 'id_lote' => 'c.id_lote', 'id_corretor', 'nr_parcela', 'dt_contrato', 'fl_distrato',
                'nr_parcela_sinal', 'nr_intercalada', 'nr_parcela_entrega', 'vl_parcela', 'vl_sinal', 'vl_intercalada', 'vl_parcela_entrega', 'fl_aprovar_contrato'))
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('l.quadra', 'l.lote'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('p.nm_pessoa', 'p.endereco', 'p.nm_bairro', 'id_pessoa' => 'p.id'))
            ->where('l.id_empreendimento = ?', $relatorio['empreendimento']['id'])
            ->where('c.fl_aprovar_contrato = "1"');

        if ($_POST['distratado'] != '1') {
            $contratos = $contratos->where('c.fl_distrato = "0"');
        }

        if ($_POST['corretor_relatorio_comissoes'])
            $contratos = $contratos->where('c.id_corretor = ?', $_POST['corretor_relatorio_comissoes']);

        if ($_POST['deContrato'])
            $contratos = $contratos->where('c.dt_contrato BETWEEN "' . Helper::getInputDate($_POST['deContrato']) . '" AND "' . Helper::getInputDate($_POST['ateContrato']) . '"');

        $contratos = $contratos->order(array('p.nm_pessoa', 'l.lote', 'l.quadra'))->query()->fetchAll();

        //Condi��o para gerar relat�rio de comiss�o do parceiro!!!
        if (count($contratos) > 0) {
            if ($_POST['idParceiro']) {
                $tpParcelasCorretorParceiro = ParceriaComissao::getArrayTiposParcela($_POST['idParceiro'],$_POST['empreendimento_relatorio_comissoes']);
            } else {
                $tpParcelasCorretorParceiro = Corretor_Empreendimento::getArrayTiposParcela(false,$_POST['empreendimento_relatorio_comissoes'],$_POST['corretor_relatorio_comissoes']);
            }

            //percorre todos os contratos selecionados
            foreach ($contratos as $key => &$contrato) {
                $hasSinal = ($contrato['nr_parcela_sinal'] > 0);

                if ($_POST['dePagamento'] && $_POST['deCredito']) {
                    //Busca todas as parcelas do contrato de acordo com os parametros utilizando a data de pagamento e de cr�dito
                    $parcelas = Parcela::parcelaByContrato($contrato['id_contrato'], $_POST['dePagamento'], $_POST['atePagamento'], $tpParcelas, 1, false,
                        array('de' => $_POST['deCredito'], 'ate' => $_POST['ateCredito']), 'dt_credito');
                    $parcelasHistorico = Parcela::parcelaHistoricoByContrato($contrato['id_contrato'], $_POST['dePagamento'], $_POST['atePagamento'], $tpParcelas, 1, false,
                        array('de' => $_POST['deCredito'], 'ate' => $_POST['ateCredito']));
                } elseif (!$_POST['dePagamento'] && $_POST['deCredito']) {
                    //Busca todas as parcelas do contrato de acordo com os parametros utilizando a data de cr�dito
                    $parcelas = Parcela::parcelaByContrato($contrato['id_contrato'], $_POST['deCredito'], $_POST['ateCredito'], $tpParcelas, 1, false, 'C', 'dt_credito');
                    $parcelasHistorico = Parcela::parcelaHistoricoByContrato($contrato['id_contrato'], $_POST['deCredito'], $_POST['ateCredito'], $tpParcelas, 1, false, true);
                } else {
                    //Busca todas as parcelas do contrato de acordo com os parametros utilizando a data de pagamento
                    $parcelas = Parcela::parcelaByContrato($contrato['id_contrato'], $_POST['dePagamento'], $_POST['atePagamento'], $tpParcelas, 1, false, '', 'dt_credito');
                    $parcelasHistorico = Parcela::parcelaHistoricoByContrato($contrato['id_contrato'], $_POST['dePagamento'], $_POST['atePagamento'], $tpParcelas, 1, false);
                }
                $contrato['parcelas'] = array_merge($parcelasHistorico, $parcelas);

                if (count($contrato['parcelas']) == 0) {
                    unset($contratos[$key]);
                    continue;
                }

                foreach ($contrato['parcelas'] as $kp => &$parc) {
                    //Teste para calculo das comissoes referentes a cada tipo
                    switch ($relatorio['corretorParceiro'][0]['tp_comissao']) {
                        case 'PL' :
                            if ($parc['tp_parcela'] == 'S')
                                $parc['vl_comissao'] = (Contrato::getVlContrato($contrato['id_contrato']) * $relatorio['corretorParceiro'][0]['pc_comissao'] * 0.01) / (int)$contrato['nr_parcela_sinal'];
                            break;
                        case 'P' :
                            if (in_array($parc['tp_parcela'], $tpParcelasCorretorParceiro))
                                $parc['vl_comissao'] = $parc['vl_total_pago'] * ($relatorio['corretorParceiro'][0]['pc_comissao'] * 0.01);
                            break;
                        case 'F' :
                            if ($hasSinal) {
                                if ($parc['tp_parcela'] == 'S' && $parc['id_parcela'] == '1')
                                    $parc['vl_comissao'] = $relatorio['corretorParceiro'][0]['pc_comissao'];
                            } else
                                if ($parc['tp_parcela'] == 'N' && $parc['id_parcela'] == '1')
                                    $parc['vl_comissao'] = $relatorio['corretorParceiro'][0]['pc_comissao'];
                            break;
                    }
                    if (isset($parc['vl_comissao'])) {
                        $totalComissao += $parc['vl_comissao'];
                        $parcela_valor += $parc['vl_parcela'];
                        $parcela_quantidade++;
                    } else
                        unset($contrato['parcelas'][$kp]);
                }
                if (count($contrato['parcelas']) == 0) {
                    unset($contratos[$key]);
                }
                $relatorio['contratos'][$key] = $contrato;
            }
            if (count($contratos) > 0) {
                $relatorio['contratos'][$key] = $contrato;
                $relatorio['corretorParceiro'][0]['totalValor'] = $parcela_valor;
                $relatorio['corretorParceiro'][0]['totalParcela'] = $parcela_quantidade;
                $relatorio['corretorParceiro'][0]['totalComissao'] = $totalComissao;
            } 
            
        }

        //verifica se existem parcelas para n�o exibir o relat�rio em branco
        if (!isset($parcela_quantidade) || $parcela_quantidade == 0) {
            $this->_helper->addMensagem('index', 'No existem parcelas a serem exibidas!');
            $this->indexAction();
            exit;
        }

        $relatorio['todos'] = ($_POST['corretor_relatorio_comissoes'] == '*') ? true : false;
        $relatorio['tipo'] = $_POST['tipo'] == 'PC' ? true : false;

        $relatorio['periodoContrato'] = $_POST['deContrato'] . " at " . $_POST['ateContrato'];
        $relatorio['periodoPagamento'] = $_POST['dePagamento'] . " at " . $_POST['atePagamento'];
        $relatorio['periodoCredito'] = $_POST['deCredito'] . " at " . $_POST['ateCredito'];

        $this->set('relatorio', $relatorio);

        $this->display("relatorio");

        if ($_POST['tipoRelatorio'] == 'pdf') {
            $this->displayMPDF('Relatorio_' . time() . '.pdf');
        }
    }

    public function relatorioF()
    {
        $instanceEmpreendimento = new Empreendimento();

        $relatorio['empreendimento'] = $instanceEmpreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.rgi', 'e.id', 'e.porcAdmin','ds_path_logo'))
            ->join(array('c' => Db_Cidade::TABLE_NAME), 'e.cd_cidade = c.id', array('cidade_nome' => 'c.nome', 'cidade_uf' => 'c.uf'))
            ->joinLeft(array('t' => TB_TIPO_LOTEAMENTO), 'e.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
            ->where('e.id = ?', $_POST['empreendimento_relatorio_comissoes'])->query()->fetch();

        //Busca o corretor ou parceiro do empreendimento
        if ($_POST['corretor_relatorio_comissoes']) {
            $instanceCorretor = new Corretor_Empreendimento();
            $corretorParceiro = $instanceCorretor->getAdapter()->select()
                ->from(array('ce' => TB_CORRETOR_EMPREENDIMENTO), array('*'))
                ->join(array('p' => TB_PESSOA), 'ce.id_corretor = p.id', array('p.nm_pessoa'))
                ->joinLeft(array('i' => TB_PESSOA_JURIDICA), 'ce.id_imobiliaria = i.id_pessoa', array('i.nm_fantasia'))
                ->where('ce.id_empreendimento = ?', $_POST['empreendimento_relatorio_comissoes'])
                ->where('p.id = ?', $_POST['corretor_relatorio_comissoes'])
                ->query()->fetchAll();
        } else {
            $instancia = new InstanciaZend();
            $corretorParceiro = $instancia->getAdapter()->select()
                ->from(array('pc' => TB_PARCERIA_COMISSAO), array('*'))
                ->join(array('p' => TB_PESSOA), 'pc.id_pessoa = p.id', array('p.nm_pessoa'))
                ->where('pc.id_empreendimento = ?', $_POST['empreendimento_relatorio_comissoes'])
                ->where('p.id = ?', $_POST['idParceiro'])
                ->query()->fetchAll();
        }
        $relatorio['corretorParceiro'] = $corretorParceiro;
        switch ($relatorio['corretorParceiro'][0]['tp_comissao']) {
            case 'P':
                $relatorio['corretorParceiro'][0]['tipoComissao'] = 'Porc. Parcela';
                break;
            case 'PL':
                $relatorio['corretorParceiro'][0]['tipoComissao'] = 'Porc. Total';
                break;
            case 'F':
                $relatorio['corretorParceiro'][0]['tipoComissao'] = 'Fixo';
                break;
            case 'PT':
                $relatorio['corretorParceiro'][0]['tipoComissao'] = 'Porc. Valor Total Tabela';
                break;
        }

        //Seta os valores do quadro resumo ao final do relat�rio para acrescimos
        $totalComissao = 0;
        $totalValor = 0;

        $instanceContrato = new Contrato();
        $contratos = $instanceContrato->getDefaultAdapter()->select()
            ->from(array('c' => TB_CONTRATO), array('id_contrato' => 'c.id', 'id_lote' => 'c.id_lote', 'id_corretor', 'nr_parcela', 'dt_contrato', 'fl_distrato',
                'nr_parcela_sinal', 'nr_intercalada', 'nr_parcela_entrega', 'vl_parcela', 'vl_sinal', 'vl_intercalada', 'vl_parcela_entrega', 'fl_aprovar_contrato'))
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('l.quadra', 'l.lote'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('p.nm_pessoa', 'p.endereco', 'p.nm_bairro', 'id_pessoa' => 'p.id'))
            ->where('l.id_empreendimento = ?', $relatorio['empreendimento']['id'])
            ->where('c.fl_aprovar_contrato = "1"');

        if ($_POST['distratado'] != '1') {
            $contratos = $contratos->where('c.fl_distrato = "0"');
        }

        if ($_POST['corretor_relatorio_comissoes'] && $_POST['corretor_relatorio_comissoes'] != '*')
            $contratos = $contratos->where('c.id_corretor = ?', $_POST['corretor_relatorio_comissoes']);


        if ($_POST['deContrato'])
            $contratos = $contratos->where('c.dt_contrato BETWEEN "' . Helper::getInputDate($_POST['deContrato']) . '" AND "' . Helper::getInputDate($_POST['ateContrato']) . '"');

        $contratos = $contratos->order(array('c.dt_contrato'))->query()->fetchAll();
        if (count($contratos) > 0) {
            //Seta valor total para acumalar valores do foreach
            $totalValor = 0;
            //percorre todos os contratos selecionados
            foreach ($contratos as $key => &$contrato) {
                //Variavel para acumulativa, para totalValor
                $valorLote = 0;
                //condi��o para verificar valor tabela pre�o, caso n�o tenha segue normal
                if ($relatorio['corretorParceiro'][0]['tp_comissao'] == 'PT' && $_POST['corretor_relatorio_comissoes']) {
                    $tabelaPrecoLote = new TabelaPrecoLote();
                    $tabelaPrecoLote = $tabelaPrecoLote->fetchRow('id_tabela_preco = ' . $relatorio['corretorParceiro'][0]['id_tabela_preco'] . ' AND id_lote = ' . $contrato['id_lote']);
                    if ($tabelaPrecoLote)
                        $valorLote += $tabelaPrecoLote['vl_total'];
                } else {
                    $valorLote = $contrato['nr_parcela'] * $contrato['vl_parcela'];
                    $valorLote += $contrato['vl_sinal'];
                    $valorLote += $contrato['nr_parcela_entrega'] * $contrato['vl_parcela_entrega'];
                    $valorLote += $contrato['nr_intercalada'] * $contrato['vl_intercalada'];

                    //Busca se o contrato possui itens adicionais e os calcula para o total do valor do contrato
                    $itensContrato = new ContratoItens();
                    $itensContrato = $itensContrato->fetchAll('id_contrato = ' . $contrato['id_contrato']);
                    if (count($itensContrato) > 0)
                        foreach ($itensContrato as $item)
                            $valorLote += ((float)$item['vl_parcela'] * (int)$item['qt_parcelas']);
                }

                if ($relatorio['corretorParceiro'][0]['tp_comissao'] == 'F' ) {
                    $contrato['comissao'] = $relatorio['corretorParceiro'][0]['pc_comissao'];
                } else {
                    $contrato['comissao'] = $valorLote * ($relatorio['corretorParceiro'][0]['pc_comissao'] / 100);
                }
                $totalComissao += $contrato['comissao'];
                $contrato['valor'] += $valorLote;
                $totalValor += $valorLote;

                $relatorio['contratos'][$key] = $contrato;                
            }            
            $relatorio['corretorParceiro'][0]['totalValor'] = $totalValor;
            $relatorio['corretorParceiro'][0]['totalComissao'] = $totalComissao;
            
        } else {
            //verifica se existem parcelas para n�o exibir o relat�rio em branco
            $this->_helper->addMensagem('index', 'No exitem dados a serem exibidos!');
            $this->indexAction();
            exit;
        }
        $relatorio['todos'] = ($_POST['corretor_relatorio_comissoes'] == '*') ? true : false;
        $relatorio['tipo'] = $_POST['tipo'] == 'PC' ? true : false;

        $relatorio['periodoContrato'] = $_POST['deContrato'] . " at " . $_POST['ateContrato'];
        $relatorio['periodoPagamento'] = $_POST['dePagamento'] . " at " . $_POST['atePagamento'];
        $relatorio['periodoCredito'] = $_POST['deCredito'] . " at " . $_POST['ateCredito'];

        $this->set('relatorio', $relatorio);
        $this->display("relatorio");


        if ($_POST['tipoRelatorio'] == 'pdf') {
            $this->displayMPDF('Relatorio_' . time() . '.pdf');
        }
    }

    public function corretor_by_empreendimentoAction()
    {
        $tb_corretorEmpreendimento = new Corretor_Empreendimento();
        $tb_parceriaComissao = new ParceriaComissao();
        $idEmpreendimento = $_POST['id_empreendimento'];

        $listaCorretor = $tb_corretorEmpreendimento->getAdapter()->select()
            ->from(array('ce' => TB_CORRETOR_EMPREENDIMENTO), '')
            ->join(array('p' => TB_PESSOA), 'ce.id_corretor = p.id', array('id', 'nm_pessoa'))
            ->where('ce.id_empreendimento = ' . $idEmpreendimento)
            ->order('nm_pessoa')
            ->query()->fetchAll();

        $listaParceria = $tb_parceriaComissao->getAdapter()->select()
            ->from(array('pa' => TB_PARCERIA_COMISSAO), '')
            ->join(array('pe' => TB_PESSOA), 'pa.id_pessoa = pe.id', array('id', 'nm_pessoa'))
            ->where('pa.id_empreendimento = ' . $idEmpreendimento)
            ->order('nm_pessoa')
            ->query()->fetchAll();

        foreach ($listaCorretor as &$corretor)
            $corretor['nm_pessoa'] = utf8_encode($corretor['nm_pessoa']);

        foreach ($listaParceria as &$parceria)
            $parceria['nm_pessoa'] = utf8_encode($parceria['nm_pessoa']);

        echo json_encode(array($listaCorretor, $listaParceria));
    }

    public function tipoComissaoAction()
    {
        $tipo = $_POST['tipo'];

        if ($tipo == 'c') {
            $tb_corretorEmpreendimento = new Corretor_Empreendimento();
            $corretorParceiro = $tb_corretorEmpreendimento->fetchRow('id_corretor = ' . $_POST['id_corretor'] . ' AND id_empreendimento = ' . $_POST['id_empreendimento']);
            $tp_comissao = $corretorParceiro->tp_comissao;
        } elseif($tipo == '*'){
            $tp_comissao = $tipo;
        } else {
            $tb_parceriaComissao = new ParceriaComissao();
            $corretorParceiro = $tb_parceriaComissao->fetchRow('id_pessoa = ' . $_POST['id_corretor'] . ' AND id_empreendimento = ' . $_POST['id_empreendimento']);
            $tp_comissao = $corretorParceiro->tp_comissao;
        }

        echo json_encode($tp_comissao);
    }

    private function validar()
    {
        //valida��o para evitar campos vazios
        $campos = array("empreendimento_relatorio_comissoes");
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "empreendimento_relatorio_comissoes" :
                        $msg = "O campo Empreendimento  obrigatrio.";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }
        if ($_POST['corretor_relatorio_comissoes'] && $_POST['idParceiro']) {
            $this->_helper->addMensagem('corretor_parceiro', 'Selecione apenas um, corretor ou parceiro.');
        }

        if ($_POST['corretor_relatorio_comissoes'] == '' && $_POST['idParceiro'] == '') {
            $msg = 'Selecione um corretor ou parceiro.';
            $this->_helper->addMensagem('corretor_parceiro', $msg);
        }

        if (count($_POST['tp_parcela']) == 0)
            $this->_helper->addMensagem('tp_parcela', 'Selecione pelo menos um tipo de parcela.');

        //Testa as datas de pagamento e de credito
        if (($_POST['dePagamento'] == '' || $_POST['atePagamento'] == '') && ($_POST['deContrato'] == '' || $_POST['ateContrato'] == '')) {
            if ($_POST['deCredito'] == '' || $_POST['ateCredito'] == '') {
                $msg = 'Ao menos um perodo deve ser preenchido.';
                $this->_helper->addMensagem('data', $msg);
            }
        } elseif (($_POST['deCredito'] == '' || $_POST['ateCredito'] == '') && ($_POST['deContrato'] == '' || $_POST['ateContrato'] == '')) {
            if ($_POST['dePagamento'] == '' || $_POST['atePagamento'] == '') {
                $msg = 'Ao menos um perodo deve ser preenchido.';
                $this->_helper->addMensagem('data', $msg);
            }
        } elseif ($_POST['deContrato'] == '' || $_POST['ateContrato'] == '') {
            if (($_POST['dePagamento'] == '' || $_POST['atePagamento'] == '') && ($_POST['deCredito'] == '' || $_POST['ateCredito'] == '')) {
                $msg = 'Ao menos um perodo deve ser preenchido.';
                $this->_helper->addMensagem('data', $msg);
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }
} 