<?php
class ClienteRelatorioController extends Controller {

    public function indexAction() {
        $this->set('empreendimentos', Empreendimento::getEmpreendimentos());
        $this->display("index");
    }

    private function carregarDados() {
        $instanceEmpreendimento = new Empreendimento();

        $empreendimentos = $instanceEmpreendimento->getDefaultAdapter()->select()
            ->from(array('e'=>TB_EMPREENDIMENTO), array('nm_empreendimento'))
            ->join(array('l'=>TB_LOTES), 'e.id = l.id_empreendimento', array('id_lote'=>'id', 'id_empreendimento'))
            ->join(array('c'=>TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato'=>'id', 'id_lote'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']->getSuper() != '1') {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        $this->set('empreendimentos',$empreendimentos);
    }

    public function relatorioAction() {
        ini_set("memory_limit", "1024M");
        set_time_limit(0);

        if($this->validar()) {

            $tbClienteAcade = new Db_Cliente();
            $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

            $instanceLote = new Lote();
            $selectLote = $instanceLote->getDefaultAdapter()->select();
            $selectLote = $selectLote->distinct('p.id')->from(array('l'=>TB_LOTES), array())
                ->join(array('c'=>TB_CONTRATO), 'l.id = c.id_lote', array('id'))
                ->join(array('p'=>TB_PESSOA), 'c.id_pessoa = p.id', array('pessoa_id'=>'p.id','pessoa_nome'=>'p.nm_pessoa','email'=>'p.email', 'telefone'=>'p.nr_telefone',
                    'celular'=>'p.nr_celular', 'fax'=>'p.nr_fax', 'recado'=>'p.nr_recado', 'cep'=>'p.nr_cep', 'endereco' =>'p.endereco', 'bairro'=>'p.nm_bairro', 'nr_endereco', 'ds_complemento'))
                ->joinLeft(array('cp'=>TB_CONTRATO_PESSOA), 'cp.id_contrato = c.id', array('*', 'outros_compradores' => 'id_contrato_pessoa'))
                ->joinLeft(array('pf'=>TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', array('cpf'=>'pf.nr_cpf','rg'=>'pf.nr_rg'))
                ->joinLeft(array('pj'=>TB_PESSOA_JURIDICA), 'p.id = pj.id_pessoa', array('cnpj'=>'pj.nr_cnpj','fantasia'=>'pj.nm_fantasia'))
                ->joinLeft(array('cd'=>Db_Cidade::TABLE_NAME), 'p.cd_cidade = cd.id', array('cidade'=>'cd.nome', 'uf'=>'cd.uf'));
            
            if ($_POST['cliente_relatorio_clientes'] && $_POST['cliente_relatorio_clientes'] != '*' ) {
                $selectLote = $selectLote->where('c.id_pessoa = ?', $_POST['cliente_relatorio_clientes']);
            }
            $selectLote->where('l.id_empreendimento = ?', $_POST['empreendimento_relatorio_empreendimentos']);
            $relatorios = $selectLote->order('p.nm_pessoa')->query()->fetchAll();
            
            foreach($relatorios as $clientes){
                if($clientes['outros_compradores'] && $_POST['cliente_relatorio_clientes'] == '*'){
                    $instanceLt = new Lote();
                    $selectLt = $instanceLt->getDefaultAdapter()->select();
                    $selectLt = $selectLt->distinct('op.id')->from(array('ol'=>TB_LOTES), array())
                    ->join(array('oc'=>TB_CONTRATO), 'ol.id = oc.id_lote', array('id'))
                    ->join(array('ooc' => TB_CONTRATO_PESSOA), 'ooc.id_contrato = oc.id', '')
                    ->join(array('op'=>TB_PESSOA), 'ooc.id_pessoa = op.id', array('pessoa_id'=>'op.id','pessoa_nome'=>'op.nm_pessoa','email'=>'op.email', 'telefone'=>'op.nr_telefone',
                        'celular'=>'op.nr_celular', 'fax'=>'op.nr_fax', 'recado'=>'op.nr_recado', 'cep'=>'op.nr_cep', 'endereco' =>'op.endereco', 'bairro'=>'op.nm_bairro', 'nr_endereco', 'ds_complemento'))
                    ->joinLeft(array('opf'=>TB_PESSOA_FISICA), 'op.id = opf.id_pessoa', array('cpf'=>'opf.nr_cpf','rg'=>'opf.nr_rg'))
                    ->joinLeft(array('opj'=>TB_PESSOA_JURIDICA), 'op.id = opj.id_pessoa', array('cnpj'=>'opj.nr_cnpj','fantasia'=>'opj.nm_fantasia'))
                    ->joinLeft(array('ocd'=>Db_Cidade::TABLE_NAME), 'op.cd_cidade = ocd.id', array('cidade'=>'ocd.nome', 'ouf'=>'ocd.uf'))
                    ->where('oc.id = ?', $clientes['id']);
                
                    $relatorio = $selectLt->order('op.nm_pessoa')->query()->fetchAll();
                    
                    if(!$novoArray){
                        $novoArray = array_merge($relatorios, $relatorio);
                    }else{
                        $novoArray = array_merge($novoArray, $relatorio);
                    }
                }
                
            }

            if(!$novoArray){
                $novoArray = $relatorios;
            }
            //Remove os itens duplicados do array
            function sortByOrder($a, $b) {
                return $a['pessoa_nome'] >= $b['pessoa_nome'];
            }
            $pessoa = 0;
            for($k = 0; $k< count($novoArray); $k++){
                if($novoArray[$k]['pessoa_id'] == $pessoa){
                    $pessoa = $novoArray[$k]['pessoa_id'];
                    unset($novoArray[$k]);
                }
                else{
                    $pessoa = $novoArray[$k]['pessoa_id'];
                }
            }
            
            $tb_empreendimento = new Empreendimento();
            $empCliente = $tb_empreendimento->fetchRow('id = ' . $_POST['empreendimento_relatorio_empreendimentos']);
            $this->set('empCliente', $empCliente);

            if(count($novoArray)) {
                $this->set('relatorios', $novoArray);

                $this->displayMPDF(rand().'.pdf');

            } else {

                $this->_helper->addMensagem ( 'index', 'Este empreendimento no possue clientes.');
                $this->carregarDados();
                $this->display("index");
            }

        } else {
            $this->carregarDados();
            $this->display("index");
        }
    }

    private function validar() {
        //validao vazio
        $campos = array ("empreendimento_relatorio_empreendimentos", "cliente_relatorio_clientes");
        foreach ( $campos as $cp ) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "empreendimento_relatorio_empreendimentos" :
                        $msg = "O campo Empreendimento  obrigatrio.";
                        break;
                    case "cliente_relatorio_clientes" :
                        $msg = "O campo Clientes  obrigatrio.";
                        break;
                }
                $this->_helper->addMensagem ( $cp, $msg );
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }
    public function relatorioDeClientesAction()
    {
        $clientes = (new Lote())->getDefaultAdapter()->select()
            ->from(array('l' => TB_LOTES), array('id', "lote", "quadra", 'id_empreendimento'))
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('idContrato' => 'id', 'id', 'id_pessoa', 'fl_distrato'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa', 'id'))
            ->where('c.fl_distrato = "0"')
            ->where('l.id_empreendimento = ?', $_POST['id_empreendimento'])
            ->order('p.nm_pessoa')
            ->query()->fetchAll();

        $buscaCliente[] = ['id' =>  '*', 'text' => 'Todos'];
        foreach ($clientes as $cliente) {
            $buscaCliente[] = array (
                'id' => $cliente['id'],
                'text' => utf8_encode($cliente['nm_pessoa']) .  ' - Quadra: '.utf8_encode($cliente['quadra']).' - Lote: '.utf8_encode($cliente['lote']).' - Contrato: ' . utf8_encode($cliente['idContrato'])
            );
        }
        echo json_encode($buscaCliente);
    }
}