<?php

class CartasEnviadasController extends Controller
{
    public function __construct($request)
    {
        parent::__construct($request);
        $this->empreendimento = new Empreendimento();
    }

    public function indexAction()
    {
        $this->redir(array('modulo' => 'rl', 'controller' => 'cartasEnviadas', 'action' => 'relatorio'));
    }

    public function relatorioAction()
    {
        if ($this->_isPost) {
            $this->gerarAction();
        } else {
            $empreendimentos = $this->empreendimento->getDefaultAdapter()->select()
                ->distinct('e.id')
                ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.id'));

            //verifica se o usuario tem o perfil de usuario de empreendimento
            if ($_SESSION['usuario']) {
                try {
                    $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                    $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                    if (count($ids)) {
                        $id = implode(',', $ids);
                        $empreendimentos->where("e.id IN({$id})");
                    } else {
                        $empreendimentos->where("1");
                    }
                } catch (Exception $e) {
                }
            }
            $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

            $this->set("empreendimentos", $empreendimentos);

            $CartaCobranca = new Modelo();
            $listaCartaCobranca = $CartaCobranca->getAdapter()->select()
                ->from(array('co' => TB_MODELO))
                ->where('co.tp_modelo = "CC"')
                ->order('co.cd_modelo')
                ->query()->fetchAll();

            $tipoCarta = array('*' => 'Todas');

            foreach ($listaCartaCobranca as $carta)
                $tipoCarta[$carta['cd_modelo']] = $carta['nm_titulo'];

            $this->set('cartas', $tipoCarta);
        }

        $this->display("form");
    }

    public function gerarAction()
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());
        $carta = new CartaHistorico();

        $empreendimento = new Empreendimento();
        $empreendimentoInfo = $empreendimento->getAdapter()->select()->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento'))
            ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
            ->where('em.id = ?', $_POST['empreendimentoRelatorioCartaTipo'])
            ->query()->fetch();
        $this->set("empreendimentoInfo", $empreendimentoInfo);

        $dtInicial = ($_POST["tipo"] == 'tipoCarta') ? $_POST['dtInicioTipo'] : $_POST['dtInicioCliente'];
        $dtFinal = ($_POST["tipo"] == 'tipoCarta') ? $_POST['dtFinalTipo'] : $_POST['dtFinalCliente'];

        switch ($_POST["tipo"]) {
            case "tipoCarta":
                $cartas = $carta->findByEmpreendimentoTipo($_POST['empreendimentoRelatorioCartaTipo'], $_POST['cartaTipo'], $dtInicial, $dtFinal);
                break;
            case "tipoCliente":
                $cartas = $carta->findByContrato($_POST['cliente_relatorio_carta'], $dtInicial, $dtFinal);
                break;
            default:
                $cartas = array();
                break;
        }

        $idEmpreendimento = $cartas[0]['id_empreendimento'];
        $relatorio = array();
        foreach ($cartas as $carta) {
            $relatorio[$carta['id_contrato']][] = $carta;
        }

        $empreendimento = Empreendimento::findEmpreendimentoDados($idEmpreendimento);
        $dadosAdicionais = array();
        $dadosAdicionais["empreendimento"] = $empreendimento["nm_empreendimento"];
        $dadosAdicionais["periodo"] = $dtInicial . ' - ' . $dtFinal;

        $this->set("relatorio", $relatorio);
        $this->set("dadosAdicionais", $dadosAdicionais);

        $this->display("relCartasEnviadasPorCliente");
        $this->displayMPDF('CartasEnviadas.pdf');
    }

    public function validarAction()
    {
        if ($_POST["tipo"] != '') {
            switch ($_POST["tipo"]) {
                case "tipoCarta":
                    if ($_POST["empreendimentoRelatorioCartaTipo"] == "") {
                        $this->_helper->addMensagem("campos", "O campo empreendimento  obrigatrio");
                    }
                    break;
                case "tipoCliente":
                    if ($_POST["empreendimentoRelatorioCartaCliente"] == "") {
                        $this->_helper->addMensagem("empreendimento", "O campo empreendimento  obrigatrio");
                    }
                    if ($_POST["cliente_relatorio_carta"] == "") {
                        $this->_helper->addMensagem("cliente", "O campo cliente  obrigatrio");
                    }
                    break;
            }
        } else {
            $this->_helper->addMensagem("campos", "O tipo de relatrio  obrigatrio.");
        }
        //Validao do Relatrio
        $carta = new CartaHistorico();
        $dtInicial = ($_POST["tipo"] == 'tipoCarta') ? $_POST['dtInicioTipo'] : $_POST['dtInicioCliente'];
        $dtFinal = ($_POST["tipo"] == 'tipoCarta') ? $_POST['dtFinalTipo'] : $_POST['dtFinalCliente'];

        switch ($_POST["tipo"]) {
            case "tipoCarta":
                $cartas = $carta->findByEmpreendimentoTipo($_POST['empreendimentoRelatorioCartaTipo'], $_POST['cartaTipo'], $dtInicial, $dtFinal);
                break;
            case "tipoCliente":
                $cartas = $carta->findByContrato($_POST['cliente_relatorio_carta'], $dtInicial, $dtFinal);
                break;
            default:
                $cartas = array();
                break;
        }

        if (!$cartas && $dtInicial && $dtFinal && $_POST['empreendimentoRelatorioCartaTipo']) {
            $this->_helper->addMensagem('danger', "Nenhum resultado foi encontrado.");
        }
        if ($dtInicial == '' && $dtFinal == '')
            $this->_helper->addMensagem('danger', "O campo Data deve ser preenchido.");

        //Mensagens de erros
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            echo json_encode(true);
        }
    }

    public function contratoByEmpreendimentoAction()
    {
        $contratos = Contrato::byEmpreendimento($_POST['id_empreendimento'], Contrato::CONTRATO_TODOS, 2, array("nm_pessoa", "lote", "quadra", "id"), true);

        $lista = array();
        foreach ($contratos as $contrato) {
            $lista[] = array('id' => $contrato['id'], 'text' => utf8_encode($contrato['nm_pessoa']) . ' - Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . utf8_encode($contrato['id']));
        }

        echo json_encode($lista);
    }

}

?>
