<?php

class BoletosController extends Controller
{

    public function indexAction()
    {
        $this->set("subtitulo", "Relat&oacute;rio de Boletos");


        $this->carregarDados();
        $this->display("index");
    }

    private function carregarDados()
    {

        //instancia as classes necessrias
        $instanceEmpreendimento = new Empreendimento();
        $empreendimento = $instanceEmpreendimento->getDefaultAdapter();

        $empreendimento = $empreendimento->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('nm_empreendimento'))
            ->join(array('l' => TB_LOTES), 'e.id = l.id_empreendimento', array('id_lote' => 'id', 'id_empreendimento'))
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'id_lote'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {
            }
        }

        $empreendimento = $empreendimento->group('e.id')->order('nm_empreendimento')->query()->fetchAll();

        $this->set('empreendimentos', $empreendimento);
    }

    //Gera relat?rio completo de parcelas pagas
    public function gerarRelatorio($relatorio)
    {

        $id_empreendimento = $_POST['empreendimento_relatorio_parcela_paga'];
        $tp_pagamento = $_POST['tp_pagamento'];

        if ((in_array('T', $tp_pagamento) && in_array('B', $tp_pagamento) && in_array('O', $tp_pagamento)) || !$tp_pagamento) {
            $tp_pagamento = 'TODOS';
        } else {
            // cria o filtro para os tipos de pagamento
            $pgs = '';
            for ($i = 0; $tp_pagamento[$i]; $i++) {
                if ($i == 0) {
                    $pgs = "'" . $tp_pagamento[$i] . "'";
                } else {
                    $pgs .= ",'" . $tp_pagamento[$i] . "'";
                }
            }
            $tp_pagamento = $pgs;
        }

        $tp_parcelas = array();

        if (count($_POST['tp_parcela'])) {
            foreach ($_POST['tp_parcela'] as $tipo) {
                if ($tipo == 'G' || $tipo == 'Q') {
                    $tp_parcelas[] = "'" . $tipo . "'";
                } else $tp_parcelas[] = "'" . $tipo . "','" . $tipo . "E'";
            }
            $tp_parcelas = '(' . implode(',', $tp_parcelas) . ')';
        }

        $tb_parcelas = new Parcela;
        $select = $tb_parcelas->getAdapter()->select();

        $empreendimento = $select->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.rgi', 'e.id', 'e.porcAdmin'))
            ->join(array('c' => Db_Cidade::TABLE_NAME), 'e.cd_cidade = c.id', array('cidade_nome' => 'c.nome', 'cidade_uf' => 'c.uf'))
            ->where('e.id = ?', $_POST['empreendimento_relatorio_parcela_paga'])->query()->fetch();

        $campoData = "P.dt_parcela";
        $ignorePagoOuNao = false;
        if ($relatorio == 'PARCELA_ENVIADA') {
            $fl_envio = '1';
            $ignorePagoOuNao = true;
            $relTitulo = 'BOLETOS ENVIADOS';
        } elseif ($relatorio == 'PARCELA_NAO_ENVIADA') {
            $fl_envio = '0';
            $ignorePagoOuNao = true;
            $relTitulo = 'BOLETOS NO ENVIADOS';
        }

        $this->set('relTitulo', $relTitulo);

        //Parcela
        $select = $tb_parcelas->getAdapter()->select();

        $select->from(array('P' => TB_PARCELA), array(
            'id_parcela_contrato',
            'id_contrato',
            'id_parcela',
            'tp_parcela',
            'dt_parcela',
            'dt_credito',
            'desconto',
            'dt_pagamento',
            'tp_baixa',
            'vl_parcela',
            'vl_juros',
            'vl_multa',
            'id_negociacao',
            'vl_total_pago'
        ))
            ->where('id_empreendimento = ?', $id_empreendimento)
            ->where('P.tp_parcela in ' . $tp_parcelas)
            ->join(array('C' => TB_CONTRATO), 'P.id_contrato = C.id', array())
            ->join(array('L' => TB_LOTES), 'L.id = C.id_lote', array('lote', 'quadra'))
            ->join(array('PS' => TB_PESSOA), 'PS.id = C.id_pessoa', array('nm_pessoa'));

        if ($_POST['ordena'] == 'quadraLote') {
            $select->order(array('L.quadra', 'L.lote'));
        } else if ($_POST['ordena'] == 'dataPgto') {
            $select->order(array('P.dt_pagamento'));
        } else {
            $select->order(array('P.dt_credito'));
        }

        if ($tp_pagamento != 'TODOS' && $tp_pagamento) {
            $select->where("tp_baixa in (" . $tp_pagamento . ")");
        }
        if ($_POST['cliente_relatorio_parcela_paga'] && $_POST['cliente_relatorio_parcela_paga'] != '*')
            $select = $select->where('C.id_pessoa = ?', $_POST['cliente_relatorio_parcela_paga']);
        if (isset($fl_envio))
            $select->where('P.fl_envio = ?', $fl_envio);
        if ($_POST['de'] && $_POST['ate']) {
            $select->where($campoData . ' >= ?', Helper::getInputDate($_POST['de']))->where($campoData . ' <= ?', Helper::getInputDate($_POST['ate']));
            $this->set('periodo', $_POST['de'] . ' at&eacute; &nbsp;' . $_POST['ate']);
        }

        $rsItens = $select->query()->fetchAll();

        //Parcela Hist?rico
        $select = $tb_parcelas->getAdapter()->select();
        $select->from(array('P' => TB_PARCELA_HISTORICO), array(
            'id_parcela_contrato',
            'id_contrato',
            'id_parcela',
            'dt_parcela',
            'dt_credito',
            'desconto',
            'dt_pagamento',
            'tp_baixa',
            'vl_parcela',
            'vl_juros',
            'vl_multa',
            'id_negociacao',
            'vl_total_pago'
        ))
            ->where('id_empreendimento = ?', $id_empreendimento)
            ->where('P.tp_parcela in ' . $tp_parcelas)
            ->join(array('C' => TB_CONTRATO), 'P.id_contrato = C.id', array('fl_distrato'))
            ->join(array('L' => TB_LOTES), 'L.id = C.id_lote', array('lote', 'quadra'))
            ->join(array('PS' => TB_PESSOA), 'PS.id = C.id_pessoa', array('nm_pessoa'));

        if ($_POST['ordena'] == 'quadraLote') {
            $select->order(array('L.quadra', 'L.lote'));
        } else if ($_POST['ordena'] == 'dataPgto') {
            $select->order(array('P.dt_pagamento'));
        } else {
            $select->order(array('P.dt_credito'));
        }

        if ($tp_pagamento != 'TODOS' && $tp_pagamento) {
            $select->where("tp_baixa in (" . $tp_pagamento . ")");
        }
        if ($_POST['cliente_relatorio_parcela_paga'] && $_POST['cliente_relatorio_parcela_paga'] != '*')
            $select = $select->where('C.id_pessoa = ?', $_POST['cliente_relatorio_parcela_paga']);
        if (isset($fl_envio))
            $select->where('P.fl_envio = ?', $fl_envio);
        if ($_POST['de'] && $_POST['ate']) {
            $select->where($campoData . ' >= ?', Helper::getInputDate($_POST['de']))->where($campoData . ' <= ?', Helper::getInputDate($_POST['ate']));
            $this->set('periodo', $_POST['de'] . ' at&eacute; &nbsp;' . $_POST['ate']);
        }

        $rsItens2 = $select->query()->fetchAll();

        //testa se existem parcelas - RELATORIO DE BOLETOS ENVIADOS
        if (!$rsItens && !$rsItens2) {
            $this->_helper->addMensagem('index', 'N&atilde;o h&aacute resultados a serem exibidos.');
            $this->display('index');
            exit;
        }

        $relatorio = new Report(array('style' => 'border-collapse:collapse;', 'align' => 'center'));
        $itens = array();

        $total_vl_parcela = 0;
        $total_vl_multa = 0;
        $total_vl_juros = 0;
        $total_vl_desconto = 0;
        $total_com_partic = 0;
        $total_sem_partic = 0;
        $total_porcAdmin = 0;

        $header = array(
            'nm_pessoa' => array('_label' => 'Nome', '_font-weight' => 'bold', 'width' => '200px', 'padding' => '3px', 'font-size' => '10px'),
            'lote' => array('_label' => 'Lote', '_font-weight' => 'bold', 'text-align' => 'center', 'padding' => '3px', 'font-size' => '10px'),
            'quadra' => array('_label' => 'Qdr.', '_font-weight' => 'bold', 'text-align' => 'center', 'padding' => '3px', 'font-size' => '10px'),
            'id_parcela_contrato' => array('_label' => 'Baixa', '_font-weight' => 'bold', 'width' => '55px', 'text-align' => 'center', 'padding' => '3px', 'font-size' => '10px'),
            'id_parcela' => array('_label' => 'Parcela', '_font-weight' => 'bold', 'width' => '45px', 'text-align' => 'center', 'padding' => '3px', 'font-size' => '10px'),
            'dt_parcela' => array('_label' => 'Vencto.', '_font-weight' => 'bold', 'text-align' => 'center', 'padding' => '3px', 'font-size' => '10px'),
            'dt_pagamento' => array('_label' => 'Pagto.', '_font-weight' => 'bold', 'text-align' => 'center', 'padding' => '3px', 'font-size' => '10px'),
            'dt_credito' => array('_label' => 'Cr&eacute;dito', '_font-weight' => 'bold', 'text-align' => 'center', 'padding' => '3px', 'font-size' => '10px'),
            'vl_parcela' => array('_label' => 'Valor', '_font-weight' => 'bold', 'text-align' => 'center', 'padding' => '3px', 'font-size' => '10px', 'text-align' => 'center'),
            'desconto' => array('_label' => 'Descto.', '_font-weight' => 'bold', '_text-align' => 'center', 'padding' => '3px', 'font-size' => '10px', 'text-align' => 'center'),
            'vl_multa' => array('_label' => 'Multa.', '_font-weight' => 'bold', 'text-align' => 'center', 'padding' => '3px', 'font-size' => '10px', 'text-align' => 'center'),
            'vl_juros' => array('_label' => 'Juros.', '_font-weight' => 'bold', 'padding' => '3px', 'font-size' => '10px', 'text-align' => 'center'),
            'vl_total_pago' => array('_label' => 'Total', '_font-weight' => 'bold', 'text-align' => 'center', 'padding' => '3px', 'font-size' => '10px', 'text-align' => 'right'),
            'tp_baixa' => array('_label' => 'Pg', '_font-weight' => 'bold', '_text-align' => 'center', 'padding' => '3px', 'font-size' => '10px', 'text-align' => 'right'),
            'saldo' => array('_label' => 'Saldo', '_font-weight' => 'bold', '_text-align' => 'center', 'padding' => '3px', 'font-size' => '10px', 'text-align' => 'right'),
        );

        foreach ($rsItens as $item) {

            if ($item['vl_total_pago']) {
                $saldo = ($item['vl_parcela'] + $item['vl_juros'] + $item['vl_multa'] - $item['desconto']) - $item['vl_total_pago'];
            } else {
                $saldo = $item['vl_parcela'] - $item['vl_total_pago'] - $item['desconto'];
            }

            $total_vl_parcela += $item['vl_parcela'];
            $total_vl_multa += $item['vl_multa'];
            $total_vl_juros += $item['vl_juros'];
            $total_vl_desconto += $item['desconto'];

            $total_com_partic += $item['vl_total_pago'];
            if ($item['tp_baixa'] != "O") {
                $total_porcAdmin += $item['vl_total_pago'] * ($empreendimento['porcAdmin'] / 100);
            }
            $select->reset()->from(TB_PARCELA, 'count(*)')->where('id_contrato = ?', $item['id_contrato']);
            if ($item['tp_parcela'] == 'S') {
                $quantidade = $select->where('tp_parcela = ?', 'S')->query()->fetch();
            } elseif ($item['tp_parcela'] == 'I') {
                $quantidade = $select->where('tp_parcela = ?', 'I')->query()->fetch();
            } elseif ($item['tp_parcela'] == 'G') {
                if($item['id_negociacao'])
                    $quantidade = $select->where("tp_parcela = 'G' and id_negociacao = {$item['id_negociacao']}")->query()->fetch();
                else $quantidade = 1;
            } elseif ($item['tp_parcela'] == 'Q') {
                $quantidade = $select->where('tp_parcela = ?', 'Q')->query()->fetch();
            } else {
                $quantidade = $select->where('tp_parcela = ?', 'N')->query()->fetch();
            }

            $item['id_parcela'] = $item['id_parcela'] . '/' . $quantidade['count(*)'] . '-' . $item['tp_parcela'];
            $item['vl_parcela'] = number_format($item['vl_parcela'], 2, ',', '.');
            $item['vl_multa'] = number_format($item['vl_multa'], 2, ',', '.');
            $item['vl_juros'] = number_format($item['vl_juros'], 2, ',', '.');
            $item['desconto'] = number_format($item['desconto'], 2, ',', '.');
            $item['vl_total_pago'] = number_format($item['vl_total_pago'], 2, ',', '.');
            $item['dt_parcela'] = $this->_helper->getDate($item['dt_parcela']);
            $item['dt_pagamento'] = $this->_helper->getDate($item['dt_pagamento']);
            $item['dt_credito'] = $this->_helper->getDate($item['dt_credito']);

            $saldo2 = ($saldo < 0 && $saldo > -1) ? 0 : $saldo;

            $item['saldo'] = number_format($saldo2, 2, ',', '.');
            $itens[] = $item;
        }

        foreach ($rsItens2 as $item) {

            if ($item['vl_total_pago']) {
                $saldo = ($item['vl_parcela'] + $item['vl_juros'] + $item['vl_multa'] - $item['desconto']) - $item['vl_total_pago'];
            } else {
                $saldo = $item['vl_parcela'] - $item['vl_total_pago'] - $item['desconto'];
            }
            $total_vl_parcela += $item['vl_parcela'];
            $total_vl_multa += $item['vl_multa'];
            $total_vl_juros += $item['vl_juros'];
            $total_vl_desconto += $item['desconto'];

            $total_com_partic += $item['vl_total_pago'];
            if ($item['tp_baixa'] != "O") {
                $total_porcAdmin += $item['vl_total_pago'] * ($empreendimento['porcAdmin'] / 100);
            }
            $select->reset()->from(TB_PARCELA, 'count(*)')->where('id_contrato = ?', $item['id_contrato']);
            if ($item['tp_parcela'] == 'S') {
                $quantidade = $select->where('tp_parcela = ?', 'S')->query()->fetch();
            } elseif ($item['tp_parcela'] == 'I') {
                $quantidade = $select->where('tp_parcela = ?', 'I')->query()->fetch();
            } elseif ($item['tp_parcela'] == 'G') {
                $quantidade = $select->where("tp_parcela = 'G' and id_negociacao = {$item['id_negociacao']}")->query()->fetch();
            } elseif ($item['tp_parcela'] == 'Q') {
                $quantidade = $select->where('tp_parcela = ?', 'Q')->query()->fetch();
            } else {
                $quantidade = $select->where('tp_parcela = ?', 'N')->query()->fetch();
            }

            $item['id_parcela'] = $item['id_parcela'] . '/' . $quantidade['count(*)'] . '-' . $item['tp_parcela'];
            $item['vl_parcela'] = number_format($item['vl_parcela'], 2, ',', '.');
            $item['vl_multa'] = number_format($item['vl_multa'], 2, ',', '.');
            $item['vl_juros'] = number_format($item['vl_juros'], 2, ',', '.');
            $item['desconto'] = number_format($item['desconto'], 2, ',', '.');
            $item['vl_total_pago'] = number_format($item['vl_total_pago'], 2, ',', '.');
            $item['dt_parcela'] = $this->_helper->getDate($item['dt_parcela']);
            $item['dt_pagamento'] = $this->_helper->getDate($item['dt_pagamento']);
            $item['dt_credito'] = $this->_helper->getDate($item['dt_credito']);
            $saldo2 = ($saldo < 0 && $saldo > -1) ? 0 : $saldo;

            $item['saldo'] = number_format($saldo2, 2, ',', '.');
            $itens[] = $item;
        }

        $totais = array(
            'parcela' =>  $_SESSION['simboloMoeda']. ' '. number_format($total_vl_parcela, 2, ',', '.'),
            'juros' =>  $_SESSION['simboloMoeda']. ' '. number_format($total_vl_juros, 2, ',', '.'),
            'multa' =>  $_SESSION['simboloMoeda']. ' '. number_format($total_vl_multa, 2, ',', '.'),
            'desconto' =>  $_SESSION['simboloMoeda']. ' '. number_format($total_vl_desconto, 2, ',', '.'),
            'totalComPartic' =>  $_SESSION['simboloMoeda']. ' '. number_format($total_com_partic, 2, ',', '.'),
            'totalSemPartic' =>  $_SESSION['simboloMoeda']. ' '. number_format($total_sem_partic, 2, ',', '.'),
            'porcAdmin' =>  $_SESSION['simboloMoeda']. ' '. number_format($total_porcAdmin, 2, ',', '.')
        );

        $this->set('totais', $totais);
        $this->set('empreendimento', $empreendimento);

        $relatorio->setHeader($header);
        $relatorio->setItens($itens);
        $this->set('report', $relatorio->run());
        $this->set('topContent', 'topContent.php');
        $this->set('footerContent', 'rodapeRelatorioCompleto.php');
        $this->set('relSubtitulo', '<b>Empreendimento: </b>' . $empreendimento['nm_empreendimento']);
        $this->display('report');

        if ($_POST['gera'] == 'html') {
            $this->display('report');
            exit;
        }
        $this->displayMPDF('Relatorio_Completo_Parcelas_Pagas_' . time() . '.pdf');
    }

    //SELECIONA RELATORIOS A SER GERADOS e gera o N?o pagas sint?tico e o Pagas Sint?tico
    public function relatorioAction()
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        ini_set('memory_limit', '3000M');
        set_time_limit(0);

        if ($this->validar()) {
            if ($_POST['tipo'] == 'PE') {
                $this->gerarRelatorio('PARCELA_ENVIADA');
            } elseif ($_POST['tipo'] == 'PNE') {
                $this->gerarRelatorio('PARCELA_NAO_ENVIADA');
            }
        } else {
            $this->display("index");
        }
    }

    private function validar()
    {

        //valida??o vazio
        $campos = array("empreendimento_relatorio_parcela_paga", "cliente_relatorio_parcela_paga");
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "empreendimento_relatorio_parcela_paga" :
                        $msg = "O campo empreendimento deve ser escolhido.";
                        break;
                    case "cliente_relatorio_parcela_paga" :
                        $msg = "O campo cliente deve ser escolhido.";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }

        if (count($_POST['tp_pagamento']) == 0)
            $this->_helper->addMensagem('tp_pagamento', 'Selecione pelo menos um tipo de pagamento.');
        if (count($_POST['tp_parcela']) == 0)
            $this->_helper->addMensagem('tp_parcela', 'Selecione pelo menos um tipo de parcela.');

        if ($_POST['de'] && $_POST['ate'] == '') {
            $msg = 'Quando a data "apartir de:" for preenchida a data "at:" deve ser preenchida.';
            $this->_helper->addMensagem('data', $msg);
        }

        return !(count($this->_helper->getMensagens()) > 0);

    }

}