<?php

/**
 * Description of CartasEnviadasController
 *
 * @author acade
 */
class AniversariantesController extends Controller {

    protected $tb_empreendimento;

    public function __construct($request) {
        parent::__construct($request);
        $this->tb_empreendimento = new Empreendimento();
        $this->meses = array(
            '' => 'Selecione...',
            '*' => 'Todos',
            '01' => 'Janeiro',
            '02' => 'Fevereiro',
            '03' => 'Maro',
            '04' => 'Abril',
            '05' => 'Maio',
            '06' => 'Junho',
            '07' => 'Julho',
            '08' => 'Agosto',
            '09' => 'Setembro',
            '10' => 'Outubro',
            '11' => 'Novembro',
            '12' => 'Dezembro',
        );
    }

    public function indexAction() {
        $this->set("subtitulo", "Relatrio de Aniversariantes");

        $empreendimentos = $this->tb_empreendimento->getDefaultAdapter()->select()
            ->distinct('e.id')
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.id'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        // verifica se  administrador pra adicionar a opo de todos os empreendimentos
        if (Login::getUsuario()->getPerfilId() == Db_Perfil::PERFIL_ADMIN)
            $empreendimentos = array_merge(array('' => array('id' => '*', 'nm_empreendimento' => 'Todos')), $empreendimentos);

        $this->set("empreendimentos", $empreendimentos);
        $this->set('meses', $this->meses);
        $this->display("index");
    }

    public function gerarAction() {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        $this->set('meses', $this->meses);
        ini_set('max_execution_time',80);

        if ($this->_isPost) {
            $aniversariantes = array();
            // gera um filtro pra selecionar apenas aniversariantes do mes selecionado, ou de todos os meses
            // caso o mes nao seja selecionado, escolhe todos meses que sejam diferente de zero (foram preenchidos corretamente)
            $filtroMes = ($_POST['mes'] == '*') ? 'MONTH(dt_nascimento) != 00' : 'MONTH(dt_nascimento) = ' . $_POST['mes'];
            // gera filtro pra selecionar apenas o empreendimento escolhido ou todos os empreendimentos
            $filtroEmp = ($_POST['empreendimento'] == '*') ? '1' : 'e.id = ' . $_POST['empreendimento'];
            switch ($_POST['tipo']) {
                case 'C': // clientes de empreendimentos
                    $aniversariantes = $this->tb_empreendimento->getAdapter()->select()->from(array('p' => TB_PESSOA), '*')
                        ->join(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', '*')
                        ->joinLeft(array('cid' => TB_CIDADE), 'p.cd_cidade = cid.id', array('cidade' => 'nome', 'uf'))
                        ->join(array('c' => TB_CONTRATO), 'c.id_pessoa = p.id', 'id')
                        ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', '')
                        ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('nm_empreendimento','ds_path_logo'))
                        ->where($filtroMes)->where($filtroEmp)
                        ->group('nm_pessoa')->order(array('MONTH(dt_nascimento)', 'DAY(dt_nascimento)', 'nm_pessoa'))
                        ->query()->fetchAll();
                    $titulo = 'RELATRIO DE CLIENTES ANIVERSARIANTES';
                    break;
                case 'F': // funcionarios = funcionarios e empreendedores
                    $aniversariantes = $this->tb_empreendimento->getAdapter()->select()->from(array('p' => TB_PESSOA),'*')
                        ->join(array('u' => TB_USUARIO), 'p.id = u.id', '')
                        ->join(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', '*')
                        ->joinLeft(array('cid' => TB_CIDADE), 'p.cd_cidade = cid.id', array('cidade' => 'nome', 'uf'))
                        ->joinLeft(array('ue' => TB_USUARIO_EMPREENDIMENTO), 'p.id = ue.id_pessoa_fisica', '')
                        ->joinLeft(array('e' => TB_EMPREENDIMENTO), 'ue.id_empreendimento = e.id', array('nm_empreendimento','ds_path_logo'))
                        ->where($filtroMes)->group('nm_pessoa')->order(array('MONTH(dt_nascimento)', 'DAY(dt_nascimento)', 'nm_pessoa'))
                        ->query()->fetchAll();
                    $titulo = 'RELATRIO DE FUNCIONRIOS E EMPREENDEDORES ANIVERSARIANTES';
                    break;
            }
            $this->set('aniversariantes', $aniversariantes);
            $this->set('titulo', $titulo);
            if (count($aniversariantes)) {
                $this->display('relatorio');
                $this->displayMPDF('relatorio_aniversariantes.pdf');
            } else {
                $this->_helper->addMensagem('fail', 'No h aniversariantes com os critrios selecionados!');
            }
        }
        $this->indexAction();
    }
    public function validarAction() {
        //validao vazio
        $campos["mes"] = "Selecione um ms!";
        if ($_POST["tipo"] == "C")
            $campos["empreendimento"] = "Selecione um empreendimento!";

        foreach ($campos as $key => $cp) {
            if ($_POST[$key] == "") {
                $this->_helper->addMensagem($key, $cp);
            }
        }

        if ($this->_isPost && count($this->_helper->getMensagens()) == 0) {
            $filtroMes = ($_POST['mes'] == '*') ? 'MONTH(dt_nascimento) != 00' : 'MONTH(dt_nascimento) = ' . $_POST['mes'];
            $filtroEmp = ($_POST['empreendimento'] == '*') ? '1' : 'e.id = ' . $_POST['empreendimento'];
            switch ($_POST['tipo']) {
                case 'C': // clientes de empreendimentos
                    $aniversariantes = $this->tb_empreendimento->getAdapter()->select()->from(array('p' => TB_PESSOA), '*')
                        ->join(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', '*')
                        ->joinLeft(array('cid' => TB_CIDADE), 'p.cd_cidade = cid.id', array('cidade' => 'nome', 'uf'))
                        ->join(array('c' => TB_CONTRATO), 'c.id_pessoa = p.id', 'id')
                        ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', '')
                        ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', 'nm_empreendimento')
                        ->where($filtroMes)->where($filtroEmp)
                        ->group('nm_pessoa')->order(array('MONTH(dt_nascimento)', 'DAY(dt_nascimento)', 'nm_pessoa'))
                        ->query()->fetchAll();
                    $titulo = 'RELATRIO DE CLIENTES ANIVERSARIANTES';
                    break;
                case 'F': // funcionarios = funcionarios e empreendedores
                    $aniversariantes = $this->tb_empreendimento->getAdapter()->select()->from(array('p' => TB_PESSOA),'*')
                        ->join(array('u' => TB_USUARIO), 'p.id = u.id', '')
                        ->join(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', '*')
                        ->joinLeft(array('cid' => TB_CIDADE), 'p.cd_cidade = cid.id', array('cidade' => 'nome', 'uf'))
                        ->joinLeft(array('ue' => TB_USUARIO_EMPREENDIMENTO), 'p.id = ue.id_pessoa_fisica', '')
                        ->joinLeft(array('e' => TB_EMPREENDIMENTO), 'ue.id_empreendimento = e.id', 'nm_empreendimento')
                        ->where($filtroMes)->group('nm_pessoa')->order(array('MONTH(dt_nascimento)', 'DAY(dt_nascimento)', 'nm_pessoa'))
                        ->query()->fetchAll();
                    $titulo = 'RELATRIO DE FUNCIONRIOS E EMPREENDEDORES ANIVERSARIANTES';
                    break;
            }
            if (!$aniversariantes) {
                $msg = "Nenhum resultado foi encontrado.";
                $this->_helper->addMensagem('danger', $msg);
            }
        }

        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            echo json_encode(true);
        }
    }
}
?>
