<?php

class AjaxController extends Controller
{

    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_cliente = new Db_Cliente();


        $this->lote = new Lote();
    }

    /*
     * Cria uma lista de clientes de um empreendimento que possuem parcelas pagas
     * @param integer $_POST['id_empreendimento']
     */
    public function cliente_by_parcelas_pagasAction()
    {
        $id_empreendimento = $_POST['id_empreendimento'];
        $instanceLote = new Lote();
        $selectLotes = $instanceLote->getDefaultAdapter()->select();
        $clientes = $selectLotes->from(array('l' => TB_LOTES), array('id_lote' => 'id', 'id_empreendimento','quadra','lote'))
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'id_pessoa'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa', 'id'))
            ->where('l.id_empreendimento = ?', $id_empreendimento)->order('p.nm_pessoa')->group('p.id')->query()->fetchAll();
        $this->set('clientes', $clientes);
        $this->display();
    }

    /**
     * Lista em ajax dos nomes dos bancos cadastrados no empreendimento
     */
    public function bancoByEmpreendimentoAction()
    {
        $bancos = new Banco();
        $bancos = $bancos->fetchAll($bancos->select()->where('id_empreendimento = '.$_POST['id_empreendimento']))->toArray();
        foreach ($bancos as &$banco) {
            $banco['nmBanco'] = Banco::findBancoNome($banco['cd_banco']);
        }
        $this->set('bancos', $bancos);
        $this->display();
    }

    /**
     * Cria uma lista de clientes de um empreendimento que possuem parcelas pagas para calculo do Imposto de Renda
     * Inclui tanto contratos distratados como transferidos
     * @param integer $_POST ['id_empreendimento']
     */
    public function clienteRelatorioImpostoRendaAction()
    {
        $id_empreendimento = $_POST['id_empreendimento'];
        $instanceLote = new Lote();
        $selectLotes = $instanceLote->getDefaultAdapter()->select();
        $clientes = $selectLotes->from(array('l' => TB_LOTES), array('id_lote' => 'id', 'id_empreendimento','quadra','lote'))
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'id_pessoa'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa', 'id'))
            ->joinLeft(array('t' => TB_TRANSFERENCIA), 'c.id = t.idContrato', '*')
            ->where('l.id_empreendimento = ?', $id_empreendimento)->order('p.nm_pessoa')->group('p.id')->query()->fetchAll();

        foreach ($clientes as $cliente) {
            if ($cliente['idContrato'] && $cliente['idCedente']) {
                $transf = Pessoa::findById($cliente['idCedente']);
                $transf['id_pessoa'] = $cliente['idCedente'];
                $transf['transf'] = true;
                $clientes[] = $transf;
            }
        }
        foreach ($clientes as $key => $row) {
            $pessoa[$key] = $row['nm_pessoa'];
        }
        array_multisort($pessoa, SORT_ASC, $clientes);

        $this->set('clientes', $clientes);
        $this->display();
    }

    public function relatorio_by_clientesAction()
    {
        $id_empreendimento = $_POST['id_empreendimento'];
        $instanceLote = new Lote();
        $selectLotes = $instanceLote->getDefaultAdapter()->select();
        $clientes = $selectLotes->from(array('l' => TB_LOTES), array('id', "lote", "quadra", 'id_empreendimento'))
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('idContrato' => 'id', 'id', 'id_pessoa', 'fl_distrato'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa', 'id'))
            ->where('l.id_empreendimento = ?', $id_empreendimento)->order('p.nm_pessoa')->group('p.id')->query()->fetchAll();
        $this->set('clientes', $clientes);
        $this->display();
    }

    /**
     * Gera uma lista de contratos do empreendimento para seleo por id do contrato e exibio em vermelho dos distratados.
     */
    public function relatorio_by_contratosAction()
    {
        $id_empreendimento = $_POST['id_empreendimento'];
        $instanceLote = new Lote();
        $selectLotes = $instanceLote->getDefaultAdapter()->select();
        $clientes = $selectLotes->from(array('l' => TB_LOTES), array('id', "lote", "quadra", 'id_empreendimento'))
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('idContrato' => 'id', 'id', 'id_pessoa', 'fl_distrato'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa', 'id'))
            ->where('l.id_empreendimento = ?', $id_empreendimento)->order('p.nm_pessoa')->group('c.id')->query()->fetchAll();
        $this->set('clientes', $clientes);
        $this->display();
    }

    public function etiquetas_by_clientesAction()
    {
        $id_empreendimento = $_POST['id_empreendimento'];
        $instanceLote = new Lote();
        $selectLotes = $instanceLote->getDefaultAdapter()->select();
        $clientes = $selectLotes->from(array('l' => TB_LOTES), array("lote", "quadra", 'id_empreendimento'))
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id', 'id_pessoa', 'fl_distrato'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa'))
            ->where('l.id_empreendimento = ?', $id_empreendimento)
            ->order('p.nm_pessoa')->query()->fetchAll();
        $this->set('clientes', $clientes);
        $this->display();
    }

    public function relatorio_by_lotesAction()
    {
        $id_empreendimento = $_POST['id_empreendimento'];
        $lotes = $this->lote->findLotesByEmpreendimento($id_empreendimento, true);
        $this->set('lotes', $lotes);
        $this->display();
    }

    public function corretor_by_empAction()
    {
        $corretoresOpt = array(array('id' => '', 'nm_pessoa' => 'Selecione...'),
            array('id' => '*', 'nm_pessoa' => 'Todos'));
        if ($_POST['emp']) {
            $tb_emp = new Empreendimento();
            $corretores = $tb_emp->getAdapter()->select()->from(array('c' => TB_CORRETOR_EMPREENDIMENTO), '')
                ->join(array('p' => TB_PESSOA), 'c.id_corretor = p.id', array('id', 'nm_pessoa'))
                ->where('c.id_empreendimento = ' . $_POST['emp'])
                ->order('p.nm_pessoa')->query()->fetchAll();
            $corretoresOpt = array_merge($corretoresOpt, $corretores);
        }
        $this->set('corretores', $corretoresOpt);
        $this->display();
    }

    public function buscaNomeClienteAction()
    {
        $cliente = $this->tb_cliente->getAdapter()->select()->from(array("c" => TB_CLIENTE), array("cd_cliente", "nm_razao_social"))->query()->fetch();
        $cliente['nm_razao_social'] = utf8_encode($cliente['nm_razao_social']);
        echo json_encode($cliente);
    }

}